/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.text.View;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.text.SubstanceTextPainter;

public class SubstanceToolTipUI
extends BasicToolTipUI {
    public static ComponentUI createUI(JComponent c) {
        return new SubstanceToolTipUI();
    }

    public void paint(Graphics g, JComponent c) {
        Font font = c.getFont();
        Dimension size = c.getSize();
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        g.setColor(c.getForeground());
        g.setFont(font);
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        Insets insets = c.getInsets();
        Rectangle paintTextR = new Rectangle(insets.left + 3, insets.top, size.width - (insets.left + insets.right + 6), size.height - (insets.top + insets.bottom + 2));
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            v.paint(g, paintTextR);
        } else {
            SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
            textPainter.init(c, null, true);
            textPainter.setBackgroundFill(c, c.getBackground(), false, 0, 0);
            textPainter.attachText(c, paintTextR, tipText, -1, font, c.getForeground(), null);
            textPainter.renderSurface(g);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        Font font = c.getFont();
        Insets insets = c.getInsets();
        Dimension prefSize = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String text = ((JToolTip)c).getTipText();
        if (text == null || text.equals("")) {
            text = "";
        } else {
            View v;
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                prefSize.width += (int)(v.getPreferredSpan(0) + 6.0f);
                prefSize.height += (int)(v.getPreferredSpan(1) + 2.0f);
            } else {
                SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
                Dimension textBounds = textPainter.getTextBounds(c, font, text);
                prefSize.width += textBounds.width + 6;
                prefSize.height += textBounds.height + 2;
            }
        }
        return prefSize;
    }
}

