/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.border.SubstanceBorderPainter;
import org.jvnet.substance.button.RectangularButtonShaper;
import org.jvnet.substance.button.StandardButtonShaper;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.ControlBackgroundComposite;
import org.jvnet.substance.painter.DefaultControlBackgroundComposite;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.PairwiseButtonBackgroundDelegate;
import org.jvnet.substance.utils.PulseTracker;
import org.jvnet.substance.utils.Sideable;
import org.jvnet.substance.utils.SoftHashMap;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class ButtonBackgroundDelegate {
    private static Map<String, BufferedImage> regularBackgrounds = new SoftHashMap<String, BufferedImage>();

    public static synchronized void reset() {
        regularBackgrounds.clear();
        PairwiseButtonBackgroundDelegate.reset();
    }

    public static synchronized ButtonBackground getBackground(AbstractButton button, SubstanceButtonShaper shaper, SubstanceGradientPainter painter, SubstanceBorderPainter borderPainter, int width, int height) {
        FadeState fadeState;
        ColorScheme borderScheme;
        ColorScheme colorScheme;
        JButton jb;
        ComponentState state = ComponentState.getState(button.getModel(), button);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(button);
        boolean isPaintedActive = state.getColorSchemeKind() == ComponentState.ColorSchemeKind.CURRENT;
        float cyclePos = state.getCycleCount();
        boolean isPulsating = false;
        if (button instanceof JButton && PulseTracker.isPulsating(jb = (JButton)button) && state != ComponentState.PRESSED_SELECTED && state != ComponentState.PRESSED_UNSELECTED) {
            isPulsating = true;
            cyclePos = (int)(PulseTracker.getCycles(jb) % 20L);
            if (cyclePos > 10.0f) {
                cyclePos = 19.0f - cyclePos;
            }
            isPaintedActive = true;
        }
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(button, state);
        ColorScheme colorScheme2 = colorScheme = theme.getColorScheme();
        ColorScheme borderScheme2 = borderScheme = theme.getBorderTheme().getColorScheme();
        boolean isWindowModified = false;
        if (SubstanceCoreUtilities.isTitleCloseButton(button)) {
            for (Container comp = button; comp != null; comp = comp.getParent()) {
                if (comp instanceof JInternalFrame) {
                    JInternalFrame jif = (JInternalFrame)comp;
                    isWindowModified = Boolean.TRUE.equals(jif.getClientProperty("windowModified"));
                    break;
                }
                if (comp instanceof JRootPane) {
                    JRootPane jrp = (JRootPane)comp;
                    isWindowModified = Boolean.TRUE.equals(jrp.getClientProperty("windowModified"));
                    break;
                }
                if (!(comp instanceof JInternalFrame.JDesktopIcon)) continue;
                JInternalFrame.JDesktopIcon jdi = (JInternalFrame.JDesktopIcon)comp;
                JInternalFrame jif = jdi.getInternalFrame();
                isWindowModified = Boolean.TRUE.equals(jif.getClientProperty("windowModified"));
                break;
            }
            if (isWindowModified) {
                colorScheme2 = SubstanceTheme.YELLOW;
                colorScheme = SubstanceTheme.ORANGE;
                isPaintedActive = true;
            }
        }
        if (!isWindowModified && !isPulsating && (fadeState = SubstanceFadeUtilities.getFadeState((Component)button, FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS)) != null) {
            SubstanceTheme prevTheme = SubstanceThemeUtilities.getTheme(button, prevState);
            colorScheme = theme.getColorScheme();
            colorScheme2 = prevTheme.getColorScheme();
            borderScheme = theme.getBorderTheme().getColorScheme();
            borderScheme2 = prevTheme.getBorderTheme().getColorScheme();
            cyclePos = fadeState.getFadePosition();
            if (fadeState.isFadingIn()) {
                cyclePos = 10.0f - cyclePos;
            }
            isPaintedActive = true;
        }
        Set<SubstanceConstants.Side> straightSides = SubstanceCoreUtilities.getSides(button, "substancelaf.buttonside");
        String straightKey = "";
        for (SubstanceConstants.Side sSide : straightSides) {
            straightKey = straightKey + sSide.name() + "-";
        }
        boolean isRoundButton = StandardButtonShaper.isRoundButton(button);
        float radius = 0.0f;
        if (shaper instanceof RectangularButtonShaper) {
            radius = ((RectangularButtonShaper)((Object)shaper)).getCornerRadius(button, null);
        }
        Set<SubstanceConstants.Side> openSides = SubstanceCoreUtilities.getSides(button, "substancelaf.buttonopenSide");
        String openKey = "";
        for (SubstanceConstants.Side oSide : openSides) {
            openKey = openKey + oSide.name() + "-";
        }
        boolean isContentAreaFilled = button.isContentAreaFilled();
        boolean isBorderPainted = button.isBorderPainted();
        String key = width + ":" + height + ":" + prevState.name() + ":" + state.name() + ":" + cyclePos + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + SubstanceCoreUtilities.getSchemeId(borderScheme) + ":" + SubstanceCoreUtilities.getSchemeId(borderScheme2) + ":" + shaper.getDisplayName() + ":" + painter.getDisplayName() + ":" + borderPainter.getDisplayName() + ":" + straightKey + ":" + openKey + ":" + button.getClass().getName() + ":" + isRoundButton + ":" + radius + ":" + isContentAreaFilled + ":" + isBorderPainted + ":" + SubstanceSizeUtils.getComponentFontSize(button);
        if (regularBackgrounds.get(key) == null) {
            int openDelta = (int)Math.ceil(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(button)));
            int deltaLeft = openSides.contains((Object)SubstanceConstants.Side.LEFT) ? openDelta : 0;
            int deltaRight = openSides.contains((Object)SubstanceConstants.Side.RIGHT) ? openDelta : 0;
            int deltaTop = openSides.contains((Object)SubstanceConstants.Side.TOP) ? openDelta : 0;
            int deltaBottom = openSides.contains((Object)SubstanceConstants.Side.BOTTOM) ? openDelta : 0;
            int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(button)) / 2.0);
            GeneralPath contour = shaper.getButtonOutline(button, new Insets(borderDelta, borderDelta, borderDelta, borderDelta), width + deltaLeft + deltaRight, height + deltaTop + deltaBottom);
            BufferedImage newBackground = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D finalGraphics = (Graphics2D)newBackground.getGraphics();
            finalGraphics.translate(-deltaLeft, -deltaTop);
            if (isContentAreaFilled) {
                BufferedImage contourBackground = painter.getContourBackground(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
                finalGraphics.drawImage((Image)contourBackground, 0, 0, null);
            }
            if (isBorderPainted) {
                int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(button));
                GeneralPath contourInner = shaper.getButtonOutline(button, new Insets(borderDelta + borderThickness, borderDelta + borderThickness, borderDelta + borderThickness, borderDelta + borderThickness), width + deltaLeft + deltaRight, height + deltaTop + deltaBottom);
                borderPainter.paintBorder(finalGraphics, button, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, contourInner, borderScheme, borderScheme2, cyclePos, borderScheme != borderScheme2);
            }
            regularBackgrounds.put(key, newBackground);
        }
        return new ButtonBackground(isPaintedActive, regularBackgrounds.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackground(Graphics g, AbstractButton button) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        button.setOpaque(false);
        if (SubstanceCoreUtilities.isButtonNeverPainted(button)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        SubstanceGradientPainter painter = SubstanceCoreUtilities.getGradientPainter(button);
        try {
            int width = button.getWidth();
            int height = button.getHeight();
            int y = 0;
            if (SubstanceCoreUtilities.isScrollButton(button)) {
                Sideable sideable = (Sideable)((Object)button);
                PairwiseButtonBackgroundDelegate.updateBackground(g, button, sideable.getSide());
                return;
            }
            if (SubstanceCoreUtilities.isSpinnerButton(button)) {
                Sideable sideable = (Sideable)((Object)button);
                PairwiseButtonBackgroundDelegate.updateBackground(g, button, sideable.getSide());
                return;
            }
            SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
            SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(button);
            ButtonBackground bb = ButtonBackgroundDelegate.getBackground(button, shaper, painter, borderPainter, width, height);
            BufferedImage bgImage = bb.backgroundImage;
            ControlBackgroundComposite composite = SubstanceCoreUtilities.getControlBackgroundComposite(button);
            boolean isCustomComposite = composite.getClass() != DefaultControlBackgroundComposite.class;
            BufferedImage result = bgImage;
            if (isCustomComposite) {
                result = SubstanceCoreUtilities.getBlankImage(bgImage.getWidth(), bgImage.getHeight());
            }
            Graphics2D resultGr = result.createGraphics();
            if (isCustomComposite) {
                resultGr.setComposite(composite.getBackgroundComposite(button, button.getParent(), -1, bb.isPaintedActive));
            }
            try {
                boolean isSpecial;
                ComponentState state = ComponentState.getState(button.getModel(), button);
                boolean bl = isSpecial = SubstanceCoreUtilities.hasFlatAppearance(button) || !state.isKindActive(FadeKind.ENABLE);
                if (isSpecial) {
                    result = SubstanceCoreUtilities.getBlankImage(bgImage.getWidth(), bgImage.getHeight());
                    resultGr = result.createGraphics();
                    BufferedImage temp = SubstanceCoreUtilities.getBlankImage(bgImage.getWidth(), bgImage.getHeight());
                    Graphics2D tempGr = temp.createGraphics();
                    if (SubstanceCoreUtilities.hasFlatAppearance(button)) {
                        if (FadeTracker.getInstance().isTracked(button, FadeKind.ROLLOVER) && !state.isKindActive(FadeKind.SELECTION) && state.isKindActive(FadeKind.ENABLE)) {
                            float fadeCoef = FadeTracker.getInstance().getFade10(button, FadeKind.ROLLOVER);
                            tempGr.setComposite(AlphaComposite.getInstance(3, fadeCoef / 10.0f));
                        } else if (state == ComponentState.DEFAULT) {
                            return;
                        }
                        if (state != ComponentState.DISABLED_UNSELECTED) {
                            tempGr.drawImage((Image)bgImage, 0, 0, null);
                        }
                    } else {
                        if (!state.isKindActive(FadeKind.ENABLE)) {
                            tempGr.setComposite(AlphaComposite.getInstance(3, SubstanceThemeUtilities.getTheme(button).getThemeAlpha(button, state)));
                        }
                        tempGr.drawImage((Image)bgImage, 0, 0, null);
                    }
                    resultGr.drawImage((Image)temp, 0, 0, null);
                    tempGr.dispose();
                } else if (isCustomComposite) {
                    resultGr.drawImage((Image)bgImage, 0, 0, null);
                }
                graphics.drawImage((Image)result, 0, y, null);
            }
            finally {
                resultGr.dispose();
            }
        }
        finally {
            graphics.dispose();
        }
    }

    public static boolean isRoundButton(AbstractButton button) {
        return !SubstanceCoreUtilities.isComboBoxButton(button) && !SubstanceCoreUtilities.isScrollButton(button) && SubstanceCoreUtilities.hasText(button);
    }

    public static boolean contains(AbstractButton button, int x, int y) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return false;
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        GeneralPath contour = shaper.getButtonOutline(button);
        return contour.contains(x, y);
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceBackgroundDelegate: \n");
        sb.append("\t" + regularBackgrounds.size() + " regular");
        return sb.toString();
    }

    public static class ButtonBackground {
        public boolean isPaintedActive;
        public BufferedImage backgroundImage;

        public ButtonBackground(boolean isPaintedActive, BufferedImage backgroundImage) {
            this.isPaintedActive = isPaintedActive;
            this.backgroundImage = backgroundImage;
        }
    }
}

