/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.Caret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.Resettable;
import org.jvnet.lafwidget.animation.EDTFadeTrackerAdapter;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceCheckBoxUI;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceInternalFrameUI;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceMenu;
import org.jvnet.substance.SubstanceMenuBarUI;
import org.jvnet.substance.SubstanceProgressBarUI;
import org.jvnet.substance.SubstanceRadioButtonUI;
import org.jvnet.substance.SubstanceRootPaneUI;
import org.jvnet.substance.SubstanceScrollBarUI;
import org.jvnet.substance.SubstanceTabbedPaneUI;
import org.jvnet.substance.border.SubstanceBorderPainter;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.color.BaseColorScheme;
import org.jvnet.substance.color.BottleGreenColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.LightAquaColorScheme;
import org.jvnet.substance.color.SunfireRedColorScheme;
import org.jvnet.substance.color.SunsetColorScheme;
import org.jvnet.substance.combo.ComboPopupPrototypeCallback;
import org.jvnet.substance.combo.SubstanceComboBoxButton;
import org.jvnet.substance.painter.ControlBackgroundComposite;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.painter.decoration.ClassicDecorationPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationUtilities;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.scroll.SubstanceScrollButton;
import org.jvnet.substance.tabbed.TabCloseCallback;
import org.jvnet.substance.theme.SubstanceBlendBiTheme;
import org.jvnet.substance.theme.SubstanceInvertedTheme;
import org.jvnet.substance.theme.SubstanceMixTheme;
import org.jvnet.substance.theme.SubstanceNegatedTheme;
import org.jvnet.substance.theme.SubstanceShiftTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ButtonBackgroundDelegate;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.MemoryAnalyzer;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceSpinnerButton;
import org.jvnet.substance.utils.SubstanceThemeUtilities;
import org.jvnet.substance.utils.SubstanceTitleButton;
import org.jvnet.substance.utils.icon.SubstanceIconFactory;
import org.jvnet.substance.utils.icon.TransitionAwareIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceCoreUtilities {
    private static final String PREV_COMPONENT_STATE = "substancelaf.internal.prevComponentState";
    private static final String PREV_SEL_COMPONENT_STATE = "substancelaf.internal.prevSelComponentState";
    private static final String NEXT_COMPONENT_STATE = "substancelaf.internal.nextComponentState";
    private static final String NEXT_SEL_COMPONENT_STATE = "substancelaf.internal.nextSelComponentState";
    public static final String DO_NOT_FILL_BACKGROUND = "substancelaf.internal.textPainter.doNotFillBackground";
    public static final String HAS_CUSTOM_BACKGROUND_FILL = "substancelaf.internal.textPainter.hasCustomBackgroundFill";
    public static final String IS_COVERED_BY_LIGHTWEIGHT_POPUPS = "substancelaf.internal.paint.isCoveredByLightweightPopups";

    private SubstanceCoreUtilities() {
    }

    public static String clipString(FontMetrics metrics, int availableWidth, String fullText) {
        if (metrics.stringWidth(fullText) <= availableWidth) {
            return fullText;
        }
        String ellipses = "...";
        int ellipsesWidth = metrics.stringWidth(ellipses);
        if (ellipsesWidth > availableWidth) {
            return "";
        }
        String starter = "";
        String ender = "";
        int w = fullText.length();
        int w2 = w / 2 + w % 2;
        String prevTitle = "";
        for (int i = 0; i < w2; ++i) {
            String newTitle;
            String newStarter = starter + fullText.charAt(i);
            String newEnder = ender;
            if (w - i > w2) {
                newEnder = fullText.charAt(w - i - 1) + newEnder;
            }
            if (metrics.stringWidth(newTitle = newStarter + ellipses + newEnder) > availableWidth) {
                return prevTitle;
            }
            starter = newStarter;
            ender = newEnder;
            prevTitle = newTitle;
        }
        return fullText;
    }

    public static boolean hasIcon(AbstractButton button) {
        return button.getIcon() != null;
    }

    public static boolean hasText(AbstractButton button) {
        String text = button.getText();
        return text != null && text.length() > 0;
    }

    public static boolean isComboBoxButton(AbstractButton button) {
        Container parent = button.getParent();
        return parent != null && (parent instanceof JComboBox || parent.getParent() instanceof JComboBox);
    }

    public static boolean isScrollBarButton(AbstractButton button) {
        Container parent = button.getParent();
        return parent != null && (parent instanceof JScrollBar || parent.getParent() instanceof JScrollBar);
    }

    public static boolean isSpinnerButton(AbstractButton button) {
        Container parent = button.getParent();
        if (!(button instanceof SubstanceSpinnerButton)) {
            return false;
        }
        return parent != null && (parent instanceof JSpinner || parent.getParent() instanceof JSpinner);
    }

    public static boolean isToolBarButton(AbstractButton button) {
        if (button instanceof SubstanceComboBoxButton) {
            return false;
        }
        if (button instanceof SubstanceSpinnerButton) {
            return false;
        }
        Container parent = button.getParent();
        return parent != null && (parent instanceof JToolBar || parent.getParent() instanceof JToolBar);
    }

    public static boolean isScrollButton(JComponent comp) {
        return comp instanceof SubstanceScrollButton;
    }

    public static boolean isControlAlwaysPaintedActive(Component comp) {
        return SubstanceCoreUtilities.isControlAlwaysPaintedActive(comp, false);
    }

    public static boolean isControlAlwaysPaintedActive(Component comp, boolean checkHierarchy) {
        if (!checkHierarchy) {
            JComponent jcomp;
            Object componentProp;
            if (comp instanceof JComponent && (componentProp = (jcomp = (JComponent)comp).getClientProperty("substancelaf.paintactive")) != null) {
                if (Boolean.TRUE.equals(componentProp)) {
                    return true;
                }
                if (Boolean.FALSE.equals(componentProp)) {
                    return false;
                }
            }
        } else {
            for (Component c = comp; c != null; c = c.getParent()) {
                JComponent jcomp;
                Object componentProp;
                if (!(c instanceof JComponent) || (componentProp = (jcomp = (JComponent)c).getClientProperty("substancelaf.paintactive")) == null) continue;
                if (Boolean.TRUE.equals(componentProp)) {
                    return true;
                }
                if (!Boolean.FALSE.equals(componentProp)) continue;
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.paintactive"));
    }

    public static boolean isButtonNeverPainted(AbstractButton button) {
        for (Container c = button; c != null; c = c.getParent()) {
            JComponent jc;
            Object prop;
            if (!(c instanceof JComponent) || (prop = (jc = (JComponent)c).getClientProperty("substancelaf.buttonpaintnever")) == null) continue;
            if (Boolean.TRUE.equals(prop)) {
                return true;
            }
            if (!Boolean.FALSE.equals(prop)) continue;
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.buttonpaintnever"));
    }

    public static SubstanceConstants.FocusKind getFocusKind(Component component) {
        while (component != null) {
            JComponent jcomp;
            Object jcompFocusKind;
            if (component instanceof JComponent && (jcompFocusKind = (jcomp = (JComponent)component).getClientProperty("substancelaf.focusKind")) instanceof SubstanceConstants.FocusKind) {
                return (SubstanceConstants.FocusKind)((Object)jcompFocusKind);
            }
            component = component.getParent();
        }
        Object globalFocusKind = UIManager.get("substancelaf.focusKind");
        if (globalFocusKind instanceof SubstanceConstants.FocusKind) {
            return (SubstanceConstants.FocusKind)((Object)globalFocusKind);
        }
        return SubstanceConstants.FocusKind.ALL_INNER;
    }

    public static SubstanceConstants.TabTextAlignmentKind getTabTextAlignmentKind(JTabbedPane tabPane) {
        Object jcompAlignmentKind = tabPane.getClientProperty("substancelaf.tabbedpanetextAlignmentKind");
        if (jcompAlignmentKind instanceof SubstanceConstants.TabTextAlignmentKind) {
            return (SubstanceConstants.TabTextAlignmentKind)((Object)jcompAlignmentKind);
        }
        Object globalAlignmentKind = UIManager.get("substancelaf.tabbedpanetextAlignmentKind");
        if (globalAlignmentKind instanceof SubstanceConstants.TabTextAlignmentKind) {
            return (SubstanceConstants.TabTextAlignmentKind)((Object)globalAlignmentKind);
        }
        return SubstanceConstants.TabTextAlignmentKind.DEFAULT;
    }

    public static boolean toDrawWatermark(Component component) {
        for (Component c = component; c != null; c = c.getParent()) {
            if (!(c instanceof JComponent)) continue;
            JComponent jcomp = (JComponent)component;
            Object obj = jcomp.getClientProperty("substancelaf.watermark.toignore");
            if (Boolean.TRUE.equals(obj)) {
                return false;
            }
            if (!Boolean.FALSE.equals(obj)) continue;
            return true;
        }
        Object obj = UIManager.get("substancelaf.watermark.toignore");
        if (Boolean.TRUE.equals(obj)) {
            return false;
        }
        if (component instanceof JList) {
            return false;
        }
        if (component instanceof JTree) {
            return false;
        }
        if (component instanceof JTable) {
            return false;
        }
        return !(component instanceof JTextComponent);
    }

    public static boolean toBleedWatermark(Component component) {
        if (component instanceof JComponent) {
            JComponent jcomp = (JComponent)component;
            Object obj = jcomp.getClientProperty("substancelaf.watermark.tobleed");
            if (Boolean.TRUE.equals(obj)) {
                return true;
            }
            if (Boolean.FALSE.equals(obj)) {
                return false;
            }
        }
        return SubstanceLookAndFeel.toBleedWatermark();
    }

    public static SubstanceButtonShaper getButtonShaper(Component button) {
        SubstanceButtonShaper shaper = null;
        for (Component c = button; c != null; c = c.getParent()) {
            JComponent jcomp;
            Object customShaper;
            if (!(c instanceof JComponent) || (customShaper = (jcomp = (JComponent)c).getClientProperty("substancelaf.buttonShaper")) == null) continue;
            if (customShaper instanceof SubstanceButtonShaper) {
                return (SubstanceButtonShaper)customShaper;
            }
            if (!(customShaper instanceof String)) continue;
            try {
                shaper = (SubstanceButtonShaper)Class.forName((String)customShaper).newInstance();
            }
            catch (Exception exc) {
                shaper = null;
            }
            if (shaper == null) continue;
            return shaper;
        }
        if (shaper == null) {
            shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        }
        return shaper;
    }

    public static SubstanceGradientPainter getGradientPainter(JComponent comp) {
        SubstanceGradientPainter painter = SubstanceLookAndFeel.getCurrentGradientPainter();
        Object customPainter = comp.getClientProperty("substancelaf.gradientPainter");
        if (customPainter != null) {
            if (customPainter instanceof SubstanceGradientPainter) {
                return (SubstanceGradientPainter)customPainter;
            }
            try {
                painter = (SubstanceGradientPainter)Class.forName((String)customPainter).newInstance();
            }
            catch (Exception exc) {
                painter = SubstanceLookAndFeel.getCurrentGradientPainter();
            }
        }
        return painter;
    }

    public static boolean isTabModified(Component tabComponent) {
        boolean isWindowModified = false;
        Component comp = tabComponent;
        if (comp instanceof JComponent) {
            JComponent jc = (JComponent)comp;
            isWindowModified = Boolean.TRUE.equals(jc.getClientProperty("windowModified"));
        }
        return isWindowModified;
    }

    public static boolean isRootPaneModified(JRootPane rootPane) {
        return Boolean.TRUE.equals(rootPane.getClientProperty("windowModified"));
    }

    public static boolean isInternalFrameModified(JInternalFrame internalFrame) {
        Object frameProp = internalFrame.getClientProperty("windowModified");
        if (Boolean.TRUE.equals(frameProp)) {
            return true;
        }
        if (Boolean.FALSE.equals(frameProp)) {
            return false;
        }
        return Boolean.TRUE.equals(internalFrame.getRootPane().getClientProperty("windowModified"));
    }

    public static ControlBackgroundComposite getControlBackgroundComposite(Component component) {
        for (Component c = component; c != null; c = c.getParent()) {
            JComponent jc;
            Object objProp;
            if (!(c instanceof JComponent) || !((objProp = (jc = (JComponent)c).getClientProperty("substancelaf.backgroundComposite")) instanceof ControlBackgroundComposite)) continue;
            return (ControlBackgroundComposite)objProp;
        }
        Object globalProp = UIManager.get("substancelaf.backgroundComposite");
        if (globalProp instanceof ControlBackgroundComposite) {
            return (ControlBackgroundComposite)globalProp;
        }
        return SubstanceLookAndFeel.getBackgroundComposite(component);
    }

    public static boolean hasCloseButton(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        if (!tabbedPane.isEnabledAt(tabIndex)) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.tabbedpanehasclosebuttons");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpanehasclosebuttons"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.tabbedpanehasclosebuttons");
    }

    public static int getCloseButtonSize(JTabbedPane tabbedPane, int tabIndex) {
        if (!SubstanceCoreUtilities.hasCloseButton(tabbedPane, tabIndex)) {
            return 0;
        }
        return SubstanceSizeUtils.getTabCloseIconSize(SubstanceSizeUtils.getComponentFontSize(tabbedPane));
    }

    public static boolean toLayoutVertically(JTabbedPane tabbedPane) {
        int tabPlacement = tabbedPane.getTabPlacement();
        if (tabPlacement == 1 || tabPlacement == 3) {
            return false;
        }
        Object tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpaneverticalOrientation");
        if (Boolean.TRUE.equals(tabProp)) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.tabbedpaneverticalOrientation");
    }

    public static boolean toShowIconUnrotated(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.tabbedpaneverticalOrientationRotateIcons");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpaneverticalOrientationRotateIcons"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.tabbedpaneverticalOrientationRotateIcons");
    }

    public static SubstanceConstants.TabContentPaneBorderKind getContentBorderKind(JTabbedPane tabbedPane) {
        Object tabProp = tabbedPane.getClientProperty("substancelaf.tabbedPaneContentBorderKind");
        if (tabProp instanceof SubstanceConstants.TabContentPaneBorderKind) {
            return (SubstanceConstants.TabContentPaneBorderKind)((Object)tabProp);
        }
        Object globalProp = UIManager.get("substancelaf.tabbedPaneContentBorderKind");
        if (globalProp instanceof SubstanceConstants.TabContentPaneBorderKind) {
            return (SubstanceConstants.TabContentPaneBorderKind)((Object)globalProp);
        }
        return SubstanceConstants.TabContentPaneBorderKind.DOUBLE_FULL;
    }

    public static boolean toAnimateCloseIconOfModifiedTab(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        if (!SubstanceCoreUtilities.hasCloseButton(tabbedPane, tabIndex)) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.tabbedpaneclosebuttonsmodifiedanimation");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpaneclosebuttonsmodifiedanimation"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.tabbedpaneclosebuttonsmodifiedanimation");
    }

    public static BufferedImage getBlankImage(int width, int height) {
        if (MemoryAnalyzer.isRunning() && (width >= 100 || height >= 100)) {
            try {
                throw new Exception();
            }
            catch (Exception exc) {
                StringBuffer sb = new StringBuffer();
                StackTraceElement[] stack = exc.getStackTrace();
                int count = 0;
                for (StackTraceElement stackEntry : stack) {
                    if (count++ > 8) break;
                    sb.append(stackEntry.getClassName() + ".");
                    sb.append(stackEntry.getMethodName() + " [");
                    sb.append(stackEntry.getLineNumber() + "]");
                    sb.append("\n");
                }
                MemoryAnalyzer.enqueueUsage("Blank " + width + "*" + height + "\n" + sb.toString());
            }
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setColor(new Color(0, 0, 0, 0));
        graphics.setComposite(AlphaComposite.Src);
        graphics.fillRect(0, 0, width, height);
        graphics.dispose();
        return image;
    }

    public static boolean hasNoMinSizeProperty(AbstractButton button) {
        Object noMinSizeProperty = button.getClientProperty("substancelaf.buttonnominsize");
        if (Boolean.TRUE.equals(noMinSizeProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(noMinSizeProperty)) {
            return false;
        }
        Container parent = button.getParent();
        if (parent instanceof JComponent) {
            noMinSizeProperty = ((JComponent)parent).getClientProperty("substancelaf.buttonnominsize");
            if (Boolean.TRUE.equals(noMinSizeProperty)) {
                return true;
            }
            if (Boolean.FALSE.equals(noMinSizeProperty)) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.buttonnominsize"));
    }

    public static boolean hasFlatAppearance(Component comp, boolean defaultValue) {
        for (Component c = comp; c != null; c = c.getParent()) {
            if (!(c instanceof JComponent)) continue;
            JComponent jcomp = (JComponent)c;
            Object flatProperty = jcomp.getClientProperty("substancelaf.componentFlat");
            if (Boolean.TRUE.equals(flatProperty)) {
                return true;
            }
            if (!Boolean.FALSE.equals(flatProperty)) continue;
            return false;
        }
        Object flatProperty = UIManager.get("substancelaf.componentFlat");
        if (Boolean.TRUE.equals(flatProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(flatProperty)) {
            return false;
        }
        return defaultValue;
    }

    public static boolean hasFlatAppearance(AbstractButton button) {
        return SubstanceCoreUtilities.isToolBarButton(button) && SubstanceCoreUtilities.hasFlatAppearance(button, true) || SubstanceCoreUtilities.hasFlatAppearance(button, false);
    }

    public static int getPopupFlyoutOrientation(JComboBox combobox) {
        Object comboProperty = combobox.getClientProperty("substancelaf.comboboxpopupFlyoutOrientation");
        if (comboProperty instanceof Integer) {
            return (Integer)comboProperty;
        }
        Object globalProperty = UIManager.get("substancelaf.comboboxpopupFlyoutOrientation");
        if (globalProperty instanceof Integer) {
            return (Integer)globalProperty;
        }
        return 5;
    }

    public static void makeNonOpaque(Component comp, Map<Component, Boolean> opacitySnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            opacitySnapshot.put(comp, jcomp.isOpaque());
            jcomp.setOpaque(false);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.makeNonOpaque(cont.getComponent(i), opacitySnapshot);
            }
        }
    }

    public static void restoreOpaque(Component comp, Map<Component, Boolean> opacitySnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            if (opacitySnapshot.containsKey(comp)) {
                jcomp.setOpaque(opacitySnapshot.get(comp));
            } else {
                jcomp.setOpaque(true);
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.restoreOpaque(cont.getComponent(i), opacitySnapshot);
            }
        }
    }

    public static void makeNonDoubleBuffered(Component comp, Map<Component, Boolean> dbSnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            dbSnapshot.put(comp, jcomp.isDoubleBuffered());
            jcomp.setDoubleBuffered(false);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.makeNonDoubleBuffered(cont.getComponent(i), dbSnapshot);
            }
        }
    }

    public static void restoreDoubleBuffered(Component comp, Map<Component, Boolean> dbSnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            if (dbSnapshot.containsKey(comp)) {
                jcomp.setDoubleBuffered(dbSnapshot.get(comp));
            } else {
                jcomp.setOpaque(true);
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.restoreDoubleBuffered(cont.getComponent(i), dbSnapshot);
            }
        }
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage compatibleImage = c.createCompatibleImage(image.getWidth(), image.getHeight());
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static boolean useThemedDefaultIcon(JComponent comp) {
        if (comp != null) {
            Object useThemedDefaultIconProperty = comp.getClientProperty("substancelaf.useThemedDefaultIcons");
            if (Boolean.TRUE.equals(useThemedDefaultIconProperty)) {
                return true;
            }
            if (Boolean.FALSE.equals(useThemedDefaultIconProperty)) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.useThemedDefaultIcons"));
    }

    public static TabCloseCallback getTabCloseCallback(MouseEvent me, JTabbedPane tabbedPane, int tabIndex) {
        Object compProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return null;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent && (compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.tabbedpanecloseCallback")) instanceof TabCloseCallback) {
            return (TabCloseCallback)compProp;
        }
        Object tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpanecloseCallback");
        if (tabProp instanceof TabCloseCallback) {
            return (TabCloseCallback)tabProp;
        }
        Object globProp = UIManager.get("substancelaf.tabbedpanecloseCallback");
        if (globProp instanceof TabCloseCallback) {
            return (TabCloseCallback)globProp;
        }
        return null;
    }

    public static BufferedImage blendImagesHorizontal(BufferedImage imageLeft, BufferedImage imageRight, double start, double end) {
        int width = imageLeft.getWidth();
        if (width != imageRight.getWidth()) {
            throw new IllegalArgumentException("Widths are not the same: " + imageLeft.getWidth() + " and " + imageRight.getWidth());
        }
        int height = imageLeft.getHeight();
        if (height != imageRight.getHeight()) {
            throw new IllegalArgumentException("Heights are not the same: " + imageLeft.getHeight() + " and " + imageRight.getHeight());
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        int endX = (int)(end * (double)width);
        int startX = (int)(start * (double)width);
        int rampWidth = endX - startX;
        if (rampWidth == 0) {
            graphics.drawImage(imageLeft, 0, 0, startX, height, 0, 0, startX, height, null);
            graphics.drawImage(imageRight, startX, 0, width, height, startX, 0, width, height, null);
        } else {
            BufferedImage rampRight = SubstanceCoreUtilities.getBlankImage(rampWidth, height);
            Graphics2D rampRightG = (Graphics2D)rampRight.getGraphics();
            rampRightG.setPaint(new GradientPaint(new Point(0, 0), new Color(0, 0, 0, 255), new Point(rampWidth, 0), new Color(0, 0, 0, 0)));
            rampRightG.fillRect(0, 0, rampWidth, height);
            BufferedImage tempRight = SubstanceCoreUtilities.getBlankImage(width - startX, height);
            Graphics2D tempRightG = (Graphics2D)tempRight.getGraphics();
            tempRightG.drawImage(imageRight, 0, 0, width - startX, height, startX, 0, width, height, null);
            tempRightG.setComposite(AlphaComposite.DstOut);
            tempRightG.drawImage((Image)rampRight, 0, 0, null);
            tempRightG.setComposite(AlphaComposite.SrcOver);
            graphics.drawImage((Image)imageLeft, 0, 0, null);
            graphics.drawImage((Image)tempRight, startX, 0, null);
        }
        graphics.dispose();
        return result;
    }

    public static BufferedImage blendImagesVertical(BufferedImage imageTop, BufferedImage imageBottom, double start, double end) {
        int width = imageTop.getWidth();
        if (width != imageBottom.getWidth()) {
            throw new IllegalArgumentException("Widths are not the same: " + imageTop.getWidth() + " and " + imageBottom.getWidth());
        }
        int height = imageTop.getHeight();
        if (height != imageBottom.getHeight()) {
            throw new IllegalArgumentException("Heights are not the same: " + imageTop.getHeight() + " and " + imageBottom.getHeight());
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        int endY = (int)(end * (double)height);
        int startY = (int)(start * (double)height);
        int rampHeight = endY - startY;
        if (rampHeight == 0) {
            graphics.drawImage(imageTop, 0, 0, width, startY, 0, 0, width, startY, null);
            graphics.drawImage(imageBottom, 0, startY, width, height, 0, startY, width, height, null);
        } else {
            BufferedImage rampBottom = SubstanceCoreUtilities.getBlankImage(width, rampHeight);
            Graphics2D rampBottomG = (Graphics2D)rampBottom.getGraphics();
            rampBottomG.setPaint(new GradientPaint(new Point(0, 0), new Color(0, 0, 0, 255), new Point(0, rampHeight), new Color(0, 0, 0, 0)));
            rampBottomG.fillRect(0, 0, width, rampHeight);
            BufferedImage tempBottom = SubstanceCoreUtilities.getBlankImage(width, height - startY);
            Graphics2D tempBottomG = (Graphics2D)tempBottom.getGraphics();
            tempBottomG.drawImage(imageBottom, 0, 0, width, height - startY, 0, startY, width, height, null);
            tempBottomG.setComposite(AlphaComposite.DstOut);
            tempBottomG.drawImage((Image)rampBottom, 0, 0, null);
            tempBottomG.setComposite(AlphaComposite.SrcOver);
            graphics.drawImage((Image)imageTop, 0, 0, null);
            graphics.drawImage((Image)tempBottom, 0, startY, null);
        }
        graphics.dispose();
        return result;
    }

    public static String getSchemeId(ColorScheme colorScheme) {
        if (colorScheme instanceof BaseColorScheme) {
            BaseColorScheme base = (BaseColorScheme)colorScheme;
            return base.getId();
        }
        return colorScheme.getClass().getName();
    }

    public static ColorScheme getOptionPaneColorScheme(int messageType, ColorScheme mainScheme) {
        if (!SubstanceLookAndFeel.isToUseConstantThemesOnDialogs()) {
            return mainScheme;
        }
        switch (messageType) {
            case 1: {
                return new BottleGreenColorScheme();
            }
            case 3: {
                return new LightAquaColorScheme();
            }
            case 2: {
                return new SunsetColorScheme();
            }
            case 0: {
                return new SunfireRedColorScheme();
            }
        }
        return null;
    }

    public static boolean isThemeDark(SubstanceTheme theme) {
        if (theme instanceof SubstanceInvertedTheme) {
            return !SubstanceCoreUtilities.isThemeDark(((SubstanceInvertedTheme)theme).getOriginalTheme());
        }
        if (theme instanceof SubstanceNegatedTheme) {
            return SubstanceCoreUtilities.isThemeDark(((SubstanceNegatedTheme)theme).getOriginalTheme());
        }
        if (theme instanceof SubstanceMixTheme) {
            SubstanceMixTheme mix = (SubstanceMixTheme)theme;
            for (SubstanceTheme mixCompTheme : mix.getOriginalThemes()) {
                if (!SubstanceCoreUtilities.isThemeDark(mixCompTheme)) continue;
                return true;
            }
            return false;
        }
        if (theme instanceof SubstanceBlendBiTheme) {
            SubstanceBlendBiTheme blend = (SubstanceBlendBiTheme)theme;
            return SubstanceCoreUtilities.isThemeDark(blend.getOriginalFirstTheme()) || SubstanceCoreUtilities.isThemeDark(blend.getOriginalSecondTheme());
        }
        return theme.getKind() == SubstanceTheme.ThemeKind.DARK;
    }

    public static Object getComboPopupPrototypeDisplayValue(JComboBox combo) {
        Object objProp = combo.getClientProperty("substancelaf.comboPopupPrototype");
        if (objProp == null) {
            objProp = UIManager.get("substancelaf.comboPopupPrototype");
        }
        if (objProp == null) {
            return null;
        }
        if (objProp instanceof ComboPopupPrototypeCallback) {
            ComboPopupPrototypeCallback callback = (ComboPopupPrototypeCallback)objProp;
            return callback.getPopupPrototypeDisplayValue(combo);
        }
        return objProp;
    }

    public static SubstanceConstants.ScrollPaneButtonPolicyKind getScrollPaneButtonsPolicyKind(JScrollBar scrollBar) {
        Object jspKind;
        Container parent = scrollBar.getParent();
        if (parent instanceof JScrollPane && (jspKind = ((JScrollPane)parent).getClientProperty("substancelaf.scrollPaneButtonsPolicy")) instanceof SubstanceConstants.ScrollPaneButtonPolicyKind) {
            return (SubstanceConstants.ScrollPaneButtonPolicyKind)((Object)jspKind);
        }
        Object globalJspKind = UIManager.get("substancelaf.scrollPaneButtonsPolicy");
        if (globalJspKind instanceof SubstanceConstants.ScrollPaneButtonPolicyKind) {
            return (SubstanceConstants.ScrollPaneButtonPolicyKind)((Object)globalJspKind);
        }
        return SubstanceConstants.ScrollPaneButtonPolicyKind.OPPOSITE;
    }

    public static Set<SubstanceConstants.Side> getSides(AbstractButton button, String propertyName) {
        Object prop = button.getClientProperty(propertyName);
        if (prop instanceof Set) {
            return (Set)prop;
        }
        HashSet<SubstanceConstants.Side> result = new HashSet<SubstanceConstants.Side>();
        if (prop != null) {
            Object[] clientSides;
            if (prop instanceof String) {
                result.add(SubstanceConstants.Side.valueOf((String)prop));
            }
            if (prop instanceof String[]) {
                for (String side : clientSides = (String[])prop) {
                    result.add(SubstanceConstants.Side.valueOf(side));
                }
            }
            if (prop instanceof SubstanceConstants.Side) {
                result.add((SubstanceConstants.Side)((Object)prop));
            }
            if (prop instanceof SubstanceConstants.Side[]) {
                for (String side : clientSides = (SubstanceConstants.Side[])prop) {
                    result.add((SubstanceConstants.Side)((Object)side));
                }
            }
        }
        return result;
    }

    public static float getToolbarButtonCornerRadius(AbstractButton button, Insets insets) {
        JToolBar toolbar = null;
        for (Container c = button.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JToolBar)) continue;
            toolbar = (JToolBar)c;
            break;
        }
        if (toolbar == null) {
            return 2.0f;
        }
        int width = button.getWidth();
        int height = button.getHeight();
        if (insets != null) {
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        float maxRadius = width > height ? (float)height / 2.0f : (float)width / 2.0f;
        Object buttonProp = button.getClientProperty("substancelaf.cornerRadius");
        if (buttonProp instanceof Float) {
            return Math.min(maxRadius, ((Float)buttonProp).floatValue());
        }
        Object toolbarProp = toolbar.getClientProperty("substancelaf.cornerRadius");
        if (toolbarProp instanceof Float) {
            return Math.min(maxRadius, ((Float)toolbarProp).floatValue());
        }
        Object globalProp = UIManager.get("substancelaf.cornerRadius");
        if (globalProp instanceof Float) {
            return Math.min(maxRadius, ((Float)globalProp).floatValue());
        }
        return 2.0f;
    }

    public static int getEchoPerChar(JPasswordField jpf) {
        int result;
        Object obj = jpf.getClientProperty("substancelaf.passwordEchoPerChar");
        if (obj != null && obj instanceof Integer && (result = ((Integer)obj).intValue()) >= 1) {
            return result;
        }
        obj = UIManager.get("substancelaf.passwordEchoPerChar");
        if (obj != null && obj instanceof Integer && (result = ((Integer)obj).intValue()) >= 1) {
            return result;
        }
        return 1;
    }

    public static BufferedImage createClipImage(Shape s, int width, int height) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage img = c.createCompatibleImage(width, height, 3);
        Graphics2D g2 = img.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, width, height);
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(s);
        g2.dispose();
        return img;
    }

    public static Color getMarkColor(SubstanceTheme theme, boolean isEnabled) {
        ColorScheme scheme = theme.getColorScheme();
        if (SubstanceCoreUtilities.isThemeDark(theme)) {
            if (!isEnabled) {
                return theme.getBorderTheme().getColorScheme().getDarkColor();
            }
            return SubstanceColorUtilities.getInterpolatedColor(scheme.getForegroundColor(), scheme.getUltraLightColor(), 0.9);
        }
        Color color1 = isEnabled ? scheme.getUltraDarkColor() : scheme.getUltraDarkColor();
        Color color2 = isEnabled ? scheme.getDarkColor() : scheme.getLightColor();
        return SubstanceColorUtilities.getInterpolatedColor(color1, color2, 0.9);
    }

    public static boolean hasOverlayProperty(Component component) {
        if (component instanceof JComponent) {
            Object flatProperty = ((JComponent)component).getClientProperty("substancelaf.overlay");
            if (Boolean.TRUE.equals(flatProperty)) {
                return true;
            }
            if (Boolean.FALSE.equals(flatProperty)) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.overlay"));
    }

    public static boolean toShowExtraElements(Component component) {
        for (Component c = component; c != null; c = c.getParent()) {
            JComponent jcomp;
            Object componentProp;
            if (!(c instanceof JComponent) || (componentProp = (jcomp = (JComponent)c).getClientProperty("substancelaf.noExtraElements")) == null) continue;
            if (Boolean.TRUE.equals(componentProp)) {
                return false;
            }
            if (!Boolean.FALSE.equals(componentProp)) continue;
            return true;
        }
        return SubstanceLookAndFeel.toShowExtraElements();
    }

    public static boolean hasSubstanceBorder(JComponent c) {
        CompoundBorder cb;
        if (c == null) {
            return false;
        }
        Border border = c.getBorder();
        if (border instanceof SubstanceBorder) {
            return true;
        }
        return border instanceof CompoundBorder && (cb = (CompoundBorder)border).getOutsideBorder() instanceof SubstanceBorder;
    }

    public static Icon getActiveIcon(Icon origIcon, JComponent comp, ButtonModel model, Icon glowingIcon, boolean ignoreRolloverSetting) {
        if (origIcon == null) {
            return null;
        }
        Icon result = origIcon;
        if (SubstanceCoreUtilities.useThemedDefaultIcon(comp)) {
            boolean useThemedVersion;
            boolean bl = useThemedVersion = !model.isArmed() && !model.isPressed() && !model.isSelected();
            if (!ignoreRolloverSetting) {
                boolean bl2 = useThemedVersion = useThemedVersion && !model.isRollover();
            }
            if (useThemedVersion) {
                result = new ImageIcon(SubstanceImageCreator.getThemeImage(comp, result, SubstanceThemeUtilities.getTheme(comp, ComponentState.DEFAULT), false));
            }
        }
        if (FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.ICON_GLOW, comp) && model.isRollover() && glowingIcon != null) {
            result = glowingIcon;
        }
        return result;
    }

    public static Icon getIcon(AbstractButton b, Icon defaultIcon, Icon glowingIcon, boolean ignoreRolloverSetting) {
        ButtonModel model = b.getModel();
        Icon icon = SubstanceCoreUtilities.getActiveIcon(b.getIcon() == null ? defaultIcon : b.getIcon(), b, model, glowingIcon, ignoreRolloverSetting);
        if (icon == null) {
            return null;
        }
        Icon tmpIcon = null;
        if (icon != null) {
            if (!model.isEnabled()) {
                tmpIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                tmpIcon = b.getPressedIcon();
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                tmpIcon = model.isSelected() ? b.getRolloverSelectedIcon() : b.getRolloverIcon();
            } else if (model.isSelected()) {
                tmpIcon = b.getSelectedIcon();
            }
            if (tmpIcon != null) {
                icon = tmpIcon;
            }
        }
        return icon;
    }

    public static SubstanceConstants.MenuGutterFillKind getMenuGutterFillKind() {
        Object globalSetting = UIManager.get("substancelaf.menuGutterFillKind");
        if (globalSetting instanceof SubstanceConstants.MenuGutterFillKind) {
            return (SubstanceConstants.MenuGutterFillKind)((Object)globalSetting);
        }
        return SubstanceConstants.MenuGutterFillKind.HARD;
    }

    public static Container getHeaderParent(Component c) {
        Container result = null;
        for (Container comp = c.getParent(); comp != null; comp = comp.getParent()) {
            if (comp instanceof JLayeredPane && result == null) {
                result = comp;
            }
            if (result != null || !(comp instanceof Window)) continue;
            result = comp;
        }
        return result;
    }

    public static float paintText(AbstractButton button, Rectangle textRect, String text, int mnemonicIndex) {
        ButtonModel model = button.getModel();
        ComponentState state = ComponentState.getState(model, button, button instanceof JMenuItem);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(button);
        if ((SubstanceCoreUtilities.isButtonNeverPainted(button) || !button.isContentAreaFilled() || button instanceof JRadioButton || button instanceof JCheckBox) && state.isKindActive(FadeKind.ENABLE)) {
            state = ComponentState.DEFAULT;
            prevState = ComponentState.DEFAULT;
        }
        return SubstanceCoreUtilities.paintText(button, textRect, text, mnemonicIndex, state, prevState);
    }

    public static float paintText(JComponent component, Rectangle textRect, String text, int mnemonicIndex, ComponentState state, ComponentState prevState) {
        float themeAlpha = SubstanceThemeUtilities.getTheme(component).getThemeAlpha(component, state);
        Color fgColor = SubstanceCoreUtilities.getForegroundColor(component, state, prevState);
        boolean isColorized = SubstanceCoreUtilities.hasColorization(component);
        boolean isForegroundUiResource = component.getForeground() instanceof UIResource;
        if (!isForegroundUiResource && !component.isEnabled() && (double)themeAlpha == 1.0) {
            double colorizationFactor = isColorized ? SubstanceCoreUtilities.getColorizationFactor(component) : 1.0;
            themeAlpha = (float)((double)themeAlpha / (1.0 + colorizationFactor));
        }
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        textPainter.attachText(component, textRect, text, mnemonicIndex, component.getFont(), fgColor, null);
        return themeAlpha;
    }

    public static Color getForegroundColor(Component component, ComponentState state, ComponentState prevState) {
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(component, state);
        boolean isColorized = SubstanceCoreUtilities.hasColorization(component);
        Color compFgColor = component.getForeground();
        boolean isForegroundUiResource = compFgColor instanceof UIResource;
        if (isColorized && !isForegroundUiResource) {
            double colorizationFactor = SubstanceCoreUtilities.getColorizationFactor(component);
            theme = SubstanceShiftTheme.getShiftedTheme(theme, compFgColor, colorizationFactor, compFgColor, colorizationFactor);
        }
        Color fgColor = compFgColor;
        if (isColorized || !isColorized && isForegroundUiResource) {
            fgColor = component instanceof JMenuItem ? SubstanceCoreUtilities.getInterpolatedForegroundColor(component, null, theme, state, prevState, FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS, FadeKind.ARM) : SubstanceCoreUtilities.getInterpolatedForegroundColor(component, null, theme, state, prevState, FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS);
        }
        return fgColor;
    }

    public static Color getForegroundColor(JTabbedPane tabPane, int tabIndex, ComponentState state, ComponentState prevState) {
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(tabPane, tabIndex, state);
        boolean isColorized = SubstanceCoreUtilities.hasColorization(tabPane);
        Color tabFgColor = tabPane.getForegroundAt(tabIndex);
        boolean isForegroundUiResource = tabFgColor instanceof UIResource;
        if (isColorized && !isForegroundUiResource) {
            double colorizationFactor = SubstanceCoreUtilities.getColorizationFactor(tabPane);
            theme = SubstanceShiftTheme.getShiftedTheme(theme, tabFgColor, colorizationFactor, tabFgColor, colorizationFactor);
        }
        Color fgColor = tabFgColor;
        if (isColorized || !isColorized && isForegroundUiResource) {
            fgColor = SubstanceCoreUtilities.getInterpolatedForegroundColor(tabPane, Integer.valueOf(tabIndex), theme, state, prevState, FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS);
        }
        return fgColor;
    }

    public static void paintFocus(Graphics g, Component mainComp, Component focusedComp, Shape focusShape, Rectangle textRect, float maxAlphaCoef, int extraPadding) {
        FadeTracker fadeTracker = FadeTracker.getInstance();
        SubstanceConstants.FocusKind focusKind = SubstanceCoreUtilities.getFocusKind(mainComp);
        if (focusKind == SubstanceConstants.FocusKind.NONE && !fadeTracker.isTracked(focusedComp, FadeKind.FOCUS)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float alpha = 1.0f;
        if (fadeTracker.isTracked(focusedComp, FadeKind.FOCUS)) {
            alpha = fadeTracker.getFade10(focusedComp, FadeKind.FOCUS) / 10.0f;
        }
        graphics.setComposite(TransitionLayout.getAlphaComposite(mainComp, alpha *= maxAlphaCoef, g));
        Color color = SubstanceColorUtilities.getFocusColor(mainComp);
        graphics.setColor(color);
        focusKind.paintFocus(mainComp, focusedComp, graphics, focusShape, textRect, extraPadding);
        graphics.dispose();
    }

    public static void paintFocus(Graphics g, Component mainComp, Component focusedComp, Rectangle textRect) {
        SubstanceCoreUtilities.paintFocus(g, mainComp, focusedComp, null, textRect, 1.0f, 0);
    }

    public static void paintSeparator(Component c, Graphics2D graphics, ColorScheme colorScheme, boolean isDark, int width, int height, int orientation) {
        SubstanceCoreUtilities.paintSeparator(c, graphics, colorScheme, isDark, width, height, orientation, true, 10);
    }

    public static void paintSeparator(Component c, Graphics2D graphics, ColorScheme colorScheme, boolean isDark, int width, int height, int orientation, boolean hasShadow, int maxGradLength) {
        SubstanceCoreUtilities.paintSeparator(c, graphics, colorScheme, isDark, width, height, orientation, hasShadow, maxGradLength, maxGradLength);
    }

    public static void paintSeparator(Component c, Graphics2D graphics, ColorScheme colorScheme, boolean isDark, int width, int height, int orientation, boolean hasShadow, int maxGradLengthStart, int maxGradLengthEnd) {
        Color foreLight = isDark ? colorScheme.getLightColor() : SubstanceColorUtilities.getInterpolatedColor(colorScheme.getLightColor(), colorScheme.getDarkColor(), 0.8);
        Color foreDark = isDark ? colorScheme.getExtraLightColor() : SubstanceColorUtilities.getInterpolatedColor(colorScheme.getMidColor(), colorScheme.getDarkColor(), 0.4);
        Color back = isDark ? colorScheme.getDarkColor() : colorScheme.getUltraLightColor();
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(c));
        graphics.setStroke(new BasicStroke(borderStrokeWidth, 0, 1));
        if (orientation == 1) {
            int gradStart = Math.min(maxGradLengthStart, height / 2);
            int gradEnd = Math.min(maxGradLengthEnd, height / 2);
            graphics.translate(Math.max(0, width / 2 - 1), 0);
            graphics.setPaint(new GradientPaint(0.0f, 0.0f, SubstanceColorUtilities.getAlphaColor(foreLight, 32), 0.0f, gradStart, SubstanceColorUtilities.getAlphaColor(foreDark, 240)));
            graphics.drawLine(0, 0, 0, gradStart);
            if (height / 2 > gradStart) {
                graphics.setColor(SubstanceColorUtilities.getAlphaColor(foreDark, 240));
                graphics.drawLine(0, gradStart, 0, height - gradEnd);
            }
            graphics.setPaint(new GradientPaint(0.0f, height - gradEnd, SubstanceColorUtilities.getAlphaColor(foreDark, 240), 0.0f, height, SubstanceColorUtilities.getAlphaColor(foreLight, 32)));
            graphics.drawLine(0, height - gradEnd, 0, height);
            if (hasShadow) {
                int offset = (int)borderStrokeWidth;
                graphics.setPaint(new GradientPaint(offset, 0.0f, SubstanceColorUtilities.getAlphaColor(back, 32), offset, gradStart, SubstanceColorUtilities.getAlphaColor(back, 196)));
                graphics.drawLine(offset, 0, offset, gradStart);
                if (height / 2 > gradStart) {
                    graphics.setColor(SubstanceColorUtilities.getAlphaColor(back, 196));
                    graphics.drawLine(offset, gradStart, offset, height - gradEnd);
                }
                graphics.setPaint(new GradientPaint(offset, height - gradEnd, SubstanceColorUtilities.getAlphaColor(back, 196), offset, height, SubstanceColorUtilities.getAlphaColor(back, 32)));
                graphics.drawLine(offset, height - gradEnd, offset, height);
            }
        } else {
            int gradStart = Math.min(maxGradLengthStart, width / 2);
            int gradEnd = Math.min(maxGradLengthEnd, width / 2);
            graphics.translate(0, Math.max(0, height / 2 - 1));
            graphics.setPaint(new GradientPaint(0.0f, 0.0f, SubstanceColorUtilities.getAlphaColor(foreLight, 32), gradStart, 0.0f, SubstanceColorUtilities.getAlphaColor(foreDark, 240)));
            graphics.drawLine(0, 0, gradStart, 0);
            graphics.setColor(SubstanceColorUtilities.getAlphaColor(foreDark, 240));
            graphics.drawLine(gradStart, 0, width - gradEnd, 0);
            graphics.setPaint(new GradientPaint(width - gradEnd, 0.0f, SubstanceColorUtilities.getAlphaColor(foreDark, 240), width, 0.0f, SubstanceColorUtilities.getAlphaColor(foreLight, 32)));
            graphics.drawLine(width - gradEnd, 0, width, 0);
            if (hasShadow) {
                int offset = (int)borderStrokeWidth;
                graphics.setPaint(new GradientPaint(0.0f, offset, SubstanceColorUtilities.getAlphaColor(back, 32), gradStart, offset, SubstanceColorUtilities.getAlphaColor(back, 196)));
                graphics.drawLine(0, offset, gradStart, offset);
                graphics.setColor(SubstanceColorUtilities.getAlphaColor(back, 196));
                graphics.drawLine(gradStart, offset, width - gradEnd, offset);
                graphics.setPaint(new GradientPaint(width - gradEnd, offset, SubstanceColorUtilities.getAlphaColor(back, 196), width, offset, SubstanceColorUtilities.getAlphaColor(back, 32)));
                graphics.drawLine(width - gradEnd, offset, width, offset);
            }
        }
    }

    public static boolean isTitleCloseButton(AbstractButton ab) {
        return ab instanceof SubstanceTitleButton && Boolean.TRUE.equals(ab.getClientProperty("substancelaf.internal.isTitleCloseButton"));
    }

    public static void uninstallMenu(JMenuItem menuItem) {
        SubstanceMenu sMenu;
        ButtonUI menuItemUI;
        if (menuItem instanceof JMenu) {
            JMenu menu = (JMenu)menuItem;
            for (Component comp : menu.getMenuComponents()) {
                if (!(comp instanceof JMenuItem)) continue;
                SubstanceCoreUtilities.uninstallMenu((JMenuItem)comp);
            }
        }
        if ((menuItemUI = menuItem.getUI()) instanceof SubstanceMenu && (sMenu = (SubstanceMenu)((Object)menuItemUI)).getAssociatedMenuItem() != null) {
            menuItemUI.uninstallUI(menuItem);
        }
        for (ActionListener actionListener : menuItem.getActionListeners()) {
            menuItem.removeActionListener(actionListener);
        }
        menuItem.removeAll();
    }

    public static Icon getIcon(String iconResource) {
        ClassLoader cl = SubstanceCoreUtilities.getClassLoaderForResources();
        URL iconUrl = cl.getResource(iconResource);
        if (iconUrl == null) {
            return null;
        }
        return new IconUIResource(new ImageIcon(iconUrl));
    }

    public static ClassLoader getClassLoaderForResources() {
        ClassLoader cl = (ClassLoader)UIManager.get("ClassLoader");
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        return cl;
    }

    public static FadeTrackerCallback getFadeCallback(AbstractButton button, boolean toRepaintParent) {
        return SubstanceCoreUtilities.getFadeCallback(button, button.getModel(), false, toRepaintParent, button);
    }

    public static FadeTrackerCallback getFadeCallback(final JComponent component, final ButtonModel model, final boolean toIgnoreSelection, final boolean toRepaintParent, final Component componentToRepaint) {
        if (SubstanceCoreUtilities.isScrollButton(component)) {
            return null;
        }
        EDTFadeTrackerAdapter callback = new EDTFadeTrackerAdapter(){

            public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
                component.putClientProperty(SubstanceCoreUtilities.PREV_COMPONENT_STATE, component.getClientProperty(SubstanceCoreUtilities.NEXT_COMPONENT_STATE));
                component.putClientProperty(SubstanceCoreUtilities.PREV_SEL_COMPONENT_STATE, component.getClientProperty(SubstanceCoreUtilities.NEXT_SEL_COMPONENT_STATE));
                if (!toRepaintParent) {
                    componentToRepaint.repaint();
                } else {
                    Container parent = component.getParent();
                    if (parent != null) {
                        parent.repaint();
                    }
                }
            }

            public void fadeEnded(FadeKind fadeKind) {
                component.putClientProperty(SubstanceCoreUtilities.PREV_COMPONENT_STATE, (Object)ComponentState.getState(model, component, toIgnoreSelection));
                component.putClientProperty(SubstanceCoreUtilities.PREV_SEL_COMPONENT_STATE, (Object)ComponentState.getState(model, component, false));
                component.putClientProperty(SubstanceCoreUtilities.NEXT_COMPONENT_STATE, null);
                component.putClientProperty(SubstanceCoreUtilities.NEXT_SEL_COMPONENT_STATE, null);
                if (!toRepaintParent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (component instanceof JMenuItem) {
                                if (this.isCoveredByLightweightPopups(component)) {
                                    component.putClientProperty(SubstanceCoreUtilities.IS_COVERED_BY_LIGHTWEIGHT_POPUPS, Boolean.TRUE);
                                } else {
                                    component.putClientProperty(SubstanceCoreUtilities.IS_COVERED_BY_LIGHTWEIGHT_POPUPS, null);
                                }
                            }
                            componentToRepaint.repaint();
                        }
                    });
                } else {
                    Container parent = component.getParent();
                    if (parent != null) {
                        parent.repaint();
                    }
                }
            }

            public void fadePerformed(FadeKind fadeKind, float fadeCycle10) {
                component.putClientProperty(SubstanceCoreUtilities.NEXT_COMPONENT_STATE, (Object)ComponentState.getState(model, component, toIgnoreSelection));
                component.putClientProperty(SubstanceCoreUtilities.NEXT_SEL_COMPONENT_STATE, (Object)ComponentState.getState(model, component, false));
                if (!toRepaintParent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (component instanceof JMenuItem) {
                                if (this.isCoveredByLightweightPopups(component)) {
                                    component.putClientProperty(SubstanceCoreUtilities.IS_COVERED_BY_LIGHTWEIGHT_POPUPS, Boolean.TRUE);
                                } else {
                                    component.putClientProperty(SubstanceCoreUtilities.IS_COVERED_BY_LIGHTWEIGHT_POPUPS, null);
                                }
                            }
                            componentToRepaint.repaint();
                        }
                    });
                } else {
                    Container parent = component.getParent();
                    if (parent != null) {
                        parent.repaint();
                    }
                }
            }

            private boolean isCoveredByLightweightPopups(Component comp) {
                int popupIndexToStartWith;
                JRootPane rootPane = SwingUtilities.getRootPane(comp);
                if (rootPane == null) {
                    return false;
                }
                Component[] popups = rootPane.getLayeredPane().getComponentsInLayer(JLayeredPane.POPUP_LAYER);
                if (popups == null) {
                    return false;
                }
                Rectangle compBoundsConverted = SwingUtilities.convertRectangle(comp.getParent(), comp.getBounds(), rootPane.getLayeredPane());
                for (int i = popupIndexToStartWith = SubstanceCoreUtilities.getPopupParentIndexOf(comp, popups) - 1; i >= 0; --i) {
                    Component popup = popups[i];
                    if (!compBoundsConverted.intersects(popup.getBounds())) continue;
                    return true;
                }
                return false;
            }
        };
        return callback;
    }

    public static int getPopupParentIndexOf(Component comp, Component[] popups) {
        for (int i = 0; i < popups.length; ++i) {
            Component popup = popups[i];
            for (Component currComp = comp; currComp != null; currComp = currComp.getParent()) {
                if (currComp != popup) continue;
                return i;
            }
        }
        return popups.length;
    }

    public static ComponentState getPrevComponentState(JComponent comp) {
        try {
            ComponentState result = (ComponentState)((Object)comp.getClientProperty(PREV_COMPONENT_STATE));
            if (result == null) {
                result = ComponentState.DEFAULT;
            }
            return result;
        }
        catch (Exception exception) {
            return ComponentState.DEFAULT;
        }
    }

    public static ComponentState getPrevSelComponentState(JComponent comp) {
        ComponentState result = (ComponentState)((Object)comp.getClientProperty(PREV_SEL_COMPONENT_STATE));
        if (result == null) {
            result = ComponentState.DEFAULT;
        }
        return result;
    }

    public static boolean hasPropertySetTo(Component comp, String propertyName, boolean expectedValue, boolean checkHierarchy) {
        Object globalProp;
        if (!checkHierarchy) {
            JComponent jcomp;
            Object componentProp;
            if (comp instanceof JComponent && (componentProp = (jcomp = (JComponent)comp).getClientProperty(propertyName)) != null && componentProp.equals(expectedValue)) {
                return true;
            }
        } else {
            for (Component c = comp; c != null; c = c.getParent()) {
                JComponent jcomp;
                Object componentProp;
                if (!(c instanceof JComponent) || (componentProp = (jcomp = (JComponent)c).getClientProperty(propertyName)) == null || !componentProp.equals(expectedValue)) continue;
                return true;
            }
        }
        if ((globalProp = UIManager.get(propertyName)) != null) {
            return globalProp.equals(expectedValue);
        }
        return false;
    }

    public static ResourceBundle getResourceBundle(JComponent jcomp) {
        if (LafWidgetUtilities.toIgnoreGlobalLocale(jcomp)) {
            return SubstanceLookAndFeel.getLabelBundle(jcomp.getLocale());
        }
        return SubstanceLookAndFeel.getLabelBundle();
    }

    public static SubstanceBorderPainter getBorderPainter(Component comp) {
        while (comp != null) {
            if (comp instanceof JComponent) {
                Object clientProp = ((JComponent)comp).getClientProperty("substancelaf.borderPainter");
                if (clientProp instanceof SubstanceBorderPainter) {
                    return (SubstanceBorderPainter)clientProp;
                }
                if (clientProp instanceof String) {
                    try {
                        return (SubstanceBorderPainter)Class.forName((String)clientProp).newInstance();
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                }
            }
            comp = comp.getParent();
        }
        Object globalProp = UIManager.get("substancelaf.borderPainter");
        if (globalProp instanceof SubstanceBorderPainter) {
            return (SubstanceBorderPainter)globalProp;
        }
        if (globalProp instanceof String) {
            try {
                return (SubstanceBorderPainter)Class.forName((String)globalProp).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return SubstanceLookAndFeel.getCurrentBorderPainter();
    }

    public static void resetMenuBars(Component component) {
        MenuBarUI ui;
        JRootPane jrp;
        JMenuBar jmb;
        if (component instanceof JRootPane && (jmb = (jrp = (JRootPane)component).getJMenuBar()) != null && (ui = jmb.getUI()) instanceof SubstanceMenuBarUI) {
            Set<?> lafWidgets = ((SubstanceMenuBarUI)ui).getLafWidgets();
            for (LafWidget lw : lafWidgets) {
                if (!(lw instanceof Resettable)) continue;
                ((Resettable)((Object)lw)).reset();
            }
        }
        if (component instanceof Container) {
            Container cont = (Container)component;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                Component child = cont.getComponent(i);
                SubstanceCoreUtilities.resetMenuBars(child);
            }
        }
    }

    public static Color getInterpolatedForegroundColor(Component comp, Comparable<?> componentId, SubstanceTheme theme, ComponentState state, ComponentState prevState, FadeKind ... kinds) {
        ColorScheme colorScheme;
        ColorScheme colorScheme2 = colorScheme = theme.getColorScheme();
        float cyclePos = state.getCycleCount();
        FadeState fadeState = SubstanceFadeUtilities.getFadeState(comp, componentId, kinds);
        if (fadeState != null) {
            colorScheme = SubstanceThemeUtilities.getTheme(comp, state).getColorScheme();
            colorScheme2 = SubstanceThemeUtilities.getTheme(comp, prevState).getColorScheme();
            cyclePos = fadeState.getFadePosition();
            if (!fadeState.isFadingIn()) {
                cyclePos = 10.0f - cyclePos;
            }
        }
        Color c1 = colorScheme.getForegroundColor();
        Color c2 = colorScheme2.getForegroundColor();
        return SubstanceColorUtilities.getInterpolatedColor(c1, c2, (double)cyclePos / 10.0);
    }

    public static void paintTextWithDropShadow(final JComponent c, Graphics g, Color foregroundColor, String text, int width, int height, int xOffset, int yOffset) {
        Graphics2D graphics = (Graphics2D)g.create();
        BufferedImage blurred = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D gBlurred = (Graphics2D)blurred.getGraphics();
        gBlurred.setFont(graphics.getFont());
        gBlurred.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        final float luminFactor = SubstanceColorUtilities.getColorStrength(foregroundColor);
        gBlurred.setColor(SubstanceColorUtilities.getNegativeColor(foregroundColor));
        ConvolveOp convolve = new ConvolveOp(new Kernel(3, 3, new float[]{0.0f, 0.05f, 0.1f, 0.05f, 0.0f, 0.1f, 0.1f, 0.1f, 0.1f}), 1, null);
        gBlurred.drawString(text, xOffset + 1, yOffset + 1);
        blurred = convolve.filter(blurred, null);
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        if (textPainter.needsBackgroundImage()) {
            final BufferedImage finalBlurred = blurred;
            textPainter.attachCallback(new SubstanceTextPainter.BackgroundPaintingCallback(){

                public void paintBackground(Graphics g) {
                    Graphics2D graphics = (Graphics2D)g.create();
                    graphics.setComposite(TransitionLayout.getAlphaComposite(c, luminFactor, g));
                    graphics.drawImage((Image)finalBlurred, 0, 0, null);
                    graphics.setComposite(TransitionLayout.getAlphaComposite((Component)c, g));
                    graphics.dispose();
                }
            });
        } else {
            graphics.setComposite(TransitionLayout.getAlphaComposite(c, luminFactor, g));
            graphics.drawImage((Image)blurred, 0, 0, null);
            graphics.setComposite(TransitionLayout.getAlphaComposite((Component)c, g));
        }
        FontMetrics fm = graphics.getFontMetrics();
        textPainter.attachText(c, new Rectangle(xOffset, yOffset - fm.getAscent(), width - xOffset, fm.getHeight()), text, -1, graphics.getFont(), foregroundColor, graphics.getClipBounds());
        graphics.dispose();
    }

    public static void workaroundBug6576507(Graphics graphics) {
        Font font = graphics.getFont();
        font = font.deriveFont(font.getStyle(), font.getSize2D());
        graphics.setFont(font);
    }

    public static String getHierarchy(Component comp) {
        StringBuffer buffer = new StringBuffer();
        SubstanceCoreUtilities.getHierarchy(comp, buffer, 0);
        while (comp instanceof Window) {
            Window w = (Window)comp;
            if ((comp = w.getOwner()) == null) continue;
            buffer.append("Owner --->\n");
            SubstanceCoreUtilities.getHierarchy(comp, buffer, 0);
        }
        return buffer.toString();
    }

    public static void getHierarchy(Component comp, StringBuffer buffer, int level) {
        for (int i = 0; i < level; ++i) {
            buffer.append("   ");
        }
        String name = comp.getName();
        if (comp instanceof Dialog) {
            name = ((Dialog)comp).getTitle();
        }
        if (comp instanceof Frame) {
            name = ((Frame)comp).getTitle();
        }
        buffer.append(comp.getClass().getName() + "[" + name + "]\n");
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.getHierarchy(cont.getComponent(i), buffer, level + 1);
            }
        }
    }

    public static JComponent getTitlePane(JRootPane rootPane) {
        JInternalFrame jif = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, rootPane);
        if (jif != null) {
            SubstanceInternalFrameUI ui = (SubstanceInternalFrameUI)jif.getUI();
            return ui.getTitlePane();
        }
        SubstanceRootPaneUI ui = (SubstanceRootPaneUI)rootPane.getUI();
        return ui.getTitlePane();
    }

    public static void resetCaches() {
        SubstanceIconFactory.reset();
        ButtonBackgroundDelegate.reset();
        SubstanceCheckBoxUI.reset();
        SubstanceProgressBarUI.reset();
        SubstanceRadioButtonUI.reset();
        SubstanceScrollBarUI.reset();
        SubstanceTabbedPaneUI.reset();
        SubstanceScrollBarUI.reset();
        ClassicDecorationPainter.reset();
    }

    public static Icon getArrowIcon(final Component comp, AbstractButton button, final int orientation) {
        TransitionAwareIcon result = new TransitionAwareIcon(button, new TransitionAwareIcon.Delegate(){

            public Icon getThemeIcon(SubstanceTheme theme) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(comp);
                return SubstanceImageCreator.getArrowIcon(fontSize, orientation, theme);
            }
        });
        return result;
    }

    public static Icon getDoubleArrowIcon(final Component comp, AbstractButton button, final int orientation) {
        TransitionAwareIcon result = new TransitionAwareIcon(button, new TransitionAwareIcon.Delegate(){

            public Icon getThemeIcon(SubstanceTheme theme) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(comp);
                return SubstanceImageCreator.getDoubleArrowIcon(fontSize, 0, 2, 0.0f, orientation, theme);
            }
        });
        return result;
    }

    public static double getColorizationFactor(Component c) {
        Component invoker;
        JPopupMenu popupMenu = null;
        while (c != null) {
            JComponent jcomp;
            Object compProp;
            if (c instanceof JComponent && (compProp = (jcomp = (JComponent)c).getClientProperty("substancelaf.colorizationFactor")) instanceof Double) {
                return (Double)compProp;
            }
            if (c instanceof JPopupMenu) {
                popupMenu = (JPopupMenu)c;
            }
            c = c.getParent();
        }
        if (popupMenu != null && popupMenu != (invoker = popupMenu.getInvoker())) {
            return SubstanceCoreUtilities.getColorizationFactor(popupMenu.getInvoker());
        }
        Object globalProp = UIManager.get("substancelaf.colorizationFactor");
        if (globalProp instanceof Double) {
            return (Double)globalProp;
        }
        return 0.0;
    }

    public static boolean hasColorization(Component c) {
        Component invoker;
        JPopupMenu popupMenu = null;
        while (c != null) {
            JComponent jcomp;
            Object compProp;
            if (c instanceof JComponent && (compProp = (jcomp = (JComponent)c).getClientProperty("substancelaf.colorizationFactor")) instanceof Double) {
                return true;
            }
            if (c instanceof JPopupMenu) {
                popupMenu = (JPopupMenu)c;
            }
            c = c.getParent();
        }
        if (popupMenu != null && popupMenu != (invoker = popupMenu.getInvoker())) {
            return SubstanceCoreUtilities.hasColorization(popupMenu.getInvoker());
        }
        Object globalProp = UIManager.get("substancelaf.colorizationFactor");
        return globalProp instanceof Double;
    }

    public static Color getBackgroundFillColor(Component component) {
        boolean isColorized = SubstanceCoreUtilities.hasColorization(component);
        if (isColorized && (component instanceof JCheckBox || component instanceof JRadioButton || component instanceof JSlider)) {
            component = component.getParent();
        } else if (component instanceof JTextComponent && !component.isOpaque()) {
            component = component.getParent();
        }
        Color backgr = component.getBackground();
        boolean isBackgroundUiResource = backgr instanceof UIResource;
        if (!isBackgroundUiResource) {
            if (isColorized) {
                SubstanceTheme theme = SubstanceThemeUtilities.getTheme(component, component.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
                backgr = theme.getBackgroundColor();
            } else if (!component.isEnabled()) {
                SubstanceTheme theme = SubstanceThemeUtilities.getTheme(component, ComponentState.DISABLED_UNSELECTED);
                backgr = theme.getBackgroundColor();
            }
        } else {
            SubstanceTheme theme;
            DecorationAreaType decorationType = SubstanceDecorationUtilities.getDecorationType(component);
            if (decorationType != null && (theme = SubstanceThemeUtilities.getNonColorizedTheme(component, true)).toUseDecorationPainter(decorationType)) {
                ComponentState state;
                ComponentState componentState = state = component.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
                if (component instanceof JTextComponent && !((JTextComponent)component).isEditable()) {
                    state = ComponentState.DISABLED_UNSELECTED;
                }
                backgr = SubstanceCoreUtilities.getDefaultBackgroundColor(component.getClass(), SubstanceThemeUtilities.getTheme(component, state));
            }
        }
        return backgr;
    }

    public static ColorUIResource getDefaultBackgroundColor(Class componentClass, SubstanceTheme componentTheme) {
        boolean useLightBackgroundColor;
        boolean bl = useLightBackgroundColor = JTextComponent.class.isAssignableFrom(componentClass) || JComboBox.class.isAssignableFrom(componentClass) || JSpinner.class.isAssignableFrom(componentClass);
        if (useLightBackgroundColor) {
            return new ColorUIResource(componentTheme.getLightBackgroundColor());
        }
        return new ColorUIResource(componentTheme.getBackgroundColor());
    }

    public static Color getStripedBackground(JComponent component, int index) {
        Color backgr = SubstanceCoreUtilities.getBackgroundFillColor(component);
        if (backgr == null) {
            return null;
        }
        if (index % 2 == 0) {
            return backgr;
        }
        int r = backgr.getRed();
        int g = backgr.getGreen();
        int b = backgr.getBlue();
        double coef = 0.96;
        if (!component.isEnabled()) {
            coef = 1.0 - (1.0 - coef) / 2.0;
        }
        ColorUIResource darkerColor = new ColorUIResource((int)(coef * (double)r), (int)(coef * (double)g), (int)(coef * (double)b));
        return darkerColor;
    }

    public static void applyStripedBackground(JComponent component, int index, JComponent renderer) {
        Color backgr = SubstanceCoreUtilities.getStripedBackground(component, index);
        if (backgr == null) {
            return;
        }
        renderer.setBackground(backgr);
    }

    public static void paintTextCompBackground(Graphics g, JComponent comp) {
        SubstanceCoreUtilities.paintTextCompBackground(g, comp, SubstanceCoreUtilities.getBackgroundFillColor(comp), SubstanceCoreUtilities.toBleedWatermark(comp) || !comp.isOpaque());
    }

    public static void paintTextCompBackground(Graphics g, JComponent comp, Color backgr, boolean toOverlayWatermark) {
        Graphics2D g2d = (Graphics2D)g.create();
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(comp)) / 2.0);
        Border compBorder = comp.getBorder();
        boolean isSubstanceBorder = compBorder instanceof SubstanceBorder;
        if (compBorder instanceof CompoundBorder) {
            isSubstanceBorder = isSubstanceBorder || ((CompoundBorder)compBorder).getOutsideBorder() instanceof SubstanceBorder;
        }
        Shape contour = isSubstanceBorder ? BaseButtonShaper.getBaseOutline(comp.getWidth(), comp.getHeight(), SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(comp)), null, borderDelta) : new Rectangle(0, 0, comp.getWidth(), comp.getHeight());
        g2d.setColor(backgr);
        g2d.fill(contour);
        if (toOverlayWatermark) {
            SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(g2d, comp, 0, 0, comp.getWidth(), comp.getHeight());
        }
        g2d.dispose();
    }

    public static Container getSpecialBackgroundFillContainer(JComponent comp) {
        for (Container c = comp; c != null; c = c.getParent()) {
            JComponent jc;
            if (!(c instanceof JComponent) || !Boolean.TRUE.equals((jc = c).getClientProperty(HAS_CUSTOM_BACKGROUND_FILL))) continue;
            return jc;
        }
        return null;
    }

    public static void paintTextComponent(Graphics g, final JTextComponent textComponent, View rootView, Rectangle visibleEditorRect) {
        final SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        Graphics2D g2d = (Graphics2D)g.create();
        if (textComponent.isOpaque() || textPainter.needsBackgroundImage()) {
            SubstanceFillBackgroundDelegate.GLOBAL_INSTANCE.update(g2d, textComponent, false);
        }
        ComponentState currState = textComponent.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
        float alpha = SubstanceThemeUtilities.getTheme(textComponent).getThemeAlpha(textComponent, currState);
        g2d.setComposite(TransitionLayout.getAlphaComposite(textComponent, alpha, g));
        SubstanceTextPainter.BackgroundPaintingCallback callback = new SubstanceTextPainter.BackgroundPaintingCallback(){

            public void paintBackground(Graphics g) {
                Highlighter highlighter = textComponent.getHighlighter();
                if (textPainter.needsBackgroundImage()) {
                    SubstanceCoreUtilities.paintTextCompBackground(g, textComponent);
                }
                if (highlighter != null) {
                    highlighter.paint(g);
                }
            }
        };
        textPainter.init(textComponent, null, true);
        if (textPainter.needsBackgroundImage()) {
            textPainter.setBackgroundFill(textComponent, SubstanceCoreUtilities.getBackgroundFillColor(textComponent), false, 0, 0);
            textPainter.attachCallback(callback);
        } else {
            callback.paintBackground(g2d);
        }
        if (visibleEditorRect != null) {
            rootView.paint(g2d, visibleEditorRect);
        }
        textPainter.renderSurface(g2d);
        Caret caret = textComponent.getCaret();
        if (caret != null) {
            caret.paint(g2d);
        }
        g2d.dispose();
    }
}

