/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceHighlightManager {
    protected Set<Class<?>> useHighlightThemeOn = new HashSet();
    protected Set<Class<?>> cache = new HashSet();
    protected static SubstanceHighlightManager instance;

    public static synchronized SubstanceHighlightManager getInstance() {
        if (instance == null) {
            instance = new SubstanceHighlightManager();
            instance.populate();
        }
        return instance;
    }

    private SubstanceHighlightManager() {
    }

    public void populate() {
        ClassLoader cl = SubstanceCoreUtilities.getClassLoaderForResources();
        try {
            Enumeration<URL> rs = cl.getResources("META-INF/substance.highlight.properties");
            while (rs.hasMoreElements()) {
                URL rUrl = rs.nextElement();
                this.populateFrom(rUrl);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateFrom(URL url) {
        InputStream is = null;
        BufferedReader br = null;
        try {
            String line;
            is = url.openStream();
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                this.addToUseHighlightTheme(line);
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public void addToUseHighlightTheme(Class<?> clazz) {
        this.useHighlightThemeOn.add(clazz);
    }

    public void addToUseHighlightTheme(String className) {
        try {
            this.useHighlightThemeOn.add(Class.forName(className));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized boolean toUseHighlightTheme(Component comp) {
        for (Component currComp = comp; currComp != null; currComp = currComp.getParent()) {
            Class<?> currClazz = currComp.getClass();
            if (this.cache.contains(currClazz)) {
                return true;
            }
            for (Class<?> usehHighlightThemeClazz : this.useHighlightThemeOn) {
                if (!usehHighlightThemeClazz.isAssignableFrom(currClazz)) continue;
                this.cache.add(currClazz);
                return true;
            }
        }
        return false;
    }
}

