/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.Painter;

public class JXGraph
extends JXPanel {
    private static final float STROKE_AXIS = 1.2f;
    private static final float STROKE_GRID = 1.0f;
    private static final float ZOOM_MULTIPLIER = 1.1f;
    private PropertyChangeListener plotChangeListener;
    private Color majorGridColor = Color.GRAY.brighter();
    private Color minorGridColor = new Color(220, 220, 220);
    private Color axisColor = Color.BLACK;
    private List<DrawablePlot> plots;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private Rectangle2D defaultView;
    private double originX;
    private double originY;
    private double majorX;
    private double defaultMajorX;
    private int minorCountX;
    private double majorY;
    private double defaultMajorY;
    private int minorCountY;
    private boolean textPainted = true;
    private boolean gridPainted = true;
    private boolean axisPainted = true;
    private boolean backPainted = true;
    private Point dragStart;
    private NumberFormat mainFormatter;
    private NumberFormat secondFormatter;
    private boolean inputEnabled = true;
    private ZoomHandler zoomHandler;
    private PanMotionHandler panMotionHandler;
    private PanHandler panHandler;
    private ResetHandler resetHandler;

    public JXGraph() {
        this(0.0, 0.0, -1.0, 1.0, -1.0, 1.0, 0.2, 4, 0.2, 4);
    }

    public JXGraph(Rectangle2D view) {
        this(new Point2D.Double(view.getCenterX(), view.getCenterY()), view, 0.2, 4, 0.2, 4);
    }

    public JXGraph(Rectangle2D view, double majorX, int minorCountX, double majorY, int minorCountY) {
        this(new Point2D.Double(view.getCenterX(), view.getCenterY()), view, majorX, minorCountX, majorY, minorCountY);
    }

    public JXGraph(Point2D origin, Rectangle2D view) {
        this(origin, view, 0.2, 4, 0.2, 4);
    }

    public JXGraph(Point2D origin, Rectangle2D view, double majorX, int minorCountX, double majorY, int minorCountY) {
        this(origin.getX(), origin.getY(), view.getMinX(), view.getMaxX(), view.getMinY(), view.getMaxY(), majorX, minorCountX, majorY, minorCountY);
    }

    public JXGraph(double originX, double originY, double minX, double maxX, double minY, double maxY, double majorX, int minorCountX, double majorY, int minorCountY) {
        if (minX >= maxX) {
            throw new IllegalArgumentException("minX must be < to maxX");
        }
        if (minY >= maxY) {
            throw new IllegalArgumentException("minY must be < to maxY");
        }
        if (minorCountX < 0) {
            throw new IllegalArgumentException("minorCountX must be >= 0");
        }
        if (minorCountY < 0) {
            throw new IllegalArgumentException("minorCountY must be >= 0");
        }
        if (majorX <= 0.0) {
            throw new IllegalArgumentException("majorX must be > 0.0");
        }
        if (majorY <= 0.0) {
            throw new IllegalArgumentException("majorY must be > 0.0");
        }
        this.originX = originX;
        this.originY = originY;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.defaultView = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
        this.defaultMajorX = majorX;
        this.setMajorX(this.defaultMajorX);
        this.setMinorCountX(minorCountX);
        this.defaultMajorY = majorY;
        this.setMajorY(this.defaultMajorY);
        this.setMinorCountY(minorCountY);
        this.plots = new LinkedList<DrawablePlot>();
        this.mainFormatter = NumberFormat.getInstance();
        this.mainFormatter.setMaximumFractionDigits(2);
        this.secondFormatter = new DecimalFormat("0.##E0");
        this.resetHandler = new ResetHandler();
        this.addMouseListener(this.resetHandler);
        this.panHandler = new PanHandler();
        this.addMouseListener(this.panHandler);
        this.panMotionHandler = new PanMotionHandler();
        this.addMouseMotionListener(this.panMotionHandler);
        this.zoomHandler = new ZoomHandler();
        this.addMouseWheelListener(this.zoomHandler);
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.plotChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JXGraph.this.repaint();
            }
        };
    }

    @Override
    public boolean isOpaque() {
        if (!this.isBackgroundPainted()) {
            return false;
        }
        return super.isOpaque();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setInputEnabled(enabled);
    }

    public void setInputEnabled(boolean enabled) {
        if (this.inputEnabled != enabled) {
            boolean old = this.isInputEnabled();
            this.inputEnabled = enabled;
            if (enabled) {
                this.addMouseListener(this.resetHandler);
                this.addMouseListener(this.panHandler);
                this.addMouseMotionListener(this.panMotionHandler);
                this.addMouseWheelListener(this.zoomHandler);
            } else {
                this.removeMouseListener(this.resetHandler);
                this.removeMouseListener(this.panHandler);
                this.removeMouseMotionListener(this.panMotionHandler);
                this.removeMouseWheelListener(this.zoomHandler);
            }
            this.firePropertyChange("inputEnabled", old, this.isInputEnabled());
        }
    }

    public boolean isInputEnabled() {
        return this.inputEnabled;
    }

    public boolean isTextPainted() {
        return this.textPainted;
    }

    public void setTextPainted(boolean textPainted) {
        boolean old = this.isTextPainted();
        this.textPainted = textPainted;
        this.firePropertyChange("textPainted", old, this.textPainted);
    }

    public boolean isGridPainted() {
        return this.gridPainted;
    }

    public void setGridPainted(boolean gridPainted) {
        boolean old = this.isGridPainted();
        this.gridPainted = gridPainted;
        this.firePropertyChange("gridPainted", old, this.isGridPainted());
    }

    public boolean isAxisPainted() {
        return this.axisPainted;
    }

    public void setAxisPainted(boolean axisPainted) {
        boolean old = this.isAxisPainted();
        this.axisPainted = axisPainted;
        this.firePropertyChange("axisPainted", old, this.isAxisPainted());
    }

    public boolean isBackgroundPainted() {
        return this.backPainted;
    }

    public void setBackgroundPainted(boolean backPainted) {
        boolean old = this.isBackgroundPainted();
        this.backPainted = backPainted;
        this.firePropertyChange("backgroundPainted", old, this.isBackgroundPainted());
    }

    public Color getMajorGridColor() {
        return this.majorGridColor;
    }

    public void setMajorGridColor(Color majorGridColor) {
        if (majorGridColor == null) {
            throw new IllegalArgumentException("Color cannot be null.");
        }
        Color old = this.getMajorGridColor();
        this.majorGridColor = majorGridColor;
        this.firePropertyChange("majorGridColor", old, this.getMajorGridColor());
    }

    public Color getMinorGridColor() {
        return this.minorGridColor;
    }

    public void setMinorGridColor(Color minorGridColor) {
        if (minorGridColor == null) {
            throw new IllegalArgumentException("Color cannot be null.");
        }
        Color old = this.getMinorGridColor();
        this.minorGridColor = minorGridColor;
        this.firePropertyChange("minorGridColor", old, this.getMinorGridColor());
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(Color axisColor) {
        if (axisColor == null) {
            throw new IllegalArgumentException("Color cannot be null.");
        }
        Color old = this.getAxisColor();
        this.axisColor = axisColor;
        this.firePropertyChange("axisColor", old, this.getAxisColor());
    }

    public double getMajorX() {
        return this.majorX;
    }

    public void setMajorX(double majorX) {
        if (majorX <= 0.0) {
            throw new IllegalArgumentException("majorX must be > 0.0");
        }
        double old = this.getMajorX();
        this.majorX = majorX;
        this.defaultMajorX = majorX;
        this.repaint();
        this.firePropertyChange("majorX", old, this.getMajorX());
    }

    public int getMinorCountX() {
        return this.minorCountX;
    }

    public void setMinorCountX(int minorCountX) {
        if (minorCountX < 0) {
            throw new IllegalArgumentException("minorCountX must be >= 0");
        }
        int old = this.getMinorCountX();
        this.minorCountX = minorCountX;
        this.repaint();
        this.firePropertyChange("minorCountX", old, this.getMinorCountX());
    }

    public double getMajorY() {
        return this.majorY;
    }

    public void setMajorY(double majorY) {
        if (majorY <= 0.0) {
            throw new IllegalArgumentException("majorY must be > 0.0");
        }
        double old = this.getMajorY();
        this.majorY = majorY;
        this.defaultMajorY = majorY;
        this.repaint();
        this.firePropertyChange("majorY", old, this.getMajorY());
    }

    public int getMinorCountY() {
        return this.minorCountY;
    }

    public void setMinorCountY(int minorCountY) {
        if (minorCountY < 0) {
            throw new IllegalArgumentException("minorCountY must be >= 0");
        }
        int old = this.getMinorCountY();
        this.minorCountY = minorCountY;
        this.repaint();
        this.firePropertyChange("minorCountY", old, this.getMinorCountY());
    }

    public void setViewAndOrigin(Rectangle2D bounds) {
        this.setView(bounds);
        this.setOrigin(new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
    }

    public void setView(Rectangle2D bounds) {
        if (bounds == null) {
            return;
        }
        Rectangle2D old = this.getView();
        this.defaultView = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        this.minX = this.defaultView.getMinX();
        this.maxX = this.defaultView.getMaxX();
        this.minY = this.defaultView.getMinY();
        this.maxY = this.defaultView.getMaxY();
        this.majorX = this.defaultMajorX;
        this.majorY = this.defaultMajorY;
        this.firePropertyChange("view", old, this.getView());
        this.repaint();
    }

    public Rectangle2D getView() {
        return new Rectangle2D.Double(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    public void resetView() {
        this.setView(this.defaultView);
    }

    public void setOrigin(Point2D origin) {
        if (origin == null) {
            return;
        }
        Point2D old = this.getOrigin();
        this.originX = origin.getX();
        this.originY = origin.getY();
        this.firePropertyChange("origin", old, this.getOrigin());
        this.repaint();
    }

    public Point2D getOrigin() {
        return new Point2D.Double(this.originX, this.originY);
    }

    public void addPlots(Color color, Plot ... plotList) {
        if (color == null) {
            throw new IllegalArgumentException("Plots color cannot be null.");
        }
        if (plotList == null) {
            return;
        }
        for (Plot plot : plotList) {
            DrawablePlot drawablePlot = new DrawablePlot(plot, color);
            if (plot == null || this.plots.contains(drawablePlot)) continue;
            plot.addPropertyChangeListener(this.plotChangeListener);
            this.plots.add(drawablePlot);
        }
        this.repaint();
    }

    public void removePlots(Plot ... plotList) {
        if (plotList == null) {
            return;
        }
        for (Plot plot : plotList) {
            if (plot == null) continue;
            DrawablePlot toRemove = null;
            for (DrawablePlot drawable : this.plots) {
                if (drawable.getEquation() != plot) continue;
                toRemove = drawable;
                break;
            }
            if (toRemove == null) continue;
            plot.removePropertyChangeListener(this.plotChangeListener);
            this.plots.remove(toRemove);
        }
        this.repaint();
    }

    public void removeAllPlots() {
        this.plots.clear();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 400);
    }

    protected double yPositionToPixel(double position) {
        double height = this.getHeight();
        return height - (position - this.minY) * height / (this.maxY - this.minY);
    }

    protected double xPositionToPixel(double position) {
        return (position - this.minX) * (double)this.getWidth() / (this.maxX - this.minX);
    }

    protected double xPixelToPosition(double pixel) {
        return this.minX + pixel * (this.maxX - this.minX) / (double)this.getWidth();
    }

    protected double yPixelToPosition(double pixel) {
        return this.minY + ((double)this.getHeight() - pixel) * (this.maxY - this.minY) / (double)this.getHeight();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.setupGraphics(g2);
        this.paintBackground(g2);
        this.drawGrid(g2);
        this.drawAxis(g2);
        this.drawPlots(g2);
        this.drawLabels(g2);
        this.paintExtra(g2);
    }

    protected void paintExtra(Graphics2D g2) {
    }

    private void drawPlots(Graphics2D g2) {
        for (DrawablePlot drawable : this.plots) {
            g2.setColor(drawable.getColor());
            this.drawPlot(g2, drawable.getEquation());
        }
    }

    private void drawPlot(Graphics2D g2, Plot equation) {
        float x = 0.0f;
        float y = (float)this.yPositionToPixel(equation.compute(this.xPixelToPosition(0.0)));
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y);
        float width = this.getWidth();
        for (x = 0.0f; x < width; x += 1.0f) {
            double position = this.xPixelToPosition(x);
            y = (float)this.yPositionToPixel(equation.compute(position));
            path.lineTo(x, y);
        }
        g2.draw(path);
    }

    private void drawGrid(Graphics2D g2) {
        Stroke stroke = g2.getStroke();
        if (this.isGridPainted()) {
            this.drawVerticalGrid(g2);
            this.drawHorizontalGrid(g2);
        }
        g2.setStroke(stroke);
    }

    private void drawLabels(Graphics2D g2) {
        if (this.isTextPainted()) {
            double axisH = this.yPositionToPixel(this.originY);
            double axisV = this.xPositionToPixel(this.originX);
            if (!this.isAxisPainted()) {
                Stroke stroke = g2.getStroke();
                g2.setStroke(new BasicStroke(1.2f));
                g2.setColor(this.getAxisColor());
                g2.drawLine((int)axisV - 3, (int)axisH, (int)axisV + 3, (int)axisH);
                g2.drawLine((int)axisV, (int)axisH - 3, (int)axisV, (int)axisH + 3);
                g2.setStroke(stroke);
            }
            g2.setColor(this.getForeground());
            FontMetrics metrics = g2.getFontMetrics();
            g2.drawString(this.format(this.originX) + "; " + this.format(this.originY), (int)axisV + 5, (int)axisH + metrics.getHeight());
            this.drawHorizontalAxisLabels(g2);
            this.drawVerticalAxisLabels(g2);
        }
    }

    private void drawVerticalAxisLabels(Graphics2D g2) {
        double startY;
        double axisV = this.xPositionToPixel(this.originX);
        for (double y = startY = Math.floor(this.minY / this.majorY) * this.majorY; y < this.maxY + this.majorY; y += this.majorY) {
            if (y - this.majorY / 2.0 < this.originY && y + this.majorY / 2.0 > this.originY) continue;
            int position = (int)this.yPositionToPixel(y);
            g2.drawString(this.format(y), (int)axisV + 5, position);
        }
    }

    private void drawHorizontalGrid(Graphics2D g2) {
        double startY;
        int position;
        double minorSpacing = this.majorY / (double)this.getMinorCountY();
        double axisV = this.xPositionToPixel(this.originX);
        BasicStroke gridStroke = new BasicStroke(1.0f);
        BasicStroke axisStroke = new BasicStroke(1.2f);
        Rectangle clip = g2.getClipBounds();
        if (!this.isAxisPainted() && (position = (int)this.xPositionToPixel(this.originX)) >= clip.x && position <= clip.x + clip.width) {
            g2.setColor(this.getMajorGridColor());
            g2.drawLine(position, clip.y, position, clip.y + clip.height);
        }
        for (double y = startY = Math.floor(this.minY / this.majorY) * this.majorY; y < this.maxY + this.majorY; y += this.majorY) {
            g2.setStroke(gridStroke);
            g2.setColor(this.getMinorGridColor());
            for (int i = 0; i < this.getMinorCountY(); ++i) {
                position = (int)this.yPositionToPixel(y - (double)i * minorSpacing);
                if (position < clip.y || position > clip.y + clip.height) continue;
                g2.drawLine(clip.x, position, clip.x + clip.width, position);
            }
            position = (int)this.yPositionToPixel(y);
            if (position < clip.y || position > clip.y + clip.height) continue;
            g2.setColor(this.getMajorGridColor());
            g2.drawLine(clip.x, position, clip.x + clip.width, position);
            g2.setStroke(axisStroke);
            g2.setColor(this.getAxisColor());
            g2.drawLine((int)axisV - 3, position, (int)axisV + 3, position);
        }
    }

    private void drawHorizontalAxisLabels(Graphics2D g2) {
        double startX;
        double axisH = this.yPositionToPixel(this.originY);
        FontMetrics metrics = g2.getFontMetrics();
        for (double x = startX = Math.floor(this.minX / this.majorX) * this.majorX; x < this.maxX + this.majorX; x += this.majorX) {
            if (x - this.majorX / 2.0 < this.originX && x + this.majorX / 2.0 > this.originX) continue;
            int position = (int)this.xPositionToPixel(x);
            g2.drawString(this.format(x), position, (int)axisH + metrics.getHeight());
        }
    }

    private void drawVerticalGrid(Graphics2D g2) {
        double startX;
        int position;
        double minorSpacing = this.majorX / (double)this.getMinorCountX();
        double axisH = this.yPositionToPixel(this.originY);
        BasicStroke gridStroke = new BasicStroke(1.0f);
        BasicStroke axisStroke = new BasicStroke(1.2f);
        Rectangle clip = g2.getClipBounds();
        if (!this.isAxisPainted() && (position = (int)this.yPositionToPixel(this.originY)) >= clip.y && position <= clip.y + clip.height) {
            g2.setColor(this.getMajorGridColor());
            g2.drawLine(clip.x, position, clip.x + clip.width, position);
        }
        for (double x = startX = Math.floor(this.minX / this.majorX) * this.majorX; x < this.maxX + this.majorX; x += this.majorX) {
            g2.setStroke(gridStroke);
            g2.setColor(this.getMinorGridColor());
            for (int i = 0; i < this.getMinorCountX(); ++i) {
                position = (int)this.xPositionToPixel(x - (double)i * minorSpacing);
                if (position < clip.x || position > clip.x + clip.width) continue;
                g2.drawLine(position, clip.y, position, clip.y + clip.height);
            }
            position = (int)this.xPositionToPixel(x);
            if (position < clip.x || position > clip.x + clip.width) continue;
            g2.setColor(this.getMajorGridColor());
            g2.drawLine(position, clip.y, position, clip.y + clip.height);
            g2.setStroke(axisStroke);
            g2.setColor(this.getAxisColor());
            g2.drawLine(position, (int)axisH - 3, position, (int)axisH + 3);
        }
    }

    private void drawAxis(Graphics2D g2) {
        if (!this.isAxisPainted()) {
            return;
        }
        double axisH = this.yPositionToPixel(this.originY);
        double axisV = this.xPositionToPixel(this.originX);
        Rectangle clip = g2.getClipBounds();
        g2.setColor(this.getAxisColor());
        Stroke stroke = g2.getStroke();
        g2.setStroke(new BasicStroke(1.2f));
        if (axisH >= (double)clip.y && axisH <= (double)(clip.y + clip.height)) {
            g2.drawLine(clip.x, (int)axisH, clip.x + clip.width, (int)axisH);
        }
        if (axisV >= (double)clip.x && axisV <= (double)(clip.x + clip.width)) {
            g2.drawLine((int)axisV, clip.y, (int)axisV, clip.y + clip.height);
        }
        g2.setStroke(stroke);
    }

    protected void setupGraphics(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    protected void paintBackground(Graphics2D g2) {
        if (this.isBackgroundPainted()) {
            Painter p = this.getBackgroundPainter();
            if (p != null) {
                p.paint(g2, this, this.getWidth(), this.getHeight());
            } else {
                g2.setColor(this.getBackground());
                g2.fill(g2.getClipBounds());
            }
        }
    }

    private String format(double number) {
        boolean farAway = number != 0.0 && Math.abs(number) < 0.01 || Math.abs(number) > 99.0;
        return (farAway ? this.secondFormatter : this.mainFormatter).format(number);
    }

    private class PanMotionHandler
    extends MouseMotionAdapter {
        private PanMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point dragEnd = e.getPoint();
            double distance = JXGraph.this.xPixelToPosition(dragEnd.getX()) - JXGraph.this.xPixelToPosition(JXGraph.this.dragStart.getX());
            JXGraph.this.minX = JXGraph.this.minX - distance;
            JXGraph.this.maxX = JXGraph.this.maxX - distance;
            distance = JXGraph.this.yPixelToPosition(dragEnd.getY()) - JXGraph.this.yPixelToPosition(JXGraph.this.dragStart.getY());
            JXGraph.this.minY = JXGraph.this.minY - distance;
            JXGraph.this.maxY = JXGraph.this.maxY - distance;
            JXGraph.this.repaint();
            JXGraph.this.dragStart = dragEnd;
        }
    }

    private class PanHandler
    extends MouseAdapter {
        private PanHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            JXGraph.this.dragStart = e.getPoint();
            JXGraph.this.setCursor(Cursor.getPredefinedCursor(13));
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            JXGraph.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class ResetHandler
    extends MouseAdapter {
        private ResetHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 2) {
                return;
            }
            JXGraph.this.resetView();
        }
    }

    private class ZoomHandler
    implements MouseWheelListener {
        private ZoomHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            double distanceX = JXGraph.this.maxX - JXGraph.this.minX;
            double distanceY = JXGraph.this.maxY - JXGraph.this.minY;
            double cursorX = JXGraph.this.minX + distanceX / 2.0;
            double cursorY = JXGraph.this.minY + distanceY / 2.0;
            int rotation = e.getWheelRotation();
            if (rotation < 0) {
                distanceX /= (double)1.1f;
                distanceY /= (double)1.1f;
                JXGraph.this.majorX = JXGraph.this.majorX / (double)1.1f;
                JXGraph.this.majorY = JXGraph.this.majorY / (double)1.1f;
            } else {
                distanceX *= (double)1.1f;
                distanceY *= (double)1.1f;
                JXGraph.this.majorX = JXGraph.this.majorX * (double)1.1f;
                JXGraph.this.majorY = JXGraph.this.majorY * (double)1.1f;
            }
            JXGraph.this.minX = cursorX - distanceX / 2.0;
            JXGraph.this.maxX = cursorX + distanceX / 2.0;
            JXGraph.this.minY = cursorY - distanceY / 2.0;
            JXGraph.this.maxY = cursorY + distanceY / 2.0;
            JXGraph.this.repaint();
        }
    }

    private static class DrawablePlot {
        private final Plot equation;
        private final Color color;

        private DrawablePlot(Plot equation, Color color) {
            this.equation = equation;
            this.color = color;
        }

        private Plot getEquation() {
            return this.equation;
        }

        private Color getColor() {
            return this.color;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DrawablePlot that = (DrawablePlot)o;
            if (!this.color.equals(that.color)) {
                return false;
            }
            return this.equation.equals(that.equation);
        }

        public int hashCode() {
            int result = this.equation.hashCode();
            result = 29 * result + this.color.hashCode();
            return result;
        }
    }

    public static abstract class Plot
    extends AbstractBean {
        protected Plot() {
        }

        public abstract double compute(double var1);
    }
}

