/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class JXLabel
extends JLabel {
    public static final double NORMAL = 0.0;
    public static final double INVERTED = Math.PI;
    public static final double VERTICAL_LEFT = 4.71238898038469;
    public static final double VERTICAL_RIGHT = 1.5707963267948966;
    private double textRotation = 0.0;
    private boolean painting = false;
    private Painter foregroundPainter;
    private Painter backgroundPainter;
    private boolean multiLine;
    private int pWidth;
    private int pHeight;
    private boolean dontIgnoreRepaint = false;
    private int occupiedWidth;
    private static final String oldRendererKey = "washtml";
    private boolean paintBorderInsets = true;
    private int maxLineSpan = -1;
    public boolean painted;
    private TextAlignment textAlignment = TextAlignment.LEFT;

    public JXLabel() {
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(Icon image) {
        super(image);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(String text) {
        super(text);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(String text, Icon image, int horizontalAlignment) {
        super(text, image, horizontalAlignment);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    private void initPainterSupport() {
        this.foregroundPainter = new AbstractPainter<JXLabel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doPaint(Graphics2D g, JXLabel label, int width, int height) {
                Insets i = JXLabel.this.getInsets();
                g = (Graphics2D)g.create(-i.left, -i.top, width, height);
                try {
                    label.paint(g);
                }
                finally {
                    g.dispose();
                }
            }

            @Override
            protected boolean shouldUseCache() {
                return false;
            }

            public boolean equals(Object obj) {
                return obj != null && this.getClass().equals(obj.getClass());
            }
        };
    }

    private void initLineWrapSupport() {
        this.addPropertyChangeListener(new MultiLineSupport());
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorResized(HierarchyEvent e) {
                View view;
                Rectangle viewportBounds;
                if (e.getChanged() instanceof JViewport && (viewportBounds = e.getChanged().getBounds()).getWidth() < (double)JXLabel.this.getWidth() && (view = JXLabel.this.getWrappingView()) != null) {
                    view.setSize(viewportBounds.width, viewportBounds.height);
                }
            }
        });
    }

    public final Painter getForegroundPainter() {
        return this.foregroundPainter;
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        View view;
        int oldH = this.getHeight();
        super.reshape(x, y, w, h);
        if (!this.isLineWrap()) {
            return;
        }
        if (oldH == 0) {
            return;
        }
        if (w > this.getVisibleRect().width) {
            w = this.getVisibleRect().width;
        }
        if ((view = (View)this.getClientProperty("html")) != null && view instanceof Renderer) {
            view.setSize(w - this.occupiedWidth, h);
        }
    }

    public void setForegroundPainter(Painter painter) {
        Painter old = this.getForegroundPainter();
        if (painter == null) {
            this.initPainterSupport();
        } else {
            this.foregroundPainter = painter;
        }
        this.firePropertyChange("foregroundPainter", old, this.getForegroundPainter());
        this.repaint();
    }

    public void setBackgroundPainter(Painter p) {
        Painter old = this.getBackgroundPainter();
        this.backgroundPainter = p;
        this.firePropertyChange("backgroundPainter", old, this.getBackgroundPainter());
        this.repaint();
    }

    public final Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public double getTextRotation() {
        return this.textRotation;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.isPreferredSizeSet()) {
            return size;
        }
        if (this.textRotation == 0.0) {
            int gap;
            View view = this.getWrappingView();
            if (view == null) {
                if (this.isLineWrap() && !MultiLineSupport.isHTML(this.getText())) {
                    this.getMultiLineSupport();
                    this.putClientProperty("html", MultiLineSupport.createView(this));
                    view = (View)this.getClientProperty("html");
                } else {
                    return size;
                }
            }
            Insets insets = this.getInsets();
            int dx = insets.left + insets.right;
            int dy = insets.top + insets.bottom;
            Rectangle textR = new Rectangle();
            Rectangle viewR = new Rectangle();
            textR.height = 0;
            textR.width = 0;
            textR.y = 0;
            textR.x = 0;
            viewR.x = dx;
            viewR.y = dy;
            viewR.height = Short.MAX_VALUE;
            viewR.width = Short.MAX_VALUE;
            Rectangle iconR = this.calculateIconRect();
            boolean textIsEmpty = this.getText() == null || this.getText().equals("");
            int lsb = 0;
            if (textIsEmpty) {
                textR.height = 0;
                textR.width = 0;
                gap = 0;
            } else {
                JPanel panel;
                Border b;
                gap = iconR.width == 0 ? 0 : this.getIconTextGap();
                this.occupiedWidth = dx + iconR.width + gap;
                Container parent = this.getParent();
                if (parent != null && parent instanceof JPanel && (b = (panel = (JPanel)parent).getBorder()) != null) {
                    Insets in = b.getBorderInsets(panel);
                    this.occupiedWidth += in.left + in.right;
                }
                int availTextWidth = this.getHorizontalTextPosition() == 0 ? viewR.width : viewR.width - (iconR.width + gap);
                float xPrefSpan = view.getPreferredSpan(0);
                textR.width = Math.min(availTextWidth, (int)xPrefSpan);
                if (this.maxLineSpan > 0) {
                    textR.width = Math.min(textR.width, this.maxLineSpan);
                    if (xPrefSpan > (float)this.maxLineSpan) {
                        view.setSize(this.maxLineSpan, textR.height);
                    }
                }
                textR.height = (int)view.getPreferredSpan(1);
                if (textR.height == 0) {
                    textR.height = this.getFont().getSize();
                }
            }
            textR.y = this.getVerticalTextPosition() == 1 ? (this.getHorizontalTextPosition() != 0 ? 0 : -(textR.height + gap)) : (this.getVerticalTextPosition() == 0 ? iconR.height / 2 - textR.height / 2 : (this.getVerticalTextPosition() != 0 ? iconR.height - textR.height : iconR.height + gap));
            textR.x = this.getHorizontalTextPosition() == 2 ? -(textR.width + gap) : (this.getHorizontalTextPosition() == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
            int labelR_x = Math.min(iconR.x, textR.x);
            int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
            int labelR_y = Math.min(iconR.y, textR.y);
            int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
            int day = this.getVerticalAlignment() == 1 ? viewR.y - labelR_y : (this.getVerticalAlignment() == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
            int dax = this.getHorizontalAlignment() == 2 ? viewR.x - labelR_x : (this.getHorizontalAlignment() == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
            textR.x += dax;
            textR.y += day;
            iconR.x += dax;
            iconR.y += day;
            if (lsb < 0) {
                textR.x -= lsb;
            }
            int x1 = Math.min(iconR.x, textR.x);
            int x2 = Math.max(iconR.x + iconR.width, textR.x + textR.width);
            int y1 = Math.min(iconR.y, textR.y);
            int y2 = Math.max(iconR.y + iconR.height, textR.y + textR.height);
            Dimension rv = new Dimension(x2 - x1, y2 - y1);
            rv.width += dx;
            rv.height += dy;
            return rv;
        }
        double theta = this.getTextRotation();
        size.setSize(JXLabel.rotateWidth(size, theta), JXLabel.rotateHeight(size, theta));
        return size;
    }

    private View getWrappingView() {
        if (super.getTopLevelAncestor() == null) {
            return null;
        }
        View view = (View)this.getClientProperty("html");
        if (!(view instanceof Renderer)) {
            return null;
        }
        return view;
    }

    private Container getViewport() {
        for (Container p = this; p != null; p = p.getParent()) {
            if (!(p instanceof Window) && !(p instanceof Applet) && !(p instanceof JViewport)) continue;
            return p;
        }
        return null;
    }

    private Rectangle calculateIconRect() {
        Rectangle iconR = new Rectangle();
        Icon icon = this.isEnabled() ? this.getIcon() : this.getDisabledIcon();
        iconR.height = 0;
        iconR.width = 0;
        iconR.y = 0;
        iconR.x = 0;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        return iconR;
    }

    public int getMaxLineSpan() {
        return this.maxLineSpan;
    }

    public void setMaxLineSpan(int maxLineSpan) {
        int old = this.getMaxLineSpan();
        this.maxLineSpan = maxLineSpan;
        this.firePropertyChange("maxLineSpan", old, this.getMaxLineSpan());
    }

    private static int rotateWidth(Dimension size, double theta) {
        return (int)Math.round((double)size.width * Math.abs(Math.cos(theta)) + (double)size.height * Math.abs(Math.sin(theta)));
    }

    private static int rotateHeight(Dimension size, double theta) {
        return (int)Math.round((double)size.width * Math.abs(Math.sin(theta)) + (double)size.height * Math.abs(Math.cos(theta)));
    }

    public void setTextRotation(double textOrientation) {
        double old = this.getTextRotation();
        this.textRotation = textOrientation;
        if (old != this.getTextRotation()) {
            this.firePropertyChange("textRotation", old, this.getTextRotation());
        }
        this.repaint();
    }

    public void setLineWrap(boolean b) {
        boolean old = this.isLineWrap();
        this.multiLine = b;
        if (this.isLineWrap() != old) {
            this.firePropertyChange("lineWrap", old, this.isLineWrap());
            if (this.getForegroundPainter() != null) {
                ((AbstractPainter)this.getForegroundPainter()).setCacheable(!b);
            }
        }
    }

    public boolean isLineWrap() {
        return this.multiLine;
    }

    public TextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(TextAlignment alignment) {
        TextAlignment old = this.getTextAlignment();
        this.textAlignment = alignment;
        this.firePropertyChange("textAlignment", old, this.getTextAlignment());
    }

    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    @Override
    public boolean isOpaque() {
        return this.painting ? false : super.isOpaque();
    }

    public void setPaintBorderInsets(boolean paintBorderInsets) {
        boolean old = this.isPaintBorderInsets();
        this.paintBorderInsets = paintBorderInsets;
        this.firePropertyChange("paintBorderInsets", old, this.isPaintBorderInsets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        this.painted = true;
        if (this.painting || this.backgroundPainter == null && this.foregroundPainter == null) {
            super.paintComponent(g);
        } else {
            this.pWidth = this.getWidth();
            this.pHeight = this.getHeight();
            Insets i = this.getInsets();
            if (this.backgroundPainter != null) {
                Graphics2D tmp = (Graphics2D)g.create();
                try {
                    if (!this.isPaintBorderInsets()) {
                        tmp.translate(i.left, i.top);
                        this.pWidth = this.pWidth - i.left - i.right;
                        this.pHeight = this.pHeight - i.top - i.bottom;
                    }
                    this.backgroundPainter.paint(tmp, this, this.pWidth, this.pHeight);
                }
                finally {
                    tmp.dispose();
                }
            }
            if (this.foregroundPainter != null) {
                this.pWidth = this.getWidth() - i.left - i.right;
                this.pHeight = this.getHeight() - i.top - i.bottom;
                Point2D tPoint = this.calculateT();
                double wx = Math.sin(this.textRotation) * tPoint.getY() + Math.cos(this.textRotation) * tPoint.getX();
                double wy = Math.sin(this.textRotation) * tPoint.getX() + Math.cos(this.textRotation) * tPoint.getY();
                double x = ((double)this.getWidth() - wx) / 2.0 + Math.sin(this.textRotation) * tPoint.getY();
                double y = ((double)this.getHeight() - wy) / 2.0;
                Graphics2D tmp = (Graphics2D)g.create();
                if (i != null) {
                    tmp.translate((double)i.left + x, (double)i.top + y);
                } else {
                    tmp.translate(x, y);
                }
                tmp.rotate(this.textRotation);
                this.painting = true;
                this.foregroundPainter.paint(tmp, this, this.pWidth, this.pHeight);
                tmp.dispose();
                this.painting = false;
                this.pWidth = 0;
                this.pHeight = 0;
            }
        }
    }

    private Point2D calculateT() {
        double tx = this.getWidth();
        double ty = this.getHeight();
        if (this.textRotation > 4.697 && this.textRotation < 4.727 || this.textRotation > 1.555 && this.textRotation < 1.585) {
            int tmp = this.pHeight;
            this.pHeight = this.pWidth;
            this.pWidth = tmp;
            tx = this.pWidth;
            ty = this.pHeight;
        } else if (this.textRotation > -0.015 && this.textRotation < 0.015 || this.textRotation > 3.14 && this.textRotation < 3.143) {
            this.pHeight = this.getHeight();
            this.pWidth = this.getWidth();
        } else {
            this.dontIgnoreRepaint = false;
            double square = (double)Math.min(this.getHeight(), this.getWidth()) * Math.cos(0.7853981633974483);
            View v = (View)this.getClientProperty("html");
            if (v == null) {
                ty = this.getFontMetrics(this.getFont()).getHeight();
                double cw = ((double)this.getWidth() - Math.abs(ty * Math.sin(this.textRotation))) / Math.abs(Math.cos(this.textRotation));
                double ch = ((double)this.getHeight() - Math.abs(ty * Math.cos(this.textRotation))) / Math.abs(Math.sin(this.textRotation));
                tx = cw < 0.0 ? ch : (ch > 0.0 ? Math.min(cw, ch) : cw);
            } else {
                float w = v.getPreferredSpan(0);
                float h = v.getPreferredSpan(1);
                double c = w;
                double alpha = this.textRotation;
                boolean ready = false;
                while (!ready) {
                    while (h == v.getPreferredSpan(1)) {
                        v.setSize(w -= 10.0f, h);
                    }
                    if ((double)w < square || (double)h > square) {
                        w = h = (float)square;
                        v.setSize(w, 100000.0f);
                        break;
                    }
                    h = v.getPreferredSpan(1);
                    double cw = ((double)this.getWidth() - Math.abs((double)h * Math.sin(alpha))) / Math.abs(Math.cos(alpha));
                    double ch = ((double)this.getHeight() - Math.abs((double)h * Math.cos(alpha))) / Math.abs(Math.sin(alpha));
                    c = cw < 0.0 ? ch : (ch > 0.0 ? Math.min(cw, ch) : cw);
                    if ((c -= 1.0) > (double)w) {
                        v.setSize((float)c, 10.0f * h);
                        ready = true;
                        continue;
                    }
                    v.setSize((float)c, 10.0f * h);
                    if (v.getPreferredSpan(1) > h) {
                        v.setSize(w, 10.0f * h);
                        continue;
                    }
                    w = (float)c;
                    ready = true;
                }
                tx = Math.floor(w);
                ty = h;
            }
            this.pWidth = (int)tx;
            this.pHeight = (int)ty;
            this.dontIgnoreRepaint = true;
        }
        return new Point2D.Double(tx, ty);
    }

    @Override
    public void repaint() {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint();
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint(x, y, width, height);
    }

    @Override
    public void repaint(long tm) {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint(tm);
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint(tm, x, y, width, height);
    }

    @Override
    public int getHeight() {
        int retValue = super.getHeight();
        if (this.painting) {
            retValue = this.pHeight;
        }
        return retValue;
    }

    @Override
    public int getWidth() {
        int retValue = super.getWidth();
        if (this.painting) {
            retValue = this.pWidth;
        }
        return retValue;
    }

    protected MultiLineSupport getMultiLineSupport() {
        return new MultiLineSupport();
    }

    protected int getOccupiedWidth() {
        return this.occupiedWidth;
    }

    static class Renderer
    extends WrappedPlainView {
        JXLabel host;
        boolean invalidated = false;
        private float width;
        private float height;
        private View view;
        private ViewFactory factory;

        Renderer(JXLabel c, ViewFactory f, View v, boolean wordWrap) {
            super(null, wordWrap);
            this.factory = f;
            this.view = v;
            this.view.setParent(this);
            this.host = c;
            if (this.host.getVisibleRect().width == 0) {
                this.invalidated = true;
                return;
            }
            int w = this.host.getVisibleRect().width;
            this.setSize(c.getMaxLineSpan() > -1 ? (float)c.getMaxLineSpan() : (float)w, this.host.getVisibleRect().height);
        }

        @Override
        protected void updateLayout(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a) {
            if (a != null) {
                this.preferenceChanged(null, true, true);
                Container host = this.getContainer();
                if (host != null) {
                    host.repaint();
                }
            }
        }

        @Override
        public void preferenceChanged(View child, boolean width, boolean height) {
            if (this.host != null && this.host.painted) {
                this.host.revalidate();
                this.host.repaint();
            }
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            Rectangle alloc = allocation.getBounds();
            if (g.getClipBounds() == null) {
                g.setClip(alloc);
                this.view.paint(g, allocation);
                g.setClip(null);
            } else {
                this.view.paint(g, allocation);
            }
        }

        @Override
        public void setParent(View parent) {
            throw new Error("Can't set parent on root view");
        }

        @Override
        public int getViewCount() {
            return 1;
        }

        @Override
        public View getView(int n) {
            return this.view;
        }

        @Override
        public Document getDocument() {
            return this.view == null ? null : this.view.getDocument();
        }

        @Override
        public void setSize(float width, float height) {
            if (this.host.maxLineSpan > 0) {
                width = Math.min(width, (float)this.host.maxLineSpan);
            }
            if (width == this.width && height == this.height) {
                return;
            }
            this.width = (int)width;
            this.height = (int)height;
            this.view.setSize(width, height == 0.0f ? 32767.0f : height);
            if (this.height == 0.0f) {
                this.height = this.view.getPreferredSpan(1);
            }
        }

        @Override
        public float getPreferredSpan(int axis) {
            if (axis == 0) {
                int w;
                if (this.invalidated && (w = this.host.getVisibleRect().width) != 0) {
                    this.invalidated = false;
                    this.setSize(w - this.host.getOccupiedWidth(), this.host.getVisibleRect().height);
                }
                return this.width > 0.0f ? this.width : this.view.getPreferredSpan(axis);
            }
            return this.view.getPreferredSpan(axis);
        }

        @Override
        public Container getContainer() {
            return this.host;
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.factory;
        }

        @Override
        public int getWidth() {
            return (int)this.width;
        }

        @Override
        public int getHeight() {
            return (int)this.height;
        }
    }

    static class BasicDocument
    extends DefaultStyledDocument {
        BasicDocument(Font defaultFont, Color foreground, TextAlignment textAlignment, float rightIndent) {
            this.setFontAndColor(defaultFont, foreground);
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setAlignment(attr, textAlignment.getValue());
            this.getStyle("default").addAttributes(attr);
            attr = new SimpleAttributeSet();
            StyleConstants.setRightIndent(attr, rightIndent);
            this.getStyle("default").addAttributes(attr);
        }

        private void setFontAndColor(Font font, Color fg) {
            SimpleAttributeSet attr;
            if (fg != null) {
                attr = new SimpleAttributeSet();
                StyleConstants.setForeground(attr, fg);
                this.getStyle("default").addAttributes(attr);
            }
            if (font != null) {
                attr = new SimpleAttributeSet();
                StyleConstants.setFontFamily(attr, font.getFamily());
                this.getStyle("default").addAttributes(attr);
                attr = new SimpleAttributeSet();
                StyleConstants.setFontSize(attr, font.getSize());
                this.getStyle("default").addAttributes(attr);
                attr = new SimpleAttributeSet();
                StyleConstants.setBold(attr, font.isBold());
                this.getStyle("default").addAttributes(attr);
                attr = new SimpleAttributeSet();
                StyleConstants.setItalic(attr, font.isItalic());
                this.getStyle("default").addAttributes(attr);
            }
            attr = new SimpleAttributeSet();
            StyleConstants.setSpaceAbove(attr, 0.0f);
            this.getStyle("default").addAttributes(attr);
        }
    }

    private static class BasicViewFactory
    implements ViewFactory {
        private BasicViewFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            View view = null;
            if (kind == null) {
                view = new LabelView(elem);
            } else if (kind.equals("content")) {
                view = new LabelView(elem);
            } else if (kind.equals("paragraph")) {
                view = new ParagraphView(elem);
            } else if (kind.equals("section")) {
                view = new BoxView(elem, 1);
            } else if (kind.equals("component")) {
                view = new ComponentView(elem);
            } else if (kind.equals("icon")) {
                view = new IconView(elem);
            }
            return view;
        }
    }

    public static class MultiLineSupport
    implements PropertyChangeListener {
        private static final String HTML = "<html>";
        private static ViewFactory basicViewFactory;
        private static BasicEditorKit basicFactory;

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            JXLabel src = (JXLabel)evt.getSource();
            if ("ancestor".equals(name)) {
                src.dontIgnoreRepaint = true;
            }
            if (src.isLineWrap()) {
                if ("font".equals(name) || "foreground".equals(name) || "maxLineSpan".equals(name) || "textAlignment".equals(name) || "icon".equals(name) || "iconTextGap".equals(name)) {
                    if (evt.getOldValue() != null && !MultiLineSupport.isHTML(src.getText())) {
                        MultiLineSupport.updateRenderer(src);
                    }
                } else if ("text".equals(name)) {
                    if (MultiLineSupport.isHTML((String)evt.getOldValue()) && evt.getNewValue() != null && !MultiLineSupport.isHTML((String)evt.getNewValue())) {
                        if (src.getClientProperty(JXLabel.oldRendererKey) == null && src.getClientProperty("html") != null) {
                            src.putClientProperty(JXLabel.oldRendererKey, src.getClientProperty("html"));
                        }
                        src.putClientProperty("html", MultiLineSupport.createView(src));
                    } else if (!MultiLineSupport.isHTML((String)evt.getOldValue()) && evt.getNewValue() != null && !MultiLineSupport.isHTML((String)evt.getNewValue())) {
                        MultiLineSupport.updateRenderer(src);
                    } else {
                        MultiLineSupport.restoreHtmlRenderer(src);
                    }
                } else if ("lineWrap".equals(name) && !MultiLineSupport.isHTML(src.getText())) {
                    src.putClientProperty("html", MultiLineSupport.createView(src));
                }
            } else if ("lineWrap".equals(name) && !((Boolean)evt.getNewValue()).booleanValue()) {
                MultiLineSupport.restoreHtmlRenderer(src);
            }
        }

        private static void restoreHtmlRenderer(JXLabel src) {
            Object current = src.getClientProperty("html");
            if (current == null || current instanceof Renderer) {
                src.putClientProperty("html", src.getClientProperty(JXLabel.oldRendererKey));
            }
        }

        private static boolean isHTML(String s) {
            return s != null && s.toLowerCase().startsWith(HTML);
        }

        public static View createView(JXLabel c) {
            BasicEditorKit kit = MultiLineSupport.getFactory();
            float rightIndent = 0.0f;
            if (c.getIcon() != null && c.getHorizontalTextPosition() != 0) {
                rightIndent = c.getIcon().getIconWidth() + c.getIconTextGap();
            }
            Document doc = kit.createDefaultDocument(c.getFont(), c.getForeground(), c.getTextAlignment(), rightIndent);
            StringReader r = new StringReader(c.getText() == null ? "" : c.getText());
            try {
                kit.read(r, doc, 0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ViewFactory f = kit.getViewFactory();
            View hview = f.create(doc.getDefaultRootElement());
            Renderer v = new Renderer(c, f, hview, true);
            return v;
        }

        public static void updateRenderer(JXLabel c) {
            View value = null;
            View oldValue = (View)c.getClientProperty("html");
            if (oldValue == null || oldValue instanceof Renderer) {
                value = MultiLineSupport.createView(c);
            }
            if (value != oldValue && oldValue != null) {
                for (int i = 0; i < oldValue.getViewCount(); ++i) {
                    oldValue.getView(i).setParent(null);
                }
            }
            c.putClientProperty("html", value);
        }

        private static BasicEditorKit getFactory() {
            if (basicFactory == null) {
                basicViewFactory = new BasicViewFactory();
                basicFactory = new BasicEditorKit();
            }
            return basicFactory;
        }

        private static class BasicEditorKit
        extends StyledEditorKit {
            private BasicEditorKit() {
            }

            public Document createDefaultDocument(Font defaultFont, Color foreground, TextAlignment textAlignment, float rightIndent) {
                BasicDocument doc = new BasicDocument(defaultFont, foreground, textAlignment, rightIndent);
                doc.setAsynchronousLoadPriority(Integer.MAX_VALUE);
                return doc;
            }

            @Override
            public ViewFactory getViewFactory() {
                return basicViewFactory;
            }
        }
    }

    protected static interface IValue {
        public int getValue();
    }

    public static enum TextAlignment implements IValue
    {
        LEFT(0),
        CENTER(1),
        RIGHT(2),
        JUSTIFY(3);

        private int value;

        private TextAlignment(int val) {
            this.value = val;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

