/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.PatternMatcher;

public class PatternFilter
extends Filter
implements PatternMatcher {
    private ArrayList<Integer> toPrevious;
    protected Pattern pattern = null;

    public PatternFilter() {
        this(null, 0, 0);
    }

    public PatternFilter(String regularExpr, int matchFlags, int col) {
        super(col);
        this.setPattern(regularExpr, matchFlags);
    }

    public void setPattern(String regularExpr, int matchFlags) {
        if (regularExpr == null || regularExpr.length() == 0) {
            regularExpr = ".*";
        }
        this.setPattern(Pattern.compile(regularExpr, matchFlags));
    }

    @Override
    public void setPattern(Pattern pattern) {
        if (pattern == null) {
            this.setPattern(null, 0);
        } else {
            this.pattern = pattern;
            this.refresh();
        }
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    protected void reset() {
        this.toPrevious.clear();
        int inputSize = this.getInputSize();
        this.fromPrevious = new int[inputSize];
        for (int i = 0; i < inputSize; ++i) {
            this.fromPrevious[i] = -1;
        }
    }

    @Override
    protected void filter() {
        if (this.pattern != null) {
            int inputSize = this.getInputSize();
            int current = 0;
            for (int i = 0; i < inputSize; ++i) {
                if (!this.test(i)) continue;
                this.toPrevious.add(new Integer(i));
                this.fromPrevious[i] = current++;
            }
        }
    }

    public boolean test(int row) {
        if (this.pattern == null) {
            return false;
        }
        if (!this.adapter.isTestable(this.getColumnIndex())) {
            return false;
        }
        String text = this.getInputString(row, this.getColumnIndex());
        return this.isEmpty(text) ? false : this.pattern.matcher(text).find();
    }

    private boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    @Override
    public int getSize() {
        return this.toPrevious.size();
    }

    @Override
    protected int mapTowardModel(int row) {
        return this.toPrevious.get(row);
    }

    @Override
    protected void init() {
        this.toPrevious = new ArrayList();
    }
}

