/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.editors;

import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.EnumSet;

public class EnumPropertyEditor<E extends Enum<E>>
extends PropertyEditorSupport {
    private Class<E> en;
    private EnumSet<E> set;

    public EnumPropertyEditor(Class<E> en) {
        this.en = en;
        this.set = EnumSet.allOf(en);
    }

    @Override
    public String[] getTags() {
        ArrayList<String> strs = new ArrayList<String>();
        for (Enum e : this.set) {
            strs.add(e.toString());
        }
        return strs.toArray(new String[0]);
    }

    @Override
    public String getAsText() {
        return this.getValue().toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        E e = Enum.valueOf(this.en, text);
        this.setValue(e);
    }

    @Override
    public String getJavaInitializationString() {
        return new String(this.en.getName() + "." + this.getAsText()).replace("$", ".");
    }
}

