/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.editors;

import java.beans.PropertyEditorSupport;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.swingx.EnumerationValue;

public abstract class EnumerationValuePropertyEditor
extends PropertyEditorSupport {
    private String[] tags;
    private Map<Object, EnumerationValue> values = new HashMap<Object, EnumerationValue>();
    private EnumerationValue defaultValue;

    public EnumerationValuePropertyEditor(EnumerationValue defaultEnum, EnumerationValue ... enums) {
        this.defaultValue = defaultEnum;
        for (EnumerationValue v : enums) {
            this.values.put(v.getValue(), v);
        }
        this.tags = new String[enums.length];
        int index = 0;
        for (EnumerationValue v : enums) {
            this.tags[index++] = v.getName();
        }
    }

    @Override
    public String getJavaInitializationString() {
        EnumerationValue value = this.values.get(this.getValue());
        if (value == null) {
            return this.defaultValue == null ? "null" : this.defaultValue.getJavaInitializationString();
        }
        return value.getJavaInitializationString();
    }

    @Override
    public String[] getTags() {
        return this.tags;
    }

    @Override
    public String getAsText() {
        EnumerationValue value = this.values.get(this.getValue());
        if (value == null) {
            return this.defaultValue == null ? null : this.defaultValue.getName();
        }
        return value.getName();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        EnumerationValue v = this.getValueByName(text);
        if (v == null && text != null) {
            v = this.getValueByName(text.trim());
        }
        if (v == null) {
            v = this.defaultValue;
        }
        this.setValue(v == null ? null : v.getValue());
    }

    private EnumerationValue getValueByName(String name) {
        for (EnumerationValue v : this.values.values()) {
            String n;
            String string = n = v == null ? null : v.getName();
            if (n != name && (n == null || !n.equalsIgnoreCase(name))) continue;
            return v;
        }
        return null;
    }
}

