/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import org.jdesktop.swingx.editors.ImagePicker;

public class ImageEditor
extends PropertyEditorSupport {
    Image image = null;
    ImagePicker picker = new ImagePicker();

    public ImageEditor() {
        this.picker.imageView.addPropertyChangeListener("image", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImageEditor.this.image = ImageEditor.this.picker.imageView.getImage();
                ImageEditor.this.firePropertyChange();
            }
        });
    }

    @Override
    public Image getValue() {
        return this.image;
    }

    @Override
    public void setValue(Object object) {
        this.image = (Image)object;
        super.setValue(this.image);
        this.picker.imageView.setImage(this.image);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
    }

    @Override
    public String getAsText() {
        return "an Image";
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle r) {
        graphics.drawImage(this.image, (int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight(), null);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.picker;
    }
}

