/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import org.jdesktop.swingx.editors.PaintPicker;

public class Paint2PropertyEditor
extends PropertyEditorSupport {
    Paint paint = new Color(0, 128, 255);
    PaintPicker picker = new PaintPicker();

    public Paint2PropertyEditor() {
        this.picker.addPropertyChangeListener("paint", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Paint2PropertyEditor.this.paint = Paint2PropertyEditor.this.picker.getPaint();
                Paint2PropertyEditor.this.firePropertyChange();
            }
        });
    }

    @Override
    public Paint getValue() {
        return this.paint;
    }

    @Override
    public void setValue(Object object) {
        this.paint = (Paint)object;
        this.picker.setPaint(this.paint);
        super.setValue(object);
    }

    @Override
    public String getJavaInitializationString() {
        Paint paint = this.getValue();
        return paint == null ? "null" : "org.jdesktop.swingx.painter.gradient.LinearGradientPainter.BLACK_STAR";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
    }

    @Override
    public String getAsText() {
        return "PainterText";
    }

    @Override
    public void paintValue(Graphics g, Rectangle box) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.picker.getDisplayPaint(box));
        g2.fill(box);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.picker;
    }
}

