/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.editors;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.PropertyEditorSupport;
import java.beans.Statement;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.jdesktop.swingx.painter.Painter;

public class PainterPropertyEditor
extends PropertyEditorSupport {
    @Override
    public Painter getValue() {
        return (Painter)super.getValue();
    }

    @Override
    public String getJavaInitializationString() {
        Painter painter = this.getValue();
        return painter == null ? "null" : "new org.jdesktop.swingx.painter.CheckerboardPainter()";
    }

    public static void main(String ... args) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(300);
        XMLEncoder e = new XMLEncoder(baos);
        e.setPersistenceDelegate(GradientPaint.class, new GradientPaintDelegate());
        e.setPersistenceDelegate(Arc2D.Float.class, new Arc2DDelegate());
        e.setPersistenceDelegate(Arc2D.Double.class, new Arc2DDelegate());
        e.setPersistenceDelegate(CubicCurve2D.Float.class, new CubicCurve2DDelegate());
        e.setPersistenceDelegate(CubicCurve2D.Double.class, new CubicCurve2DDelegate());
        e.setPersistenceDelegate(Ellipse2D.Float.class, new Ellipse2DDelegate());
        e.setPersistenceDelegate(Ellipse2D.Double.class, new Ellipse2DDelegate());
        e.setPersistenceDelegate(Line2D.Float.class, new Line2DDelegate());
        e.setPersistenceDelegate(Line2D.Double.class, new Line2DDelegate());
        e.setPersistenceDelegate(Point2D.Float.class, new Point2DDelegate());
        e.setPersistenceDelegate(Point2D.Double.class, new Point2DDelegate());
        e.setPersistenceDelegate(QuadCurve2D.Float.class, new QuadCurve2DDelegate());
        e.setPersistenceDelegate(QuadCurve2D.Double.class, new QuadCurve2DDelegate());
        e.setPersistenceDelegate(Rectangle2D.Float.class, new Rectangle2DDelegate());
        e.setPersistenceDelegate(Rectangle2D.Double.class, new Rectangle2DDelegate());
        e.setPersistenceDelegate(RoundRectangle2D.Float.class, new RoundRectangle2DDelegate());
        e.setPersistenceDelegate(RoundRectangle2D.Double.class, new RoundRectangle2DDelegate());
        e.setPersistenceDelegate(Area.class, new AreaDelegate());
        e.setPersistenceDelegate(GeneralPath.class, new GeneralPathDelegate());
        e.setPersistenceDelegate(AffineTransform.class, new AffineTransformDelegate());
        e.setPersistenceDelegate(RadialGradientPaint.class, new RadialGradientPaintDelegate());
        e.setPersistenceDelegate(LinearGradientPaint.class, new LinearGradientPaintDelegate());
        e.setPersistenceDelegate(Insets.class, new InsetsDelegate());
        RadialGradientPaint rp = new RadialGradientPaint((Point2D)new Point2D.Double(0.5, 0.5), 0.2f, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{Color.BLACK, Color.WHITE, Color.RED});
        baos = new ByteArrayOutputStream(300);
        e = new XMLEncoder(baos);
        TestStuff ts = new TestStuff();
        ts.str = "asdfasdf";
        System.out.println("db = " + ts.getDb());
        ts.setDb(new Point2D.Double(1.0, 1.0));
        ts.setIns(new Insets(5, 5, 5, 5));
        System.out.println("db = " + ts.getDb());
        e.writeObject(ts);
        e.close();
        System.out.println("more stuff");
        System.out.println(baos.toString());
        if (new Point2D.Double(0.0, 0.0).equals(new Point2D.Double(1.0, 1.0))) {
            System.out.println("they are equal");
        } else {
            System.out.println("they are not equal");
        }
    }

    public static final class GeneralPathDelegate
    extends PersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(oldInstance, GeneralPath.class, "new", new Object[0]);
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            GeneralPath a = (GeneralPath)oldInstance;
            AffineTransform tx = new AffineTransform();
            PathIterator itr = a.getPathIterator(tx);
            out.writeStatement(new Statement(a, "setWindingRule", new Object[]{a.getWindingRule()}));
            while (!itr.isDone()) {
                float[] segment = new float[6];
                int pathType = itr.currentSegment(segment);
                switch (pathType) {
                    case 4: {
                        out.writeStatement(new Statement(a, "closePath", new Object[0]));
                        break;
                    }
                    case 3: {
                        out.writeStatement(new Statement(a, "curveTo", new Object[]{Float.valueOf(segment[0]), Float.valueOf(segment[1]), Float.valueOf(segment[2]), Float.valueOf(segment[3]), Float.valueOf(segment[4]), Float.valueOf(segment[5])}));
                        break;
                    }
                    case 1: {
                        out.writeStatement(new Statement(a, "lineTo", new Object[]{Float.valueOf(segment[0]), Float.valueOf(segment[1])}));
                        break;
                    }
                    case 0: {
                        out.writeStatement(new Statement(a, "moveTo", new Object[]{Float.valueOf(segment[0]), Float.valueOf(segment[1])}));
                        break;
                    }
                    case 2: {
                        out.writeStatement(new Statement(a, "quadTo", new Object[]{Float.valueOf(segment[0]), Float.valueOf(segment[1]), Float.valueOf(segment[2]), Float.valueOf(segment[3])}));
                    }
                }
                itr.next();
            }
        }
    }

    public static final class AffineTransformDelegate
    extends DefaultPersistenceDelegate {
        public AffineTransformDelegate() {
            super(new String[]{"scaleX", "shearY", "shearX", "scaleY", "translateX", "translateY"});
        }
    }

    public static final class AreaDelegate
    extends PersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Area a = (Area)oldInstance;
            AffineTransform tx = new AffineTransform();
            PathIterator itr = a.getPathIterator(tx);
            GeneralPath path = new GeneralPath();
            out.writeExpression(new Expression(path, GeneralPath.class, "new", new Object[0]));
            while (!itr.isDone()) {
                float[] segment = new float[6];
                int pathType = itr.currentSegment(segment);
                switch (pathType) {
                    case 4: {
                        out.writeStatement(new Statement(path, "closePath", new Object[0]));
                        break;
                    }
                    case 3: {
                        out.writeStatement(new Statement(path, "curveTo", new Object[]{Float.valueOf(segment[0]), Float.valueOf(segment[1]), Float.valueOf(segment[2]), Float.valueOf(segment[3]), Float.valueOf(segment[4]), Float.valueOf(segment[5])}));
                        break;
                    }
                    case 1: {
                        out.writeStatement(new Statement(path, "lineTo", new Object[]{Float.valueOf(segment[0]), Float.valueOf(segment[1])}));
                        break;
                    }
                    case 0: {
                        out.writeStatement(new Statement(path, "moveTo", new Object[]{Float.valueOf(segment[0]), Float.valueOf(segment[1])}));
                        break;
                    }
                    case 2: {
                        out.writeStatement(new Statement(path, "quadTo", new Object[]{Float.valueOf(segment[0]), Float.valueOf(segment[1]), Float.valueOf(segment[2]), Float.valueOf(segment[3])}));
                    }
                }
                itr.next();
            }
            return new Expression(a, Area.class, "new", new Object[]{path});
        }
    }

    public static final class RoundRectangle2DDelegate
    extends DefaultPersistenceDelegate {
        public RoundRectangle2DDelegate() {
            super(new String[]{"x", "y", "width", "height", "arcWidth", "arcHeight"});
        }
    }

    public static final class InsetsDelegate
    extends DefaultPersistenceDelegate {
        public InsetsDelegate() {
            super(new String[]{"top", "left", "bottom", "right"});
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Insets ins = (Insets)oldInstance;
            return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{ins.top, ins.left, ins.bottom, ins.right});
        }
    }

    public static final class Rectangle2DDelegate
    extends DefaultPersistenceDelegate {
        public Rectangle2DDelegate() {
            super(new String[]{"x", "y", "width", "height"});
        }
    }

    public static final class QuadCurve2DDelegate
    extends DefaultPersistenceDelegate {
        public QuadCurve2DDelegate() {
            super(new String[]{"x1", "y1", "ctrlX", "ctrlY", "x2", "y2"});
        }
    }

    public static final class Point2DDelegate
    extends DefaultPersistenceDelegate {
        public Point2DDelegate() {
            super(new String[]{"x", "y"});
        }
    }

    public static final class Line2DDelegate
    extends DefaultPersistenceDelegate {
        public Line2DDelegate() {
            super(new String[]{"x1", "y1", "x2", "y2"});
        }
    }

    public static final class Ellipse2DDelegate
    extends DefaultPersistenceDelegate {
        public Ellipse2DDelegate() {
            super(new String[]{"x", "y", "width", "height"});
        }
    }

    public static final class CubicCurve2DDelegate
    extends DefaultPersistenceDelegate {
        public CubicCurve2DDelegate() {
            super(new String[]{"x1", "y1", "ctrlX1", "ctrlY1", "ctrlX2", "ctrlY2", "x2", "y2"});
        }
    }

    public static final class Arc2DDelegate
    extends DefaultPersistenceDelegate {
        public Arc2DDelegate() {
            super(new String[]{"x", "y", "width", "height", "angleStart", "angleExtent", "arcType"});
        }
    }

    public static final class RadialGradientPaintDelegate
    extends DefaultPersistenceDelegate {
        public RadialGradientPaintDelegate() {
            super(new String[]{"centerPoint", "radius", "focusPoint", "fractions", "colors"});
        }
    }

    public static final class LinearGradientPaintDelegate
    extends DefaultPersistenceDelegate {
        public LinearGradientPaintDelegate() {
            super(new String[]{"startPoint", "endPoint", "fractions", "colors"});
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            MultipleGradientPaint.ColorSpaceEnum e = ((LinearGradientPaint)oldInstance).getColorSpace();
            Expression retValue = super.instantiate(oldInstance, out);
            return retValue;
        }
    }

    public static final class GradientPaintDelegate
    extends DefaultPersistenceDelegate {
        public GradientPaintDelegate() {
            super(new String[]{"point1", "color1", "point2", "color2"});
        }
    }

    public static final class TestStuff {
        public Point2D.Double db = null;
        public String str = "asdf";
        private Insets ins = null;

        public TestStuff() {
        }

        public TestStuff(Point2D.Double db, String str) {
            this.setDb(db);
            this.setStr(str);
        }

        public void setDb(Point2D.Double db) {
            this.db = db;
        }

        public Point2D.Double getDb() {
            return this.db;
        }

        public void setStr(String str) {
            this.str = str;
        }

        public String getStr() {
            return this.str;
        }

        public Insets getIns() {
            return this.ins;
        }

        public void setIns(Insets ins) {
            this.ins = ins;
        }
    }
}

