/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.editors;

import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import org.jdesktop.swingx.editors.PropertyEditorUtil;

public class RectanglePropertyEditor
extends PropertyEditorSupport {
    @Override
    public Rectangle getValue() {
        return (Rectangle)super.getValue();
    }

    @Override
    public String getJavaInitializationString() {
        Rectangle rect = this.getValue();
        return rect == null ? "null" : "new java.awt.Rectangle(" + rect.getX() + ", " + rect.getY() + ", " + rect.getWidth() + ", " + rect.getHeight() + ")";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        String originalParam = text;
        try {
            Rectangle val = (Rectangle)PropertyEditorUtil.createValueFromString(text, 4, Rectangle.class, Integer.TYPE);
            this.setValue(val);
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            throw new IllegalArgumentException("The input value " + originalParam + " is not formatted correctly. Please try something of the form [x,y,w,h] or [x , y , w , h] or [x y w h]", e);
        }
    }

    @Override
    public String getAsText() {
        Rectangle rect = this.getValue();
        return rect == null ? "[]" : "[" + rect.x + ", " + rect.y + ", " + rect.width + ", " + rect.height + "]";
    }
}

