/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.rollover.RolloverController;
import org.jdesktop.swingx.rollover.RolloverRenderer;

public class TableRolloverController<T extends JTable>
extends RolloverController<T> {
    private Cursor oldCursor;

    @Override
    protected void rollover(Point oldLocation, Point newLocation) {
        Rectangle r;
        if (oldLocation != null) {
            r = ((JTable)this.component).getCellRect(oldLocation.y, oldLocation.x, false);
            r.x = 0;
            r.width = ((JTable)this.component).getWidth();
            ((JTable)this.component).repaint(r);
        }
        if (newLocation != null) {
            r = ((JTable)this.component).getCellRect(newLocation.y, newLocation.x, false);
            r.x = 0;
            r.width = ((JTable)this.component).getWidth();
            ((JTable)this.component).repaint(r);
        }
        this.setRolloverCursor(newLocation);
    }

    @Override
    protected boolean isClickable(Point location) {
        return super.isClickable(location) && !((JTable)this.component).isCellEditable(location.y, location.x);
    }

    @Override
    protected RolloverRenderer getRolloverRenderer(Point location, boolean prepare) {
        RolloverRenderer rollover;
        TableCellRenderer renderer = ((JTable)this.component).getCellRenderer(location.y, location.x);
        RolloverRenderer rolloverRenderer = rollover = renderer instanceof RolloverRenderer ? (RolloverRenderer)((Object)renderer) : null;
        if (rollover != null && !rollover.isEnabled()) {
            rollover = null;
        }
        if (rollover != null && prepare) {
            ((JTable)this.component).prepareRenderer(renderer, location.y, location.x);
        }
        return rollover;
    }

    private void setRolloverCursor(Point location) {
        if (this.hasRollover(location)) {
            if (this.oldCursor == null) {
                this.oldCursor = ((JTable)this.component).getCursor();
                ((JTable)this.component).setCursor(Cursor.getPredefinedCursor(12));
            }
        } else if (this.oldCursor != null) {
            ((JTable)this.component).setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    @Override
    protected Point getFocusedCell() {
        int leadRow = ((JTable)this.component).getSelectionModel().getLeadSelectionIndex();
        int leadColumn = ((JTable)this.component).getColumnModel().getSelectionModel().getLeadSelectionIndex();
        return new Point(leadColumn, leadRow);
    }
}

