/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.UIDependent;
import org.jdesktop.swingx.renderer.AbstractRenderer;

public class TableColumnExt
extends TableColumn
implements UIDependent {
    protected boolean visible = true;
    protected Object prototypeValue;
    protected Comparator comparator;
    protected boolean sortable = true;
    protected boolean editable = true;
    private String toolTipText;
    protected Hashtable<Object, Object> clientProperties;
    protected CompoundHighlighter compoundHighlighter;
    private ChangeListener highlighterChangeListener;
    private boolean ignoreHighlighterStateChange;

    public TableColumnExt() {
        this(0);
    }

    public TableColumnExt(int modelIndex) {
        this(modelIndex, 75);
    }

    public TableColumnExt(int modelIndex, int width) {
        this(modelIndex, width, null, null);
    }

    public TableColumnExt(int modelIndex, int width, TableCellRenderer cellRenderer, TableCellEditor cellEditor) {
        super(modelIndex, width, cellRenderer, cellEditor);
    }

    public TableColumnExt(TableColumnExt columnExt) {
        this(columnExt.getModelIndex(), columnExt.getWidth(), columnExt.getCellRenderer(), columnExt.getCellEditor());
        this.copyFrom(columnExt);
    }

    public void setHighlighters(Highlighter ... highlighters) {
        this.ignoreHighlighterStateChange = true;
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().setHighlighters(highlighters);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
        this.ignoreHighlighterStateChange = false;
    }

    public Highlighter[] getHighlighters() {
        return this.getCompoundHighlighter().getHighlighters();
    }

    public void addHighlighter(Highlighter highlighter) {
        this.ignoreHighlighterStateChange = true;
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().addHighlighter(highlighter);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
        this.ignoreHighlighterStateChange = false;
    }

    public void removeHighlighter(Highlighter highlighter) {
        this.ignoreHighlighterStateChange = true;
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().removeHighlighter(highlighter);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
        this.ignoreHighlighterStateChange = false;
    }

    protected CompoundHighlighter getCompoundHighlighter() {
        if (this.compoundHighlighter == null) {
            this.compoundHighlighter = new CompoundHighlighter(new Highlighter[0]);
            this.compoundHighlighter.addChangeListener(this.getHighlighterChangeListener());
        }
        return this.compoundHighlighter;
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (TableColumnExt.this.ignoreHighlighterStateChange) {
                    return;
                }
                TableColumnExt.this.firePropertyChange("highlighterStateChanged", false, true);
            }
        };
    }

    @Override
    public boolean getResizable() {
        return super.getResizable() && this.getMinWidth() < this.getMaxWidth();
    }

    public void setEditable(boolean editable) {
        boolean oldEditable = this.editable;
        this.editable = editable;
        this.firePropertyChange("editable", oldEditable, editable);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setPrototypeValue(Object value) {
        Object oldPrototypeValue = this.prototypeValue;
        this.prototypeValue = value;
        this.firePropertyChange("prototypeValue", oldPrototypeValue, value);
    }

    public Object getPrototypeValue() {
        return this.prototypeValue;
    }

    public void setComparator(Comparator comparator) {
        Comparator old = this.getComparator();
        this.comparator = comparator;
        this.firePropertyChange("comparator", old, this.getComparator());
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setSortable(boolean sortable) {
        boolean old = this.isSortable();
        this.sortable = sortable;
        this.firePropertyChange("sortable", old, this.isSortable());
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setToolTipText(String toolTipText) {
        String old = this.getToolTipText();
        this.toolTipText = toolTipText;
        this.firePropertyChange("toolTipText", old, this.getToolTipText());
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setTitle(String title) {
        this.setHeaderValue(title);
    }

    public String getTitle() {
        Object header = this.getHeaderValue();
        return header != null ? header.toString() : null;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.visible;
        this.visible = visible;
        this.firePropertyChange("visible", oldVisible, visible);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void putClientProperty(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (value == null && this.getClientProperty(key) == null) {
            return;
        }
        Object old = this.getClientProperty(key);
        if (value == null) {
            this.getClientProperties().remove(key);
        } else {
            this.getClientProperties().put(key, value);
        }
        this.firePropertyChange(key.toString(), old, value);
    }

    public Object getClientProperty(Object key) {
        return key == null || this.clientProperties == null ? null : this.clientProperties.get(key);
    }

    private Hashtable<Object, Object> getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable();
        }
        return this.clientProperties;
    }

    protected void copyFrom(TableColumnExt original) {
        this.setEditable(original.isEditable());
        this.setHeaderValue(original.getHeaderValue());
        this.setToolTipText(original.getToolTipText());
        this.setIdentifier(original.getIdentifier());
        this.setMaxWidth(original.getMaxWidth());
        this.setMinWidth(original.getMinWidth());
        this.setPreferredWidth(original.getPreferredWidth());
        this.setPrototypeValue(original.getPrototypeValue());
        this.setResizable(original.isResizable);
        this.setVisible(original.isVisible());
        this.setSortable(original.isSortable());
        this.setComparator(original.getComparator());
        this.copyClientPropertiesFrom(original);
        if (original.compoundHighlighter != null) {
            this.setHighlighters(original.getHighlighters());
        }
    }

    protected void copyClientPropertiesFrom(TableColumnExt original) {
        if (original.clientProperties == null) {
            return;
        }
        for (Object key : original.clientProperties.keySet()) {
            this.putClientProperty(key, original.getClientProperty(key));
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeListener[] pcl;
        if ((oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) && (pcl = this.getPropertyChangeListeners()) != null && pcl.length != 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            for (int i = 0; i < pcl.length; ++i) {
                pcl[i].propertyChange(pce);
            }
        }
    }

    @Override
    public void updateUI() {
        this.updateHighlighterUI();
        this.updateRendererUI(this.getCellRenderer());
        this.updateRendererUI(this.getHeaderRenderer());
        this.updateEditorUI(this.getCellEditor());
    }

    private void updateEditorUI(TableCellEditor editor) {
        if (editor == null) {
            return;
        }
        if (editor instanceof JComponent || editor instanceof DefaultCellEditor) {
            return;
        }
        try {
            Component comp = editor.getTableCellEditorComponent(null, null, false, -1, -1);
            if (comp != null) {
                SwingUtilities.updateComponentTreeUI(comp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateRendererUI(TableCellRenderer renderer) {
        if (renderer == null) {
            return;
        }
        if (renderer instanceof JComponent) {
            return;
        }
        Component comp = null;
        if (renderer instanceof AbstractRenderer) {
            comp = (Component)((AbstractRenderer)((Object)renderer)).getComponentProvider().getRendererComponent(null);
        } else {
            try {
                comp = renderer.getTableCellRendererComponent(null, null, false, false, -1, -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (comp != null) {
            SwingUtilities.updateComponentTreeUI(comp);
        }
    }

    private void updateHighlighterUI() {
        if (this.compoundHighlighter == null) {
            return;
        }
        this.compoundHighlighter.updateUI();
    }
}

