/*
 * Decompiled with CFR 0.152.
 */
package invoicexpluginautoupdate;

import invoicexpluginautoupdate.UnzipWorker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class UnZip {
    public static ZipFile zf;
    public static final int EOF = -1;

    public static void main(String[] argv) {
        UnZip.main(argv, null);
    }

    public static void main(String[] argv, UnzipWorker work) {
        if (argv.length == 1) {
            try {
                zf = new ZipFile(new File(argv[0]).getAbsolutePath());
                Enumeration<? extends ZipEntry> enum1 = zf.entries();
                while (enum1.hasMoreElements()) {
                    ZipEntry target = enum1.nextElement();
                    System.out.print(target.getName() + " .");
                    if (work != null) {
                        work.publicPublish("Unzip " + target);
                    }
                    UnZip.saveEntry(target, work);
                    System.out.println(". unpacked");
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("zipfile not found");
            }
            catch (ZipException e) {
                System.out.println("zip error...");
                e.printStackTrace();
            }
            catch (IOException e) {
                System.out.println("IO error...");
            }
        } else {
            System.out.println("Usage:java UnZip zipfile");
        }
    }

    public static void saveEntry(ZipEntry target, UnzipWorker work) throws ZipException, IOException {
        try {
            File file = new File(target.getName());
            if (target.isDirectory()) {
                file.mkdirs();
            } else {
                int c;
                InputStream is = zf.getInputStream(target);
                BufferedInputStream bis = new BufferedInputStream(is);
                if (file.getParent() != null) {
                    File dir = new File(file.getParent());
                    dir.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                byte[] buff = new byte[38528];
                int writed = 0;
                int towrite = (int)target.getSize();
                while ((c = bis.read(buff)) > 0) {
                    writed += c;
                    bos.write(buff, 0, c);
                    if (work == null) continue;
                    work.publicPublish("Unzip " + target + " " + writed * 100 / towrite + "%");
                }
                bos.close();
                fos.close();
            }
        }
        catch (ZipException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }
}

