/*
 * Decompiled with CFR 0.152.
 */
package invoicexpluginbackuptnx;

import gestioneFatture.Db;
import gestioneFatture.main;
import invoicexpluginbackuptnx.SendBackupClient;
import it.tnx.JFrameMessage;
import it.tnx.Util;
import it.tnx.Zip;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.SystemUtils;
import it.tnx.invoicex.data.DatiAzienda;
import it.tnx.shell.CurrentDir;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.io.FileUtils;

public class DumpThreadOnline
extends Thread {
    JTextArea text;
    JButton chiudi;
    JProgressBar bar;
    JScrollPane scroll;
    String nomeFileDump;
    boolean sendOnline = true;

    public DumpThreadOnline(JFrameMessage frame) {
        this.text = frame.getTextArea();
        this.chiudi = frame.getPulsanteChiudi();
        this.bar = frame.getAvanzamento();
        this.scroll = frame.getTextAreaScrollPane();
        frame.setTitle("Creazione copia di sicurezza dei dati");
    }

    @Override
    public void run() {
        Exception error1 = null;
        this.chiudi.setEnabled(false);
        this.bar.setIndeterminate(true);
        this.text.setAutoscrolls(true);
        this.text.append("Inizio backup database\n");
        this.text.append("Controllo cartella 'backup'");
        File dirBackup = new File(main.wd + "backup");
        if (!dirBackup.exists()) {
            dirBackup.mkdir();
        }
        this.text.append("...ok\n");
        try {
            block34: {
                this.nomeFileDump = CurrentDir.getCurrentDir() + "/backup/dump";
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmm");
                Date d = new Date();
                this.nomeFileDump = this.nomeFileDump + "_" + sdf.format(d) + "_online.txt";
                FileOutputStream fos = new FileOutputStream(this.nomeFileDump, false);
                PrintStream o = new PrintStream((OutputStream)fos, true, "UTF8");
                o.println("SET foreign_key_checks = 0;");
                o.println("SET storage_engine = MYISAM;");
                Vector tables = new Vector();
                Statement s = Db.getConn().createStatement();
                ResultSet r = s.executeQuery("show full tables");
                while (r.next()) {
                    String tab = r.getString(1);
                    String tipo = r.getString(2);
                    this.text.append("backup " + tipo + " '" + tab + "'");
                    try {
                        Method m = Util.class.getMethod("dumpTable", String.class, Connection.class, OutputStream.class, String.class);
                        if (m != null) {
                            m.invoke(Util.class, tab, Db.conn, fos, tipo);
                        }
                    }
                    catch (NoSuchMethodException nomethodex) {
                        Util.dumpTable((String)tab, (Connection)Db.conn, (OutputStream)fos);
                    }
                    System.out.println(r.getString(1) + " : dumped");
                    this.text.append("...ok\n");
                    this.text.setCaretPosition(this.text.getText().length());
                }
                o.println("SET foreign_key_checks = 1;");
                s.close();
                r.close();
                File fnomeFileDump = new File(this.nomeFileDump);
                fos.flush();
                fos.close();
                try {
                    int i;
                    String copia = null;
                    try {
                        URL[] url = new URL[]{new URL("file:plugins/InvoicexPluginInvoicex.jar")};
                        URLClassLoader classloader = new URLClassLoader(url);
                        Object obj = classloader.loadClass("invoicexplugininvoicex.backup.MainBackup").newInstance();
                        Method m = obj.getClass().getDeclaredMethod("getNomeFileDump", new Class[0]);
                        Object ret = m.invoke(obj, new Object[0]);
                        System.out.println("ret = " + ret);
                        if (ret instanceof String) {
                            copia = (String)ret;
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (copia == null) {
                        copia = SystemUtils.getUserDocumentsFolder() + File.separator + "Invoicex" + File.separator + "backup" + File.separator;
                        File nomeFileDumpFile = new File(this.nomeFileDump);
                        copia = copia + nomeFileDumpFile.getName();
                    }
                    File fileCopia = new File(copia);
                    boolean errore_cartella = false;
                    if (!fileCopia.getParentFile().isDirectory()) {
                        File cartellaCopia = fileCopia.getParentFile();
                        boolean retdir = cartellaCopia.mkdirs();
                        System.out.println("creazione cartella backup in documenti:" + retdir);
                        if (!retdir) {
                            error1 = new Exception("Errore nella creazione della cartella '" + cartellaCopia.getAbsolutePath() + "'");
                            this.text.append("\nErrore nella creazione della cartella per il backup\n\n");
                            this.text.append("Cartella: '" + cartellaCopia.getAbsolutePath() + "'\n\n");
                            errore_cartella = true;
                            if (!main.isBatch) {
                                SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)("Errore nella creazione della cartella:\n" + cartellaCopia.getAbsolutePath()));
                            } else {
                                System.out.println("Errore nella creazione della cartella:\n" + cartellaCopia.getAbsolutePath());
                            }
                        }
                    }
                    File ffileCopia = fileCopia;
                    if (!errore_cartella) {
                        if (!fnomeFileDump.getAbsolutePath().equals(ffileCopia.getAbsolutePath())) {
                            it.tnx.commons.FileUtils.copyFile((File)fnomeFileDump, (File)ffileCopia);
                        }
                        this.text.append("\nIl backup si trova nel file\n'" + ffileCopia.getAbsolutePath() + "'\n\n");
                    }
                    Comparator filecomp = new Comparator(){

                        public int compare(Object o1, Object o2) {
                            File f1 = (File)o1;
                            File f2 = (File)o2;
                            if (f1.lastModified() > f2.lastModified()) {
                                return -1;
                            }
                            if (f1.lastModified() < f2.lastModified()) {
                                return 1;
                            }
                            return 0;
                        }
                    };
                    File dir = new File(CurrentDir.getCurrentDir() + "/backup");
                    Object[] lista = dir.listFiles();
                    Vector listav = Util.getVectorFromArray((Object[])lista);
                    Collections.sort(listav, filecomp);
                    for (i = 0; i < listav.size(); ++i) {
                        System.out.println("files[" + i + "]:" + ((File)listav.get(i)).getName() + "\t\t" + ((File)listav.get(i)).lastModified());
                        if (i <= 20) continue;
                        try {
                            System.out.println("delete file:" + ((File)listav.get(i)).getCanonicalFile() + "\t deleteed:" + ((File)listav.get(i)).delete());
                            continue;
                        }
                        catch (IOException err) {
                            err.printStackTrace();
                        }
                    }
                    try {
                        dir = new File(SystemUtils.getUserDocumentsFolder() + File.separator + "Invoicex" + File.separator + "backup");
                        lista = dir.listFiles();
                        listav = Util.getVectorFromArray((Object[])lista);
                        Collections.sort(listav, filecomp);
                        for (i = 0; i < listav.size(); ++i) {
                            System.out.println("files[" + i + "]:" + ((File)listav.get(i)).getName() + "\t\t" + ((File)listav.get(i)).lastModified());
                            if (i <= 20) continue;
                            try {
                                System.out.println("delete file:" + ((File)listav.get(i)).getCanonicalFile() + "\t deleteed:" + ((File)listav.get(i)).delete());
                                continue;
                            }
                            catch (IOException err) {
                                err.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.bar.setIndeterminate(false);
                    this.bar.setStringPainted(true);
                    this.bar.setValue(100);
                    this.text.append("Backup completato.\nDimensione " + FileUtils.byteCountToDisplaySize((long)ffileCopia.length()));
                    this.text.setCaretPosition(this.text.getText().length());
                    if (!this.sendOnline) break block34;
                    this.bar.setValue(0);
                    this.text.append("\nInvio online...");
                    this.text.setCaretPosition(this.text.getText().length());
                    String nomeFileZip = this.nomeFileDump + ".zip";
                    this.text.append("\nCompressione in corso...");
                    this.text.setCaretPosition(this.text.getText().length());
                    try {
                        Zip.createZip((String)this.nomeFileDump, (String)nomeFileZip);
                    }
                    catch (Exception err) {
                        if (!main.isBatch) {
                            JOptionPane.showMessageDialog((JFrame)this.text.getTopLevelAncestor(), "Errore durante la creazione del file zip\n" + err.toString(), "Attenzione", 0);
                        }
                        System.out.println("Errore:" + err.toString());
                    }
                    this.text.append("\nDimensione file compresso " + FileUtils.byteCountToDisplaySize((long)new File(nomeFileZip).length()) + "\n");
                    this.text.setCaretPosition(this.text.getText().length());
                    File f = new File(nomeFileZip);
                    try {
                        DatiAzienda dati = main.attivazione.getDatiAzienda();
                        System.out.println("backup online:" + SendBackupClient.sendBackup(f, main.attivazione.getIdRegistrazione().toString(), dati.getRagione_sociale(), dati.getPartita_iva(), dati.getCodice_fiscale(), (JFrame)this.text.getTopLevelAncestor(), this.text, this.bar));
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                        if (!main.isBatch) {
                            JOptionPane.showMessageDialog((JFrame)this.text.getTopLevelAncestor(), "Errore:" + err.toString(), "Errore", 0);
                            break block34;
                        }
                        System.out.println("Errore:" + err.toString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!main.isBatch) {
                        JOptionPane.showMessageDialog((JFrame)this.text.getTopLevelAncestor(), "Errore:" + e.toString(), "Errore", 0);
                    }
                    System.out.println("Errore:" + e.toString());
                }
            }
            this.bar.setValue(100);
            this.text.setCaretPosition(this.text.getText().length());
            this.chiudi.setEnabled(true);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }
}

