/*
 * Decompiled with CFR 0.152.
 */
package invoicexpluginbackuptnx;

import gestioneFatture.main;
import invoicexpluginbackuptnx.Main;
import invoicexpluginbackuptnx.SendBackupClient;
import it.tnx.commons.HttpUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.invoicex.Backup;
import it.tnx.invoicex.data.DatiAzienda;
import it.tnx.invoicex.gui.JDialogProgress;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingworker.SwingWorker;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;

public class JDialogRipristino
extends JDialog {
    private JMenuItem elimina;
    private JButton jButton1;
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JPopupMenu popup;

    public JDialogRipristino(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.aggiornaElencoBackup();
    }

    public void aggiornaElencoBackup() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        SwingWorker worker = new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground() throws Exception {
                URLCodec u = new URLCodec();
                String url = Main.urlbwsd;
                url = url + "?f=list_backup";
                System.out.println("url = " + url);
                String out = null;
                HttpClient httpclient = HttpUtils.getHttpClient();
                PostMethod post = new PostMethod(url);
                DatiAzienda da = main.attivazione.getDatiAzienda();
                Part[] parts = new Part[]{new StringPart("id", cu.s((Object)da.getId_registrazione())), new StringPart("piva", da.getPartita_iva()), new StringPart("cfisc", da.getCodice_fiscale()), new StringPart("rs", da.getRagione_sociale())};
                post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
                post.addRequestHeader("x-invoicex", "1");
                int retcode = 0;
                String message = null;
                try {
                    retcode = httpclient.executeMethod((HttpMethod)post);
                    retcode = post.getStatusLine().getStatusCode();
                    System.out.println("retcode = " + retcode);
                    message = post.getStatusLine().getReasonPhrase();
                    System.out.println("message = " + message);
                    out = post.getResponseBodyAsString();
                    System.out.println("out = " + out);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    post.releaseConnection();
                }
                String xinvoicex = cu.s((Object)post.getResponseHeader("X-Invoicex"));
                System.out.println("xinvoicex = " + xinvoicex);
                return new Object[]{retcode, out};
            }

            protected void done() {
                block12: {
                    JDialogRipristino.this.jList1.setModel(new DefaultListModel());
                    Object[] retget = null;
                    try {
                        retget = (Object[])this.get();
                    }
                    catch (Exception ex) {
                        SwingUtils.showExceptionMessage((Component)JDialogRipristino.this, (Exception)ex);
                    }
                    int retcode = (Integer)retget[0];
                    String out = (String)retget[1];
                    if (retcode != 200) {
                        System.out.println("getURL: errore retcode:" + retcode);
                        JDialogRipristino.this.setCursor(Cursor.getPredefinedCursor(0));
                        SwingUtils.showErrorMessage((Component)JDialogRipristino.this, (String)("Errore dal server (" + retcode + ")"));
                        return;
                    }
                    if (out != null && out.trim().length() > 0) {
                        if (out.toLowerCase().indexOf("i dati di registrazione non corrispondono") >= 0) {
                            SwingUtils.showInfoMessage((Component)JDialogRipristino.this, (String)("Ripeti la 'registrazione' del tuo Invoicex da Anagrafiche > Azienda\n\n" + out));
                        } else {
                            JSONParser parser = new JSONParser();
                            try {
                                Object ret = parser.parse(out);
                                System.out.println("ret = " + ret);
                                JSONArray retjsa = (JSONArray)ret;
                                ArrayList<Backup> list = new ArrayList<Backup>();
                                for (Object objn : retjsa) {
                                    System.out.println("objn = " + objn);
                                    Map m = (Map)objn;
                                    System.out.println("m = " + m);
                                    Backup b = new Backup();
                                    b.setNome_file(cu.s(m.get("nomefile")));
                                    b.setData_creazione(cu.toLong(m.get("data")) * 1000L);
                                    b.setSize(cu.toLong(m.get("size")).longValue());
                                    list.add(b);
                                }
                                if (list != null && list.size() > 0) {
                                    Collections.sort(list, new BeanComparator("data_creazione", (Comparator)new ReverseComparator((Comparator)new ComparableComparator())));
                                    for (Backup b : list) {
                                        ((DefaultListModel)JDialogRipristino.this.jList1.getModel()).addElement(b);
                                    }
                                    break block12;
                                }
                                SwingUtils.showInfoMessage((Component)JDialogRipristino.this, (String)"Nessun backup presente\nSe hai cambiato computer contatta l'assistenza");
                            }
                            catch (Exception e) {
                                SwingUtils.showErrorMessage((Component)JDialogRipristino.this, (String)e.toString());
                            }
                        }
                    } else {
                        SwingUtils.showErrorMessage((Component)JDialogRipristino.this, (String)"Nessun backup presente");
                    }
                }
                JDialogRipristino.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        worker.execute();
    }

    private void initComponents() {
        this.popup = new JPopupMenu();
        this.elimina = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton1 = new JButton();
        this.elimina.setText("Elimina da server TNX");
        this.elimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogRipristino.this.eliminaActionPerformed(evt);
            }
        });
        this.popup.add(this.elimina);
        this.setDefaultCloseOperation(2);
        this.setTitle("Elenco Backup disponibili");
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDialogRipristino.this.jList1MouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                JDialogRipristino.this.jList1MousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                JDialogRipristino.this.jList1MouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jButton1.setText("Ripristina");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogRipristino.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 380, Short.MAX_VALUE).add((Component)this.jButton1)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 220, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton1).addContainerGap()));
        this.pack();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.jButton1ActionPerformed(null);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Prima seleziona il backup da ripristinare", "Attenzione", 1);
        } else if (JOptionPane.showConfirmDialog(this, "Sicuro di eliminare tutti i dati e ripristinarli dal backup selezionato ?", "Attenzione", 0) == 0) {
            DatiAzienda d = main.attivazione.getDatiAzienda();
            try {
                this.setEnabled(false);
                JDialogProgress progress = new JDialogProgress(main.getPadreWindow(), false);
                progress.setLocationRelativeTo((Component)this);
                progress.setVisible(true);
                progress.setAlwaysOnTop(true);
                SendBackupClient.receiveBackup(((Backup)this.jList1.getSelectedValue()).getNome_file(), d.getId_registrazione().toString(), d.getRagione_sociale(), d.getPartita_iva(), d.getCodice_fiscale(), progress, this);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    }

    private void eliminaActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedIndices().length == 0) {
            SwingUtils.showInfoMessage((Component)this, (String)"Seleziona almeno un backup");
            return;
        }
        String msg = "Sicuro di eliminare il backup ?";
        if (this.jList1.getSelectedIndices().length > 1) {
            msg = "Sicuro di eliminare i backup selezionati ?";
        }
        if (SwingUtils.showYesNoMessage((Component)this, (String)msg)) {
            DatiAzienda d = main.attivazione.getDatiAzienda();
            try {
                ArrayList<String> nomiFile = new ArrayList<String>();
                for (int i : this.jList1.getSelectedIndices()) {
                    nomiFile.add(((Backup)((DefaultListModel)this.jList1.getModel()).get(i)).getNome_file());
                }
                SendBackupClient.deleteBackup(nomiFile, d.getId_registrazione().toString(), d.getRagione_sociale(), d.getPartita_iva(), d.getCodice_fiscale(), null, this);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    }

    private void jList1MouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jList1MousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JDialogRipristino((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }
}

