/*
 * Decompiled with CFR 0.152.
 */
package invoicexpluginbackuptnx;

import it.tnx.invoicex.GenericWorker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class UnZipBackup {
    public static ZipFile zf;
    public static final int EOF = -1;
    public static String lastmsg;
    public static boolean esito;

    public static void main(String[] argv) {
        lastmsg = null;
        esito = false;
        UnZipBackup.main(argv, null);
    }

    public static void main(String[] argv, GenericWorker work) {
        lastmsg = null;
        esito = false;
        if (argv.length == 1) {
            try {
                zf = new ZipFile(argv[0]);
                Enumeration<? extends ZipEntry> enum1 = zf.entries();
                while (enum1.hasMoreElements()) {
                    ZipEntry target = enum1.nextElement();
                    System.out.print(target.getName() + " .");
                    if (work != null) {
                        work.publicPublish("Unzip " + target);
                    }
                    UnZipBackup.saveEntry(target, work);
                    System.out.println(". unpacked");
                }
                esito = true;
            }
            catch (FileNotFoundException e) {
                lastmsg = e.getMessage();
                System.out.println("zipfile not found");
            }
            catch (ZipException e) {
                lastmsg = e.getMessage();
                System.out.println("zip error...");
            }
            catch (IOException e) {
                lastmsg = e.getMessage();
                System.out.println("IO error...");
            }
        } else {
            System.out.println("Usage:java UnZip zipfile");
        }
    }

    public static void unzip(File zipfile, File todir) {
        lastmsg = null;
        esito = false;
        try {
            zf = new ZipFile(zipfile);
            Enumeration<? extends ZipEntry> enum1 = zf.entries();
            while (enum1.hasMoreElements()) {
                ZipEntry target = enum1.nextElement();
                System.out.print(target.getName() + " .");
                UnZipBackup.saveEntryToDir(target, todir);
                System.out.println(". unpacked");
            }
            esito = true;
        }
        catch (FileNotFoundException e) {
            lastmsg = e.getMessage();
            System.out.println("zipfile not found");
        }
        catch (ZipException e) {
            lastmsg = e.getMessage();
            System.out.println("zip error...");
        }
        catch (IOException e) {
            lastmsg = e.getMessage();
            System.out.println("IO error...");
        }
    }

    public static void saveEntryToDir(ZipEntry target, File todir) throws ZipException, IOException {
        try {
            File file = new File(todir.getAbsolutePath() + File.separator + target.getName());
            if (target.isDirectory()) {
                file.mkdirs();
            } else {
                int c;
                InputStream is = zf.getInputStream(target);
                BufferedInputStream bis = new BufferedInputStream(is);
                if (file.getParent() != null) {
                    File dir = new File(file.getParent());
                    dir.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                byte[] buff = new byte[32768];
                int writed = 0;
                int towrite = (int)target.getSize();
                while ((c = bis.read(buff)) > 0) {
                    writed += c;
                    bos.write(buff, 0, c);
                }
                bos.close();
                fos.close();
            }
        }
        catch (ZipException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public static void saveEntry(ZipEntry target, GenericWorker work) throws ZipException, IOException {
        try {
            File file = new File(target.getName());
            if (target.isDirectory()) {
                file.mkdirs();
            } else {
                int c;
                InputStream is = zf.getInputStream(target);
                BufferedInputStream bis = new BufferedInputStream(is);
                if (file.getParent() != null) {
                    File dir = new File(file.getParent());
                    dir.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                byte[] buff = new byte[38528];
                int writed = 0;
                int towrite = (int)target.getSize();
                while ((c = bis.read(buff)) > 0) {
                    writed += c;
                    bos.write(buff, 0, c);
                    if (work == null) continue;
                    work.publicPublish("Unzip " + target + " " + writed * 100 / towrite + "%");
                }
                bos.close();
                fos.close();
            }
        }
        catch (ZipException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    static {
        lastmsg = null;
        esito = false;
    }
}

