/*
 * Decompiled with CFR 0.152.
 */
package invoicexpluginbarcode;

import gestioneFatture.InvoicexEvent;
import gestioneFatture.InvoicexEventListener;
import gestioneFatture.JDialogCompilazioneReport;
import gestioneFatture.Menu;
import gestioneFatture.Reports;
import gestioneFatture.Util;
import gestioneFatture.frmElenDDT;
import gestioneFatture.frmElenFatt;
import gestioneFatture.frmElenOrdini;
import gestioneFatture.iniFileProp;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.accessoUtenti.Utente;
import it.tnx.commons.CastUtils;
import it.tnx.commons.FileUtils;
import it.tnx.commons.ReflectUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.Versione;
import it.tnx.invoicex.gui.JDialogJasperViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import net.sf.jasperreports.components.barbecue.StandardBarbecueComponent;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignLine;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sourceforge.barbecue.BarcodeException;
import org.jdesktop.swingworker.SwingWorker;
import reports.JRDSBarcode;
import tnxbeans.tnxDbGrid;

public class Main2 {
    public static ImageIcon mygetIcon(String icona) {
        try {
            if (main.version.older(new Versione(2, 0, 0))) {
                icona = "/invoicexpluginbarcode/res/" + icona + ".png";
                return new ImageIcon(ImageIO.read(InvoicexUtil.class.getResource(icona)));
            }
            return (ImageIcon)ReflectUtils.runMethod((String)"it.tnx.invoicex.InvoicexUtil", (String)"getIcon", (Object[])new Object[]{icona});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void startPluginEntry2() {
        Menu menu = main.getPadre();
        final JMenuItem menStampaCodiciABarre = new JMenuItem();
        try {
            menStampaCodiciABarre.setIcon(Main2.mygetIcon("Barcode"));
            menStampaCodiciABarre.setText("Stampa Codici a Barre");
            menStampaCodiciABarre.setActionCommand("Stampa Codici a Barre");
            menStampaCodiciABarre.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    frmElenDDT form;
                    JInternalFrame selframe = main.getPadrePanel().getDesktopPane().getSelectedFrame();
                    boolean ok = false;
                    try {
                        if (Integer.parseInt(main.build) >= 20121219) {
                            ok = true;
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (!ok) {
                        SwingUtils.showErrorMessage((Component)selframe, (String)"Per stampare i codici a barre \u00e8 necessario almeno Invoicex 1.8.3 2012-12-19");
                        return;
                    }
                    tnxDbGrid griglia = null;
                    boolean acquisto = false;
                    String tipo_doc = null;
                    if (selframe instanceof frmElenDDT) {
                        form = (frmElenDDT)selframe;
                        griglia = form.griglia;
                        acquisto = form.acquisto;
                        tipo_doc = Db.TIPO_DOCUMENTO_DDT;
                        if (acquisto) {
                            tipo_doc = Db.TIPO_DOCUMENTO_DDT_ACQUISTO;
                        }
                    } else if (selframe instanceof frmElenFatt) {
                        form = (frmElenFatt)selframe;
                        griglia = form.griglia;
                        tipo_doc = Db.TIPO_DOCUMENTO_FATTURA;
                    } else if (selframe instanceof frmElenOrdini) {
                        form = (frmElenOrdini)selframe;
                        griglia = form.griglia;
                        acquisto = form.acquisto;
                        tipo_doc = Db.TIPO_DOCUMENTO_ORDINE;
                        if (acquisto) {
                            tipo_doc = Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO;
                        }
                    }
                    if (griglia.getSelectedRowCount() <= 0) {
                        SwingUtils.showErrorMessage((Component)selframe, (String)"Seleziona un documento prima!");
                        return;
                    }
                    selframe.setCursor(new Cursor(3));
                    if (griglia.getSelectedRowCount() > 1) {
                        SwingUtils.showErrorMessage((Component)selframe, (String)"Si pu\ufffd stampare un solo documento per volta", (String)"Documenti multipli");
                    } else {
                        int dbId = Integer.parseInt(String.valueOf(griglia.getValueAt(griglia.getSelectedRow(), griglia.getColumnByName("id"))));
                        try {
                            Main2.stampaBarcode(dbId, false, false, acquisto, tipo_doc);
                        }
                        catch (RuntimeException e) {
                            SwingUtils.showErrorMessage((Component)selframe, (String)"Alcuni codici a barre non rispettano gli standard, verificali prima di procedre", (String)"Errore lettura codici a barre", (boolean)true);
                        }
                    }
                    selframe.setCursor(new Cursor(0));
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        main.events.addInvoicexEventListener(new InvoicexEventListener(){

            public void event(InvoicexEvent event) {
                try {
                    frmElenDDT frm;
                    if (event.type == 11) {
                        frm = (frmElenDDT)event.getSource();
                        this.aggiungiAPopup(frm.popupElenco);
                    }
                    if (event.type == 19) {
                        frm = (frmElenFatt)event.getSource();
                        this.aggiungiAPopup(frm.pop);
                    }
                    if (event.type == 30) {
                        frm = (frmElenOrdini)event.getSource();
                        this.aggiungiAPopup(frm.jPopupMenu1);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            private void aggiungiAPopup(JPopupMenu popupElenco) {
                Component[] comps;
                for (Component comp : comps = popupElenco.getComponents()) {
                    popupElenco.remove(comp);
                }
                for (Component comp : comps) {
                    popupElenco.add(comp);
                    if (!(comp instanceof JMenuItem) || !((JMenuItem)comp).getText().equals("Stampa")) continue;
                    popupElenco.add(menStampaCodiciABarre);
                }
            }
        });
    }

    public static Object stampaBarcode(final int dbIdPadre, final boolean generazionePdfDaJasper, boolean attendi, boolean acquisto, final String tipo_doc) {
        Object ret = null;
        String tempts = "barcode.jrxml";
        final String prefTipoStampa = tempts;
        if (prefTipoStampa.endsWith(".jrxml")) {
            final boolean f_acquisto = acquisto;
            SwingWorker work = new SwingWorker(){
                private boolean debug = false;

                private JasperDesign formatoBarcode(File freport, JasperReport rep, JasperDesign repdes) throws JRException {
                    int larghezzaReport = CastUtils.toInteger((Object)main.fileIni.getValue("barcode", "pagina_larghezza", "595"));
                    int altezzaReport = CastUtils.toInteger((Object)main.fileIni.getValue("barcode", "pagina_altezza", "842"));
                    double mmw = (double)larghezzaReport * 25.4 / 72.0;
                    double mmh = (double)altezzaReport * 25.4 / 72.0;
                    System.out.println("mmw = " + mmw + " mmh = " + mmh);
                    int margtop = CastUtils.toInteger0((Object)main.fileIni.getValue("barcode", "mtop", "20"));
                    int margleft = CastUtils.toInteger0((Object)main.fileIni.getValue("barcode", "mleft", "20"));
                    int margright = CastUtils.toInteger0((Object)main.fileIni.getValue("barcode", "mright", "20"));
                    int margbottom = CastUtils.toInteger0((Object)main.fileIni.getValue("barcode", "mbottom", "20"));
                    int numColonne = CastUtils.toInteger((Object)main.fileIni.getValue("barcode", "colonne", "4"));
                    int numRighe = CastUtils.toInteger((Object)main.fileIni.getValue("barcode", "righe", "10"));
                    System.out.println("marigni: " + margtop + " " + margleft + " " + margright + " " + margbottom);
                    repdes.setPageWidth(larghezzaReport);
                    repdes.setPageHeight(altezzaReport);
                    int colWidth = (larghezzaReport -= margleft + margright) / numColonne;
                    int detHeight = (altezzaReport -= margtop + margbottom) / numRighe;
                    repdes.setColumnCount(numColonne);
                    repdes.setColumnWidth(colWidth);
                    repdes.setTopMargin(margtop);
                    repdes.setBottomMargin(margbottom);
                    repdes.setLeftMargin(margleft);
                    repdes.setRightMargin(margright);
                    JRDesignBand details = (JRDesignBand)repdes.getDetail();
                    details.setHeight(detHeight);
                    for (JRElement el : details.getElements()) {
                        if (!(el instanceof JRDesignComponentElement)) continue;
                        JRDesignComponentElement elemento = (JRDesignComponentElement)el;
                        if (elemento.getComponent() instanceof StandardBarbecueComponent) {
                            StandardBarbecueComponent barcode = (StandardBarbecueComponent)elemento.getComponent();
                            barcode.setType(main.fileIni.getValue("barcode", "formato", "Code39"));
                            barcode.setDrawText(main.fileIni.getValueBoolean("barcode", "draw_text", Boolean.valueOf(true)).booleanValue());
                            JRDesignExpression designExpression = new JRDesignExpression();
                            designExpression.setValueClass(String.class);
                            designExpression.setText("$F{codice_a_barre}");
                            barcode.setCodeExpression((JRExpression)designExpression);
                        }
                        elemento.setWidth(colWidth - 20);
                        elemento.setHeight(detHeight - 45);
                        elemento.setX(10);
                        elemento.setY(20);
                        elemento.setBackcolor(Color.red);
                        if (!this.debug) continue;
                        JRDesignLine line = new JRDesignLine((JRDefaultStyleProvider)repdes);
                        line.setWidth(elemento.getWidth());
                        line.setHeight(1);
                        line.setDirection((byte)1);
                        line.getLinePen().setLineColor(Color.red);
                        line.getLinePen().setLineStyle((byte)2);
                        line.getLinePen().setLineWidth(1.0f);
                        line.setX(elemento.getX());
                        line.setY(elemento.getY());
                        details.addElement((JRDesignElement)line);
                        line = new JRDesignLine((JRDefaultStyleProvider)repdes);
                        line.setWidth(1);
                        line.setHeight(elemento.getHeight());
                        line.setDirection((byte)1);
                        line.getLinePen().setLineColor(Color.red);
                        line.getLinePen().setLineStyle((byte)2);
                        line.getLinePen().setLineWidth(1.0f);
                        line.setX(elemento.getX());
                        line.setY(elemento.getY());
                        details.addElement((JRDesignElement)line);
                        line = new JRDesignLine((JRDefaultStyleProvider)repdes);
                        line.setWidth(elemento.getWidth());
                        line.setHeight(1);
                        line.setDirection((byte)1);
                        line.getLinePen().setLineColor(Color.red);
                        line.getLinePen().setLineStyle((byte)2);
                        line.getLinePen().setLineWidth(1.0f);
                        line.setX(elemento.getX());
                        line.setY(elemento.getY() + elemento.getHeight());
                        details.addElement((JRDesignElement)line);
                        line = new JRDesignLine((JRDefaultStyleProvider)repdes);
                        line.setWidth(1);
                        line.setHeight(elemento.getHeight());
                        line.setDirection((byte)1);
                        line.getLinePen().setLineColor(Color.red);
                        line.getLinePen().setLineStyle((byte)2);
                        line.getLinePen().setLineWidth(1.0f);
                        line.setX(elemento.getX() + elemento.getWidth());
                        line.setY(elemento.getY());
                        details.addElement((JRDesignElement)line);
                    }
                    JRDesignTextField codiceArticolo = new JRDesignTextField((JRDefaultStyleProvider)repdes);
                    JRDesignExpression expressionArticolo = new JRDesignExpression();
                    expressionArticolo.setValueClass(String.class);
                    expressionArticolo.setText("$F{codice_articolo}");
                    codiceArticolo.setExpression((JRExpression)expressionArticolo);
                    codiceArticolo.setWidth(colWidth);
                    codiceArticolo.setHeight(11);
                    codiceArticolo.setFontName("SansSerif");
                    codiceArticolo.setFontSize(7);
                    codiceArticolo.setHorizontalAlignment((byte)2);
                    if (main.fileIni.getValueBoolean("barcode", "articolo_sopra", Boolean.valueOf(true)).booleanValue()) {
                        codiceArticolo.setX(0);
                        codiceArticolo.setY(2);
                    } else {
                        codiceArticolo.setX(0);
                        codiceArticolo.setY(detHeight - 24);
                    }
                    JRDesignTextField testoLibero = new JRDesignTextField((JRDefaultStyleProvider)repdes);
                    JRDesignExpression expressionTesto = new JRDesignExpression();
                    expressionTesto.setValueClass(String.class);
                    expressionTesto.setText("$F{testo_libero}");
                    testoLibero.setExpression((JRExpression)expressionTesto);
                    testoLibero.setWidth(colWidth);
                    testoLibero.setHeight(11);
                    testoLibero.setFontName("SansSerif");
                    testoLibero.setFontSize(7);
                    testoLibero.setHorizontalAlignment((byte)2);
                    if (main.fileIni.getValueBoolean("barcode", "articolo_sopra", Boolean.valueOf(true)).booleanValue()) {
                        testoLibero.setX(0);
                        testoLibero.setY(detHeight - 24);
                    } else {
                        testoLibero.setX(0);
                        testoLibero.setY(2);
                    }
                    if (this.debug) {
                        JRDesignLine line = new JRDesignLine((JRDefaultStyleProvider)repdes);
                        line = new JRDesignLine((JRDefaultStyleProvider)repdes);
                        line.setWidth(colWidth - 2);
                        line.setHeight(1);
                        line.setDirection((byte)1);
                        line.getLinePen().setLineColor(Color.lightGray);
                        line.getLinePen().setLineStyle((byte)2);
                        line.getLinePen().setLineWidth(0.5f);
                        line.setX(1);
                        line.setY(detHeight - 1);
                        details.addElement((JRDesignElement)line);
                        line = new JRDesignLine((JRDefaultStyleProvider)repdes);
                        line.setWidth(1);
                        line.setHeight(detHeight - 5);
                        line.setDirection((byte)1);
                        line.getLinePen().setLineColor(Color.lightGray);
                        line.getLinePen().setLineStyle((byte)2);
                        line.getLinePen().setLineWidth(0.5f);
                        line.setX(0);
                        line.setY(2);
                        details.addElement((JRDesignElement)line);
                        line = new JRDesignLine((JRDefaultStyleProvider)repdes);
                        line.setWidth(1);
                        line.setHeight(detHeight - 5);
                        line.setDirection((byte)1);
                        line.getLinePen().setLineColor(Color.lightGray);
                        line.getLinePen().setLineStyle((byte)2);
                        line.getLinePen().setLineWidth(0.5f);
                        line.setX(colWidth);
                        line.setY(2);
                        details.addElement((JRDesignElement)line);
                    }
                    details.addElement((JRDesignElement)codiceArticolo);
                    details.addElement((JRDesignElement)testoLibero);
                    return repdes;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Object doInBackground() throws Exception {
                    JDialogCompilazioneReport dialog = new JDialogCompilazioneReport();
                    String ret = null;
                    try {
                        HashMap<String, Object> params;
                        dialog.setLocationRelativeTo(null);
                        dialog.setVisible(true);
                        File freport = new File(main.wd + Reports.DIR_REPORTS + prefTipoStampa);
                        JasperReport rep = Reports.getReport((File)freport);
                        String suffisso = "";
                        suffisso = suffisso.length() == 0 ? suffisso + ".jasper" : suffisso + "_gen_invoicex.jasper";
                        String newFile = freport.getAbsolutePath() + suffisso;
                        File newFileFile = new File(newFile);
                        boolean ricompilare = true;
                        if (newFileFile.exists() && newFileFile.lastModified() >= freport.lastModified()) {
                            ricompilare = false;
                            rep = JasperManager.loadReport((String)newFile);
                        }
                        ricompilare = true;
                        JasperDesign repdes = JRXmlLoader.load((File)freport);
                        repdes = this.formatoBarcode(freport, rep, repdes);
                        if (ricompilare) {
                            JasperCompileManager.compileReportToFile((JasperDesign)repdes, (String)newFile);
                            rep = JasperManager.loadReport((String)newFile);
                        }
                        try {
                            params = new HashMap<String, Object>();
                            params.put("source", (Object)this);
                            params.put("freport", freport);
                            params.put("rep", rep);
                            params.put("repdes", repdes);
                            InvoicexEvent event = new InvoicexEvent(params);
                            event.type = 28;
                            HashMap reth = (HashMap)main.events.fireInvoicexEventWResult(event);
                            if (reth != null) {
                                rep = (JasperReport)reth.get("rep");
                            }
                        }
                        catch (Exception err) {
                            err.printStackTrace();
                        }
                        params = new HashMap();
                        ArrayList valori = InvoicexUtil.checkBarcodeList((int)dbIdPadre, (String)tipo_doc, (boolean)f_acquisto);
                        if (valori != null) {
                            JRDSBarcode jrInvoice = new JRDSBarcode(valori, main.fileIni.getValueBoolean("barcode", "per_quantita", Boolean.valueOf(false)).booleanValue());
                            params.put("myds", jrInvoice);
                            JasperPrint print = JasperManager.fillReport((JasperReport)rep, params, (JRDataSource)jrInvoice);
                            if (generazionePdfDaJasper) {
                                String nomeFile = "barcode.pdf";
                                nomeFile = "tempEmail/" + FileUtils.normalizeFileName((String)nomeFile);
                                File fd = new File(main.wd + nomeFile);
                                String nomeFilePdf = fd.getAbsolutePath();
                                JasperExportManager.exportReportToPdfFile((JasperPrint)print, (String)nomeFilePdf);
                                ret = nomeFilePdf;
                            } else if (main.fileIni.getValueBoolean("pref", "stampaPdf", Boolean.valueOf(false)).booleanValue()) {
                                String nomeFilePdf = main.wd + "tempPrnBarcode.pdf";
                                JasperExportManager.exportReportToPdfFile((JasperPrint)print, (String)nomeFilePdf);
                                Util.start2((String)nomeFilePdf);
                            } else {
                                final JasperPrint printer = print;
                                Thread t = new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        JDialogJasperViewer viewr = new JDialogJasperViewer((Frame)main.getPadre(), true, printer);
                                        viewr.setTitle("Anteprima di stampa");
                                        viewr.setLocationRelativeTo(null);
                                        viewr.setVisible(true);
                                    }
                                });
                                t.start();
                            }
                        } else {
                            SwingUtils.showErrorMessage((Component)dialog, (String)"Non ci sono codici a barre da stampare in questo documento", (String)"Impossibile Proseguire");
                        }
                    }
                    catch (JRException jrerr) {
                        jrerr.printStackTrace();
                        JOptionPane.showMessageDialog((Component)main.getPadreFrame(), jrerr.toString(), "Errore", 0);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        if (t.getCause() != null && t.getCause() instanceof BarcodeException) {
                            SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)("Errore nella creazione del codice a barre, probabilmente devi cambiare impostazioni da Utilit\ufffd->Impostazioni->Codici a barre\nCausa:" + t.getCause().getMessage()));
                        } else {
                            SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)("Errore: " + t.toString()));
                        }
                    }
                    finally {
                        dialog.setVisible(false);
                    }
                    return ret;
                }
            };
            work.execute();
            if (attendi) {
                try {
                    ret = work.get();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                System.out.println("get " + work + " : " + ret);
            }
        } else {
            System.err.println("rimossi vecchi modelli di stampa");
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            File fwd = new File("./");
            try {
                main.wd = fwd.getCanonicalPath() + File.separator;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            main.paramProp = "param_prop_blank5.txt";
            main.fileIni = new iniFileProp();
            main.fileIni.realFileName = main.wd + main.paramProp;
            main.loadIni();
            main.utente = new Utente(1);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JFrame main2 = new JFrame();
            JDesktopPane desk = new JDesktopPane();
            main2.getContentPane().add(desk);
            int dbId = 88;
            try {
                Main2.stampaBarcode(dbId, false, false, false, Db.TIPO_DOCUMENTO_DDT);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            main2.setDefaultCloseOperation(3);
            Thread t = new Thread("chiusi"){

                @Override
                public void run() {
                    try {
                        4.sleep(60000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Main2.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    System.exit(0);
                }
            };
            t.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

