/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex.pnota;

import java.util.Map;

public abstract class Cache {
    public boolean initialized = false;
    public Map<String, Map> values;
    public Long lastinit = null;
    public long maxtime = 60000L;

    public void needInit() throws Exception {
        if (this.lastinit != null && System.currentTimeMillis() - this.lastinit > this.maxtime) {
            this.initialized = false;
        }
        if (!this.initialized) {
            this.values = this.initValues();
            this.initialized = true;
            this.lastinit = System.currentTimeMillis();
        }
    }

    public void reset() {
        this.initialized = false;
    }

    public void reset(String id) {
        this.values.remove(id);
    }

    public void update(String id, Map rec) {
        this.values.put(id, rec);
    }

    abstract Map<String, Map> initValues();
}

