/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex.pnota;

import invoicexplugincontabilita.Main;
import it.tnx.Db;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.MicroBench;
import it.tnx.commons.SwingUtils;
import it.tnx.invoicex.pnota.PNCache;
import it.tnx.invoicex.pnota.PNUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXFindBar;
import org.jdesktop.swingx.JXTree;

public class JDialogTrovaConto
extends JDialog {
    ContiModel model = null;
    public Map conto_selezionato;
    public TreePath path_selezionata;
    private Integer filtro;
    private JXTree conti;
    private JButton espandi;
    private JScrollPane jScrollPane1;
    private JXFindBar jXFindBar1;
    private JButton richiudi;

    public JDialogTrovaConto(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jXFindBar1.setSearchable(this.conti.getSearchable());
        this.pack();
        try {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner != null) {
                Point p = focusOwner.getLocationOnScreen();
                int maxh = SwingUtils.getScreenAvailableMaxHeight();
                int y = focusOwner.getHeight();
                if (p.getY() + (double)y + (double)this.getHeight() > (double)maxh) {
                    y = -this.getHeight();
                }
                int x = -(this.getWidth() / 2);
                p.translate(x, y);
                this.setLocation(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.conti = new JXTree();
        this.richiudi = new JButton();
        this.espandi = new JButton();
        this.jXFindBar1 = new JXFindBar();
        this.setDefaultCloseOperation(2);
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        DefaultMutableTreeNode treeNode2 = new DefaultMutableTreeNode("caricamento...");
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("Piano dei conti in caricamento...");
        treeNode1.add(treeNode2);
        this.conti.setModel((TreeModel)new DefaultTreeModel(treeNode1));
        this.conti.setName("conti");
        this.conti.setRootVisible(false);
        this.conti.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDialogTrovaConto.this.contiMouseClicked(evt);
            }
        });
        this.conti.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JDialogTrovaConto.this.contiKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.conti);
        this.richiudi.setIcon(Main.mygetIcon("Collapse_Arrow"));
        this.richiudi.setText("Richiudi");
        this.richiudi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogTrovaConto.this.richiudiActionPerformed(evt);
            }
        });
        this.espandi.setIcon(Main.mygetIcon("Expand_Arrow"));
        this.espandi.setText("Espandi");
        this.espandi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogTrovaConto.this.espandiActionPerformed(evt);
            }
        });
        this.jXFindBar1.setSearchable(null);
        GroupLayout jXFindBar1Layout = new GroupLayout((Container)this.jXFindBar1);
        this.jXFindBar1.setLayout((LayoutManager)jXFindBar1Layout);
        jXFindBar1Layout.setHorizontalGroup((GroupLayout.Group)jXFindBar1Layout.createParallelGroup(1).add(0, 629, Short.MAX_VALUE));
        jXFindBar1Layout.setVerticalGroup((GroupLayout.Group)jXFindBar1Layout.createParallelGroup(1).add(0, 33, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0, 485, Short.MAX_VALUE).add((Component)this.espandi).addPreferredGap(0).add((Component)this.richiudi)).add((Component)this.jXFindBar1, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jScrollPane1, -1, 629, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.espandi).add((Component)this.richiudi)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 350, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jXFindBar1, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void richiudiActionPerformed(ActionEvent evt) {
        this.conti.collapseAll();
    }

    private void espandiActionPerformed(ActionEvent evt) {
        SwingUtils.mouse_wait((Component)this);
        this.conti.expandAll();
        SwingUtils.mouse_def((Component)this);
    }

    private void contiMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.seleziona_conto();
        }
    }

    private void contiKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.seleziona_conto();
        }
    }

    public void init() throws Exception {
        this.init(0);
    }

    public void init(int filtro) throws Exception {
        SwingUtils.mouse_wait((Component)this);
        this.model = new ContiModel(filtro);
        this.filtro = filtro;
        this.conti.setModel((TreeModel)this.model);
        this.conti.setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof Map) {
                    value = ((Map)value).get("id");
                } else if (value instanceof DefaultMutableTreeNode) {
                    Map m = (Map)((DefaultMutableTreeNode)value).getUserObject();
                    value = m.get("id") + " " + m.get("descrizione");
                }
                Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value == null) {
                    return c;
                }
                try {
                    if (CastUtils.toString((Object)value).length() == 2) {
                        Font f = c.getFont().deriveFont(14.0f);
                        c.setFont(f);
                    } else if (CastUtils.toString((Object)value).length() == 4) {
                        Font f = c.getFont().deriveFont(12.0f);
                        c.setFont(f);
                    } else {
                        Font f = c.getFont().deriveFont(11.0f);
                        c.setFont(f);
                    }
                }
                catch (Exception e) {
                    Font f = c.getFont().deriveFont(11.0f);
                    c.setFont(f);
                }
                return c;
            }
        });
        this.espandiActionPerformed(null);
        SwingUtils.mouse_def((Component)this);
    }

    private void seleziona_conto() {
        this.conto_selezionato = (Map)((DefaultMutableTreeNode)this.conti.getSelectionPath().getLastPathComponent()).getUserObject();
        this.path_selezionata = this.conti.getSelectionPath();
        if (this.filtro != null) {
            try {
                if (PNCache.getLivello((String)this.conto_selezionato.get("id")) != PNUtil.getMaxLivello()) {
                    Point p = MouseInfo.getPointerInfo().getLocation();
                    p.translate(0, 30);
                    SwingUtils.showFlashMessage2((String)("Devi selezionare un conto di " + PNUtil.getMaxLivello() + "\u00b0 livello "), (int)3, (Point)p, (Color)Color.yellow);
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setVisible(false);
    }

    public static class ContiModel
    extends DefaultTreeModel {
        int filtro;

        public ContiModel() throws Exception {
            this(0);
        }

        public ContiModel(int filtro) throws Exception {
            super(new DefaultMutableTreeNode("Piano dei conti"));
            this.filtro = filtro;
            MicroBench mb = new MicroBench();
            mb.start();
            this.scan(null, null);
            System.out.println(mb.getDiff("caricamento conti"));
        }

        private void scan(String id, DefaultMutableTreeNode npadre) throws Exception {
            if (id == null) {
                DefaultMutableTreeNode root = new DefaultMutableTreeNode("Piano dei conti");
                String sql = "select * from pn_conti where id_padre is null";
                ArrayList list = DbUtils.getListMap((Connection)Db.getConn(), (String)sql);
                for (Map m : list) {
                    String idlist = (String)m.get("id");
                    DefaultMutableTreeNode n = new DefaultMutableTreeNode(m);
                    this.scan(idlist, n);
                    boolean add = true;
                    if (this.filtro > 0 && PNCache.getLivello(idlist) < PNUtil.getMaxLivello() && n.getChildCount() <= 0) {
                        add = false;
                    }
                    if (!add) continue;
                    root.add(n);
                }
                this.setRoot(root);
            } else {
                String sql = "select * from pn_conti where id_padre = " + Db.pcs((String)id);
                ArrayList list = DbUtils.getListMap((Connection)Db.getConn(), (String)sql);
                for (Map m : list) {
                    DefaultMutableTreeNode n = new DefaultMutableTreeNode(m);
                    String idlist = (String)m.get("id");
                    if (idlist.equals("05.01.999")) {
                        System.out.println("debug");
                    }
                    boolean ok = true;
                    if (this.filtro > 0) {
                        if (PNCache.getLivello(idlist) == PNUtil.getMaxLivello()) {
                            boolean costo;
                            if (this.filtro == 1) {
                                boolean richiesta_clifor = CastUtils.toBoolean(m.get("richiesta_clifor"));
                                if (!richiesta_clifor) {
                                    ok = false;
                                }
                            } else if (this.filtro == 2) {
                                boolean ricavo = CastUtils.toString(m.get("tipo")).equals("RIC");
                                if (!ricavo) {
                                    ok = false;
                                }
                            } else if (this.filtro == 3) {
                                costo = CastUtils.toString(m.get("tipo")).equals("COS");
                                if (!costo) {
                                    ok = false;
                                }
                            } else if (this.filtro == 4) {
                                costo = CastUtils.toString(m.get("tipo")).equals("COS");
                                boolean ricavo = CastUtils.toString(m.get("tipo")).equals("RIC");
                                if (!costo && !ricavo) {
                                    ok = false;
                                }
                            }
                        } else {
                            boolean figli = CastUtils.toBoolean(m.get("ha_figli"));
                            if (!figli) {
                                ok = false;
                            }
                        }
                    }
                    if (!ok) continue;
                    this.scan(idlist, n);
                    boolean add = true;
                    if (this.filtro > 0 && PNCache.getLivello(idlist) < PNUtil.getMaxLivello() && n.getChildCount() <= 0) {
                        add = false;
                    }
                    if (!add) continue;
                    npadre.add(n);
                }
            }
        }
    }
}

