CREATE TABLE IF NOT EXISTS `pn_causali` (
  `id` varchar(10) NOT NULL DEFAULT '',
  `descrizione` varchar(250) NOT NULL DEFAULT '',
  `richiesta_codice_iva` bit(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DELETE FROM `pn_causali`;
/*!40000 ALTER TABLE `pn_causali` DISABLE KEYS */;
INSERT INTO `pn_causali` (`id`, `descrizione`, `richiesta_codice_iva`) VALUES
	('FA', 'Fattura di acquisto', b'10000000'),
	('FV', 'Fattura di vendita', b'10000000');
/*!40000 ALTER TABLE `pn_causali` ENABLE KEYS */;


CREATE TABLE IF NOT EXISTS `pn_conti` (
  `id` varchar(50) NOT NULL DEFAULT '',
  `id_padre` varchar(50) DEFAULT NULL,
  `descrizione` varchar(250) DEFAULT NULL,
  `richiesta_clifor` enum('S','') NOT NULL DEFAULT '',
  `richiesta_iva` enum('S','') NOT NULL DEFAULT '',
  `td` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `id_utente` int(10) DEFAULT NULL,
  `livello` int(10) DEFAULT NULL,
  `ha_figli` tinyint(4) DEFAULT NULL,
  `tipo` char(3) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table inv_test_prima_nota.pn_conti: ~60 rows (approximately)
DELETE FROM `pn_conti`;
/*!40000 ALTER TABLE `pn_conti` DISABLE KEYS */;
INSERT INTO `pn_conti` (`id`, `id_padre`, `descrizione`, `richiesta_clifor`, `richiesta_iva`, `td`, `id_utente`, `livello`, `ha_figli`, `tipo`) VALUES
	('01', NULL, 'ATTIVITA\'', '', '', '2012-10-31 18:00:30', NULL, 1, 1, 'ATT'),
	('01.01', '01', 'CLIENTI', '', '', '2013-01-31 17:22:30', NULL, 2, 1, 'ATT'),
	('01.01.001', '01.01', 'Clienti Italia', 'S', '', '2013-01-31 17:22:30', NULL, 3, 0, 'ATT'),
	('01.01.002', '01.01', 'Clienti Estero', 'S', '', '2013-01-31 17:22:30', NULL, 3, 0, 'ATT'),
	('01.02', '01', 'ALTRI CREDITI COMMERCIALI', '', '', '2012-10-31 18:00:30', NULL, 2, 1, 'ATT'),
	('01.02.001', '01.02', 'Clienti c/ricevute bancarie', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'ATT'),
	('01.10', '01', 'ALTRI CREDITI', '', '', '2012-10-31 18:00:30', NULL, 2, 1, 'ATT'),
	('01.10.002', '01.10', 'IVA c/acquisti', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'ATT'),
	('01.30', '01', 'DEPOSITI E C/C ATTIVI', '', '', '2013-01-31 17:22:30', NULL, 2, 1, 'ATT'),
	('01.30.001', '01.30', 'Banca', '', '', '2013-01-31 17:22:30', NULL, 3, 0, 'ATT'),
	('01.50', '01', 'DISPONIBILITA\' LIQUIDE', '', '', '2013-01-31 17:22:30', NULL, 2, 1, 'ATT'),
	('01.50.001', '01.50', 'Cassa', '', '', '2013-01-31 17:22:30', NULL, 3, 0, 'ATT'),
	('02', NULL, 'PASSIVITA\'', '', '', '2012-10-31 18:00:30', NULL, 1, 1, 'PAS'),
	('02.01', '02', 'FORNITORI', '', '', '2013-01-31 17:22:30', NULL, 2, 1, 'PAS'),
	('02.01.001', '02.01', 'Fornitori Italia', 'S', '', '2013-01-31 17:20:32', NULL, 3, 0, 'PAS'),
	('02.01.002', '02.01', 'Fornitori Estero', 'S', '', '2013-01-31 17:20:32', NULL, 3, 0, 'PAS'),
	('02.01.003', '02.01', 'Professionisti', '', '', '2013-01-31 17:20:32', NULL, 3, 0, 'PAS'),
	('02.10', '02', 'DEBITI VERSO BANCHE', '', '', '2013-01-31 17:22:30', NULL, 2, 1, 'PAS'),
	('02.10.001', '02.10', 'Banche c/c passivi', '', '', '2013-01-31 17:19:29', NULL, 3, 0, 'PAS'),
	('02.20', '02', 'DEBITI MED.LUNGO TERMINE', '', '', '2013-01-31 17:22:30', NULL, 2, 1, 'PAS'),
	('02.20.001', '02.20', 'Mutui ipotecari', '', '', '2013-01-31 17:19:56', NULL, 3, 0, 'PAS'),
	('02.30', '02', 'DEBITI TRIBUTARI', '', 'S', '2013-01-31 17:33:43', NULL, 2, 1, 'PAS'),
	('02.30.011', '02.30', 'IVA c/acquisti', '', 'S', '2013-01-31 17:37:04', NULL, 3, 0, 'PAS'),
	('02.30.012', '02.30', 'IVA c/vendite', '', 'S', '2013-01-31 17:33:43', NULL, 3, 0, 'PAS'),
	('02.30.013', '02.30', 'IVA c/corrisp. scorporo', '', '', '2013-01-31 17:33:43', NULL, 3, 0, 'PAS'),
	('02.30.015', '02.30', 'IVA in sospensione', '', '', '2013-01-31 17:33:43', NULL, 3, 0, 'PAS'),
	('03', NULL, 'PATRIMONIO NETTO', '', '', '2012-10-31 18:00:30', NULL, 1, 1, 'PAT'),
	('03.01', '03', 'CAPITALE NETTO', '', '', '2012-10-31 18:00:30', NULL, 2, 1, 'PAT'),
	('03.01.001', '03.01', 'Capitale sociale', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'PAT'),
	('03.01.002', '03.01', 'Riserva legale', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'PAT'),
	('03.01.003', '03.01', 'Riserva statutaria', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'PAT'),
	('03.01.011', '03.01', 'Utile esercizi precedenti', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'PAT'),
	('03.01.012', '03.01', 'Perdite eserc. precedenti', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'PAT'),
	('03.01.021', '03.01', 'Utile d\'esercizio', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'PAT'),
	('03.01.022', '03.01', 'Perdita d\'esercizio', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'PAT'),
	('04', NULL, 'COSTI DI ESERCIZIO', '', '', '2012-10-31 18:00:30', NULL, 1, 1, 'COS'),
	('04.01', '04', 'COSTI PER MATERIALE', '', '', '2012-10-31 18:00:30', NULL, 2, 1, 'COS'),
	('04.01.001', '04.01', 'Acq. mater. di produzione', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'COS'),
	('04.02', '04', 'COSTI PER SERVIZI', '', '', '2013-01-31 19:12:50', NULL, 2, 1, 'COS'),
	('04.02.001', '04.02', 'Trasporti su acquisti', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'COS'),
	('04.03', '04', 'SERVIZI INDUSTRIALI', '', '', '2012-10-31 18:00:30', NULL, 2, 1, 'COS'),
	('04.03.001', '04.03', 'Lavorazioni esterne', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'COS'),
	('04.03.002', '04.03', 'Energia elettrica', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'COS'),
	('04.20', '04', 'COSTI PER IL PERSONALE', '', '', '2013-01-31 19:13:26', NULL, 2, 1, 'COS'),
	('04.20.001', '04.20', 'Retribuzioni', '', '', '2013-01-31 19:13:26', NULL, 3, 0, 'COS'),
	('04.40', '04', 'AMMORTAMENTO IMMOB.IMMAT.', '', '', '2013-01-31 19:13:37', NULL, 2, 1, 'COS'),
	('04.40.001', '04.40', 'Amm.costi impianto e ampl', '', '', '2013-01-31 19:13:37', NULL, 3, 0, 'COS'),
	('04.50', '04', 'AMMORTAMENTO IMMOB.MATER.', '', '', '2013-01-31 19:13:44', NULL, 2, 1, 'COS'),
	('04.50.001', '04.50', 'Amm.ordin.fabbricati civ.', '', '', '2013-01-31 19:13:44', NULL, 3, 0, 'COS'),
	('05', NULL, 'RICAVI DI ESERCIZIO', '', '', '2012-10-31 18:00:30', NULL, 1, 1, 'RIC'),
	('05.01', '05', 'RICAVI VENDITE E PRESTAZ.', '', '', '2012-10-31 18:00:30', NULL, 2, 1, 'RIC'),
	('05.01.001', '05.01', 'Ricavi Italia', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'RIC'),
	('05.01.002', '05.01', 'Rimborsi spese vend. Ita.', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'RIC'),
	('05.01.011', '05.01', 'Ricavi estero', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'RIC'),
	('06', NULL, 'CONTI RIEPILOGATIVI', '', '', '2012-10-31 18:00:30', NULL, 1, 1, 'RIE'),
	('06.01', '06', 'CONTO ECONOMICO', '', '', '2012-10-31 18:00:30', NULL, 2, 1, 'RIE'),
	('06.01.001', '06.01', 'Profitti e perdite', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'RIE'),
	('06.02', '06', 'STATO PATRIMONIALE', '', '', '2012-10-31 18:00:30', NULL, 2, 1, 'RIE'),
	('06.02.001', '06.02', 'Bilancio di apertura', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'RIE'),
	('06.02.002', '06.02', 'Bilancio di chiusura', '', '', '2012-10-31 18:00:30', NULL, 3, 0, 'RIE');
/*!40000 ALTER TABLE `pn_conti` ENABLE KEYS */;


CREATE TABLE IF NOT EXISTS `pn_conti_standard` (
  `id` varchar(50) NOT NULL,
  `descrizione` varchar(250) DEFAULT NULL,
  `id_conto` varchar(50) DEFAULT NULL,
  `ts` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `id_utente` int(10) DEFAULT NULL,
  `ordine` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_pn_conti_standard_pn_conti` (`id_conto`),
  CONSTRAINT `FK_pn_conti_standard_pn_conti` FOREIGN KEY (`id_conto`) REFERENCES `pn_conti` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DELETE FROM `pn_conti_standard`;
/*!40000 ALTER TABLE `pn_conti_standard` DISABLE KEYS */;
INSERT INTO `pn_conti_standard` (`id`, `descrizione`, `id_conto`, `ts`, `id_utente`, `ordine`) VALUES
	('ACQ', 'ACQUISTI', '04.01.001', '2013-01-31 10:23:02', NULL, 70),
	('CLI', 'CLIENTI', '01.01.001', '2013-01-31 10:22:35', NULL, 10),
	('FOR', 'FORNITORI', '02.01.001', '2013-01-31 10:22:37', NULL, 20),
	('IVA-ACQ', 'IVA ACQUISTI', '01.10.002', '2013-01-31 10:22:51', NULL, 40),
	('IVA-LIQ', 'LIQUIDAZIONE IVA', '02.30.011', '2013-01-31 10:22:57', NULL, 50),
	('IVA-VEN', 'IVA VENDITE', '02.30.012', '2013-01-31 10:22:55', NULL, 30),
	('RIC', 'VENDITE', '05.01.001', '2013-01-31 10:23:04', NULL, 60);
/*!40000 ALTER TABLE `pn_conti_standard` ENABLE KEYS */;


-- Dumping structure for table inv_test_prima_nota.pn_esercizi
CREATE TABLE IF NOT EXISTS `pn_esercizi` (
  `esercizio` varchar(10) NOT NULL,
  `dal` date DEFAULT NULL,
  `al` date DEFAULT NULL,
  `ts` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `id_utente` int(10) DEFAULT NULL,
  PRIMARY KEY (`esercizio`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table inv_test_prima_nota.pn_esercizi: ~1 rows (approximately)
DELETE FROM `pn_esercizi`;
/*!40000 ALTER TABLE `pn_esercizi` DISABLE KEYS */;
INSERT INTO `pn_esercizi` (`esercizio`, `dal`, `al`, `ts`, `id_utente`) VALUES
	('2013', '2013-01-01', '2013-12-31', '2013-01-31 15:19:27', NULL);
/*!40000 ALTER TABLE `pn_esercizi` ENABLE KEYS */;


-- Dumping structure for table inv_test_prima_nota.pn_registrazioni
CREATE TABLE IF NOT EXISTS `pn_registrazioni` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `numero` int(10) NOT NULL DEFAULT '0',
  `esercizio` varchar(10) NOT NULL,
  `data` date NOT NULL,
  `ts` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `id_utente` int(10) NOT NULL,
  `causale` varchar(10) NOT NULL,
  `descrizione` varchar(250) NOT NULL,
  `registro_iva` varchar(10) DEFAULT NULL,
  `id_test_fatt` int(10) DEFAULT NULL,
  `id_test_fatt_acquisto` int(10) DEFAULT NULL,
  `totale_dare` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `totale_avere` decimal(15,5) NOT NULL DEFAULT '0.00000',
  PRIMARY KEY (`id`),
  UNIQUE KEY `num_ese` (`numero`,`esercizio`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

-- Dumping structure for table inv_test_prima_nota.pn_registrazioni_righe
CREATE TABLE IF NOT EXISTS `pn_registrazioni_righe` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_padre` int(10) unsigned NOT NULL,
  `numero_registrazione` int(10) DEFAULT NULL,
  `riga` int(10) DEFAULT NULL,
  `conto` varchar(50) DEFAULT NULL,
  `clifor` int(10) unsigned DEFAULT NULL,
  `iva` char(3) DEFAULT NULL,
  `descrizione` varchar(250) DEFAULT NULL,
  `dare` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `avere` decimal(15,5) NOT NULL DEFAULT '0.00000',
  `ts` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `id_utente` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_pn_registrazioni` (`id_padre`),
  CONSTRAINT `FK_pn_registrazioni` FOREIGN KEY (`id_padre`) REFERENCES `pn_registrazioni` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `pn_registri_iva` (
  `id` varchar(10) NOT NULL,
  `tipo` enum('Acquisti','Vendite','Corrispettivi') NOT NULL,
  `descrizione` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DELETE FROM `pn_registri_iva`;
/*!40000 ALTER TABLE `pn_registri_iva` DISABLE KEYS */;
INSERT INTO `pn_registri_iva` (`id`, `tipo`, `descrizione`) VALUES
	('A1', 'Acquisti', 'Acquisti 1'),
	('V1', 'Vendite', 'Vendite 1');
/*!40000 ALTER TABLE `pn_registri_iva` ENABLE KEYS */;


CREATE TABLE IF NOT EXISTS `pn_temp_bilancio` (
  `riga` int(10) NOT NULL DEFAULT '0',
  `id_user` varchar(200) NOT NULL DEFAULT '',
  `ts` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tipo` char(2) DEFAULT NULL,
  `sx_conto` varchar(50) DEFAULT NULL,
  `sx_des` varchar(250) DEFAULT NULL,
  `sx_importo` decimal(15,5) DEFAULT NULL,
  `sx_totale` decimal(15,5) DEFAULT NULL,
  `dx_conto` varchar(50) DEFAULT NULL,
  `dx_des` varchar(250) DEFAULT NULL,
  `dx_importo` decimal(15,5) DEFAULT NULL,
  `dx_totale` decimal(15,5) DEFAULT NULL,
  PRIMARY KEY (`riga`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;