/*
 * Decompiled with CFR 0.152.
 */
package invoicexpluginemail;

import it.tnx.commons.FormatUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class DbUtils {
    public static List tryJpaQuery(Object query) throws Exception {
        int max = 5;
        int tries = 0;
        Object ret = null;
        do {
            ++tries;
            try {
                ret = query.getClass().getMethod("getResultList", new Class[0]).invoke(query, new Object[0]);
                tries = max + 1;
            }
            catch (Exception ex) {
                if (ex.getCause().getCause() instanceof SQLException) {
                    SQLException sqlex = (SQLException)ex.getCause().getCause();
                    String sqlState = sqlex.getSQLState();
                    if (!"08S01".equals(sqlState) && !"40001".equals(sqlState)) {
                        tries = max + 1;
                    }
                    continue;
                }
                throw ex;
            }
        } while (tries < max);
        return (List)ret;
    }

    public static ResultSet tryQuery(Statement stat, String sql) throws Exception {
        int max = 5;
        int tries = 0;
        ResultSet ret = null;
        do {
            ++tries;
            try {
                ret = stat.executeQuery(sql);
                tries = max + 1;
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof SQLException) {
                    SQLException sqlex = (SQLException)ex.getCause();
                    String sqlState = sqlex.getSQLState();
                    if (!"08S01".equals(sqlState) && !"40001".equals(sqlState)) {
                        tries = max + 1;
                    }
                    continue;
                }
                throw ex;
            }
        } while (tries < max);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryExecQuery(Connection conn, String sql) throws Exception {
        int max = 5;
        int tries = 0;
        Statement stat = null;
        boolean ret = false;
        do {
            ++tries;
            try {
                stat = conn.createStatement();
                ret = stat.execute(sql);
                tries = max + 1;
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof SQLException) {
                    SQLException sqlex = (SQLException)ex.getCause();
                    String sqlState = sqlex.getSQLState();
                    if (!"08S01".equals(sqlState) && !"40001".equals(sqlState)) {
                        tries = max + 1;
                    }
                    continue;
                }
                throw ex;
            }
            finally {
                if (stat != null) {
                    stat.close();
                }
            }
        } while (tries < max);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int tryExecQueryWithResult(Connection conn, String sql) throws Exception {
        int max = 5;
        int tries = 0;
        Statement stat = null;
        boolean ret = false;
        int uc = -1;
        do {
            ++tries;
            try {
                stat = conn.createStatement();
                ret = stat.execute(sql);
                uc = stat.getUpdateCount();
                tries = max + 1;
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof SQLException) {
                    SQLException sqlex = (SQLException)ex.getCause();
                    String sqlState = sqlex.getSQLState();
                    if (!"08S01".equals(sqlState) && !"40001".equals(sqlState)) {
                        tries = max + 1;
                    }
                    continue;
                }
                throw ex;
            }
            finally {
                if (stat != null) {
                    stat.close();
                }
            }
        } while (tries < max);
        return uc;
    }

    public static ResultSet tryOpenResultSet(Connection conn, String sql) throws Exception {
        int max = 5;
        int tries = 0;
        Statement stat = null;
        ResultSet ret = null;
        do {
            ++tries;
            try {
                stat = conn.createStatement();
                ret = stat.executeQuery(sql);
                tries = max + 1;
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof SQLException) {
                    SQLException sqlex = (SQLException)ex.getCause();
                    String sqlState = sqlex.getSQLState();
                    if (!"08S01".equals(sqlState) && !"40001".equals(sqlState)) {
                        tries = max + 1;
                    }
                    continue;
                }
                throw ex;
            }
        } while (tries < max);
        return ret;
    }

    public static ResultSet tryOpenResultSetEditable(Connection conn, String sql) throws Exception {
        int max = 5;
        int tries = 0;
        Statement stat = null;
        ResultSet ret = null;
        do {
            ++tries;
            try {
                stat = conn.createStatement(1004, 1008);
                stat.setFetchSize(50);
                ret = stat.executeQuery(sql);
                tries = max + 1;
            }
            catch (Exception ex) {
                try {
                    if (ex.getCause() instanceof SQLException) {
                        SQLException sqlex = (SQLException)ex.getCause();
                        String sqlState = sqlex.getSQLState();
                        if (!"08S01".equals(sqlState) && !"40001".equals(sqlState)) {
                            tries = max + 1;
                        }
                        continue;
                    }
                    if (stat != null) {
                        stat.close();
                    }
                    throw ex;
                }
                catch (Exception ex0) {
                    if (stat != null) {
                        stat.close();
                    }
                    throw ex0;
                }
            }
        } while (tries < max);
        return ret;
    }

    public static ResultSet tryOpenResultSetEditableSensitive(Connection conn, String sql) throws Exception {
        int max = 5;
        int tries = 0;
        Statement stat = null;
        ResultSet ret = null;
        do {
            ++tries;
            try {
                stat = conn.createStatement(1005, 1008);
                stat.setFetchSize(50);
                ret = stat.executeQuery(sql);
                tries = max + 1;
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof SQLException) {
                    SQLException sqlex = (SQLException)ex.getCause();
                    String sqlState = sqlex.getSQLState();
                    if (!"08S01".equals(sqlState) && !"40001".equals(sqlState)) {
                        tries = max + 1;
                    }
                    continue;
                }
                throw ex;
            }
        } while (tries < max);
        return ret;
    }

    public static Connection getMysqlJdbcConn(String server, String database, String user, String password) throws Exception {
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        String url = "jdbc:mysql://" + server + "/" + database + "?jdbcCompliantTruncation=false&zeroDateTimeBehavior=round&emptyStringsConvertToZero=true&autoReconnect=true";
        Connection conn = DriverManager.getConnection(url, user, password);
        return conn;
    }

    public static Object getObject(Connection conn, String sql) throws Exception {
        ResultSet r = null;
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            if (r.next()) {
                Object object = r.getObject(1);
                return object;
            }
            throw new Exception("record non trovato sql:" + sql);
        }
        finally {
            if (r != null) {
                r.getStatement().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getString(Connection conn, String sql) {
        String string;
        ResultSet r = null;
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            if (!r.next()) return null;
            string = r.getString(1);
            if (r == null) return string;
        }
        catch (Exception exception) {
            // empty catch block
            return null;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        try {
            r.getStatement().close();
        }
        catch (SQLException ex) {
            Logger.getLogger(DbUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            r.close();
            return string;
        }
        catch (SQLException ex) {
            Logger.getLogger(DbUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getList(Connection conn, String sql) throws Exception {
        ResultSet r = null;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            while (r.next()) {
                list.add(r.getObject(1));
            }
            ArrayList<Object> arrayList = list;
            return arrayList;
        }
        finally {
            if (r != null) {
                r.getStatement().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Object[]> getListKV(Connection conn, String sql) throws Exception {
        ResultSet r = null;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            while (r.next()) {
                list.add(new Object[]{r.getObject(1), r.getObject(2)});
            }
            ArrayList<Object[]> arrayList = list;
            return arrayList;
        }
        finally {
            if (r != null) {
                r.getStatement().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Map> getListMap(Connection conn, String sql) throws Exception {
        ResultSet r = null;
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            ResultSetMetaData m = r.getMetaData();
            while (r.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < m.getColumnCount(); ++i) {
                    map.put(m.getColumnName(i + 1), r.getObject(i + 1));
                }
                list.add(map);
            }
            ArrayList<Map> arrayList = list;
            return arrayList;
        }
        finally {
            if (r != null) {
                r.getStatement().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getListMapMap(Connection conn, String sql, String pk) throws Exception {
        ResultSet r = null;
        HashMap list = new HashMap();
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            ResultSetMetaData m = r.getMetaData();
            while (r.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < m.getColumnCount(); ++i) {
                    map.put(m.getColumnName(i + 1), r.getObject(i + 1));
                }
                list.put(r.getObject(pk), map);
            }
            HashMap hashMap = list;
            return hashMap;
        }
        finally {
            if (r != null) {
                r.getStatement().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getListMapKV(Connection conn, String sql) throws Exception {
        ResultSet r = null;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            ResultSetMetaData m = r.getMetaData();
            while (r.next()) {
                map.put(r.getObject(1), r.getObject(2));
            }
            HashMap<Object, Object> hashMap = map;
            return hashMap;
        }
        finally {
            if (r != null) {
                r.getStatement().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containRows(Connection conn, String sql) throws Exception {
        ResultSet r = null;
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            if (r.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (r != null) {
                r.getStatement().close();
            }
        }
    }

    public static boolean existColumn(ResultSet r, String column) throws SQLException {
        ResultSetMetaData m = r.getMetaData();
        for (int i = 1; i <= m.getColumnCount(); ++i) {
            if (!m.getColumnName(i).equalsIgnoreCase(column)) continue;
            return true;
        }
        return false;
    }

    public static Object[] getRow(ResultSet r) throws Exception {
        int cols = r.getMetaData().getColumnCount();
        Object[] row = new Object[cols];
        for (int c = 1; c <= cols; ++c) {
            row[c - 1] = r.getObject(c);
        }
        return row;
    }

    public static String prepareSqlFromMap(Map mkeyvalue) {
        String sql = "";
        Set set = mkeyvalue.keySet();
        Iterator iter = set.iterator();
        int max = set.size();
        int conta = 0;
        while (iter.hasNext()) {
            ++conta;
            String key = (String)iter.next();
            Object value = mkeyvalue.get(key);
            sql = sql + " " + key + " = ";
            if (value instanceof String) {
                sql = sql + "'" + DbUtils.aa((String)value) + "'";
            } else if (value instanceof Integer) {
                sql = sql + "(" + value + ")";
            } else if (value instanceof Float || value instanceof Double || value instanceof BigInteger || value instanceof Long || value instanceof BigDecimal) {
                sql = sql + "(" + value + ")";
            } else if (value instanceof Timestamp) {
                value = FormatUtils.formatMysqlTimestamp((Timestamp)((Timestamp)value));
                sql = sql + "'" + value + "'";
            } else if (value instanceof Date) {
                value = FormatUtils.formatMysqlDate((Object)((Date)value));
                sql = sql + "'" + value + "'";
            } else if (value instanceof java.util.Date) {
                value = FormatUtils.formatMysqlDate((Object)((java.util.Date)value));
                sql = sql + "'" + value + "'";
            } else if (value instanceof Boolean) {
                sql = sql + "'" + value + "'";
            } else if (value == null) {
                sql = sql + "null";
            } else {
                System.err.println("prepareSqlFromMap: " + value.getClass().toString() + " non riconosciuto");
                sql = sql + "'" + DbUtils.aa((String)value) + "'";
            }
            if (conta >= max) continue;
            sql = sql + ",";
        }
        return sql;
    }

    public static String prepareSqlFromMapJava(Map mkeyvalue) {
        String sql = "";
        Set set = mkeyvalue.keySet();
        Iterator iter = set.iterator();
        int max = set.size();
        int conta = 0;
        while (iter.hasNext()) {
            ++conta;
            String key = (String)iter.next();
            Object value = mkeyvalue.get(key);
            sql = sql + " " + key + " = ";
            if (value instanceof String) {
                sql = sql + "'" + DbUtils.aaJava((String)value) + "'";
            } else if (value instanceof Integer) {
                sql = sql + "(" + value + ")";
            } else if (value instanceof Float || value instanceof Double || value instanceof BigInteger || value instanceof Long || value instanceof BigDecimal) {
                sql = sql + "(" + value + ")";
            } else if (value instanceof Timestamp) {
                FormatUtils.formatMysqlTimestamp((Timestamp)((Timestamp)value));
                sql = sql + "'" + value + "'";
            } else if (value == null) {
                sql = sql + "null";
            } else {
                System.err.println("prepareSqlFromMap: " + value.getClass().toString() + " non riconosciuto");
                sql = sql + "'" + DbUtils.aaJava((String)value) + "'";
            }
            if (conta >= max) continue;
            sql = sql + ",";
        }
        return sql;
    }

    public static String aa(String str) {
        return StringUtils.replace((String)str, (String)"'", (String)"\\'");
    }

    public static String aaJava(String str) {
        String temp = StringUtils.replace((String)str, (String)"'", (String)"\\\\'");
        temp = StringUtils.replace((String)str, (String)"\n", (String)"\\n\" +\n\"");
        return temp;
    }
}

