/*
 * Decompiled with CFR 0.152.
 */
package simpleswingbrowser;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import netscape.javascript.JSObject;
import simpleswingbrowser.SimpleSwingBrowser2;

class Browser
extends Region {
    private HBox toolBar;
    private static final String[] imageFiles = new String[]{"product.png", "blog.png", "documentation.png", "partners.png", "help.png"};
    private static final String[] captions = new String[]{"Products", "Blogs", "Documentation", "Partners", "Help"};
    private static final String[] urls = new String[]{"http://www.oracle.com/products/index.html", "http://blogs.oracle.com/", "http://docs.oracle.com/javase/index.html", "http://www.oracle.com/partners/index.html", SimpleSwingBrowser2.class.getResource("/help.html").toExternalForm()};
    final ImageView selectedImage = new ImageView();
    final Hyperlink[] hpls = new Hyperlink[captions.length];
    final Image[] images = new Image[imageFiles.length];
    final WebView browser = new WebView();
    final WebEngine webEngine = this.browser.getEngine();
    final Button showPrevDoc = new Button("Toggle Previous Docs");
    final WebView smallView = new WebView();
    final ComboBox comboBox = new ComboBox();
    private boolean needDocumentationButton = false;

    public Browser() {
        this.getStyleClass().add((Object)"browser");
        for (int i = 0; i < captions.length; ++i) {
            Hyperlink hpl = this.hpls[i] = new Hyperlink(captions[i]);
            Image image = this.images[i] = new Image(((Object)((Object)this)).getClass().getResourceAsStream(imageFiles[i]));
            hpl.setGraphic((Node)new ImageView(image));
            final String url = urls[i];
            final boolean addButton = hpl.getText().equals("Documentation");
            hpl.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    Browser.this.needDocumentationButton = addButton;
                    Browser.this.webEngine.load(url);
                }
            });
        }
        this.comboBox.setPrefWidth(60.0);
        this.toolBar = new HBox();
        this.toolBar.setAlignment(Pos.CENTER);
        this.toolBar.getStyleClass().add((Object)"browser-toolbar");
        this.toolBar.getChildren().add((Object)this.comboBox);
        this.toolBar.getChildren().addAll((Object[])this.hpls);
        this.toolBar.getChildren().add((Object)this.createSpacer());
        this.showPrevDoc.setOnAction(new EventHandler(){

            public void handle(Event t) {
                Browser.this.webEngine.executeScript("toggleDisplay('PrevRel')");
            }
        });
        this.smallView.setPrefSize(120.0, 80.0);
        this.webEngine.setCreatePopupHandler((Callback)new Callback<PopupFeatures, WebEngine>(){

            public WebEngine call(PopupFeatures config) {
                Browser.this.smallView.setFontScale(0.8);
                if (!Browser.this.toolBar.getChildren().contains((Object)Browser.this.smallView)) {
                    Browser.this.toolBar.getChildren().add((Object)Browser.this.smallView);
                }
                return Browser.this.smallView.getEngine();
            }
        });
        final WebHistory history = this.webEngine.getHistory();
        history.getEntries().addListener((ListChangeListener)new ListChangeListener<WebHistory.Entry>(){

            public void onChanged(ListChangeListener.Change<? extends WebHistory.Entry> c) {
                c.next();
                for (WebHistory.Entry e : c.getRemoved()) {
                    Browser.this.comboBox.getItems().remove((Object)e.getUrl());
                }
                for (WebHistory.Entry e : c.getAddedSubList()) {
                    Browser.this.comboBox.getItems().add((Object)e.getUrl());
                }
            }
        });
        this.comboBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent ev) {
                int offset = Browser.this.comboBox.getSelectionModel().getSelectedIndex() - history.getCurrentIndex();
                history.go(offset);
            }
        });
        this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
                Browser.this.toolBar.getChildren().remove((Object)Browser.this.showPrevDoc);
                if (newState == Worker.State.SUCCEEDED) {
                    JSObject win = (JSObject)Browser.this.webEngine.executeScript("window");
                    win.setMember("app", new JavaApp());
                    if (Browser.this.needDocumentationButton) {
                        Browser.this.toolBar.getChildren().add((Object)Browser.this.showPrevDoc);
                    }
                }
            }
        });
        final ContextMenu cm = new ContextMenu();
        MenuItem cmItem1 = new MenuItem("Print");
        cm.getItems().add((Object)cmItem1);
        this.toolBar.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                if (e.getButton() == MouseButton.SECONDARY) {
                    cm.show((Node)Browser.this.toolBar, e.getScreenX(), e.getScreenY());
                }
            }
        });
        cmItem1.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                PrinterJob job = PrinterJob.createPrinterJob();
                if (job != null) {
                    Browser.this.webEngine.print(job);
                    job.endJob();
                }
            }
        });
        this.webEngine.load("http://www.oracle.com/products/index.html");
        this.getChildren().add((Object)this.toolBar);
        this.getChildren().add((Object)this.browser);
    }

    private Node createSpacer() {
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        return spacer;
    }

    protected void layoutChildren() {
        double w = this.getWidth();
        double h = this.getHeight();
        double tbHeight = this.toolBar.prefHeight(w);
        this.layoutInArea((Node)this.browser, 0.0, 0.0, w, h - tbHeight, 0.0, HPos.CENTER, VPos.CENTER);
        this.layoutInArea((Node)this.toolBar, 0.0, h - tbHeight, w, tbHeight, 0.0, HPos.CENTER, VPos.CENTER);
    }

    protected double computePrefWidth(double height) {
        return 900.0;
    }

    protected double computePrefHeight(double width) {
        return 600.0;
    }

    public class JavaApp {
        public void exit() {
            Platform.exit();
        }
    }
}

