/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Formatter;
import org.apache.commons.io.FileUtils;

public class TestXu {
    public static void main(String[] args) throws UnsupportedEncodingException, IOException {
        String orig;
        String text = "alfa \u00f2 \u00e0 \u00f9 \u00e8 \u00e9 \u20ac \u00f8 \u00d8 beta";
        System.out.println("text = " + text);
        String test = orig = "\u20ac";
        System.out.println("test = " + test);
        System.out.println(TestXu.prettyHexView(test.getBytes()));
        byte[] testb = TestXu.toLatin3(orig.getBytes());
        System.out.println(TestXu.prettyHexView(testb));
        System.out.println(new String(testb, "ISO-8859-15"));
        FileUtils.writeStringToFile((File)new File("c:\\temp\\testj.txt"), (String)new String(testb, "ISO-8859-15"), (String)"ISO-8859-15");
    }

    public static String prettyHexView(byte[] ba) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        for (int j = 1; j < ba.length + 1; ++j) {
            if (j % 8 == 1 || j == 0) {
                if (j != 0) {
                    try {
                        for (int n = j - 8; n < j; ++n) {
                            sb.append((char)ba[n - 1]);
                            if (n % 4 != 0) continue;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sb.append("\n");
                }
                formatter.format("0%d\t|\t", j / 8);
            }
            formatter.format("%02X", ba[j - 1]);
            if (j % 4 != 0) continue;
            sb.append(" ");
        }
        sb.append("\n");
        return sb.toString();
    }

    public static String toLatin(String str) {
        Charset utf8charset = Charset.forName("UTF-8");
        Charset iso88591charset = Charset.forName("ISO-8859-1");
        ByteBuffer inputBuffer = ByteBuffer.wrap(str.getBytes());
        CharBuffer data = utf8charset.decode(inputBuffer);
        ByteBuffer outputBuffer = iso88591charset.encode(data);
        byte[] outputData = outputBuffer.array();
        return new String(outputData);
    }

    public static String toLatin2(String utf16str) {
        ByteBuffer bb = Charset.forName("utf-16").encode(CharBuffer.wrap(utf16str));
        CharBuffer ascii = Charset.forName("US-ASCII").decode(bb);
        return ascii.toString();
    }

    public static byte[] toLatin3(byte[] utf8) throws UnsupportedEncodingException {
        byte[] latin1 = new String(utf8, "UTF-8").getBytes("ISO-8859-15");
        return latin1;
    }
}

