/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugininvoicex.allegati;

import gestioneFatture.JDialogImpostazioni;
import gestioneFatture.main;
import invoicexplugininvoicex.allegati.JPanelImpostazioniAllegati;
import it.tnx.commons.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingworker.SwingWorker;

public class JDialogNetscan
extends JDialog {
    JDialogImpostazioni padre;
    JPanelImpostazioniAllegati panelImpoAllegati;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JList lstIndirizzi;
    private JProgressBar progress;
    private JLabel status;

    public JDialogNetscan(Dialog parent, boolean modal, JPanelImpostazioniAllegati panel) {
        super(parent, modal);
        this.initComponents();
        this.padre = (JDialogImpostazioni)parent;
        this.panelImpoAllegati = panel;
        this.lstIndirizzi.setModel(new DefaultListModel());
        try {
            InetAddress localHost = Inet4Address.getLocalHost();
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(localHost);
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            ArrayList<InetAddress> myaddr = new ArrayList<InetAddress>();
            while (addresses.hasMoreElements()) {
                InetAddress addr = addresses.nextElement();
                myaddr.add(addr);
            }
            int i = 0;
            for (InetAddress addr : myaddr) {
                ++i;
                String myIpAddress = addr.getHostAddress();
                String string = myIpAddress.substring(0, myIpAddress.lastIndexOf("."));
            }
            this.checkHosts(myaddr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void checkHosts(final ArrayList<InetAddress> myaddr) {
        final JDialogNetscan dialogPadre = this;
        DefaultListModel listModel = (DefaultListModel)this.lstIndirizzi.getModel();
        listModel.clear();
        this.lstIndirizzi.setEnabled(false);
        SwingWorker work1 = new SwingWorker(){

            protected void done() {
                JDialogNetscan.this.status.setText("scansione completata");
                SwingUtils.mouse_def((Component)main.getPadreWindow());
                JDialogNetscan.this.lstIndirizzi.setEnabled(true);
            }

            protected Object doInBackground() throws Exception {
                JDialogNetscan.this.progress.setMaximum(myaddr.size() * 255);
                JDialogNetscan.this.progress.setValue(0);
                JDialogNetscan.this.progress.setIndeterminate(false);
                ArrayList<String> tutti = new ArrayList<String>();
                for (InetAddress addr : myaddr) {
                    String myIpAddress = addr.getHostAddress();
                    String subnetMask = myIpAddress.substring(0, myIpAddress.lastIndexOf("."));
                    for (int i = 1; i < 255; ++i) {
                        String host = subnetMask + "." + i;
                        tutti.add(host);
                    }
                }
                JDialogNetscan.this.status.setText("Inizio scansione");
                int timeout = 25;
                for (int i = 1; i < myaddr.size() * 255; ++i) {
                    this.publish(new Object[]{i});
                    String host = (String)tutti.get(i - 1);
                    try {
                        Socket s = new Socket();
                        s.connect(new InetSocketAddress(host, 445), timeout);
                        s.close();
                        String hostname = InetAddress.getByName(host).getHostName();
                        this.publish(new Object[]{hostname});
                        continue;
                    }
                    catch (Exception ex) {
                        System.out.println(host + " non raggiungibile");
                    }
                }
                return null;
            }

            protected void process(List chunks) {
                for (Object o2 : chunks) {
                    if (o2 instanceof Integer) {
                        JDialogNetscan.this.status.setText("Scansione in corso ...");
                        JDialogNetscan.this.progress.setValue((Integer)o2);
                        continue;
                    }
                    if (!(o2 instanceof String)) continue;
                    try {
                        DefaultListModel listModel = (DefaultListModel)JDialogNetscan.this.lstIndirizzi.getModel();
                        if (listModel.contains(o2)) continue;
                        listModel.addElement(o2);
                    }
                    catch (Exception e) {
                        SwingUtils.showExceptionMessage((Component)dialogPadre, (Exception)e);
                    }
                }
            }
        };
        work1.execute();
    }

    private void initComponents() {
        this.status = new JLabel();
        this.progress = new JProgressBar();
        this.jScrollPane1 = new JScrollPane();
        this.lstIndirizzi = new JList();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Seleziona server");
        this.status.setHorizontalAlignment(0);
        this.status.setText("Scansione in corso..");
        this.lstIndirizzi.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDialogNetscan.this.lstIndirizziMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstIndirizzi);
        this.jLabel1.setText("Server/Nas trovati");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 380, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 0, Short.MAX_VALUE)).add((Component)this.status, -1, -1, Short.MAX_VALUE).add((Component)this.progress, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.status).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.progress, -2, 19, -2).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 216, -2).addContainerGap()));
        this.pack();
    }

    private void lstIndirizziMouseClicked(MouseEvent evt) {
        String selected = this.lstIndirizzi.getSelectedValue().toString();
        this.panelImpoAllegati.texImpoSmbServer.setText(selected);
        this.dispose();
        this.setVisible(false);
    }
}

