/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugininvoicex.allegati;

import gestioneFatture.JDialogImpostazioni;
import gestioneFatture.main;
import invoicexplugininvoicex.Main;
import invoicexplugininvoicex.allegati.JPanelImpostazioniAllegati;
import invoicexplugininvoicex.allegati.SmbUtil;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.combo.SortedComboBoxModel;
import it.tnx.commons.cu;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jcifs.smb.SmbFile;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingworker.SwingWorker;

public class JDialogSelectNetDir
extends JDialog {
    JDialogImpostazioni padre;
    JPanelImpostazioniAllegati panelImpoAllegati;
    String server;
    String username;
    String password;
    String curDir = "";
    String path = "";
    String rootDir = "";
    private JButton btnAnnulla;
    private JButton btnSave;
    private JLabel jLabel1;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JLabel labCurDir;
    private JLabel labStatus;
    private JList lstCartelle;

    public JDialogSelectNetDir(Dialog parent, boolean modal, JPanelImpostazioniAllegati panel, String server, String username, String password, String curDir) {
        super(parent, modal);
        this.initComponents();
        this.padre = (JDialogImpostazioni)parent;
        this.panelImpoAllegati = panel;
        this.lstCartelle.setModel(new SortedComboBoxModel());
        this.server = server;
        this.password = password;
        this.username = username;
        this.curDir = curDir.equals("") ? "/" : curDir;
        this.path = "smb://" + this.server + this.curDir;
        this.rootDir = "smb://" + this.server + "/";
        this.labCurDir.setText(this.path);
        this.searchDirectory();
    }

    private void searchDirectory() {
        this.labStatus.setText("Elaborazione cartelle in corso..");
        this.lstCartelle.setEnabled(false);
        DefaultComboBoxModel listModel = (DefaultComboBoxModel)this.lstCartelle.getModel();
        listModel.removeAllElements();
        if (!this.path.equals(this.rootDir)) {
            listModel.addElement(".. (cartella superiore)");
        }
        final JDialogSelectNetDir dialog = this;
        SwingWorker work1 = new SwingWorker(){
            final JDialogSelectNetDir finestra;
            {
                this.finestra = dialog;
            }

            protected void done() {
                JDialogSelectNetDir.this.labStatus.setText("Fai doppio click su una condivisione per vedere il suo contenuto");
                SwingUtils.mouse_def((Component)main.getPadreWindow());
                JDialogSelectNetDir.this.lstCartelle.setEnabled(true);
            }

            protected Object doInBackground() throws Exception {
                try {
                    ArrayList<SmbFile> listFiles = SmbUtil.listSubdir(JDialogSelectNetDir.this.path, JDialogSelectNetDir.this.username, JDialogSelectNetDir.this.password);
                    this.publish(new Object[]{listFiles.size()});
                    for (SmbFile smbf : listFiles) {
                        this.publish(new Object[]{smbf.toString()});
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SwingUtils.showErrorMessage((Component)JDialogSelectNetDir.this.padre, (String)e.getMessage(), (String)"Impossibile procedere", (boolean)true);
                    JDialogSelectNetDir.this.changeDirectory("..");
                }
                return null;
            }

            protected void process(List chunks) {
                for (Object o2 : chunks) {
                    if (o2 instanceof Integer) {
                        JDialogSelectNetDir.this.labStatus.setText("Ricerca in corso: trovate " + cu.s(o2) + " condivisioni");
                        continue;
                    }
                    if (o2 instanceof String) {
                        try {
                            String directory = cu.s(o2);
                            String dirName = directory.replace(JDialogSelectNetDir.this.path, "");
                            if (dirName.endsWith("/")) {
                                dirName = dirName.substring(0, dirName.length() - 1);
                            }
                            DefaultComboBoxModel listModel = (DefaultComboBoxModel)JDialogSelectNetDir.this.lstCartelle.getModel();
                            listModel.addElement(dirName);
                        }
                        catch (Exception e) {
                            SwingUtils.showExceptionMessage((Component)JDialogSelectNetDir.this.padre, (Exception)e);
                            JDialogSelectNetDir.this.changeDirectory("..");
                        }
                        continue;
                    }
                    if (!(o2 instanceof Boolean)) continue;
                    this.finestra.dispose();
                    this.finestra.setVisible(false);
                }
            }
        };
        work1.execute();
    }

    private void initComponents() {
        this.labStatus = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstCartelle = new JList();
        this.jPanel9 = new JPanel();
        this.btnAnnulla = new JButton();
        this.btnSave = new JButton();
        this.jLabel1 = new JLabel();
        this.labCurDir = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Seleziona cartella");
        this.labStatus.setHorizontalAlignment(0);
        this.labStatus.setText("Ricerca condivisioni in corso..");
        this.lstCartelle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDialogSelectNetDir.this.lstCartelleMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstCartelle);
        this.btnAnnulla.setIcon(Main.mygetIcon("annulla"));
        this.btnAnnulla.setText("Annulla");
        this.btnAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogSelectNetDir.this.btnAnnullaActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.btnAnnulla);
        this.btnSave.setIcon(Main.mygetIcon("conferma"));
        this.btnSave.setText("Conferma percorso");
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogSelectNetDir.this.btnSaveActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.btnSave);
        this.jLabel1.setText("Percorso corrente:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.labStatus, -1, -1, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 423, Short.MAX_VALUE).add((Component)this.jPanel9, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.labCurDir, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.labStatus).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.labCurDir, -2, 14, -2)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 209, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel9, -2, -1, -2)));
        this.pack();
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        try {
            String nuovopath = this.path;
            if (this.lstCartelle.getSelectedValue() != null && !this.lstCartelle.getSelectedValue().toString().startsWith("..")) {
                nuovopath = nuovopath + (nuovopath.endsWith("/") ? "" : "/") + this.lstCartelle.getSelectedValue() + "/";
            }
            if (SmbUtil.isWritable(nuovopath, this.username, this.password)) {
                String messagge = "Vuoi usare la cartella " + nuovopath + " come destinazione per gli allegati?";
                boolean response = SwingUtils.showYesNoMessage((Component)this, (String)messagge, (String)"Selezione cartella");
                if (response) {
                    this.panelImpoAllegati.texImpoSmbDir.setText("/" + nuovopath.replace(this.rootDir, ""));
                    this.dispose();
                    this.setVisible(false);
                }
            } else {
                SwingUtils.showErrorMessage((Component)this.padre, (String)("Impossibie usare la cartella:\n" + nuovopath + "\nLa cartella non \u00e8 scrivibile."), (String)"Errore impostazione cartella");
            }
        }
        catch (Exception e) {
            SwingUtils.showExceptionMessage((Component)this.padre, (Exception)e);
        }
    }

    private void btnAnnullaActionPerformed(ActionEvent evt) {
        this.dispose();
        this.setVisible(false);
    }

    private void lstCartelleMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            String selected = cu.s(this.lstCartelle.getSelectedValue());
            this.changeDirectory(selected);
        }
    }

    private void changeDirectory(String selected) {
        this.path = selected.startsWith("..") ? this.path.substring(0, this.path.substring(0, this.path.length() - 1).lastIndexOf("/") + 1) : this.path + selected + "/";
        this.labCurDir.setText(this.path);
        this.searchDirectory();
    }
}

