/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugininvoicex.allegati;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import com.rapid7.client.dcerpc.mssrvs.ServerService;
import com.rapid7.client.dcerpc.transport.RPCTransport;
import com.rapid7.client.dcerpc.transport.SMBTransportFactories;
import gestioneFatture.iniFileProp;
import it.tnx.Db;
import it.tnx.commons.DbUtils;
import it.tnx.commons.cu;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;

public class SmbUtilSmbj {
    private static NtlmPasswordAuthentication authenticate(String username, String password) throws Exception {
        NtlmPasswordAuthentication auth = null;
        auth = username.equals("") && password.equals("") ? NtlmPasswordAuthentication.ANONYMOUS : new NtlmPasswordAuthentication(";" + username + ":" + password);
        return auth;
    }

    public static boolean isWritable(String path, String username, String password) {
        try {
            String fileName = "test-" + RandomStringUtils.randomAlphanumeric((int)10) + ".txt";
            String fileCont = "--TEST TEST TEST TEST--";
            String filePath = path + fileName;
            SmbFile f2 = new SmbFile(filePath, SmbUtilSmbj.authenticate(username, password));
            SmbFileOutputStream out = new SmbFileOutputStream(f2);
            out.write(fileCont.getBytes());
            out.close();
            ArrayList<SmbFile> listaFiles = SmbUtilSmbj.listFiles(path, username, password);
            for (SmbFile file : listaFiles) {
                if (!file.getName().equals(fileName)) continue;
                SmbFileInputStream in = new SmbFileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                in.read(data);
                in.close();
                String smbFileCont = new String(data, "UTF-8");
                SmbUtilSmbj.deleteFile(fileName, path, username, password);
                return smbFileCont.equals(fileCont);
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static SmbFile uploadFile(java.io.File f, String path, String username, String password) {
        try {
            String fileName = f.getName();
            String filePath = path + fileName;
            SmbFile smbFile = new SmbFile(filePath, SmbUtilSmbj.authenticate(username, password));
            if (smbFile.exists()) {
                int n = 0;
                while (smbFile.exists()) {
                    String extension = StringUtils.substringAfterLast((String)fileName, (String)".");
                    String name = StringUtils.substringBeforeLast((String)fileName, (String)".");
                    filePath = path + name + "-" + ++n + (extension.length() > 0 ? "." : "") + extension;
                    smbFile = new SmbFile(filePath, SmbUtilSmbj.authenticate(username, password));
                }
            }
            SmbFileOutputStream out = new SmbFileOutputStream(smbFile);
            FileInputStream in = new FileInputStream(f);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
            if (smbFile.exists()) {
                return smbFile;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void deleteFile(String filename, String path, String username, String password) throws Exception {
        path = path + filename;
        SmbFile fileToDel = new SmbFile(path, SmbUtilSmbj.authenticate(username, password));
        fileToDel.delete();
    }

    public static ArrayList<SmbFile> listSubdir(String path, String username, String password) throws Exception {
        ArrayList<SmbFile> retList = new ArrayList<SmbFile>();
        SmbFile rootDir = new SmbFile(path, SmbUtilSmbj.authenticate(username, password));
        if (rootDir.exists()) {
            SmbFile[] listaCompleta;
            for (SmbFile smbf : listaCompleta = rootDir.listFiles()) {
                if (!smbf.isDirectory()) continue;
                retList.add(smbf);
            }
        }
        return retList;
    }

    public static ArrayList<SmbFile> listFiles(String path, String username, String password) throws Exception {
        ArrayList<SmbFile> retList = new ArrayList<SmbFile>();
        SmbFile rootDir = new SmbFile(path, SmbUtilSmbj.authenticate(username, password));
        if (rootDir.exists()) {
            SmbFile[] listaCompleta;
            for (SmbFile smbf : listaCompleta = rootDir.listFiles()) {
                if (!smbf.isFile()) continue;
                retList.add(smbf);
            }
        }
        return retList;
    }

    public static void anteprimaFile(String fileName, String tmpfile, String path, String username, String password) throws Exception {
        SmbUtilSmbj.downloadFile(fileName, tmpfile, path, username, password);
    }

    public static void downloadFile(String fileName, String tmpfile, String path, String username, String password) throws Exception {
        SMBClient client = new SMBClient();
        try {
            Connection connection = client.connect("MCECCARELLI");
            AuthenticationContext ac = new AuthenticationContext("m.ceccarelli@tnx.it", "senna!!!94".toCharArray(), "");
            Session session = connection.authenticate(ac);
            RPCTransport transport = SMBTransportFactories.SRVSVC.getTransport(session);
            ServerService serverService = new ServerService(transport);
            List shares = serverService.getShares0();
            for (Object share : shares) {
                System.out.println(share);
            }
            DiskShare share = (DiskShare)session.connectShare("scambio");
            for (FileIdBothDirectoryInformation f : share.list("", "*.*")) {
                System.out.println("File : " + f.getFileName());
            }
            File f = share.openFile("testsmbj.txt", EnumSet.of(AccessMask.GENERIC_WRITE), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OVERWRITE_IF, null);
            OutputStream out = f.getOutputStream();
            IOUtils.copy((InputStream)new FileInputStream("c:\\setup.log"), (OutputStream)out);
            out.close();
            f.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void downloadFile(String fileName, OutputStream out, String path, String username, String password) throws Exception {
        String filePath = path + fileName;
        System.out.println("filePath = " + filePath);
        SmbFile smbFile = new SmbFile(filePath, SmbUtilSmbj.authenticate(username, password));
        System.out.println("smbFile = " + smbFile);
        if (!smbFile.exists()) {
            throw new Exception("file " + smbFile.toString() + " inesistente");
        }
        SmbFileInputStream smbIn = new SmbFileInputStream(smbFile);
        IOUtils.copy((InputStream)smbIn, (OutputStream)out);
        smbIn.close();
        out.close();
        System.out.println("smbIn close");
    }

    public static String getDefaultValue(String chiave) throws Exception {
        String field = "";
        field = chiave.equals("tipo_salvataggio") ? "tipo_salvataggio_allegati" : (chiave.equals("server") ? "allegati_smb_server" : (chiave.equals("cartella") ? "allegati_smb_cartella" : (chiave.equals("username") ? "allegati_smb_username" : (chiave.equals("password") ? "allegati_smb_password" : chiave))));
        String ret = cu.toString((Object)DbUtils.getObject((java.sql.Connection)Db.getConn(), (String)("SELECT " + field + " FROM dati_azienda WHERE id = 1")));
        if (chiave.equals("password") || chiave.equals("allegati_smb_password")) {
            return iniFileProp.decrypt((String)ret);
        }
        return ret;
    }

    private static String getDefaultPath() throws Exception {
        return "smb://" + SmbUtilSmbj.getDefaultValue("server") + SmbUtilSmbj.getDefaultValue("cartella");
    }

    public static NtlmPasswordAuthentication authenticate() throws Exception {
        return SmbUtilSmbj.authenticate(SmbUtilSmbj.getDefaultValue("username"), SmbUtilSmbj.getDefaultValue("password"));
    }

    public static boolean isWritable(String path) throws Exception {
        return SmbUtilSmbj.isWritable(path, SmbUtilSmbj.getDefaultValue("username"), SmbUtilSmbj.getDefaultValue("password"));
    }

    public static ArrayList<SmbFile> listSubdir(String path) throws Exception {
        return SmbUtilSmbj.listSubdir(path, SmbUtilSmbj.getDefaultValue("username"), SmbUtilSmbj.getDefaultValue("password"));
    }

    public static ArrayList<SmbFile> listFiles(String path) throws Exception {
        return SmbUtilSmbj.listFiles(path, SmbUtilSmbj.getDefaultValue("username"), SmbUtilSmbj.getDefaultValue("password"));
    }

    public static SmbFile uploadFile(java.io.File f) throws Exception {
        return SmbUtilSmbj.uploadFile(f, SmbUtilSmbj.getDefaultPath(), SmbUtilSmbj.getDefaultValue("username"), SmbUtilSmbj.getDefaultValue("password"));
    }

    public static void deleteFile(String filename) throws Exception {
        SmbUtilSmbj.deleteFile(filename, SmbUtilSmbj.getDefaultPath(), SmbUtilSmbj.getDefaultValue("username"), SmbUtilSmbj.getDefaultValue("password"));
    }

    public static void downloadFile(String fileName, OutputStream out) throws Exception {
        SmbUtilSmbj.downloadFile(fileName, out, SmbUtilSmbj.getDefaultPath(), SmbUtilSmbj.getDefaultValue("username"), SmbUtilSmbj.getDefaultValue("password"));
    }

    public static void anteprimaFile(String fileName, String tmpfile) throws Exception {
        SmbUtilSmbj.anteprimaFile(fileName, tmpfile, SmbUtilSmbj.getDefaultPath(), SmbUtilSmbj.getDefaultValue("username"), SmbUtilSmbj.getDefaultValue("password"));
    }
}

