/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugininvoicex.impexp;

import gestioneFatture.Db;
import gestioneFatture.JDialogWait;
import gestioneFatture.logic.documenti.Documento;
import gestioneFatture.logic.provvigioni.ProvvigioniFattura;
import gestioneFatture.main;
import invoicexplugininvoicex.Main;
import invoicexplugininvoicex.impexp.ImportExportUtils;
import it.tnx.Util;
import it.tnx.commons.DateUtils;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.InvoicexUtil;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingworker.SwingWorker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JInternalFrameImportEasyFattXml
extends JInternalFrame {
    static final String TIPO_DOCUMENTO_ORDINE_VENDITA = "C";
    static final String TIPO_DOCUMENTO_DDT_VENDITA = "D";
    static final String TIPO_DOCUMENTO_ORDINE_ACQUISTO = "E";
    static final String TIPO_DOCUMENTO_FATTURA_ACCOMPAGNATORIA = "F";
    static final String TIPO_DOCUMENTO_FATTURA_VENDITA = "I";
    static final String TIPO_DOCUMENTO_FATTURA_ACCONTO = "J";
    static final String TIPO_DOCUMENTO_FATTURA_PROFORMA = "L";
    static final String TIPO_DOCUMENTO_AUTOFATTURA = "M";
    static final String TIPO_DOCUMENTO_NOTA_DI_CREDITO = "N";
    static final String TIPO_DOCUMENTO_NOTA_DI_DEBITO = "O";
    static final String TIPO_DOCUMENTO_PREVENTIVO_VENDITA = "Q";
    static final String TIPO_DOCUMENTO_RICEVUTA_FISCALE = "R";
    static final String TIPO_DOCUMENTO_PREVENTIVO_ACQUISTO = "S";
    static final String TIPO_DOCUMENTO_DDT_ACQUISTO = "H";
    HashMap<String, String> TIPI_DOCUMENTO_TABELLE = new HashMap();
    HashMap<Integer, String> RISPOSTE_IMPORT = new HashMap();
    public ImportExportUtils utils;
    public JButton btnChooseImportFile;
    public JButton btnImporta;
    public ButtonGroup buttonGroup1;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel4;
    public JScrollPane jScrollPane1;
    public JRadioButton radNumerazioneFile;
    public JRadioButton radSeguiNumerazioneInvoicex;
    public JTextField texImportFilename;
    public JTextArea texLogImport;
    public JTextField texSerieImport;

    public JInternalFrameImportEasyFattXml() throws Exception {
        this.initComponents();
        this.TIPI_DOCUMENTO_TABELLE.put(TIPO_DOCUMENTO_ORDINE_VENDITA, "test_ordi");
        this.TIPI_DOCUMENTO_TABELLE.put(TIPO_DOCUMENTO_DDT_VENDITA, "test_ddt");
        this.TIPI_DOCUMENTO_TABELLE.put(TIPO_DOCUMENTO_ORDINE_ACQUISTO, "test_ordi_acquisto");
        this.TIPI_DOCUMENTO_TABELLE.put(TIPO_DOCUMENTO_FATTURA_ACCOMPAGNATORIA, "test_fatt");
        this.TIPI_DOCUMENTO_TABELLE.put(TIPO_DOCUMENTO_FATTURA_VENDITA, "test_fatt");
        this.TIPI_DOCUMENTO_TABELLE.put(TIPO_DOCUMENTO_FATTURA_ACCONTO, "test_fatt");
        this.TIPI_DOCUMENTO_TABELLE.put(TIPO_DOCUMENTO_FATTURA_PROFORMA, "test_fatt");
        this.TIPI_DOCUMENTO_TABELLE.put(TIPO_DOCUMENTO_AUTOFATTURA, "test_fatt");
        this.TIPI_DOCUMENTO_TABELLE.put(TIPO_DOCUMENTO_NOTA_DI_CREDITO, "test_fatt");
        this.TIPI_DOCUMENTO_TABELLE.put(TIPO_DOCUMENTO_NOTA_DI_DEBITO, "test_fatt_acquisto");
        this.TIPI_DOCUMENTO_TABELLE.put(TIPO_DOCUMENTO_PREVENTIVO_VENDITA, "test_ordi");
        this.TIPI_DOCUMENTO_TABELLE.put(TIPO_DOCUMENTO_RICEVUTA_FISCALE, "test_fatt");
        this.TIPI_DOCUMENTO_TABELLE.put(TIPO_DOCUMENTO_PREVENTIVO_ACQUISTO, "test_ordi_acquisto");
        this.TIPI_DOCUMENTO_TABELLE.put(TIPO_DOCUMENTO_DDT_ACQUISTO, "test_ddt_acquisto");
        this.changeTipoSerie();
        this.utils = new ImportExportUtils();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel4 = new JLabel();
        this.texSerieImport = new JTextField();
        this.radNumerazioneFile = new JRadioButton();
        this.radSeguiNumerazioneInvoicex = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.texImportFilename = new JTextField();
        this.btnChooseImportFile = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.texLogImport = new JTextArea();
        this.btnImporta = new JButton();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Import EasyFatt Xml");
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Serie");
        this.buttonGroup1.add(this.radNumerazioneFile);
        this.radNumerazioneFile.setSelected(true);
        this.radNumerazioneFile.setText("Usa numerazione file");
        this.radNumerazioneFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JInternalFrameImportEasyFattXml.this.radNumerazioneFileItemStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.radSeguiNumerazioneInvoicex);
        this.radSeguiNumerazioneInvoicex.setText("Segui numerazione Invoicex");
        this.radSeguiNumerazioneInvoicex.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JInternalFrameImportEasyFattXml.this.radSeguiNumerazioneInvoicexItemStateChanged(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Scegli file");
        this.btnChooseImportFile.setIcon(Main.mygetIcon("cartella"));
        this.btnChooseImportFile.setMargin(new Insets(2, 2, 2, 2));
        this.btnChooseImportFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JInternalFrameImportEasyFattXml.this.btnChooseImportFileActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Log importazione");
        this.texLogImport.setColumns(20);
        this.texLogImport.setRows(5);
        this.texLogImport.setEnabled(false);
        this.jScrollPane1.setViewportView(this.texLogImport);
        this.btnImporta.setIcon(Main.mygetIcon("conferma"));
        this.btnImporta.setText("Importa");
        this.btnImporta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JInternalFrameImportEasyFattXml.this.btnImportaActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.btnImporta)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.texImportFilename).add(0, 0, 0).add((Component)this.btnChooseImportFile)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.texSerieImport, -2, 25, -2).add(18, 18, 18).add((Component)this.radNumerazioneFile).addPreferredGap(0).add((Component)this.radSeguiNumerazioneInvoicex))).add(0, 227, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(new Component[]{this.jLabel1, this.jLabel4}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(16, 16, 16).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.texSerieImport, -2, -1, -2).add((Component)this.radNumerazioneFile).add((Component)this.radSeguiNumerazioneInvoicex)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.texImportFilename, -2, -1, -2)).add((Component)this.btnChooseImportFile)).addPreferredGap(1).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 272, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnImporta).addContainerGap()));
        layout.linkSize(new Component[]{this.btnChooseImportFile, this.texImportFilename}, 2);
        this.pack();
    }

    private void radNumerazioneFileItemStateChanged(ItemEvent evt) {
        this.changeTipoSerie();
    }

    private void radSeguiNumerazioneInvoicexItemStateChanged(ItemEvent evt) {
        this.changeTipoSerie();
    }

    private void btnChooseImportFileActionPerformed(ActionEvent evt) {
        FileDialog dlgChoose = new FileDialog((Frame)main.getPadreFrame());
        dlgChoose.setMode(0);
        dlgChoose.setFile("*.xml;*.DefXml");
        String path = main.prefs.get("impostazioni_path_chooser", null);
        if (path != null) {
            dlgChoose.setDirectory(path);
        }
        dlgChoose.setTitle("Seleziona il file da importare");
        dlgChoose.setVisible(true);
        String retfile = dlgChoose.getFile();
        if (retfile != null && this.checkFileImport(retfile)) {
            main.prefs.put("impostazioni_path_chooser", dlgChoose.getDirectory());
            String file = dlgChoose.getDirectory() + retfile;
            this.texImportFilename.setText(file);
        }
    }

    private void btnImportaActionPerformed(ActionEvent evt) {
        this.texLogImport.setText("");
        String fileName = this.texImportFilename.getText();
        if (this.checkFileImport(fileName)) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                File file = new File(fileName);
                Document doc = builder.parse(file);
                doc.getDocumentElement().normalize();
                this.parseImportXml(doc);
            }
            catch (Exception ex) {
                SwingUtils.showExceptionMessage((Component)main.getPadre(), (Exception)ex);
            }
        }
    }

    private void changeTipoSerie() {
        this.texSerieImport.setEnabled(this.radSeguiNumerazioneInvoicex.isSelected() && Db.nz((String)main.fileIni.getValue("varie", "campoSerie"), (String)"").equalsIgnoreCase(TIPO_DOCUMENTO_PREVENTIVO_ACQUISTO));
        this.texSerieImport.setEditable(this.radSeguiNumerazioneInvoicex.isSelected() && Db.nz((String)main.fileIni.getValue("varie", "campoSerie"), (String)"").equalsIgnoreCase(TIPO_DOCUMENTO_PREVENTIVO_ACQUISTO));
    }

    public void parseImportXml(final Document xml) {
        SwingUtils.mouse_wait((Component)main.getPadreFrame());
        final JInternalFrameImportEasyFattXml frm_lancio = this;
        final boolean numerazione_esterna = this.radNumerazioneFile.isSelected();
        SwingWorker w = new SwingWorker(){
            JDialogWait wait = new JDialogWait((Frame)main.getPadreFrame(), false);

            protected void done() {
                SwingUtils.mouse_def((Component)main.getPadreWindow());
                try {
                    if (cu.toBoolean((Object)this.get())) {
                        frm_lancio.texLogImport.append("Importazione terminata");
                        SwingUtils.showInfoMessage((Component)frm_lancio, (String)"Importazione terminata");
                    } else {
                        SwingUtils.showInfoMessage((Component)frm_lancio, (String)"Problemi durante l'importazione");
                    }
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(JInternalFrameImportEasyFattXml.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(JInternalFrameImportEasyFattXml.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.wait.setVisible(false);
            }

            protected void process(List chunks) {
                for (Object chunk : chunks) {
                    if (chunk instanceof int[]) {
                        int[] vals = (int[])chunk;
                        this.wait.progress.setMaximum(vals[1]);
                        this.wait.progress.setValue(vals[0]);
                        if (this.wait.progress.isIndeterminate()) {
                            this.wait.progress.setIndeterminate(false);
                        }
                        this.wait.labStato.setText("Importazione " + vals[0] + " di " + vals[1]);
                        continue;
                    }
                    frm_lancio.texLogImport.append((String)chunk + "\n");
                }
            }

            protected Object doInBackground() {
                this.wait.setLocationRelativeTo(null);
                this.wait.setVisible(true);
                try {
                    int nodeNumber;
                    this.publish(new Object[]{"Avvio import xml Danea EasyFatt"});
                    JInternalFrameImportEasyFattXml.this.RISPOSTE_IMPORT.clear();
                    xml.getDocumentElement().normalize();
                    NodeList Documents = xml.getElementsByTagName("Document");
                    int[] stato_publish = new int[]{1, Documents.getLength()};
                    String serieDocumento = JInternalFrameImportEasyFattXml.this.texSerieImport.getText();
                    if (numerazione_esterna) {
                        for (nodeNumber = 0; nodeNumber < Documents.getLength(); ++nodeNumber) {
                            if (!this.checkTipoDocumento((Element)Documents.item(nodeNumber))) {
                                this.publish(new Object[]{"Import terminato: impossibile importare questo tipo di documento"});
                                return null;
                            }
                            if (this.checkExternalDocumentNumber((Element)Documents.item(nodeNumber))) continue;
                            this.publish(new Object[]{"Alcuni dei numeri presenti nel file sono gi\u00e0 utilizzati da altri documenti, non \u00e8 possibile continuare con l'import"});
                            return null;
                        }
                    }
                    for (nodeNumber = 0; nodeNumber < Documents.getLength(); ++nodeNumber) {
                        this.publish(new Object[]{stato_publish});
                        String import_state = this.importDocumentNode((Element)Documents.item(nodeNumber), serieDocumento, numerazione_esterna);
                        this.publish(new Object[]{import_state});
                        stato_publish[0] = stato_publish[0] + 1;
                    }
                }
                catch (Exception e) {
                    this.publish(new Object[]{"Errore: " + e.getMessage()});
                    SwingUtils.showExceptionMessage((Component)frm_lancio, (Exception)e);
                    return null;
                }
                return true;
            }

            public boolean checkExternalDocumentNumber(Element document) throws Exception {
                String tipo_documento_xml = JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DocumentType");
                String table_testata = JInternalFrameImportEasyFattXml.this.TIPI_DOCUMENTO_TABELLE.get(tipo_documento_xml);
                String serie_xml = JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Numbering").replace("/", "");
                Integer numero_xml = cu.i((Object)JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Number"));
                Date data_xml = cu.toDate((Object)JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Date"));
                String serie = serie_xml;
                if (serie_xml.length() > 1) {
                    serie_xml = serie_xml.substring(0, 1);
                }
                Integer numero = numero_xml;
                Integer anno = DateUtils.getYear((Date)data_xml);
                String sql = "SELECT id FROM " + table_testata + " WHERE serie = " + Db.pc((Object)serie, (int)1) + " AND numero = " + Db.pc((Object)numero, (int)4) + " AND anno = " + Db.pc((Object)anno, (int)4);
                Integer id = cu.i((Object)dbu.getObject((Connection)Db.getConn(), (String)sql, (boolean)false));
                return id == null;
            }

            public boolean checkTipoDocumento(Element document) throws Exception {
                String table = JInternalFrameImportEasyFattXml.this.TIPI_DOCUMENTO_TABELLE.get(JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DocumentType"));
                return table != null;
            }

            public String importDocumentNode(Element document) throws Exception {
                return this.importDocumentNode(document, "", true);
            }

            public String importDocumentNode(Element document, boolean numerazioneOriginale) throws Exception {
                return this.importDocumentNode(document, "", numerazioneOriginale);
            }

            public String importDocumentNode(Element document, String serieImport) throws Exception {
                return this.importDocumentNode(document, serieImport, true);
            }

            public String importDocumentNode(Element document, String serieImport, boolean numerazioneOriginale) throws Exception {
                HashMap<String, String> Customer = new HashMap<String, String>();
                String tipo_documento_xml = JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DocumentType");
                Integer numero_xml = cu.i((Object)JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Number"));
                String serie_xml = JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Numbering").replace("/", "");
                if (serie_xml.length() > 1) {
                    serie_xml = serie_xml.substring(0, 1);
                }
                Date data_xml = cu.toDate((Object)JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Date"));
                String tipo_documento = "";
                String tipo_cliente = JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_ORDINE_VENDITA;
                Integer tipo_fattura = null;
                boolean documento_vendita = true;
                if (tipo_documento_xml.equals(JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_ORDINE_VENDITA)) {
                    tipo_documento = Db.TIPO_DOCUMENTO_ORDINE;
                } else if (tipo_documento_xml.equals(JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_DDT_VENDITA)) {
                    tipo_documento = Db.TIPO_DOCUMENTO_DDT;
                } else if (tipo_documento_xml.equals(JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
                    tipo_documento = Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO;
                    documento_vendita = false;
                    tipo_cliente = JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_FATTURA_ACCOMPAGNATORIA;
                } else if (tipo_documento_xml.equals(JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_FATTURA_ACCOMPAGNATORIA)) {
                    tipo_documento = Db.TIPO_FATTURA_ACCOMPAGNATORIA;
                    tipo_fattura = 2;
                } else if (tipo_documento_xml.equals(JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_FATTURA_VENDITA)) {
                    tipo_documento = Db.TIPO_DOCUMENTO_FATTURA;
                    tipo_fattura = 1;
                } else if (tipo_documento_xml.equals(JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_FATTURA_ACCONTO)) {
                    tipo_documento = Db.TIPO_DOCUMENTO_FATTURA;
                    tipo_fattura = 1;
                } else if (tipo_documento_xml.equals(JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_FATTURA_PROFORMA)) {
                    tipo_documento = Db.TIPO_FATTURA_PROFORMA;
                    tipo_fattura = 6;
                } else if (tipo_documento_xml.equals(JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_AUTOFATTURA)) {
                    tipo_documento = Db.TIPO_DOCUMENTO_FATTURA;
                    tipo_fattura = 1;
                } else if (tipo_documento_xml.equals(JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_NOTA_DI_CREDITO)) {
                    tipo_documento = Db.TIPO_FATTURA_NOTA_DI_CREDITO;
                    tipo_fattura = 3;
                } else if (tipo_documento_xml.equals(JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_NOTA_DI_DEBITO)) {
                    tipo_documento = Db.TIPO_FATTURA_NOTA_DI_CREDITO;
                    tipo_fattura = 9;
                    documento_vendita = false;
                    tipo_cliente = JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_FATTURA_ACCOMPAGNATORIA;
                } else if (tipo_documento_xml.equals(JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_PREVENTIVO_VENDITA)) {
                    tipo_documento = Db.TIPO_DOCUMENTO_PREVENTIVO;
                } else if (tipo_documento_xml.equals(JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_PREVENTIVO_ACQUISTO)) {
                    tipo_documento = Db.TIPO_DOCUMENTO_PREVENTIVO;
                    documento_vendita = false;
                    tipo_cliente = JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_FATTURA_ACCOMPAGNATORIA;
                } else if (tipo_documento_xml.equals(JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_DDT_ACQUISTO)) {
                    tipo_documento = Db.TIPO_DOCUMENTO_DDT_ACQUISTO;
                    documento_vendita = false;
                    tipo_cliente = JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_FATTURA_ACCOMPAGNATORIA;
                } else {
                    return "Impossibile importare il documento " + numero_xml + " (" + data_xml + "): tipo di documento non importabile";
                }
                String table_testata = JInternalFrameImportEasyFattXml.this.TIPI_DOCUMENTO_TABELLE.get(tipo_documento_xml);
                String table_righe = table_testata.replace("test_", "righ_");
                Customer.put("Code", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomerCode"));
                Customer.put("Type", tipo_cliente);
                Customer.put("Name", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomerName"));
                Customer.put("Address", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomerAddress"));
                Customer.put("Postcode", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomerPostcode"));
                Customer.put("City", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomerCity"));
                Customer.put("Province", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomerProvince"));
                Customer.put("Country", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomerCountry"));
                Customer.put("VatCode", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomerVatCode"));
                Customer.put("Tel", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomerTel"));
                Customer.put("Email", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomerEmail"));
                Customer.put("Cellphone", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomerCellPhone"));
                HashMap clifor = new HashMap();
                clifor.put("tipo", Customer.get("Type"));
                clifor.put("ragione_sociale", Customer.get("Name"));
                clifor.put("indirizzo", Customer.get("Address"));
                clifor.put("cap", Customer.get("Postcode"));
                clifor.put("localita", Customer.get("City"));
                clifor.put("provincia", Customer.get("Province"));
                clifor.put("paese", Customer.get("Country"));
                clifor.put("piva_cfiscale", Customer.get("VatCode"));
                clifor.put("telefono", Customer.get("Tel"));
                clifor.put("email", Customer.get("Email"));
                clifor.put("cellulare", Customer.get("Cellphone"));
                Integer codCliente = cu.i((Object)dbu.getObject((Connection)Db.getConn(), (String)("select codice from clie_forn WHERE piva_cfiscale = " + dbu.sql(Customer.get("VatCode"))), (boolean)false));
                String sql = null;
                if (codCliente == null) {
                    codCliente = cu.i0((Object)dbu.getObject((Connection)Db.getConn(), (String)"SELECT IFNULL(MAX(codice), 0) + 1 FROM clie_forn"));
                    clifor.put("codice", codCliente);
                    sql = "insert into clie_forn set " + dbu.prepareSqlFromMap(clifor);
                } else {
                    sql = "update clie_forn set " + dbu.prepareSqlFromMap(clifor) + " where codice = " + dbu.sql((Object)codCliente);
                }
                dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
                String nome_agente = JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "SalesAgent");
                Integer codAgente = 0;
                if (!nome_agente.equals("")) {
                    HashMap Agente = new HashMap();
                    codAgente = cu.i0((Object)dbu.getObject((Connection)Db.getConn(), (String)("SELECT id FROM agenti WHERE nome = " + Db.pc((Object)nome_agente, (int)12)), (boolean)false));
                    if (codAgente == 0) {
                        codAgente = cu.i0((Object)dbu.getObject((Connection)Db.getConn(), (String)"SELECT IFNULL(MAX(id), 0) + 1 FROM agenti"));
                        String sqlAgente = "INSERT INTO agenti SET id = " + Db.pc((Object)codAgente, (int)4) + ", nome = " + Db.pc((Object)nome_agente, (int)12);
                        dbu.tryExecQuery((Connection)Db.getConn(), (String)sqlAgente);
                    }
                }
                HashMap<String, Object> fields = new HashMap<String, Object>();
                String serie = "";
                Integer numero = 0;
                Integer anno = 0;
                String numero_esterno = "";
                anno = DateUtils.getYear((Date)data_xml);
                if (numerazioneOriginale) {
                    serie = serie_xml;
                    numero = numero_xml;
                } else {
                    serie = JInternalFrameImportEasyFattXml.this.getSerie(serieImport, tipo_documento_xml);
                    numero = JInternalFrameImportEasyFattXml.this.getNumero(serie, tipo_documento_xml, anno);
                    numero_esterno = JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Number") + JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Numbering") + "/" + DateUtils.getYear((Date)data_xml);
                }
                String metodo = JInternalFrameImportEasyFattXml.this.utils.getCodicePagamento(JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "PaymentName"), ImportExportUtils.TIPO_OPERAZIONE_IMPORT);
                if (!JInternalFrameImportEasyFattXml.this.checkNumber(serie, numero, anno, tipo_documento_xml)) {
                    return JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Number") + JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Numbering") + "/" + DateUtils.getYear((Date)data_xml) + " => Impossibile importare documento: numero di documento gi\u00e0 presente";
                }
                if (metodo.equals("")) {
                    return JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Number") + JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Numbering") + "/" + DateUtils.getYear((Date)data_xml) + " => Impossibile importare documento: metodo di pagamento non associabile";
                }
                boolean iva_inclusa = cu.toBoolean((Object)JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "PricesIncludeVat"));
                String campo_cliente_fornitore = documento_vendita ? "cliente" : "fornitore";
                fields.put("serie", serie);
                fields.put("numero", numero);
                fields.put("anno", anno);
                fields.put("numero_esterno", numero_esterno);
                fields.put("data", FormatUtils.formatMysqlDate((Object)data_xml));
                fields.put(campo_cliente_fornitore, codCliente);
                fields.put("pagamento", metodo);
                fields.put("sconto1", 0.0);
                fields.put("sconto2", 0.0);
                fields.put("sconto3", 0.0);
                fields.put("spese_trasporto", 0.0);
                fields.put("spese_incasso", 0.0);
                fields.put("prezzi_ivati", iva_inclusa ? JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_PREVENTIVO_ACQUISTO : JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_NOTA_DI_CREDITO);
                fields.put("agente_codice", 0);
                fields.put("agente_percentuale", 0.0);
                fields.put("modalita_consegna", 0);
                fields.put("modalita_scarico", 0);
                fields.put("deposito", cu.i((Object)main.fileIni.getValue("depositi", "predefinito", "0")));
                fields.put("acconto", 0);
                if (codAgente != 0) {
                    fields.put("agente_codice", codAgente);
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DeliveryName").equals("")) {
                    fields.put("dest_ragione_sociale", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DeliveryName"));
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DeliveryAddress").equals("")) {
                    fields.put("dest_indirizzo", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DeliveryAddress"));
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DeliveryPostcode").equals("")) {
                    fields.put("dest_cap", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DeliveryPostcode"));
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DeliveryCity").equals("")) {
                    fields.put("dest_localita", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DeliveryCity"));
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DeliveryProvince").equals("")) {
                    fields.put("dest_provincia", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DeliveryProvince"));
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DeliveryCountry").equals("")) {
                    fields.put("dest_paese", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "DeliveryCountry"));
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "InternalComment").equals("")) {
                    fields.put("note", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "InternalComment"));
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "TransportReason").equals("")) {
                    fields.put("causale_trasporto", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "TransportReason"));
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "GoodsAppearance").equals("")) {
                    fields.put("aspetto_esteriore_beni", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "GoodsAppearance"));
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Carrier").equals("")) {
                    fields.put("mezzo_consegna", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Carrier"));
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "ShipmentTerms").equals("")) {
                    fields.put("porto", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "ShipmentTerms"));
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "NumOfPieces").equals("")) {
                    fields.put("numero_colli", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "NumOfPieces"));
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "TransportedWeight").equals("")) {
                    fields.put("peso_lordo", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "TransportedWeight"));
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "TransportDateTime").equals("")) {
                    fields.put("dataoraddt", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "TransportDateTime"));
                }
                String nota = "";
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomField1").equals("")) {
                    nota = nota + JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomField1") + "\n";
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomField2").equals("")) {
                    nota = nota + JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomField2") + "\n";
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomField3").equals("")) {
                    nota = nota + JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomField3") + "\n";
                }
                if (!JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomField4").equals("")) {
                    nota = nota + JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CustomField4") + "\n";
                }
                fields.put("note", nota);
                fields.put("note_pagamento", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "PaymentBank"));
                if (tipo_fattura != null) {
                    fields.put("tipo_fattura", tipo_fattura);
                }
                if (tipo_documento.equals(Db.TIPO_DOCUMENTO_PREVENTIVO)) {
                    fields.put("stato_ordine", "Preventivo");
                } else if (tipo_documento.equals(Db.TIPO_DOCUMENTO_ORDINE) || tipo_documento.equals(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
                    fields.put("stato_ordine", "Ordine");
                }
                String sql_testata = "INSERT INTO " + table_testata + " SET " + dbu.prepareSqlFromMap(fields);
                dbu.tryExecQuery((Connection)Db.getConn(), (String)sql_testata);
                String sql_recupero_id = "SELECT id FROM " + table_testata + " WHERE serie = " + Db.pc((Object)serie, (int)1) + " AND numero = " + Db.pc((Object)numero, (int)1) + " AND anno = " + Db.pc((Object)anno, (int)1);
                Integer id = cu.i((Object)dbu.getObject((Connection)Db.getConn(), (String)sql_recupero_id));
                Integer row_num = 1;
                NodeList Rows = document.getElementsByTagName("Row");
                for (int rowNumber = 0; rowNumber < Rows.getLength(); ++rowNumber) {
                    Element row = (Element)Rows.item(rowNumber);
                    HashMap row_fields = new HashMap();
                    String discount = JInternalFrameImportEasyFattXml.this.readStringFromElement(row, "Discounts").replace("%", "").replace("+", ",");
                    String[] discounts = discount.split(",", -1);
                    double[] sconti = new double[]{0.0, 0.0};
                    double prezzo_netto_riga = cu.d0a((Object)JInternalFrameImportEasyFattXml.this.readStringFromElement(row, "Price"));
                    if (discounts.length > 2) {
                        double prezzo_scontato_riga;
                        double sconto;
                        sconti[0] = sconto = cu.d0a((Object)discounts[0]).doubleValue();
                        double prezzo_pre_sconto = prezzo_scontato_riga = prezzo_netto_riga * (100.0 - sconto) / 100.0;
                        for (int numSconto = 1; numSconto < discounts.length; ++numSconto) {
                            sconto = cu.d0a((Object)discounts[numSconto]);
                            prezzo_scontato_riga = prezzo_scontato_riga * (100.0 - sconto) / 100.0;
                        }
                        sconti[1] = (prezzo_pre_sconto - prezzo_scontato_riga) * 100.0 / prezzo_pre_sconto;
                    } else if (discounts.length == 2) {
                        sconti[0] = cu.d0a((Object)discounts[0]);
                        sconti[1] = cu.d0a((Object)discounts[1]);
                    } else if (discounts.length == 1) {
                        sconti[0] = cu.d0a((Object)discounts[0]);
                    }
                    String codice_iva = JInternalFrameImportEasyFattXml.this.utils.getCodiceIVADaCodEsterno(JInternalFrameImportEasyFattXml.this.readStringFromElement(row, "VatCode"), ImportExportUtils.TIPO_OPERAZIONE_IMPORT);
                    if (iva_inclusa) {
                        double percIva = cu.d0a((Object)dbu.getObject((Connection)Db.getConn(), (String)("SELECT percentuale FROM codici_iva WHERE codice = " + Db.pc((Object)codice_iva, (int)12))));
                        prezzo_netto_riga = prezzo_netto_riga * 100.0 / (100.0 + percIva);
                    }
                    double quantita = Math.abs(cu.d0a((Object)JInternalFrameImportEasyFattXml.this.readStringFromElement(row, "Qty")));
                    row_fields.put("serie", serie);
                    row_fields.put("numero", numero);
                    row_fields.put("anno", anno);
                    row_fields.put("riga", row_num);
                    row_fields.put("codice_articolo", JInternalFrameImportEasyFattXml.this.readStringFromElement(row, "Code"));
                    row_fields.put("descrizione", JInternalFrameImportEasyFattXml.this.readStringFromElement(row, "Description"));
                    row_fields.put("um", JInternalFrameImportEasyFattXml.this.readStringFromElement(row, "Um"));
                    row_fields.put("quantita", quantita);
                    row_fields.put("prezzo", prezzo_netto_riga);
                    row_fields.put("sconto1", sconti[0]);
                    row_fields.put("sconto2", sconti[1]);
                    row_fields.put("stato", "P");
                    row_fields.put("id_padre", id);
                    row_fields.put("provvigione", 0.0);
                    row_fields.put("arrotondamento_parametro", 0);
                    row_fields.put("arrotondamento_tipo", "Inf.");
                    row_fields.put("iva", codice_iva);
                    double provvigione = cu.d0a((Object)JInternalFrameImportEasyFattXml.this.readStringFromElement(row, "CommissionPerc"));
                    if (codAgente != 0 && provvigione > 0.0) {
                        dbu.tryExecQuery((Connection)Db.getConn(), (String)("UPDATE agenti SET percentuale = " + Db.pc((double)provvigione, (int)3) + " WHERE id = " + Db.pc((Object)codAgente, (int)4)));
                        dbu.tryExecQuery((Connection)Db.getConn(), (String)("UPDATE test_fatt SET agente_percentuale = " + Db.pc((double)provvigione, (int)3) + " WHERE id = " + Db.pc((Object)id, (int)4)));
                        row_fields.put("provvigione", cu.d0a((Object)JInternalFrameImportEasyFattXml.this.readStringFromElement(row, "CommissionPerc")));
                    }
                    row_fields = JInternalFrameImportEasyFattXml.this.aggiornatTotaliRiga(row_fields, iva_inclusa);
                    String sql_righe = "INSERT INTO " + table_righe + " SET " + dbu.prepareSqlFromMap((Map)row_fields);
                    dbu.tryExecQuery((Connection)Db.getConn(), (String)sql_righe);
                    Integer n = row_num;
                    Integer n2 = row_num = Integer.valueOf(row_num + 1);
                }
                Double costAmount = cu.d0a((Object)JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CostAmount"));
                if (costAmount > 0.0) {
                    HashMap row_fields = new HashMap();
                    row_fields.put("serie", serie);
                    row_fields.put("numero", numero);
                    row_fields.put("anno", anno);
                    row_fields.put("riga", row_num);
                    row_fields.put("codice_articolo", "");
                    row_fields.put("descrizione", JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CostDescription"));
                    row_fields.put("um", "");
                    row_fields.put("quantita", 1);
                    row_fields.put("prezzo", costAmount);
                    row_fields.put("sconto1", 0.0);
                    row_fields.put("sconto2", 0.0);
                    row_fields.put("stato", "P");
                    row_fields.put("id_padre", id);
                    row_fields.put("provvigione", 0.0);
                    row_fields.put("iva", JInternalFrameImportEasyFattXml.this.utils.getCodiceIVA(JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "CostVatCode"), ImportExportUtils.TIPO_OPERAZIONE_IMPORT));
                    row_fields = JInternalFrameImportEasyFattXml.this.aggiornatTotaliRiga(row_fields, iva_inclusa);
                    String sql_righe = "INSERT INTO " + table_righe + " SET " + dbu.prepareSqlFromMap((Map)row_fields);
                    dbu.tryExecQuery((Connection)Db.getConn(), (String)sql_righe);
                }
                if (table_testata.equals("test_fatt")) {
                    NodeList Payments = document.getElementsByTagName("Payment");
                    for (int paymentNumber = 0; paymentNumber < Payments.getLength(); ++paymentNumber) {
                        Element payment = (Element)Payments.item(paymentNumber);
                        HashMap<String, Object> payment_fields = new HashMap<String, Object>();
                        boolean pagata = cu.toBoolean((Object)JInternalFrameImportEasyFattXml.this.readStringFromElement(payment, "Paid"));
                        boolean acconto = cu.toBoolean((Object)JInternalFrameImportEasyFattXml.this.readStringFromElement(payment, "Advance"));
                        String data = cu.s((Object)JInternalFrameImportEasyFattXml.this.readStringFromElement(payment, "Date"));
                        double amount = cu.d0a((Object)JInternalFrameImportEasyFattXml.this.readStringFromElement(payment, "Amount"));
                        payment_fields.put("numero", paymentNumber);
                        payment_fields.put("documento_tipo", tipo_documento);
                        payment_fields.put("id_doc", id);
                        payment_fields.put("data_scadenza", data);
                        payment_fields.put("importo", amount);
                        if (pagata) {
                            payment_fields.put("pagata", JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_NOTA_DI_CREDITO);
                            payment_fields.put("importo_pagato", amount);
                            payment_fields.put("importo_da_pagare", 0);
                        } else {
                            payment_fields.put("pagata", JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_PREVENTIVO_ACQUISTO);
                            payment_fields.put("importo_pagato", 0);
                            payment_fields.put("importo_da_pagare", amount);
                        }
                        if (acconto) {
                            payment_fields.put("flag_acconto", JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_PREVENTIVO_ACQUISTO);
                            dbu.tryExecQuery((Connection)Db.getConn(), (String)("UPDATE " + table_testata + " SET acconto = " + Db.pc((double)amount, (int)8) + " WHERE id = " + Db.pc((Object)id, (int)4)));
                        } else {
                            payment_fields.put("flag_acconto", JInternalFrameImportEasyFattXml.TIPO_DOCUMENTO_NOTA_DI_CREDITO);
                        }
                        String sql_payment = "INSERT INTO scadenze SET " + dbu.prepareSqlFromMap(payment_fields);
                        dbu.tryExecQuery((Connection)Db.getConn(), (String)sql_payment);
                        if (!pagata) continue;
                        Integer id_payment = cu.i((Object)dbu.getObject((Connection)Db.getConn(), (String)"SELECT LAST_INSERT_ID()"));
                        HashMap<String, Object> partial_payment_fields = new HashMap<String, Object>();
                        partial_payment_fields.put("id_scadenza", id_payment);
                        partial_payment_fields.put("data", data);
                        partial_payment_fields.put("importo", amount);
                        partial_payment_fields.put("tipo_pagamento", metodo);
                        String sql_partial_payment = "INSERT INTO scadenze_parziali SET " + dbu.prepareSqlFromMap(partial_payment_fields);
                        dbu.tryExecQuery((Connection)Db.getConn(), (String)sql_partial_payment);
                    }
                }
                Documento doc = new Documento();
                String tipo_documento_calcolo = tipo_documento;
                if (tipo_documento.equals(Db.TIPO_FATTURA_NOTA_DI_CREDITO)) {
                    tipo_documento_calcolo = Db.TIPO_DOCUMENTO_FATTURA;
                }
                doc.load(Db.INSTANCE, numero.intValue(), serie, anno.intValue(), tipo_documento_calcolo, id);
                doc.calcolaTotali();
                fields.clear();
                fields.put("totale_imponibile_pre_sconto", doc.totaleImponibilePreSconto);
                fields.put("totale_ivato_pre_sconto", doc.totaleIvatoPreSconto);
                if (table_testata.equalsIgnoreCase("test_fatt")) {
                    fields.put("totale_da_pagare", doc.getTotale_da_pagare());
                }
                fields.put("totale_da_pagare_finale", doc.getTotale_da_pagare_finale());
                fields.put("totale_imponibile", doc.getTotaleImponibile());
                fields.put("totale_iva", doc.getTotaleIva());
                fields.put("totale", doc.getTotale());
                String sql_update_totali = "UPDATE " + table_testata + " SET " + dbu.prepareSqlFromMap(fields) + " WHERE id = " + Db.pc((Object)id, (int)4);
                dbu.tryExecQuery((Connection)Db.getConn(), (String)sql_update_totali);
                InvoicexUtil.aggiornaPrezziNettiUnitari((String)table_righe, (String)table_testata, (Integer)id);
                if (codAgente != 0 && tipo_fattura != null) {
                    ProvvigioniFattura provvigioni = new ProvvigioniFattura(id);
                    boolean bl = provvigioni.generaProvvigioni();
                }
                return JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Number") + JInternalFrameImportEasyFattXml.this.readStringFromElement(document, "Numbering") + "/" + DateUtils.getYear((Date)data_xml) + " => Documento importato correttamente (nuovo numero: " + serie + numero + "/" + anno + " del " + DateUtils.formatDateIta((Date)data_xml) + ")";
            }
        };
        w.execute();
    }

    private HashMap<String, Object> aggiornatTotaliRiga(HashMap<String, Object> row_fields, boolean prezzi_ivati) throws Exception {
        String sql_perc_iva = "select percentuale from codici_iva where codice = " + Db.pc((Object)row_fields.get("iva"), (int)12);
        double perc_iva = cu.d0((Object)dbu.getObject((Connection)Db.getConn(), (String)sql_perc_iva));
        double qta = cu.toDouble0((Object)row_fields.get("quantita"));
        double prezzo = cu.toDouble0((Object)row_fields.get("prezzo"));
        double sconto1 = cu.toDouble0((Object)row_fields.get("sconto1"));
        double sconto2 = cu.toDouble0((Object)row_fields.get("sconto2"));
        double totale = prezzo - prezzo / 100.0 * sconto1;
        totale -= totale / 100.0 * sconto2;
        totale = Util.round((double)(totale * qta), (int)2);
        if (!prezzi_ivati) {
            row_fields.put("totale_imponibile", totale);
            row_fields.put("totale_ivato", FormatUtils.round((double)(totale / 100.0 * perc_iva), (int)2));
        } else {
            row_fields.put("totale_imponibile", FormatUtils.round((double)(totale / perc_iva * 100.0), (int)2));
            row_fields.put("totale_ivato", totale);
        }
        return row_fields;
    }

    private String readStringFromElement(Element element, String element_name) {
        NodeList Elements = element.getElementsByTagName(element_name);
        if (Elements.getLength() >= 1) {
            return element.getElementsByTagName(element_name).item(0).getTextContent();
        }
        return "";
    }

    private String getSerie(String serieImport, String tipo_doc) {
        if (tipo_doc.equals(TIPO_DOCUMENTO_FATTURA_PROFORMA)) {
            return "*";
        }
        if ((tipo_doc.equals(TIPO_DOCUMENTO_NOTA_DI_CREDITO) || tipo_doc.equals(TIPO_DOCUMENTO_NOTA_DI_DEBITO)) && main.fileIni.getValueBoolean("pref", "numerazioneNoteCredito", Boolean.valueOf(true)).booleanValue()) {
            return "#";
        }
        return serieImport;
    }

    private Integer getNumero(String serie, String tipo_documento, Integer anno) throws Exception {
        String table = this.TIPI_DOCUMENTO_TABELLE.get(tipo_documento);
        Integer numero = cu.i((Object)(dbu.getObject((Connection)Db.getConn(), (String)("SELECT IFNULL(MAX(numero), 0) + 1 as next FROM " + table + " WHERE serie = " + Db.pc((Object)serie, (int)1))) + " and anno = " + dbu.sql((Object)anno)));
        return numero;
    }

    private boolean checkNumber(String serie, Integer numero, Integer anno, String tipo_documento) {
        try {
            String table = this.TIPI_DOCUMENTO_TABELLE.get(tipo_documento);
            String sql = "SELECT IFNULL(id, 0) FROM " + table + " WHERE serie = " + Db.pc((Object)serie, (int)1) + " AND numero = " + Db.pc((Object)numero, (int)1) + " AND anno = " + Db.pc((Object)anno, (int)1);
            cu.i0((Object)dbu.getObject((Connection)Db.getConn(), (String)sql));
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean checkFileImport(String nomeFile) {
        if (!nomeFile.equals("")) {
            String retfile2 = nomeFile.toLowerCase();
            if (!retfile2.endsWith(".xml") && !retfile2.endsWith(".defxml")) {
                SwingUtils.showErrorMessage((Component)this, (String)("Il file '" + retfile2 + "' non \u00e8 in un formato leggibile"), (String)"Impossibile importare");
                return false;
            }
        } else {
            SwingUtils.showErrorMessage((Component)this, (String)"Seleziona un file da importare prima di procedere", (String)"Impossibile importare");
            return false;
        }
        return true;
    }
}

