/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugininvoicex.impexp.export;

import gestioneFatture.main;
import invoicexplugininvoicex.impexp.ImportExportUtils;
import invoicexplugininvoicex.impexp.export.ExportBase;
import it.tnx.Db;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import java.awt.Component;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextArea;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jdesktop.swingworker.SwingWorker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EasyFattXml
extends ExportBase {
    public EasyFattXml(Component frm_lancio, JTextArea testo, Map param, SwingWorker w) throws Exception {
        super(frm_lancio, testo, param, w);
    }

    public boolean esporta() throws Exception {
        try {
            if (this.fatture_vendita) {
                this.esportaXml("fatture_vendita.DefXml", "test_fatt", "righ_fatt");
            }
            if (this.ddt_vendita) {
                this.esportaXml("ddt_vendita.DefXml", "test_ddt", "righ_ddt");
            }
            if (this.ddt_acquisto) {
                this.esportaXml("ddt_acquisto.DefXml", "test_ddt_acquisto", "righ_ddt_acquisto");
            }
            if (this.ordini_vendita) {
                this.esportaXml("ordini_vendita.DefXml", "test_ordi", "righ_ordi");
            }
            if (this.ordini_acquisto) {
                this.esportaXml("ordini_acquisto.DefXml", "test_ordi_acquisto", "righ_ordi_acquisto");
            }
        }
        catch (Exception e) {
            SwingUtils.showExceptionMessage((Component)this.frm_lancio, (Exception)e);
            return false;
        }
        return true;
    }

    private void esportaXml(String file, String tabt, String tabr) throws Exception {
        ResultSet documenti;
        String campo_cli_forn = "cliente";
        if (tabt.endsWith("_acquisto")) {
            campo_cli_forn = "fornitore";
        }
        String test_docu = "SELECT * FROM " + tabt + " WHERE 1 = 1";
        if (this.dal != null) {
            test_docu = test_docu + " AND data >= " + dbu.sql((Object)this.dal);
        }
        if (this.al != null) {
            test_docu = test_docu + " AND data <= " + dbu.sql((Object)this.al);
        }
        String campoClifor = "cliente";
        if (tabt.endsWith("_acquisto")) {
            campoClifor = "fornitore";
        }
        if (this.clifor != null) {
            test_docu = test_docu + " AND " + campoClifor + " = " + dbu.sql((Object)this.clifor);
        }
        if ((documenti = dbu.tryOpenResultSet((Connection)Db.getConn(), (String)test_docu)).next()) {
            documenti.beforeFirst();
            boolean canExport = true;
            this.w.publish(new Object[]{"Avvio export xml Danea EasyFatt"});
            HashMap<String, String> erroriMetodiPagamento = new HashMap<String, String>();
            HashMap<String, String> erroriCodiciIva = new HashMap<String, String>();
            while (documenti.next()) {
                ResultSet righe;
                String metodo = this.utils.getCodicePagamento(documenti.getString("pagamento"), ImportExportUtils.TIPO_OPERAZIONE_EXPORT);
                if (metodo.equals("")) {
                    if (erroriMetodiPagamento.get(documenti.getString("pagamento")) == null) {
                        erroriMetodiPagamento.put(documenti.getString("pagamento"), "Collegamento dati mancante: il tipo di pagamento " + documenti.getString("pagamento") + " non ha associato un codice esterno");
                    }
                    if (this.param.get("modo_codici_esterni").equals("Continua usando il codice interno")) {
                        metodo = documenti.getString("pagamento");
                    } else {
                        canExport = false;
                    }
                }
                if (!(righe = dbu.tryOpenResultSet((Connection)Db.getConn(), (String)("SELECT * FROM " + tabr + " WHERE id_padre = " + Db.pc((int)documenti.getInt("id"), (int)4)))).next()) continue;
                String codice_iva = this.utils.getCodiceIVA(righe.getString("iva"), ImportExportUtils.TIPO_OPERAZIONE_EXPORT);
                if (!codice_iva.equals("")) continue;
                if (erroriCodiciIva.get(righe.getString("iva")) == null) {
                    erroriCodiciIva.put(righe.getString("iva"), "Collegamento dati mancante: il codice IVA " + righe.getString("iva") + " non ha associato un codice esterno");
                }
                if (this.param.get("modo_codici_esterni").equals("Continua usando il codice interno")) {
                    codice_iva = righe.getString("iva");
                    continue;
                }
                canExport = false;
            }
            if (!canExport) {
                for (Map.Entry pair : erroriMetodiPagamento.entrySet()) {
                    this.w.publish(new Object[]{pair.getValue()});
                }
                for (Map.Entry pair : erroriCodiciIva.entrySet()) {
                    this.w.publish(new Object[]{pair.getValue()});
                }
                throw new Exception("Problema in export xml");
            }
            documenti.beforeFirst();
            int total_documents = 0;
            while (documenti.next()) {
                ++total_documents;
            }
            int[] stato_publish = new int[]{0, total_documents};
            documenti.beforeFirst();
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element EasyfattDocuments = document.createElement("EasyfattDocuments");
            EasyfattDocuments.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            EasyfattDocuments.setAttribute("AppVersion", "2");
            EasyfattDocuments.setAttribute("Creator", "Danea Soft");
            EasyfattDocuments.setAttribute("CreatorUrl", "http://www.danea.it/software/easyfatt");
            EasyfattDocuments.setAttribute("xsi:noNamespaceSchemaLocation", "https://www.danea.it/public/easyfatt-xml.xsd");
            String sql_dati_azienda = "SELECT ragione_sociale, indirizzo, cap, localita, provincia, cfiscale, piva, telefono, fax, email, sito_web FROM dati_azienda LIMIT 1";
            Map dati_azienda = (Map)dbu.getListMap((Connection)Db.getConn(), (String)sql_dati_azienda).get(0);
            Element Company = document.createElement("Company");
            if (!cu.s(dati_azienda.get("ragione_sociale")).equals("")) {
                Company.appendChild(this.createNode(document, "Name", cu.s(dati_azienda.get("ragione_sociale"))));
            }
            if (!cu.s(dati_azienda.get("indirizzo")).equals("")) {
                Company.appendChild(this.createNode(document, "Address", cu.s(dati_azienda.get("indirizzo"))));
            }
            if (!cu.s(dati_azienda.get("cap")).equals("")) {
                Company.appendChild(this.createNode(document, "Postcode", cu.s(dati_azienda.get("cap"))));
            }
            if (!cu.s(dati_azienda.get("localita")).equals("")) {
                Company.appendChild(this.createNode(document, "City", cu.s(dati_azienda.get("localita"))));
            }
            if (!cu.s(dati_azienda.get("provincia")).equals("")) {
                Company.appendChild(this.createNode(document, "Province", cu.s(dati_azienda.get("provincia"))));
            }
            Company.appendChild(this.createNode(document, "Country", "Italia"));
            if (!cu.s(dati_azienda.get("cfiscale")).equals("")) {
                Company.appendChild(this.createNode(document, "FiscalCode", cu.s(dati_azienda.get("cfiscale"))));
            }
            if (!cu.s(dati_azienda.get("piva")).equals("")) {
                Company.appendChild(this.createNode(document, "VatCode", cu.s(dati_azienda.get("piva"))));
            }
            if (!cu.s(dati_azienda.get("telefono")).equals("")) {
                Company.appendChild(this.createNode(document, "Tel", cu.s(dati_azienda.get("telefono"))));
            }
            if (!cu.s(dati_azienda.get("fax")).equals("")) {
                Company.appendChild(this.createNode(document, "Fax", cu.s(dati_azienda.get("fax"))));
            }
            if (!cu.s(dati_azienda.get("email")).equals("")) {
                Company.appendChild(this.createNode(document, "Email", cu.s(dati_azienda.get("email"))));
            }
            if (!cu.s(dati_azienda.get("sito_web")).equals("")) {
                Company.appendChild(this.createNode(document, "HomePage", cu.s(dati_azienda.get("sito_web"))));
            }
            EasyfattDocuments.appendChild(Company);
            Element Documents = document.createElement("Documents");
            while (documenti.next()) {
                Integer id_documento;
                boolean prezzi_ivati;
                Element Document2;
                String refDocumento;
                block78: {
                    this.w.publish(new Object[]{stato_publish});
                    String serie = documenti.getString("serie");
                    Integer numero = documenti.getInt("numero");
                    Integer anno = documenti.getInt("anno");
                    refDocumento = serie + numero + "/" + anno;
                    Document2 = document.createElement("Document");
                    String codice_cliente = documenti.getString(campo_cli_forn);
                    String sql_cliente = "SELECT * FROM clie_forn WHERE codice = " + Db.pc((Object)codice_cliente, (int)12);
                    Map cliente = (Map)dbu.getListMap((Connection)Db.getConn(), (String)sql_cliente).get(0);
                    Document2.appendChild(this.createNode(document, "CustomerCode", codice_cliente));
                    Document2.appendChild(this.createNode(document, "CustomerWebLogin", ""));
                    Document2.appendChild(this.createNode(document, "CustomerName", cu.s(cliente.get("ragione_sociale"))));
                    Document2.appendChild(this.createNode(document, "CustomerAddress", cu.s(cliente.get("indirizzo"))));
                    Document2.appendChild(this.createNode(document, "CustomerPostcode", cu.s(cliente.get("cap"))));
                    Document2.appendChild(this.createNode(document, "CustomerCity", cu.s(cliente.get("localita"))));
                    Document2.appendChild(this.createNode(document, "CustomerProvince", cu.s(cliente.get("provincia"))));
                    Document2.appendChild(this.createNode(document, "CustomerCountry", cu.s(cliente.get("paese"))));
                    Document2.appendChild(this.createNode(document, "CustomerFiscalCode", cu.s(cliente.get("cfiscale"))));
                    Document2.appendChild(this.createNode(document, "CustomerVatCode", cu.s(cliente.get("piva_cfiscale"))));
                    Document2.appendChild(this.createNode(document, "CustomerReference", cu.s(cliente.get("persona_riferimento"))));
                    Document2.appendChild(this.createNode(document, "CustomerTel", cu.s(cliente.get("telefono"))));
                    Document2.appendChild(this.createNode(document, "CustomerCellPhone", cu.s(cliente.get("cellulare"))));
                    Document2.appendChild(this.createNode(document, "CustomerEmail", cu.s(cliente.get("email"))));
                    Document2.appendChild(this.createNode(document, "DeliveryName", documenti.getString("dest_ragione_sociale")));
                    Document2.appendChild(this.createNode(document, "DeliveryAddress", documenti.getString("dest_indirizzo")));
                    Document2.appendChild(this.createNode(document, "DeliveryPostcode", documenti.getString("dest_cap")));
                    Document2.appendChild(this.createNode(document, "DeliveryCity", documenti.getString("dest_localita")));
                    Document2.appendChild(this.createNode(document, "DeliveryProvince", documenti.getString("dest_provincia")));
                    Document2.appendChild(this.createNode(document, "DeliveryCountry", documenti.getString("dest_paese")));
                    String tipo_doc_xml = "";
                    String tipo_doc_invoicex = Db.TIPO_DOCUMENTO_FATTURA;
                    if (tabt.startsWith("test_fatt")) {
                        Integer tipo_fattura = cu.i0((Object)documenti.getInt("tipo_fattura"));
                        if (tipo_fattura.equals(1)) {
                            tipo_doc_xml = "I";
                        }
                        if (tipo_fattura.equals(3)) {
                            tipo_doc_xml = "N";
                        }
                        if (tipo_fattura.equals(2)) {
                            tipo_doc_xml = "F";
                        }
                        if (tipo_fattura.equals(6)) {
                            tipo_doc_xml = "L";
                        }
                    } else if (tabt.equalsIgnoreCase("test_ordi")) {
                        tipo_doc_xml = "C";
                        tipo_doc_invoicex = Db.TIPO_DOCUMENTO_ORDINE;
                    } else if (tabt.equalsIgnoreCase("test_ordi_acquisto")) {
                        tipo_doc_xml = "E";
                        tipo_doc_invoicex = Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO;
                    } else if (tabt.equalsIgnoreCase("test_ddt")) {
                        tipo_doc_xml = "D";
                        tipo_doc_invoicex = Db.TIPO_DOCUMENTO_DDT;
                    } else if (tabt.equalsIgnoreCase("test_ddt_acquisto")) {
                        tipo_doc_xml = "H";
                        tipo_doc_invoicex = Db.TIPO_DOCUMENTO_DDT_ACQUISTO;
                    }
                    if (tipo_doc_xml.equals("C") || tipo_doc_xml.equals("E")) {
                        String stato_doc = documenti.getString("stato_ordine");
                        if (tipo_doc_xml.equals("C") && stato_doc.contains("Preventivo")) {
                            Document2.appendChild(this.createNode(document, "DocumentType", "Q"));
                        } else if (tipo_doc_xml.equals("E") && stato_doc.contains("Preventivo")) {
                            Document2.appendChild(this.createNode(document, "DocumentType", "S"));
                        } else {
                            Document2.appendChild(this.createNode(document, "DocumentType", tipo_doc_xml));
                        }
                    } else {
                        Document2.appendChild(this.createNode(document, "DocumentType", tipo_doc_xml));
                    }
                    Document2.appendChild(this.createNode(document, "Date", documenti.getString("data")));
                    Document2.appendChild(this.createNode(document, "Number", documenti.getString("numero")));
                    if (serie.equals("")) {
                        Document2.appendChild(this.createNode(document, "Numbering", ""));
                    } else {
                        Document2.appendChild(this.createNode(document, "Numbering", "/" + serie));
                    }
                    Document2.appendChild(this.createNode(document, "CostDescription", ""));
                    Document2.appendChild(this.createNode(document, "CostVatCode", ""));
                    Document2.appendChild(this.createNode(document, "CostAmount", ""));
                    Document2.appendChild(this.createNode(document, "ContribDescription", ""));
                    Document2.appendChild(this.createNode(document, "ContribPerc", ""));
                    Document2.appendChild(this.createNode(document, "ContribSubjectToWithholdingTax", ""));
                    Document2.appendChild(this.createNode(document, "ContribAmount", ""));
                    Document2.appendChild(this.createNode(document, "ContribVatCode", ""));
                    double totale_imponibile = documenti.getDouble("totale_imponibile");
                    Document2.appendChild(this.createNode(document, "TotalWithoutTax", FormatUtils.formatEngNum02Dec((double)totale_imponibile).replace(",", "")));
                    double totale_iva = documenti.getDouble("totale_iva");
                    Document2.appendChild(this.createNode(document, "VatAmount", FormatUtils.formatEngNum02Dec((double)totale_iva).replace(",", "")));
                    Document2.appendChild(this.createNode(document, "WithholdingTaxAmount", "0"));
                    Document2.appendChild(this.createNode(document, "WithholdingTaxAmountB", "0"));
                    Document2.appendChild(this.createNode(document, "WithholdingTaxNameB", ""));
                    double totale_documento = documenti.getDouble("totale");
                    Document2.appendChild(this.createNode(document, "Total", FormatUtils.formatEngNum02Dec((double)totale_documento).replace(",", "")));
                    Document2.appendChild(this.createNode(document, "PriceList", ""));
                    prezzi_ivati = cu.s((Object)documenti.getString("prezzi_ivati")).equals("S");
                    Document2.appendChild(this.createNode(document, "PricesIncludeVat", prezzi_ivati ? "true" : "false"));
                    Document2.appendChild(this.createNode(document, "WithholdingTaxPerc", "0"));
                    Document2.appendChild(this.createNode(document, "WithholdingTaxPerc2", "0"));
                    String metodo = this.utils.getCodicePagamento(documenti.getString("pagamento"), ImportExportUtils.TIPO_OPERAZIONE_EXPORT);
                    if (metodo.equals("") && this.param.get("modo_codici_esterni").equals("Continua usando il codice interno")) {
                        metodo = documenti.getString("pagamento");
                    }
                    if (metodo.equals("")) {
                        this.w.publish(new Object[]{"Impossibile esportare documento " + refDocumento + ": non ho trovato il metodo di pagamento collegato"});
                        continue;
                    }
                    Document2.appendChild(this.createNode(document, "PaymentName", metodo));
                    String note_pagamento = cu.s((Object)documenti.getString("note_pagamento"));
                    if (!note_pagamento.equals("")) {
                        Document2.appendChild(this.createNode(document, "PaymentBank", note_pagamento));
                    }
                    id_documento = documenti.getInt("id");
                    String sql_scadenze = "SELECT * FROM scadenze WHERE id_doc = " + Db.pc((Object)id_documento, (int)4) + " AND documento_tipo = " + Db.pc((Object)tipo_doc_invoicex, (int)12);
                    ResultSet scadenze = dbu.tryOpenResultSet((Connection)Db.getConn(), (String)sql_scadenze);
                    if (scadenze.next()) {
                        scadenze.beforeFirst();
                        Element Payments = document.createElement("Payments");
                        while (scadenze.next()) {
                            boolean acconto = cu.s((Object)scadenze.getString("flag_acconto")).equals("S");
                            String stato_pagamento = cu.s((Object)scadenze.getString("pagata"));
                            boolean pagata = stato_pagamento.equals("S");
                            double totale = scadenze.getDouble("importo");
                            String data_scadenza = scadenze.getString("data_scadenza");
                            if (stato_pagamento.equals("N") || stato_pagamento.equals("S")) {
                                Element Payment = document.createElement("Payment");
                                Payment.appendChild(this.createNode(document, "Advance", acconto ? "true" : "false"));
                                Payment.appendChild(this.createNode(document, "Date", data_scadenza));
                                Payment.appendChild(this.createNode(document, "Amount", FormatUtils.formatEngNum02Dec((double)totale).replace(",", "")));
                                Payment.appendChild(this.createNode(document, "Paid", pagata ? "true" : "false"));
                                Payments.appendChild(Payment);
                                continue;
                            }
                            Integer id_scadenza = scadenze.getInt("id");
                            String sql_parziali = "SELECT * FROM scadenze_parziali WHERE id_scadenza = " + Db.pc((Object)id_scadenza, (int)4);
                            ResultSet parziali = dbu.tryOpenResultSet((Connection)Db.getConn(), (String)sql_parziali);
                            double da_pagare = totale;
                            while (parziali.next()) {
                                String data_pagamento = parziali.getString("data");
                                double pagato = parziali.getDouble("importo");
                                da_pagare -= pagato;
                                Element Payment = document.createElement("Payment");
                                Payment.appendChild(this.createNode(document, "Advance", "false"));
                                Payment.appendChild(this.createNode(document, "Date", data_pagamento));
                                Payment.appendChild(this.createNode(document, "Amount", FormatUtils.formatEngNum02Dec((double)pagato).replace(",", "")));
                                Payment.appendChild(this.createNode(document, "Paid", "true"));
                                Payments.appendChild(Payment);
                            }
                            Element Payment = document.createElement("Payment");
                            Payment.appendChild(this.createNode(document, "Advance", "false"));
                            Payment.appendChild(this.createNode(document, "Date", data_scadenza));
                            Payment.appendChild(this.createNode(document, "Amount", FormatUtils.formatEngNum02Dec((double)da_pagare).replace(",", "")));
                            Payment.appendChild(this.createNode(document, "Paid", "false"));
                            Payments.appendChild(Payment);
                        }
                        Document2.appendChild(Payments);
                    }
                    Document2.appendChild(this.createNode(document, "Carrier", documenti.getString("mezzo_consegna")));
                    Document2.appendChild(this.createNode(document, "TransportReason", documenti.getString("causale_trasporto")));
                    Document2.appendChild(this.createNode(document, "GoodsAppearance", documenti.getString("aspetto_esteriore_beni")));
                    Document2.appendChild(this.createNode(document, "NumOfPieces", documenti.getString("numero_colli")));
                    try {
                        Document2.appendChild(this.createNode(document, "TransportDateTime", documenti.getString("dataoraddt")));
                    }
                    catch (SQLException sqle) {
                        if (cu.s((Object)sqle.getSQLState()).equals("S0022")) break block78;
                        sqle.printStackTrace();
                    }
                }
                Document2.appendChild(this.createNode(document, "ShipmentTerms", documenti.getString("porto")));
                Document2.appendChild(this.createNode(document, "TransportedWeight", documenti.getString("peso_lordo")));
                Document2.appendChild(this.createNode(document, "TrackingNumber", ""));
                Document2.appendChild(this.createNode(document, "InternalComment", ""));
                if (!cu.s((Object)documenti.getString("note")).equals("")) {
                    Document2.appendChild(this.createNode(document, "CustomField1", documenti.getString("note")));
                } else {
                    Document2.appendChild(this.createNode(document, "CustomField1", ""));
                }
                Document2.appendChild(this.createNode(document, "CustomField2", ""));
                Document2.appendChild(this.createNode(document, "CustomField3", ""));
                Document2.appendChild(this.createNode(document, "CustomField4", ""));
                Document2.appendChild(this.createNode(document, "FootNotes", main.fileIni.getValue("varie", "messaggioStampa", "")));
                Integer codice_agente = documenti.getInt("agente_codice");
                if (codice_agente > 0) {
                    String nome_agente = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)("SELECT nome FROM agenti WHERE id = " + Db.pc((Object)codice_agente, (int)4))));
                    Document2.appendChild(this.createNode(document, "SalesAgent", nome_agente));
                } else {
                    Document2.appendChild(this.createNode(document, "SalesAgent", ""));
                }
                Document2.appendChild(this.createNode(document, "DelayedVat", "false"));
                ResultSet righe = dbu.tryOpenResultSet((Connection)Db.getConn(), (String)("SELECT * FROM " + tabr + " WHERE id_padre = " + Db.pc((Object)id_documento, (int)4)));
                if (righe.next()) {
                    Element Rows;
                    block79: {
                        righe.beforeFirst();
                        Rows = document.createElement("Rows");
                        while (righe.next()) {
                            Element Row = document.createElement("Row");
                            String sconto1 = cu.s((Object)righe.getDouble("sconto1"));
                            String sconto2 = cu.s((Object)righe.getDouble("sconto2"));
                            String sconti = "";
                            if (!sconto1.equals("") && !sconto2.equals("")) {
                                sconti = sconto1 + "+" + sconto2 + "%";
                            } else if (!sconto1.equals("")) {
                                sconti = sconto1 + "%";
                            } else if (!sconto2.equals("")) {
                                sconti = sconto2 + "%";
                            }
                            Double prezzo = prezzi_ivati ? righe.getDouble("prezzo_ivato") : righe.getDouble("prezzo");
                            Double quantita = righe.getDouble("quantita");
                            Double totale = righe.getDouble("totale_ivato");
                            Row.appendChild(this.createNode(document, "Code", righe.getString("codice_articolo")));
                            Row.appendChild(this.createNode(document, "Description", righe.getString("descrizione")));
                            Row.appendChild(this.createNode(document, "Qty", FormatUtils.formatEngNum02Dec((double)quantita).replace(",", "")));
                            Row.appendChild(this.createNode(document, "Um", righe.getString("um")));
                            Row.appendChild(this.createNode(document, "Price", FormatUtils.formatEngNum02Dec((double)prezzo).replace(",", "")));
                            Row.appendChild(this.createNode(document, "Discounts", sconti));
                            String codice_iva = this.utils.getCodiceIVA(righe.getString("iva"), ImportExportUtils.TIPO_OPERAZIONE_EXPORT);
                            String sql_codice_iva = "SELECT * FROM codici_iva WHERE codice = " + Db.pc((Object)codice_iva, (int)12);
                            Map iva = new HashMap();
                            try {
                                iva = (Map)dbu.getListMap((Connection)Db.getConn(), (String)sql_codice_iva).get(0);
                            }
                            catch (Exception pagato) {
                                // empty catch block
                            }
                            Element VatCode = this.createNode(document, "VatCode", codice_iva);
                            VatCode.setAttribute("Description", cu.s(iva.get("descrizione_breve")));
                            VatCode.setAttribute("Class", "Imponibile");
                            VatCode.setAttribute("Perc", FormatUtils.formatEngNum02Dec((double)cu.d0(iva.get("percentuale"))).replace(",", ""));
                            Row.appendChild(VatCode);
                            Row.appendChild(this.createNode(document, "Total", FormatUtils.formatEngNum02Dec((double)totale).replace(",", "")));
                            Row.appendChild(this.createNode(document, "Stock", cu.s((Object)righe.getString("codice_articolo")).equals("") ? "false" : "true"));
                            Row.appendChild(this.createNode(document, "CommissionPerc", FormatUtils.formatEngNum02Dec((double)righe.getDouble("provvigione")).replace(",", "")));
                            Row.appendChild(this.createNode(document, "Notes", ""));
                            Rows.appendChild(Row);
                        }
                        String codice_iva_spese = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)"SELECT codiceIvaSpese FROM dati_azienda LIMIT 1"));
                        String codice_iva_export = this.utils.getCodiceIVA(codice_iva_spese, ImportExportUtils.TIPO_OPERAZIONE_EXPORT);
                        Double spese_spedizione = documenti.getDouble("spese_trasporto");
                        if (spese_spedizione > 0.0) {
                            Element Row = document.createElement("Row");
                            Row.appendChild(this.createNode(document, "Code", ""));
                            Row.appendChild(this.createNode(document, "Description", "Spese di trasporto"));
                            Row.appendChild(this.createNode(document, "Qty", "1"));
                            Row.appendChild(this.createNode(document, "Um", ""));
                            Row.appendChild(this.createNode(document, "Price", FormatUtils.formatEngNum02Dec((double)spese_spedizione).replace(",", "")));
                            Row.appendChild(this.createNode(document, "Discounts", ""));
                            Row.appendChild(this.createNode(document, "VatCode", codice_iva_export));
                            Row.appendChild(this.createNode(document, "Total", FormatUtils.formatEngNum02Dec((double)spese_spedizione).replace(",", "")));
                            Row.appendChild(this.createNode(document, "Stock", "false"));
                            Rows.appendChild(Row);
                        }
                        Double spese_incasso = documenti.getDouble("spese_incasso");
                        if (spese_spedizione > 0.0) {
                            Element Row = document.createElement("Row");
                            Row.appendChild(this.createNode(document, "Code", ""));
                            Row.appendChild(this.createNode(document, "Description", "Spese di incasso"));
                            Row.appendChild(this.createNode(document, "Qty", "1"));
                            Row.appendChild(this.createNode(document, "Um", ""));
                            Row.appendChild(this.createNode(document, "Price", FormatUtils.formatEngNum02Dec((double)spese_incasso).replace(",", "")));
                            Row.appendChild(this.createNode(document, "Discounts", ""));
                            Row.appendChild(this.createNode(document, "VatCode", codice_iva_export));
                            Row.appendChild(this.createNode(document, "Total", FormatUtils.formatEngNum02Dec((double)spese_incasso).replace(",", "")));
                            Row.appendChild(this.createNode(document, "Stock", "false"));
                            Rows.appendChild(Row);
                        }
                        try {
                            Double spese_bollo = documenti.getDouble("marca_da_bollo");
                            if (spese_spedizione > 0.0) {
                                Element Row = document.createElement("Row");
                                Row.appendChild(this.createNode(document, "Code", ""));
                                Row.appendChild(this.createNode(document, "Description", "Bolli sul documento"));
                                Row.appendChild(this.createNode(document, "Qty", "1"));
                                Row.appendChild(this.createNode(document, "Um", ""));
                                Row.appendChild(this.createNode(document, "Price", FormatUtils.formatEngNum02Dec((double)spese_bollo).replace(",", "")));
                                Row.appendChild(this.createNode(document, "Discounts", ""));
                                Row.appendChild(this.createNode(document, "VatCode", codice_iva_export));
                                Row.appendChild(this.createNode(document, "Total", FormatUtils.formatEngNum02Dec((double)spese_bollo).replace(",", "")));
                                Row.appendChild(this.createNode(document, "Stock", "false"));
                                Rows.appendChild(Row);
                            }
                        }
                        catch (SQLException sqle) {
                            if (cu.s((Object)sqle.getSQLState()).equals("S0022")) break block79;
                            sqle.printStackTrace();
                        }
                    }
                    Document2.appendChild(Rows);
                } else {
                    this.w.publish(new Object[]{"Impossibile esportare il documento " + refDocumento + ": non ci sono righe all'interno della fattura"});
                }
                Documents.appendChild(Document2);
                stato_publish[0] = stato_publish[0] + 1;
                this.w.publish(new Object[]{"Documento " + refDocumento + " esportato correttamente"});
            }
            EasyfattDocuments.appendChild(Documents);
            document.appendChild(EasyfattDocuments);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmm");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            this.checkForNullTextNodes(document.getDocumentElement());
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(this.current_dir_export + file));
            transformer.transform(source, result);
        }
        dbu.close((ResultSet)documenti);
    }

    private Element createNode(Document document, String name, String value) {
        Element new_element = document.createElement(name);
        new_element.appendChild(document.createTextNode(value));
        return new_element;
    }

    private void checkForNullTextNodes(Node node) {
        System.out.println(node.getNodeName());
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() == 3 && nl.item(i).getNodeValue() == null) {
                nl.item(i).setNodeValue("");
                continue;
            }
            this.checkForNullTextNodes(nl.item(i));
        }
    }
}

