/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.demo;

import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.ext.DebugRepaintingUI;

public class DebugRepaintingDemo
extends JFrame {
    public DebugRepaintingDemo() {
        super("DebugLayerDemo");
        this.setDefaultCloseOperation(3);
        JTabbedPane tb = new JTabbedPane();
        tb.setTabPlacement(3);
        tb.addTab("Components", this.createButtonPanel());
        tb.addTab("Table", this.createTable());
        tb.addTab("Tree", new JTree());
        JXLayer<JTabbedPane> layer = new JXLayer<JTabbedPane>(tb);
        this.add(layer);
        DebugRepaintingUI dp = new DebugRepaintingUI();
        layer.setUI(dp);
        this.setSize(400, 350);
        this.setLocationRelativeTo(null);
    }

    private JComponent createTable() {
        return new JScrollPane(new JTable(new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 10;
            }

            @Override
            public int getRowCount() {
                return 20;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return "" + rowIndex;
            }
        }));
    }

    private JComponent createButtonPanel() {
        Box box = Box.createVerticalBox();
        box.add(Box.createGlue());
        this.addToBox(box, new JButton("JButton"));
        this.addToBox(box, new JRadioButton("JRadioButton"));
        this.addToBox(box, new JCheckBox("JCheckBox"));
        this.addToBox(box, new JTextField(10));
        String[] str = new String[]{"One", "Two", "Three"};
        this.addToBox(box, new JComboBox<String>(str));
        this.addToBox(box, new JSlider(0, 100));
        return box;
    }

    private void addToBox(Box box, JComponent c) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.add(c);
        box.add(panel);
        box.add(Box.createGlue());
    }

    public static void main(String[] args) throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DebugRepaintingDemo().setVisible(true);
            }
        });
    }
}

