/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.demo.util;

import java.awt.color.ColorSpace;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.awt.image.RescaleOp;
import java.util.Arrays;
import org.jdesktop.jxlayer.demo.util.LookupTableWrapper;

public class ImageOpFactory {
    private ImageOpFactory() {
    }

    public static LookupOp getInvertColorOp() {
        return ImageOpFactory.getInvertColorOp(true, true, true);
    }

    public static LookupOp getInvertColorOp(boolean red, boolean green, boolean blue) {
        byte[] invert = new byte[256];
        byte[] straight = new byte[256];
        for (int i = 0; i < invert.length; ++i) {
            invert[i] = (byte)(255 - i);
            straight[i] = (byte)i;
        }
        byte[][] result = new byte[4][];
        Arrays.fill((Object[])result, straight);
        if (red) {
            result[0] = invert;
        }
        if (green) {
            result[1] = invert;
        }
        if (blue) {
            result[2] = invert;
        }
        result[3] = straight;
        LookupTableWrapper table = new LookupTableWrapper(new ByteLookupTable(0, result));
        return new LookupOp(table, null);
    }

    public static LookupOp getPosterizeOp() {
        byte[] posterize = new byte[256];
        for (int i = 0; i < posterize.length; ++i) {
            posterize[i] = (byte)(i - i % 32);
        }
        LookupTableWrapper table = new LookupTableWrapper(new ByteLookupTable(0, posterize));
        return new LookupOp(table, null);
    }

    public static ColorConvertOp getGrayScaleOp() {
        return new ColorConvertOp(ColorSpace.getInstance(1003), null);
    }

    public static RescaleOp getRescaleOp(float scaleFactor) {
        return new RescaleOp(scaleFactor, 0.0f, null);
    }

    public static RescaleOp getRescaleOp(float scaleFactor, float offset) {
        return new RescaleOp(scaleFactor, offset, null);
    }

    public static RescaleOp getRescaleOp(float[] scaleFactor) {
        float[] offset = new float[scaleFactor.length];
        Arrays.fill(offset, 0.0f);
        return new RescaleOp(scaleFactor, offset, null);
    }

    public static RescaleOp getRescaleOp(float[] scaleFactor, float[] offset) {
        return new RescaleOp(scaleFactor, offset, null);
    }

    public static ConvolveOp getConvolveOp(int i) {
        float[] kernel = new float[i * i];
        Arrays.fill(kernel, 1.0f / (float)(i * i));
        return new ConvolveOp(new Kernel(i, i, kernel), 1, null);
    }
}

