/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugintnx;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.tnx.commons.cu;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ImportXmlPa {
    XPath xpath = null;

    public Map getFromXml(String file) throws ParserConfigurationException, SAXException, IOException, Exception {
        File fXmlFile = new File(file);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(fXmlFile);
        doc.getDocumentElement().normalize();
        XPathFactory xPathfactory = XPathFactory.newInstance();
        this.xpath = xPathfactory.newXPath();
        String root = doc.getDocumentElement().getNodeName();
        if (!root.equalsIgnoreCase("p:FatturaElettronica")) {
            throw new Exception("Il file non contiene una fattura elettronica (root=" + root + ")");
        }
        System.out.println("----------------------------");
        HashMap<String, Cloneable> ret = new HashMap<String, Cloneable>();
        HashMap clifor = new HashMap();
        Element cedente = (Element)((NodeList)this.xpath.evaluate("//FatturaElettronicaHeader/CedentePrestatore", doc, XPathConstants.NODESET)).item(0);
        this.get(clifor, cedente, "DatiAnagrafici/IdFiscaleIVA/IdPaese", "paese");
        this.get(clifor, cedente, "DatiAnagrafici/IdFiscaleIVA/IdCodice", "piva_cfiscale");
        this.get(clifor, cedente, "DatiAnagrafici/CodiceFiscale", "cfiscale");
        this.get(clifor, cedente, "DatiAnagrafici/CodiceFiscale", "cfiscale");
        this.get(clifor, cedente, "DatiAnagrafici/Anagrafica/Denominazione", "ragione_sociale");
        this.get(clifor, cedente, "Sede/Indirizzo", "indirizzo");
        this.get(clifor, cedente, "Sede/CAP", "cap");
        this.get(clifor, cedente, "Sede/Comune", "localita");
        this.get(clifor, cedente, "Sede/Provincia", "provincia");
        this.get(clifor, cedente, "Sede/Nazione", "paese");
        ret.put("clifor", clifor);
        ArrayList list_fatture = new ArrayList();
        NodeList list = (NodeList)this.xpath.evaluate("//FatturaElettronicaBody", doc, XPathConstants.NODESET);
        for (int i = 0; i < list.getLength(); ++i) {
            Element body = (Element)list.item(i);
            HashMap<String, Cloneable> dati_fattura = new HashMap<String, Cloneable>();
            HashMap fattura = new HashMap();
            HashMap fattura_extra = new HashMap();
            this.get(fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/TipoDocumento", "tipo_documento");
            this.get(fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/Divisa", "divisa");
            this.get(fattura, body, "DatiGenerali/DatiGeneraliDocumento/Data", "data");
            this.get(fattura, body, "DatiGenerali/DatiGeneraliDocumento/Numero", "numero");
            this.get(fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiRitenuta/TipoRitenuta", "tipo_ritenuta");
            this.get(fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiRitenuta/AliquotaRitenuta", "aliquota_ritenuta");
            this.get(fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiCassaPrevidenziale/TipoCassa", "tipo_cassa");
            this.get(fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiCassaPrevidenziale/AlCassa", "aliquota_cassa");
            this.get(fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiCassaPrevidenziale/AliquotaIVA", "aliquota_iva");
            this.get(fattura, body, "DatiGenerali/DatiGeneraliDocumento/ImportoTotaleDocumento", "totale");
            ArrayList righe = new ArrayList();
            NodeList list_linee = (NodeList)this.xpath.evaluate("DatiBeniServizi/DettaglioLinee", body, XPathConstants.NODESET);
            for (int i2 = 0; i2 < list_linee.getLength(); ++i2) {
                Element linea = (Element)list_linee.item(i2);
                HashMap riga = new HashMap();
                this.get(riga, linea, "NumeroLinea", "riga");
                this.get(riga, linea, "Descrizione", "descrizione");
                this.get(riga, linea, "Quantita", "quantita");
                this.get(riga, linea, "PrezzoUnitario", "prezzo");
                this.get(riga, linea, "PrezzoTotale", "totale_imponibile");
                this.get(riga, linea, "AliquotaIVA", "iva");
                this.get(riga, linea, "Ritenuta", "flag_ritenuta");
                righe.add(riga);
            }
            this.get(fattura_extra, body, "DatiPagamento/CondizioniPagamento", "condizioni_pagamento");
            this.get(fattura_extra, body, "DatiPagamento/DettaglioPagamento/ModalitaPagamento", "modalita_pagamento");
            this.get(fattura_extra, body, "DatiPagamento/DettaglioPagamento/ModalitaPagamento", "modalita_pagamento");
            ArrayList scadenze = new ArrayList();
            NodeList list_scadenze = (NodeList)this.xpath.evaluate("DatiPagamento/DettaglioPagamento", body, XPathConstants.NODESET);
            for (int i3 = 0; i3 < list_scadenze.getLength(); ++i3) {
                Element scadenza_el = (Element)list_scadenze.item(i3);
                HashMap scadenza = new HashMap();
                this.get(scadenza, scadenza_el, "ModalitaPagamento", "ModalitaPagamento");
                this.get(scadenza, scadenza_el, "DataScadenzaPagamento", "DataScadenzaPagamento");
                this.get(scadenza, scadenza_el, "ImportoPagamento", "ImportoPagamento");
                this.get(scadenza, scadenza_el, "IstitutoFinanziario", "IstitutoFinanziario");
                this.get(scadenza, scadenza_el, "IBAN", "IBAN");
                scadenze.add(scadenza);
            }
            dati_fattura.put("fattura", fattura);
            dati_fattura.put("righe", righe);
            dati_fattura.put("fattura_extra", fattura_extra);
            dati_fattura.put("scadenze", scadenze);
            list_fatture.add(dati_fattura);
        }
        ret.put("fatture", list_fatture);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonOutput = gson.toJson(ret);
        System.out.println("jsonOutput = " + jsonOutput);
        return ret;
    }

    public static void main(String[] args) {
        ImportXmlPa i = new ImportXmlPa();
        try {
            Map m = i.getFromXml("f:\\temp\\IT02101170062_00508.xml");
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(ImportXmlPa.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(ImportXmlPa.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ImportXmlPa.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(ImportXmlPa.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void get(Map m, Element element, String expr, String campo) throws XPathExpressionException {
        String val = cu.s((Object)this.xpath.evaluate(expr, element, XPathConstants.STRING));
        m.put(campo, val);
    }
}

