/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.renderpack;

import java.awt.Component;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ClassConciousEditorRenderer
implements TableCellRenderer,
TableCellEditor {
    private JTable table;
    private TableCellRenderer objectRenderer = null;
    private TableCellEditor objectEditor = null;
    private List cellEditorListeners = new ArrayList();
    private TableCellEditor currentEditor = null;

    private ClassConciousEditorRenderer(JTable table) {
        this.table = table;
        this.objectRenderer = table.getDefaultRenderer(Object.class);
        this.objectEditor = table.getDefaultEditor(Object.class);
    }

    public static ClassConciousEditorRenderer install(JTable table) {
        ClassConciousEditorRenderer ccr = new ClassConciousEditorRenderer(table);
        table.setDefaultRenderer(Object.class, ccr);
        table.setDefaultEditor(Object.class, ccr);
        return ccr;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRenderer renderer = this.getRenderer(value);
        return renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        TableCellEditor editor = this.getEditor(value);
        this.setCurrentEditor(editor);
        return editor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.cellEditorListeners.add(listener);
        if (this.currentEditor != null) {
            this.currentEditor.addCellEditorListener(listener);
        }
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.cellEditorListeners.remove(listener);
        if (listener != null) {
            this.currentEditor.removeCellEditorListener(listener);
        }
    }

    private void setCurrentEditor(TableCellEditor editor) {
        if (this.currentEditor == editor) {
            return;
        }
        TableCellEditor previousEditor = this.currentEditor;
        this.currentEditor = editor;
        if (previousEditor != null) {
            for (CellEditorListener listener : this.cellEditorListeners) {
                previousEditor.removeCellEditorListener(listener);
            }
        }
        if (this.currentEditor != null) {
            for (CellEditorListener listener : this.cellEditorListeners) {
                this.currentEditor.addCellEditorListener(listener);
            }
        }
    }

    public void cancelCellEditing() {
        if (this.currentEditor != null) {
            this.currentEditor.cancelCellEditing();
        } else {
            System.out.println("Cancel with no current editor!");
        }
    }

    public Object getCellEditorValue() {
        if (this.currentEditor != null) {
            return this.currentEditor.getCellEditorValue();
        }
        System.out.println("Get value with no current editor!");
        return null;
    }

    public boolean isCellEditable(EventObject anEvent) {
        if (this.currentEditor != null) {
            return this.currentEditor.isCellEditable(anEvent);
        }
        return this.objectEditor.isCellEditable(anEvent);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        if (this.currentEditor != null) {
            return this.currentEditor.shouldSelectCell(anEvent);
        }
        return this.objectEditor.shouldSelectCell(anEvent);
    }

    public boolean stopCellEditing() {
        if (this.currentEditor != null) {
            return this.currentEditor.stopCellEditing();
        }
        System.out.println("Stop with no current editor value");
        return false;
    }

    private TableCellRenderer getRenderer(Object value) {
        if (value == null) {
            return this.objectRenderer;
        }
        TableCellRenderer renderer = this.table.getDefaultRenderer(value.getClass());
        if (renderer != this) {
            return renderer;
        }
        return this.objectRenderer;
    }

    private TableCellEditor getEditor(Object value) {
        if (value == null) {
            return this.objectEditor;
        }
        TableCellEditor editor = this.table.getDefaultEditor(value.getClass());
        if (editor != this) {
            return editor;
        }
        return this.objectEditor;
    }
}

