/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.renderpack;

import ca.odell.renderpack.ClassConciousEditorRenderer;
import ca.odell.renderpack.pipeline.BeanRenderStage;
import ca.odell.renderpack.pipeline.DateRenderStage;
import ca.odell.renderpack.pipeline.PipelineListCellRenderer;
import ca.odell.renderpack.pipeline.PipelineTableCellRenderer;
import ca.odell.renderpack.pipeline.RenderStage;
import ca.odell.renderpack.pipeline.SelectionRenderStage;
import ca.odell.renderpack.pipeline.StripedRenderStage;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class Demo
extends JFrame {
    public static void main(String[] args) {
        Demo demo = new Demo();
        demo.setSize(300, 300);
        demo.show();
    }

    public Demo() {
        JTabbedPane demoTabs = new JTabbedPane();
        demoTabs.add(this.constructPipelineDemo(), "Pipelines");
        demoTabs.add(this.constructClasssConciousDemo(), "Class Concious");
        this.getContentPane().add(demoTabs);
        this.setDefaultCloseOperation(3);
    }

    public Component constructPipelineDemo() {
        Box box = Box.createVerticalBox();
        JComboBox<Object> jComboBox = new JComboBox<Object>(new MyComboModel());
        JList<Object> jList = new JList<Object>(new MyListModel());
        JTable jTable = new JTable(new MyTableModel());
        RenderStage[] comboRenderers = new RenderStage[]{new BeanRenderStage("username"), new StripedRenderStage(Color.YELLOW, Color.PINK), new SelectionRenderStage(Color.WHITE)};
        jComboBox.setRenderer(new PipelineListCellRenderer(comboRenderers));
        RenderStage[] listRenderers = new RenderStage[]{new DateRenderStage("yyyy"), new StripedRenderStage(Color.RED, Color.GREEN)};
        jList.setCellRenderer(new PipelineListCellRenderer(listRenderers));
        RenderStage[] columnOneRenderers = new RenderStage[]{new DateRenderStage("yyyy"), new StripedRenderStage(Color.RED, Color.BLUE)};
        jTable.getColumnModel().getColumn(0).setCellRenderer(new PipelineTableCellRenderer(columnOneRenderers));
        RenderStage[] columnTwoRenderers = new RenderStage[]{new BeanRenderStage("username"), new StripedRenderStage(Color.YELLOW, Color.PINK)};
        jTable.getColumnModel().getColumn(1).setCellRenderer(new PipelineTableCellRenderer(columnTwoRenderers));
        JScrollPane tableScrollPane = new JScrollPane(jTable);
        JScrollPane listScrollPane = new JScrollPane(jList);
        box.add(jComboBox);
        box.add(jTable);
        box.add(jList);
        return box;
    }

    public Component constructClasssConciousDemo() {
        JTable jTable = new JTable(new MultipleClassesTableModel());
        ClassConciousEditorRenderer.install(jTable);
        return jTable;
    }

    class MyComboModel
    extends DefaultComboBoxModel {
        public MyComboModel() {
            super(new Object[]{new MyBean(), new MyBean(), new MyBean(), new MyBean()});
        }
    }

    class MyListModel
    extends AbstractListModel {
        MyListModel() {
        }

        public int getSize() {
            return 5;
        }

        public Object getElementAt(int index) {
            return new Date(System.currentTimeMillis());
        }
    }

    class MyTableModel
    extends DefaultTableModel {
        MyTableModel() {
        }

        public int getRowCount() {
            return 5;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Date";
                }
                case 1: {
                    return "Bean";
                }
            }
            return "";
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return new Date(System.currentTimeMillis());
                }
                case 1: {
                    return new MyBean();
                }
            }
            return null;
        }
    }

    static class MultipleClassesTableModel
    extends DefaultTableModel {
        public MultipleClassesTableModel() {
            super(MultipleClassesTableModel.createData(), MultipleClassesTableModel.createColumnNames());
        }

        private static Object[][] createData() {
            return new Object[][]{{"Extra Cheese", Boolean.TRUE}, {"Thin Crust", Boolean.FALSE}, {"Topping 1", "Ham"}, {"Topping 2", "Pineapple"}, {"Topping 3", null}, {"Price", new Integer(20)}, {"Delivery Time", new Short(45)}};
        }

        private static Object[] createColumnNames() {
            return new Object[]{"Property", "Value"};
        }
    }

    public class MyBean {
        public String getUsername() {
            return "Michael Jackson";
        }
    }
}

