/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.renderpack;

import ca.odell.renderpack.HTMLRenderer;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public abstract class HTMLTableCellRenderer
extends HTMLRenderer
implements TableCellRenderer {
    private StringBuffer stringBuffer = new StringBuffer();
    private boolean controlHeight;

    public HTMLTableCellRenderer(boolean controlHeight) {
        this.controlHeight = controlHeight;
    }

    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.prepareRendered(table, value, isSelected, hasFocus, row, column);
        this.stringBuffer.delete(0, this.stringBuffer.length());
        this.writeObject(this.stringBuffer, table, value, isSelected, hasFocus, row, column);
        this.rendered.setText(this.stringBuffer.toString());
        this.getRendered(table, value, isSelected, hasFocus, row, column);
        return this.rendered;
    }

    public abstract void writeObject(StringBuffer var1, JTable var2, Object var3, boolean var4, boolean var5, int var6, int var7);

    protected void prepareRendered(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.colorSelected(isSelected);
        int columnWidth = table.getColumnModel().getColumn(column).getWidth();
        Rectangle bounds = this.rendered.getBounds();
        bounds.width = columnWidth;
        bounds.height = 1000;
        this.rendered.setBounds(bounds);
        this.rendered.setText("");
    }

    protected void getRendered(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int requiredRowHeight = this.rendered.getPreferredSize().height;
        int currentRowHeight = table.getRowHeight(row);
        if (this.controlHeight && currentRowHeight != requiredRowHeight) {
            table.setRowHeight(row, requiredRowHeight);
        }
    }
}

