/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.renderpack;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class StripedTableCellRenderer
implements TableCellRenderer {
    private Color oddRowsColor;
    private Color evenRowsColor;
    private TableCellRenderer baseRenderer = null;

    public StripedTableCellRenderer(Color oddRowsColor, Color evenRowsColor) {
        this.oddRowsColor = oddRowsColor;
        this.evenRowsColor = evenRowsColor;
    }

    public StripedTableCellRenderer(Color oddRowsColor, Color evenRowsColor, TableCellRenderer baseRenderer) {
        this.baseRenderer = baseRenderer;
        this.oddRowsColor = oddRowsColor;
        this.evenRowsColor = evenRowsColor;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRenderer renderer;
        if (this.baseRenderer == null) {
            Class rendererClass = Object.class;
            if (value != null) {
                rendererClass = value.getClass();
            }
            renderer = table.getDefaultRenderer(rendererClass);
        } else {
            renderer = this.baseRenderer;
        }
        Component rendered = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            return rendered;
        }
        if (row % 2 == 0) {
            rendered.setBackground(this.evenRowsColor);
        } else {
            rendered.setBackground(this.oddRowsColor);
        }
        return rendered;
    }
}

