/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.mapper.helper.impl;

import com.sdicons.json.mapper.MapperException;
import com.sdicons.json.mapper.helper.SimpleMapperHelper;
import com.sdicons.json.model.JSONInteger;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.model.JSONValue;
import java.math.BigInteger;

public class ByteMapper
implements SimpleMapperHelper {
    @Override
    public Class getHelpedClass() {
        return Byte.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (aValue.isString()) {
            try {
                return Byte.parseByte(((JSONString)aValue).getValue());
            }
            catch (NumberFormatException e) {
                throw new MapperException("ByteMapper cannot map value: " + ((JSONString)aValue).getValue());
            }
        }
        if (aValue.isInteger()) {
            return (byte)((JSONInteger)aValue).getValue().intValue();
        }
        throw new MapperException("ByteMapper cannot map: " + aValue.getClass().getName());
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        if (!Byte.class.isAssignableFrom(aPojo.getClass())) {
            throw new MapperException("ByteMapper cannot map: " + aPojo.getClass().getName());
        }
        return new JSONInteger(new BigInteger(aPojo.toString()));
    }
}

