/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.mapper.helper.impl;

import com.sdicons.json.mapper.JSONMapper;
import com.sdicons.json.mapper.MapperException;
import com.sdicons.json.mapper.helper.ComplexMapperHelper;
import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONValue;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CollectionMapper
implements ComplexMapperHelper {
    @Override
    public Class getHelpedClass() {
        return Collection.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        return this.toJava(aValue, aRequestedClass, new Type[0]);
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRawClass, Type[] aTypes) throws MapperException {
        Collection lCollObj;
        if (!aValue.isArray()) {
            throw new MapperException("CollectionMapper cannot map: " + aValue.getClass().getName());
        }
        if (!Collection.class.isAssignableFrom(aRawClass)) {
            throw new MapperException("CollectionMapper cannot map: " + aValue.getClass().getName());
        }
        JSONArray aObject = (JSONArray)aValue;
        try {
            lCollObj = aRawClass.isInterface() ? (aRawClass == Set.class ? new HashSet() : (aRawClass == SortedSet.class ? new TreeSet() : new LinkedList())) : (Collection)aRawClass.newInstance();
        }
        catch (Exception e) {
            lCollObj = new LinkedList();
        }
        if (aTypes.length == 0) {
            for (JSONValue lVal : aObject.getValue()) {
                lCollObj.add(JSONMapper.toJava(lVal));
            }
        } else if (aTypes.length == 1) {
            for (JSONValue lVal : aObject.getValue()) {
                if (aTypes[0] instanceof Class) {
                    lCollObj.add(JSONMapper.toJava(lVal, (Class)aTypes[0]));
                    continue;
                }
                lCollObj.add(JSONMapper.toJava(lVal, (ParameterizedType)aTypes[0]));
            }
        } else {
            throw new MapperException("CollectionMapper cannot map: " + aValue.getClass().getName());
        }
        return lCollObj;
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        JSONArray lArray = new JSONArray();
        if (!Collection.class.isAssignableFrom(aPojo.getClass())) {
            throw new MapperException("CollectionMapper cannot map: " + aPojo.getClass().getName());
        }
        Collection lColl = (Collection)aPojo;
        for (Object lEl : lColl) {
            lArray.getValue().add(JSONMapper.toJSON(lEl));
        }
        return lArray;
    }
}

