/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.mapper.helper.impl;

import com.sdicons.json.mapper.MapperException;
import com.sdicons.json.mapper.helper.impl.AbstractMapper;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.model.JSONValue;

public class EnumMapper
extends AbstractMapper {
    @Override
    public Class getHelpedClass() {
        return Enum.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (!aValue.isString()) {
            throw new MapperException("EnumMapper cannot map class: " + aValue.getClass().getName());
        }
        if (aRequestedClass.isEnum()) {
            T[] lEnumVals;
            for (Object lEnumVal : lEnumVals = aRequestedClass.getEnumConstants()) {
                if (!lEnumVal.toString().equals(((JSONString)aValue).getValue())) continue;
                return lEnumVal;
            }
        } else {
            String lMsg = "Enum mapper tried to handle a non-enum class: " + aRequestedClass;
            throw new MapperException(lMsg);
        }
        String lMsg = "The enum class *is found* but no matching value could be found. Enum Class: " + aRequestedClass + ", unknown value: " + ((JSONString)aValue).getValue();
        throw new MapperException(lMsg);
    }
}

