/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.mapper.helper.impl;

import com.sdicons.json.mapper.JSONMapper;
import com.sdicons.json.mapper.MapperException;
import com.sdicons.json.mapper.helper.SimpleMapperHelper;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONValue;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ObjectMapper
implements SimpleMapperHelper {
    @Override
    public Class getHelpedClass() {
        return Object.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (!aValue.isObject()) {
            throw new MapperException("ObjectMapper cannot map: " + aValue.getClass().getName());
        }
        JSONObject aObject = (JSONObject)aValue;
        try {
            Object lBean = aRequestedClass.newInstance();
            for (String lPropname : aObject.getValue().keySet()) {
                PropertyDescriptor[] lPropDesc;
                JSONValue lSubEl = aObject.get(lPropname);
                boolean lFoundWriter = false;
                for (PropertyDescriptor aLPropDesc : lPropDesc = Introspector.getBeanInfo(aRequestedClass, 1).getPropertyDescriptors()) {
                    if (!aLPropDesc.getName().equals(lPropname)) continue;
                    lFoundWriter = true;
                    Method lWriter = aLPropDesc.getWriteMethod();
                    if (lWriter == null) break;
                    Type[] lTypes = lWriter.getGenericParameterTypes();
                    Object lProp = lTypes.length == 1 && lTypes[0] instanceof ParameterizedType ? JSONMapper.toJava(lSubEl, (ParameterizedType)lTypes[0]) : JSONMapper.toJava(lSubEl, aLPropDesc.getPropertyType());
                    lWriter.invoke(lBean, lProp);
                    break;
                }
                if (lFoundWriter) continue;
                String lMsg = "Could not find a setter for prop: " + lPropname + " in class: " + aRequestedClass;
                throw new MapperException(lMsg);
            }
            return lBean;
        }
        catch (IllegalAccessException e) {
            String lMsg = "IllegalAccessException while trying to instantiate bean: " + aRequestedClass;
            throw new MapperException(lMsg);
        }
        catch (InstantiationException e) {
            String lMsg = "InstantiationException while trying to instantiate bean: " + aRequestedClass;
            throw new MapperException(lMsg);
        }
        catch (IntrospectionException e) {
            String lMsg = "IntrospectionException while trying to fill bean: " + aRequestedClass;
            throw new MapperException(lMsg);
        }
        catch (InvocationTargetException e) {
            String lMsg = "InvocationTargetException while trying to fill bean: " + aRequestedClass;
            throw new MapperException(lMsg);
        }
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        JSONObject lElements = new JSONObject();
        String lPropName = "";
        try {
            PropertyDescriptor[] lPropDesc;
            Class<?> lClass = aPojo.getClass();
            for (PropertyDescriptor aLPropDesc : lPropDesc = Introspector.getBeanInfo(lClass, 1).getPropertyDescriptors()) {
                Method lReader = aLPropDesc.getReadMethod();
                lPropName = aLPropDesc.getName();
                if (lReader != null && (lReader.getReturnType().toString().contains("net.sf.cglib.proxy.Callback") || lReader.getReturnType().toString().contains("org.hibernate.proxy.LazyInitializer")) || lReader != null && lPropName.equals("class") || lReader == null) continue;
                lElements.getValue().put(lPropName, JSONMapper.toJSON(lReader.invoke(aPojo, new Object[0])));
            }
            return lElements;
        }
        catch (IntrospectionException e) {
            String lMsg = "Error while introspecting JavaBean. Class: " + aPojo.getClass();
            throw new MapperException(lMsg);
        }
        catch (IllegalAccessException e) {
            String lMsg = "Illegal access while trying to fetch a bean property (1).Property: " + lPropName + " Object: " + aPojo;
            throw new MapperException(lMsg);
        }
        catch (InvocationTargetException e) {
            String lMsg = "Illegal access while trying to fetch a bean property (2).Property: " + lPropName + " Object: " + aPojo;
            throw new MapperException(lMsg);
        }
    }
}

