/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.serializer.helper.impl;

import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.serializer.helper.impl.AbstractHelper;
import com.sdicons.json.serializer.marshall.JSONMarshall;
import com.sdicons.json.serializer.marshall.MarshallException;
import java.util.HashMap;

public class EnumHelper
extends AbstractHelper {
    @Override
    public Object parseValue(JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        Class<?> lEnumClass;
        JSONMarshall.requireStringAttribute(aObjectElement, "c");
        String lEnumClassName = ((JSONString)aObjectElement.get("c")).getValue();
        try {
            lEnumClass = Class.forName(lEnumClassName);
        }
        catch (ClassNotFoundException e) {
            String lMsg = "The class cannot be instantiated, it cannot be found in the classpath: " + lEnumClassName;
            throw new MarshallException(lMsg);
        }
        if (lEnumClass.isEnum()) {
            ?[] lEnumVals;
            for (Object lEnumVal : lEnumVals = lEnumClass.getEnumConstants()) {
                JSONMarshall.requireStringAttribute(aObjectElement, "=");
                String lVal = ((JSONString)aObjectElement.get("=")).getValue();
                if (!lEnumVal.toString().equals(lVal)) continue;
                return lEnumVal;
            }
        } else {
            String lMsg = "Enum helper tried to handle a non-enum class: " + lEnumClassName;
            throw new MarshallException(lMsg);
        }
        String lMsg = "The enum class *is found* but no matching value could be found." + lEnumClassName;
        throw new MarshallException(lMsg);
    }

    @Override
    public Class getHelpedClass() {
        return Enum.class;
    }
}

