/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.serializer.helper.impl;

import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.serializer.helper.impl.AbstractHelper;
import com.sdicons.json.serializer.marshall.JSONMarshall;
import com.sdicons.json.serializer.marshall.MarshallException;
import java.awt.Font;
import java.util.HashMap;

public class FontHelper
extends AbstractHelper {
    @Override
    public Object parseValue(JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        JSONMarshall.requireStringAttribute(aObjectElement, "=");
        return Font.decode(((JSONString)aObjectElement.get("=")).getValue());
    }

    @Override
    public void renderValue(Object aObj, JSONObject aParent, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        String lStyle;
        Font lFont = (Font)aObj;
        int lFontStyle = lFont.getStyle();
        switch (lFontStyle) {
            case 0: {
                lStyle = "PLAIN";
                break;
            }
            case 1: {
                lStyle = "BOLD";
                break;
            }
            case 2: {
                lStyle = "ITALIC";
                break;
            }
            case 3: {
                lStyle = "BOLDITALIC";
                break;
            }
            default: {
                lStyle = "PLAIN";
            }
        }
        aParent.getValue().put("=", new JSONString(lFont.getName() + "-" + lStyle + "-" + lFont.getSize()));
    }

    @Override
    public Class getHelpedClass() {
        return Font.class;
    }
}

