/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.serializer.helper.impl;

import com.sdicons.json.helper.JSONConstruct;
import com.sdicons.json.helper.JSONSerialize;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.serializer.helper.MarshallHelper;
import com.sdicons.json.serializer.marshall.JSONMarshall;
import com.sdicons.json.serializer.marshall.MarshallException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ObjectHelperDirect
implements MarshallHelper {
    private Map<Class, AnnotatedMethods> annotatedPool = new HashMap<Class, AnnotatedMethods>();

    protected synchronized AnnotatedMethods getAnnotatedMethods(Class aClass) throws MarshallException {
        AnnotatedMethods lResult = this.annotatedPool.get(aClass);
        if (lResult == null) {
            Constructor lCons = this.getAnnotatedConstructor(aClass);
            Method lMeth = this.getAnnotatedSerializingMethod(aClass);
            if (lMeth == null && lCons != null || lMeth != null && lCons == null) {
                throw new MarshallException(String.format("ObjectHelperDirect found inconsistency in class: '%1$s'. If annotated methods are used, it should contain both @HessianConstruct and @HessianSerialize together.", aClass.getClass().getName()));
            }
            lResult = new AnnotatedMethods(lCons, lMeth);
            this.annotatedPool.put(aClass, lResult);
        }
        return lResult;
    }

    protected List<Field> getFieldInfo(Class aClass) {
        LinkedList<Field> lJavaFields = new LinkedList<Field>();
        for (Class lClassWalker = aClass; lClassWalker != null; lClassWalker = lClassWalker.getSuperclass()) {
            Field[] lClassFields;
            for (Field lFld : lClassFields = lClassWalker.getDeclaredFields()) {
                int lModif = lFld.getModifiers();
                if (Modifier.isTransient(lModif) || Modifier.isAbstract(lModif) || Modifier.isStatic(lModif) || Modifier.isFinal(lModif)) continue;
                lFld.setAccessible(true);
                lJavaFields.add(lFld);
            }
        }
        return lJavaFields;
    }

    protected Method getAnnotatedSerializingMethod(Class aClass) {
        for (Method lMethod : aClass.getDeclaredMethods()) {
            if (!lMethod.isAnnotationPresent(JSONSerialize.class)) continue;
            lMethod.setAccessible(true);
            return lMethod;
        }
        return null;
    }

    protected Constructor getAnnotatedConstructor(Class aClass) {
        Constructor<?>[] lConstructors;
        for (Constructor<?> lCons : lConstructors = aClass.getDeclaredConstructors()) {
            if (!lCons.isAnnotationPresent(JSONConstruct.class)) continue;
            lCons.setAccessible(true);
            return lCons;
        }
        return null;
    }

    @Override
    public void renderValue(Object aObj, JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        if (aObj instanceof Serializable) {
            try {
                Method lWriteReplace = aObj.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                if (lWriteReplace != null) {
                    lWriteReplace.setAccessible(true);
                    JSONObject lOele = aMarshall.marshallImpl(lWriteReplace.invoke(aObj, new Object[0]), aPool);
                    aObjectElement.getValue().put("=", lOele);
                    return;
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                throw new MarshallException(String.format("ObjectHelperDirect error while trying to invoke 'writeReplace' on instance of class: '%1$s'.", aObj.getClass().getName()));
            }
        }
        JSONObject lElements = new JSONObject();
        aObjectElement.getValue().put("=", lElements);
        Class<?> lClass = aObj.getClass();
        List<Field> lJavaFields = this.getFieldInfo(lClass);
        AnnotatedMethods lAnnotated = this.getAnnotatedMethods(lClass);
        if (lAnnotated.serialize != null) {
            Object[] lVals;
            try {
                lVals = (Object[])lAnnotated.serialize.invoke(aObj, new Object[0]);
            }
            catch (Exception e) {
                throw new MarshallException(String.format("ObjectHelperDirect error while serializing. Error while invoking the @HessianSerialize method called '%1$s(...)' on an instance of class: '%2$s'.", lAnnotated.serialize.getName(), lClass.getName()));
            }
            int i = 0;
            try {
                for (Object lVal : lVals) {
                    lElements.getValue().put("cons-" + i, aMarshall.marshallImpl(lVal, aPool));
                    ++i;
                }
            }
            catch (MarshallException e) {
                throw new MarshallException(String.format("ObjectHelperDirect error while serializing. Error while serializing element nr %1$d from the @HessianSerialize method: '%2$s(...)' on instance of class: '%3$s'.", i, lAnnotated.serialize.getName(), lClass.getName()));
            }
        }
        for (Field lFld : lJavaFields) {
            try {
                lFld.setAccessible(true);
                lElements.getValue().put(lFld.getName(), aMarshall.marshallImpl(lFld.get(aObj), aPool));
            }
            catch (MarshallException e) {
                throw new MarshallException(String.format("ObjectHelperDirect error while serializing. Error while serializing field: '%1$s' from instance of class: '%2$s'.", lFld.getName(), lClass.getName()));
            }
            catch (Exception e) {
                throw new MarshallException(String.format("ObjectHelperDirect error while serializing. Error while reading field: '%1$s' from instance of class: '%2$s'.", lFld.getName(), lClass.getName()));
            }
        }
    }

    @Override
    public Object parseValue(JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        JSONMarshall.requireStringAttribute(aObjectElement, "c");
        String lBeanClassName = ((JSONString)aObjectElement.get("c")).getValue();
        String lId = null;
        try {
            JSONMarshall.requireStringAttribute(aObjectElement, "&");
            lId = ((JSONString)aObjectElement.get("&")).getValue();
        }
        catch (Exception eIgnore) {
            // empty catch block
        }
        try {
            Object lBean;
            Class<?> lBeanClass = Class.forName(lBeanClassName);
            List<Field> lJavaFields = this.getFieldInfo(lBeanClass);
            AnnotatedMethods lAnnotated = this.getAnnotatedMethods(lBeanClass);
            JSONObject lProperties = (JSONObject)aObjectElement.get("=");
            if (lAnnotated.cons != null) {
                int lCnt = lAnnotated.cons.getParameterTypes().length;
                Object[] lAttrs = new Object[lCnt];
                for (int i = 0; i < lCnt; ++i) {
                    String lFldName = "cons-" + i;
                    JSONObject lSubEl = (JSONObject)lProperties.get(lFldName);
                    try {
                        lAttrs[i] = aMarshall.unmarshallImpl(lSubEl, aPool);
                        continue;
                    }
                    catch (MarshallException e) {
                        throw new MarshallException(String.format("ObjectHelperDirect error while deserializing. Error while calling the @JSONConstruct constructor in class: '%1$s' on parameter nr: %2$d with a value of class: '%3$s'.", lBeanClass.getName(), i, lSubEl.getClass().getName()));
                    }
                }
                try {
                    lBean = lAnnotated.cons.newInstance(lAttrs);
                }
                catch (Exception e) {
                    throw new MarshallException(String.format("ObjectHelperDirect error while deserializing. Tried to instantiate an object (using annotated constructor) of class: '%1$s'.", lBeanClass.getName()));
                }
            } else {
                lBean = lBeanClass.newInstance();
            }
            if (lId != null) {
                aPool.put(lId, lBean);
            }
            int i = 0;
            block16: for (String lPropname : lProperties.getValue().keySet()) {
                for (Field lFld : lJavaFields) {
                    if (!lFld.getName().equals(lPropname)) continue;
                    JSONObject lSubEl = (JSONObject)lProperties.get(lPropname);
                    Object lFldValue = aMarshall.unmarshallImpl(lSubEl, aPool);
                    try {
                        lFld.setAccessible(true);
                        lFld.set(lBean, lFldValue);
                        ++i;
                        continue block16;
                    }
                    catch (Exception e) {
                        throw new MarshallException(String.format("ObjectHelperDirect error while deserializing. Type error while trying to set the field: '%1$s' in class: '%2$s' with a value of class: '%3$s'.", lFld.getName(), lBeanClass.getName(), lFldValue.getClass().getName()));
                    }
                }
            }
            if (lBean instanceof Serializable) {
                try {
                    Method lReadResolve = lBean.getClass().getDeclaredMethod("readResolve", new Class[0]);
                    if (lReadResolve != null) {
                        lReadResolve.setAccessible(true);
                        lBean = lReadResolve.invoke(lBean, new Object[0]);
                        aPool.put(aObjectElement, lBean);
                    }
                }
                catch (NoSuchMethodException e) {
                }
                catch (Exception e) {
                    throw new MarshallException(String.format("ObjectHelperDirect error while deserializing. Tried to invoke 'readResolve' on instance of class: '%1$s'.", lBean.getClass().getName()));
                }
            }
            return lBean;
        }
        catch (ClassNotFoundException e) {
            String lMsg = "Could not find JavaBean class: " + lBeanClassName;
            throw new MarshallException(lMsg);
        }
        catch (IllegalAccessException e) {
            String lMsg = "IllegalAccessException while trying to instantiate bean: " + lBeanClassName;
            throw new MarshallException(lMsg);
        }
        catch (InstantiationException e) {
            String lMsg = "InstantiationException while trying to instantiate bean: " + lBeanClassName;
            throw new MarshallException(lMsg);
        }
    }

    @Override
    public Class getHelpedClass() {
        return Object.class;
    }

    private static class AnnotatedMethods {
        public Constructor cons;
        public Method serialize;

        public AnnotatedMethods(Constructor aCons, Method aSerialize) {
            this.cons = aCons;
            this.serialize = aSerialize;
        }
    }
}

