/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.validator.impl.predicates;

import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONInteger;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.validator.ValidationException;
import com.sdicons.json.validator.impl.predicates.Predicate;

public class Length
extends Predicate {
    private Integer minLength = null;
    private Integer maxLength = null;

    public Length(String aName, JSONObject aRule) throws ValidationException {
        super(aName, aRule);
        if (aRule.containsKey("min")) {
            JSONValue lMin = aRule.get("min");
            if (!lMin.isInteger()) {
                String lMsg = "Minimum length should be specified using an integer.";
                throw new ValidationException("Minimum length should be specified using an integer.", aRule, "WRONG TYPE");
            }
            this.minLength = ((JSONInteger)lMin).getValue().intValue();
        }
        if (aRule.containsKey("max")) {
            JSONValue lMax = aRule.get("max");
            if (!lMax.isInteger()) {
                String lMsg = "Maximum length should be specified using an integer.";
                throw new ValidationException("Maximum length should be specified using an integer.", aRule, "WRONG TYPE");
            }
            this.maxLength = ((JSONInteger)lMax).getValue().intValue();
        }
    }

    @Override
    public void validate(JSONValue aValue) throws ValidationException {
        int lSize = 0;
        if (aValue.isArray()) {
            lSize = ((JSONArray)aValue).getValue().size();
        } else if (aValue.isString()) {
            lSize = ((JSONString)aValue).getValue().length();
        } else if (aValue.isObject()) {
            lSize = ((JSONObject)aValue).getValue().size();
        } else {
            this.fail("The value is not a JSONArray, JSONString or JSONObject.", aValue);
        }
        if (this.minLength != null && lSize < this.minLength) {
            this.fail("The size (" + lSize + ") is smaller then allowed (" + this.minLength + ").", aValue);
        }
        if (this.maxLength != null && lSize > this.maxLength) {
            this.fail("The size (" + lSize + ") is larger then allowed (" + this.maxLength + ").", aValue);
        }
    }
}

