/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.validator.impl.predicates;

import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.validator.ValidationException;
import com.sdicons.json.validator.Validator;
import com.sdicons.json.validator.impl.ValidatorUtil;
import com.sdicons.json.validator.impl.predicates.Predicate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Let
extends Predicate {
    private HashMap<String, Validator> ruleset;
    private String ref;

    public Let(String aName, JSONObject aRule, HashMap<String, Validator> aRuleset) throws ValidationException {
        super(aName, aRule);
        this.ruleset = aRuleset;
        ValidatorUtil.requiresAttribute(aRule, "rules", JSONArray.class);
        List<JSONValue> lRules = ((JSONArray)aRule.get("rules")).getValue();
        Iterator<JSONValue> i$ = lRules.iterator();
        while (i$.hasNext()) {
            JSONValue lRule;
            JSONValue lVal = lRule = i$.next();
            ValidatorUtil.buildValidator(lVal, this.ruleset);
        }
        ValidatorUtil.requiresAttribute(aRule, "*", JSONString.class);
        this.ref = ((JSONString)aRule.get("*")).getValue();
    }

    @Override
    public void validate(JSONValue aValue) throws ValidationException {
        if (this.ruleset.containsKey(this.ref)) {
            Validator lValidator = this.ruleset.get(this.ref);
            lValidator.validate(aValue);
        } else {
            this.fail("Reference to an unexisting rule: \"" + this.ref + "\".", aValue);
        }
    }
}

