/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import it.tnx.commons.cu;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;

public class CastUtils {
    public static boolean toBoolean(Object val) {
        return CastUtils.toBoolean(val, false);
    }

    public static Boolean toBoolean(Object val, Boolean ifNull) {
        if (val == null) {
            return ifNull;
        }
        if (val instanceof Boolean) {
            return (boolean)((Boolean)val);
        }
        if (val instanceof Number) {
            int ival = ((Number)val).intValue();
            if (ival == 1) {
                return true;
            }
            if (ival == -1) {
                return true;
            }
        } else {
            if (val.toString().equalsIgnoreCase("true")) {
                return true;
            }
            if (val.toString().equals("S")) {
                return true;
            }
            if (val.toString().equals("1")) {
                return true;
            }
            if (val.toString().equals("-1")) {
                return true;
            }
            return false;
        }
        return false;
    }

    public static Integer toInteger(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            try {
                String s = (String)val;
                if (s.indexOf(".") >= 0 && s.indexOf(",") >= 0) {
                    if (s.indexOf(".") > s.indexOf(",")) {
                        s = s.replace(",", "");
                        s = s.substring(0, s.indexOf("."));
                    } else {
                        s = s.replace(".", "");
                        s = s.substring(0, s.indexOf(","));
                    }
                } else if (s.indexOf(".") >= 0) {
                    s = s.substring(0, s.indexOf("."));
                } else if (s.indexOf(",") >= 0) {
                    s = s.substring(0, s.indexOf(","));
                }
                return Integer.parseInt(s);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (val instanceof Number) {
            try {
                return ((Number)val).intValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            return (Integer)val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Integer toInteger0(Object val) {
        Integer ret = 0;
        if (val instanceof Boolean) {
            Boolean valore = (Boolean)val;
            ret = 0;
            if (valore.booleanValue()) {
                ret = 1;
            }
        } else {
            ret = CastUtils.toInteger(val);
            if (ret == null) {
                return 0;
            }
        }
        return ret;
    }

    public static Long toLong(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            try {
                String s = (String)val;
                if (s.indexOf(".") >= 0 && s.indexOf(",") >= 0) {
                    if (s.indexOf(".") > s.indexOf(",")) {
                        s = s.replace(",", "");
                        s = s.substring(0, s.indexOf("."));
                    } else {
                        s = s.replace(".", "");
                        s = s.substring(0, s.indexOf(","));
                    }
                } else if (s.indexOf(".") >= 0) {
                    s = s.substring(0, s.indexOf("."));
                } else if (s.indexOf(",") >= 0) {
                    s = s.substring(0, s.indexOf(","));
                }
                return Long.parseLong(s);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (val instanceof Number) {
            try {
                return ((Number)val).longValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            return (Long)val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long toLong0(Object val) {
        Long ret = 0L;
        if (val instanceof Boolean) {
            Boolean valore = (Boolean)val;
            ret = 0L;
            if (valore.booleanValue()) {
                ret = 1L;
            }
        } else {
            ret = CastUtils.toLong(val);
            if (ret == null) {
                return 0L;
            }
        }
        return ret;
    }

    public static Double toDouble(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            String sval = (String)val;
            NumberFormat f = null;
            f = DecimalFormat.getInstance();
            if (sval.indexOf(".") >= 0 && sval.indexOf(",") >= 0 && sval.lastIndexOf(".") > sval.lastIndexOf(",")) {
                f = DecimalFormat.getInstance(Locale.ENGLISH);
            }
            try {
                return f.parse((String)val).doubleValue();
            }
            catch (ParseException e1) {
                try {
                    return Double.parseDouble((String)val);
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }
        if (val instanceof BigDecimal) {
            try {
                return ((BigDecimal)val).doubleValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        if (val instanceof Integer) {
            try {
                return ((Integer)val).doubleValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        if (val instanceof Long) {
            try {
                return ((Long)val).doubleValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            return (Double)val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Double toDoubleAll(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            String sval = (String)val;
            NumberFormat f = null;
            f = DecimalFormat.getInstance();
            if (sval.indexOf(".") >= 0 && sval.indexOf(",") >= 0) {
                if (sval.lastIndexOf(".") > sval.lastIndexOf(",")) {
                    f = DecimalFormat.getInstance(Locale.ENGLISH);
                }
            } else if (sval.indexOf(".") >= 0) {
                f = DecimalFormat.getInstance(Locale.ENGLISH);
            } else if (sval.indexOf(",") >= 0) {
                f = DecimalFormat.getInstance(Locale.ITALIAN);
            }
            try {
                return f.parse((String)val).doubleValue();
            }
            catch (ParseException e1) {
                try {
                    return Double.parseDouble((String)val);
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }
        if (val instanceof BigDecimal) {
            try {
                return ((BigDecimal)val).doubleValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        if (val instanceof Integer) {
            try {
                return ((Integer)val).doubleValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        if (val instanceof Long) {
            try {
                return ((Long)val).doubleValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            return (Double)val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Double toDoubleEng(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            String sval = (String)val;
            NumberFormat f = null;
            f = DecimalFormat.getInstance(Locale.ENGLISH);
            try {
                return f.parse((String)val).doubleValue();
            }
            catch (ParseException e1) {
                try {
                    return Double.parseDouble((String)val);
                }
                catch (Exception e2) {
                    return 0.0;
                }
            }
        }
        if (val instanceof BigDecimal) {
            try {
                return ((BigDecimal)val).doubleValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        if (val instanceof Integer) {
            try {
                return ((Integer)val).doubleValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        if (val instanceof Long) {
            try {
                return ((Long)val).doubleValue();
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            return (Double)val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Double toDouble0(Object val) {
        Double ret = CastUtils.toDouble(val);
        if (ret == null) {
            return 0.0;
        }
        return ret;
    }

    public static Double toDouble0All(Object val) {
        Double ret = CastUtils.toDoubleAll(val);
        if (ret == null) {
            return 0.0;
        }
        return ret;
    }

    public static Double toDouble0Eng(Object val) {
        Double ret = CastUtils.toDoubleEng(val);
        if (ret == null) {
            return 0.0;
        }
        return ret;
    }

    public static String toString(Object obj) {
        return CastUtils.toString(obj, "");
    }

    public static String toString(Object obj, String ifNull) {
        if (obj == null) {
            return ifNull;
        }
        return String.valueOf(obj);
    }

    public static Date toDate(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof byte[]) {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return f.parse(new String((byte[])val));
            }
            catch (ParseException e1) {
                return null;
            }
        }
        if (val instanceof String) {
            String str = (String)val;
            DateFormat f = null;
            if (str.length() >= 19 && !str.substring(10, 11).equals(" ")) {
                return DatatypeConverter.parseDateTime((String)str).getTime();
            }
            f = str.length() > 9 && str.substring(4, 5).equals("-") && str.substring(7, 8).equals("-") ? new SimpleDateFormat("yyyy-MM-dd") : DateFormat.getDateInstance(3);
            try {
                return f.parse((String)val);
            }
            catch (ParseException e1) {
                return null;
            }
        }
        try {
            return (Date)val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date toDateTime(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof byte[]) {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                return f.parse(new String((byte[])val));
            }
            catch (ParseException e1) {
                return null;
            }
        }
        if (val instanceof String) {
            String str = (String)val;
            DateFormat f = null;
            f = str.length() > 9 && str.substring(4, 5).equals("-") && str.substring(7, 8).equals("-") ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : DateFormat.getDateTimeInstance(3, 3);
            try {
                return f.parse((String)val);
            }
            catch (ParseException e1) {
                return null;
            }
        }
        try {
            return (Date)val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date toDateTimeIta(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof byte[]) {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                return f.parse(new String((byte[])val));
            }
            catch (ParseException e1) {
                return null;
            }
        }
        if (val instanceof String) {
            String str = (String)val;
            SimpleDateFormat f = null;
            if (str.length() > 9 && str.substring(4, 5).equals("-") && str.substring(7, 8).equals("-")) {
                f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    return f.parse(str);
                }
                catch (Exception e) {
                }
            } else {
                ArrayList<SimpleDateFormat> knownPatterns = new ArrayList<SimpleDateFormat>();
                knownPatterns.add(new SimpleDateFormat("dd/MM/yy HH:mm"));
                knownPatterns.add(new SimpleDateFormat("dd/MM/yy HH.mm"));
                knownPatterns.add(new SimpleDateFormat("dd-MM-yy HH:mm"));
                knownPatterns.add(new SimpleDateFormat("dd-MM-yy HH.mm"));
                knownPatterns.add(new SimpleDateFormat("dd.MM.yy HH:mm"));
                knownPatterns.add(new SimpleDateFormat("dd.MM.yy HH.mm"));
                for (SimpleDateFormat pattern : knownPatterns) {
                    try {
                        return new Date(pattern.parse(str).getTime());
                    }
                    catch (ParseException pe) {
                    }
                }
                System.err.println("cu.toDateTimeIta: No known Date format found: " + str);
            }
            return null;
        }
        try {
            return (Date)val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date toDateIta(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            DateFormat f = DateFormat.getDateInstance(3, Locale.ITALIAN);
            try {
                return f.parse((String)val);
            }
            catch (ParseException e1) {
                return null;
            }
        }
        try {
            return (Date)val;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getOnlyNumerics(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer strBuff = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isDigit(c)) continue;
            strBuff.append(c);
        }
        return strBuff.toString();
    }

    public static void main(String[] args) {
        System.out.println(CastUtils.toDate("2017-09-08 16:35:40"));
        System.out.println(CastUtils.toDate("2012-05-29T11:17:04.805-07:00"));
        System.out.println(CastUtils.toInteger0("123"));
        System.out.println(CastUtils.toInteger0("123.12"));
        System.out.println(CastUtils.toInteger0("123,12"));
        System.out.println(CastUtils.toInteger0("1.023,12"));
        System.out.println(CastUtils.toInteger0("1,023.12"));
        System.out.println(CastUtils.toInteger0("1,023"));
        System.out.println(CastUtils.toInteger0("1.023"));
    }

    public static Double d(Object val) {
        return CastUtils.toDouble(val);
    }

    public static Double d0(Object val) {
        return CastUtils.toDouble0(val);
    }

    public static Double d0e(Object val) {
        return CastUtils.toDouble0Eng(val);
    }

    public static Double d0a(Object val) {
        return CastUtils.toDouble0All(val);
    }

    public static String s(Object val) {
        return CastUtils.toString(val);
    }

    public static String s(Object val, String ifNull) {
        return CastUtils.toString(val, ifNull);
    }

    public static Integer i(Object val) {
        return CastUtils.toInteger(val);
    }

    public static Integer i0(Object val) {
        return CastUtils.toInteger0(val);
    }

    public static Long l(Object val) {
        return CastUtils.toLong(val);
    }

    public static Long l0(Object val) {
        return CastUtils.toLong0(val);
    }

    public static Boolean b(Object val) {
        return CastUtils.toBoolean(val);
    }

    public static Date dt(Object val) {
        return CastUtils.toDate(val);
    }

    public static boolean sIsBlank(Object o) {
        return StringUtils.isBlank((String)cu.s(o));
    }
}

