/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    public static final long MILLISECS_PER_MINUTE = 60000L;
    public static final long MILLISECS_PER_HOUR = 3600000L;
    protected static final long MILLISECS_PER_DAY = 86400000L;
    public static DateFormat f8 = new SimpleDateFormat("ddMMyyyy");

    public static int getCurrentYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1);
    }

    public static int getYear(Date data) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        return cal.get(1);
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day);
        cal.set(year, month - 1, day, 0, 0, 0);
        return cal.getTime();
    }

    public static String formatDateTimeFromMillis(Long millis) {
        if (millis == null) {
            return "";
        }
        DateFormat f1 = DateFormat.getDateTimeInstance(3, 3);
        return f1.format(new Date(millis));
    }

    public static String formatDateTime(Date date) {
        if (date == null) {
            return "";
        }
        DateFormat f1 = DateFormat.getDateTimeInstance(3, 3);
        return f1.format(date);
    }

    public static String formatDateTime(Long millis) {
        if (millis == null) {
            return "";
        }
        return DateUtils.formatDateTimeFromMillis(millis);
    }

    public static String formatTime(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat f1 = new SimpleDateFormat("HH:mm");
        return f1.format(date);
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        DateFormat f1 = DateFormat.getDateInstance(3);
        return f1.format(date);
    }

    public static String formatDate8(Date date) {
        if (date == null) {
            return "";
        }
        return f8.format(date);
    }

    public static String formatDateIta(Date date) {
        if (date == null) {
            return "";
        }
        DateFormat f1 = DateFormat.getDateInstance(3, Locale.ITALIAN);
        return f1.format(date);
    }

    public static String formatDateTimeIta(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat f1 = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        return f1.format(date);
    }

    public static boolean dateInRange(Date date, Date start, Date end) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(end);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.add(5, 1);
        cal.add(14, -1);
        end = cal.getTime();
        return !(!start.before(date) && !start.equals(date) || !end.after(date) && !end.equals(date));
    }

    public static int getDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2);
    }

    public static Date getOnlyDate(int year, int month, int day) {
        return DateUtils.getOnlyDate(DateUtils.getDate(year, month, day));
    }

    public static Date getOnlyDate(Date value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static long daysDifference(Date start, Date end) {
        Calendar cals = Calendar.getInstance();
        cals.setTime(start);
        cals.set(11, 0);
        cals.set(12, 0);
        cals.set(13, 0);
        cals.set(14, 0);
        Calendar cale = Calendar.getInstance();
        cale.setTime(end);
        cale.set(11, 0);
        cale.set(12, 0);
        cale.set(13, 0);
        cale.set(14, 0);
        long endL = cale.getTimeInMillis() + (long)cale.getTimeZone().getOffset(cale.getTimeInMillis());
        long startL = cals.getTimeInMillis() + (long)cals.getTimeZone().getOffset(cals.getTimeInMillis());
        return (endL - startL) / 86400000L;
    }

    public static String getDateStartYear() {
        return DateUtils.formatDate(DateUtils.getDate(DateUtils.getCurrentYear(), 1, 1));
    }

    public static boolean isDate(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof String) {
            DateFormat f = DateFormat.getDateInstance(3);
            try {
                f.parse((String)val);
                return true;
            }
            catch (ParseException e1) {
                return false;
            }
        }
        return val instanceof Date;
    }

    public static Date getCurDate(int calendar_field, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.add(calendar_field, amount);
        return cal.getTime();
    }

    public static boolean isFineMese(Date dataScadenza) {
        int year = DateUtils.getYear(dataScadenza);
        int month = DateUtils.getMonth(dataScadenza);
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, 1, 0, 0, 0);
        cal.add(2, 1);
        cal.add(6, -1);
        System.out.println("fine mese di  = " + dataScadenza + " > " + cal.getTime());
        return DateUtils.isSameDate(dataScadenza, cal.getTime());
    }

    public static boolean isSameDate(Date data1, Date data2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(data1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(data2);
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5);
    }
}

