/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import it.tnx.commons.ArraysUtils;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DbCacheResultSet;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.KeyValuePair;
import it.tnx.commons.MicroBench;
import it.tnx.commons.NullValue;
import it.tnx.commons.ReflectUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;

public class DbUtils {
    public static boolean debug = false;
    public static boolean debugStack = false;
    public static boolean bench = false;
    public static boolean conta = false;
    public static boolean cache = false;
    public static Callable resetConn = null;
    public static final String DIFF_TYPE_INSERT = "insert";
    public static final String DIFF_TYPE_UPDATE = "update";
    public static final String DIFF_TYPE_DELETE = "delete";
    public static Map<String, Object> mapcache = new HashMap(){};
    public static Map<String, Integer> mapconta = new HashMap(){};

    public static List tryJpaQuery(Object query) throws Exception {
        int max = 5;
        int tries = 0;
        Object ret = null;
        do {
            ++tries;
            try {
                ret = query.getClass().getMethod("getResultList", new Class[0]).invoke(query, new Object[0]);
                tries = max + 1;
            }
            catch (Exception ex) {
                if (ex.getCause().getCause() instanceof SQLException) {
                    SQLException sqlex = (SQLException)ex.getCause().getCause();
                    String sqlState = sqlex.getSQLState();
                    if (!"08S01".equals(sqlState) && !"40001".equals(sqlState)) {
                        tries = max + 1;
                    }
                    continue;
                }
                throw ex;
            }
        } while (tries < max);
        return (List)ret;
    }

    public static ResultSet tryQuery(Statement stat, String sql) throws Exception {
        DbUtils.conteggio(sql);
        int max = 5;
        int tries = 0;
        ResultSet ret = null;
        do {
            ++tries;
            try {
                ret = stat.executeQuery(sql);
                tries = max + 1;
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof SQLException) {
                    SQLException sqlex = (SQLException)ex.getCause();
                    String sqlState = sqlex.getSQLState();
                    if (!"08S01".equals(sqlState) && !"40001".equals(sqlState)) {
                        tries = max + 1;
                    }
                    continue;
                }
                throw ex;
            }
        } while (tries < max);
        return ret;
    }

    public static boolean tryExecQuery(Connection conn, String sql) throws Exception {
        return DbUtils.tryExecQuery(conn, sql, true, false);
    }

    public static boolean tryExecQuery(Connection conn, String sql, boolean retry) throws Exception {
        return DbUtils.tryExecQuery(conn, sql, retry, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryExecQuery(Connection conn, String sql, boolean retry, boolean ignoresync) throws Exception {
        DbUtils.conteggio(sql);
        if (!ignoresync) {
            try {
                Object retissync = ReflectUtils.runMethod("it.tnx.invoicex.sync.Sync", "isQueryToSync", new Object[]{sql});
                if (((Boolean)retissync).booleanValue()) {
                    Object retexec = ReflectUtils.runMethod("it.tnx.Db", "executeSqlDialogExcSync", new Object[]{conn, sql, false, true});
                    return (Boolean)retexec;
                }
            }
            catch (ClassNotFoundException cex) {
                if (!cex.getMessage().endsWith(".SyncImpl")) {
                    cex.printStackTrace();
                }
            }
            catch (IllegalAccessException cex) {
                System.out.println("");
            }
            catch (IllegalArgumentException cex) {
                System.out.println("");
            }
            catch (InvocationTargetException cex) {
                if (cex.getTargetException() instanceof Exception) {
                    throw (Exception)cex.getTargetException();
                }
                cex.printStackTrace();
                SwingUtils.showErrorMessage(SwingUtils.getActiveFrame(), "Errore:\n" + cex.toString(), "Errore grave", true);
                return false;
            }
            catch (Exception ex) {
                throw ex;
            }
        }
        int max = 5;
        int tries = 0;
        if (!retry) {
            tries = max;
        }
        Statement stat = null;
        boolean ret = false;
        MicroBench mb = null;
        if (bench) {
            mb = new MicroBench(true);
        }
        do {
            ++tries;
            try {
                stat = conn.createStatement();
                stat.execute(sql);
                ret = true;
                if (debug) {
                    DbUtils.dumpSqlTrace(sql);
                }
                tries = max + 1;
            }
            catch (Exception ex) {
                System.err.println("sql di errore:" + sql);
                if (ex.getCause() instanceof SQLException) {
                    SQLException sqlex = (SQLException)ex.getCause();
                    String sqlState = sqlex.getSQLState();
                    if (!"08S01".equals(sqlState) && !"40001".equals(sqlState)) {
                        tries = max + 1;
                    }
                    continue;
                }
                if (ex.getClass().getName().equals("com.mysql.jdbc.exceptions.jdbc4.CommunicationsException")) {
                    if (resetConn != null) {
                        conn = (Connection)resetConn.call();
                    }
                    if (tries >= max) {
                        throw ex;
                    }
                    continue;
                }
                throw ex;
            }
            finally {
                if (stat != null) {
                    stat.close();
                }
            }
        } while (tries < max);
        if (bench) {
            mb.out("BENCH: tryExecQuery");
        }
        return ret;
    }

    public static void dumpSqlTrace(String sql) {
        if (debug) {
            StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
            System.out.println("SQL TRACE SQL: " + sql);
            if (debugStack) {
                for (StackTraceElement e : stacks) {
                    if (!e.getClassName().startsWith("gestioneFatture") && !e.getClassName().startsWith("it.tnx") && !e.getClassName().startsWith("invoicex") || e.getClassName().startsWith("it.tnx.commons.DbUtils")) continue;
                    System.out.println("SQL TRACE: \t\t" + e.toString());
                }
            }
        }
    }

    public static int tryExecQueryWithResult(Connection conn, String sql) throws Exception {
        return DbUtils.tryExecQueryWithResult(conn, sql, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int tryExecQueryWithResult(Connection conn, String sql, boolean ignoresync) throws Exception {
        DbUtils.conteggio(sql);
        if (!ignoresync) {
            try {
                Object retissync = ReflectUtils.runMethod("it.tnx.invoicex.sync.Sync", "isQueryToSync", new Object[]{sql});
                if (((Boolean)retissync).booleanValue()) {
                    Object retexec = ReflectUtils.runMethod("it.tnx.Db", "executeSqlWithResultDialogExcSync", new Object[]{conn, sql, false, true});
                    return (Integer)retexec;
                }
            }
            catch (ClassNotFoundException cex) {
                System.out.println("");
            }
            catch (IllegalAccessException cex) {
                System.out.println("");
            }
            catch (IllegalArgumentException cex) {
                System.out.println("");
            }
            catch (InvocationTargetException cex) {
                throw (Exception)cex.getTargetException();
            }
            catch (Exception ex) {
                throw ex;
            }
        }
        int max = 5;
        int tries = 0;
        Statement stat = null;
        boolean ret = false;
        int uc = -1;
        do {
            ++tries;
            try {
                stat = conn.createStatement();
                ret = stat.execute(sql);
                DbUtils.dumpSqlTrace(sql);
                uc = stat.getUpdateCount();
                tries = max + 1;
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof SQLException) {
                    SQLException sqlex = (SQLException)ex.getCause();
                    String sqlState = sqlex.getSQLState();
                    if (!"08S01".equals(sqlState) && !"40001".equals(sqlState)) {
                        tries = max + 1;
                    }
                    continue;
                }
                if (ex.getClass().getName().equals("com.mysql.jdbc.exceptions.jdbc4.CommunicationsException")) {
                    if (resetConn != null) {
                        conn = (Connection)resetConn.call();
                    }
                    continue;
                }
                throw ex;
            }
            finally {
                if (stat != null) {
                    stat.close();
                }
            }
        } while (tries < max);
        return uc;
    }

    public static ResultSet tryOpenResultSet(Connection conn, String sql) throws Exception {
        DbUtils.conteggio(sql);
        if (DbUtils.checkCache(sql)) {
            return (ResultSet)DbUtils.fromCache(sql);
        }
        int max = 5;
        int tries = 0;
        Statement stat = null;
        ResultSet ret = null;
        MicroBench mb = null;
        if (bench) {
            mb = new MicroBench(true);
        }
        DbUtils.dumpSqlTrace(sql);
        do {
            ++tries;
            try {
                stat = conn.createStatement();
                ret = stat.executeQuery(sql);
                tries = max + 1;
            }
            catch (Exception ex) {
                System.out.println("sql di errore: " + sql);
                System.out.println("ex.getClass().getName() = " + ex.getClass().getName());
                if (ex.getCause() instanceof SQLException) {
                    SQLException sqlex = (SQLException)ex.getCause();
                    String sqlState = sqlex.getSQLState();
                    if (!"08S01".equals(sqlState) && !"40001".equals(sqlState)) {
                        tries = max + 1;
                    }
                    continue;
                }
                if (ex.getClass().getName().equals("com.mysql.jdbc.exceptions.jdbc4.CommunicationsException")) {
                    if (resetConn != null) {
                        conn = (Connection)resetConn.call();
                    }
                    continue;
                }
                throw ex;
            }
        } while (tries < max);
        if (bench) {
            mb.out("BENCH: tryOpenResultSet");
        }
        DbUtils.inCache(sql, ret);
        return ret;
    }

    public static ResultSet tryOpenResultSetEditable(Connection conn, String sql) throws Exception {
        DbUtils.conteggio(sql);
        int max = 5;
        int tries = 0;
        Statement stat = null;
        ResultSet ret = null;
        do {
            ++tries;
            try {
                stat = conn.createStatement(1004, 1008);
                stat.setFetchSize(50);
                ret = stat.executeQuery(sql);
                tries = max + 1;
            }
            catch (Exception ex) {
                try {
                    if (ex.getCause() instanceof SQLException) {
                        SQLException sqlex = (SQLException)ex.getCause();
                        String sqlState = sqlex.getSQLState();
                        if (!"08S01".equals(sqlState) && !"40001".equals(sqlState)) {
                            tries = max + 1;
                        }
                        continue;
                    }
                    if (ex.getClass().getName().equals("com.mysql.jdbc.exceptions.jdbc4.CommunicationsException")) {
                        if (resetConn != null) {
                            conn = (Connection)resetConn.call();
                        }
                        continue;
                    }
                    if (stat != null) {
                        stat.close();
                    }
                    throw ex;
                }
                catch (Exception ex0) {
                    if (stat != null) {
                        stat.close();
                    }
                    throw ex0;
                }
            }
        } while (tries < max);
        return ret;
    }

    public static ResultSet tryOpenResultSetEditableSensitive(Connection conn, String sql) throws Exception {
        DbUtils.conteggio(sql);
        int max = 5;
        int tries = 0;
        Statement stat = null;
        ResultSet ret = null;
        do {
            ++tries;
            try {
                stat = conn.createStatement(1005, 1008);
                stat.setFetchSize(50);
                ret = stat.executeQuery(sql);
                tries = max + 1;
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof SQLException) {
                    SQLException sqlex = (SQLException)ex.getCause();
                    String sqlState = sqlex.getSQLState();
                    if (!"08S01".equals(sqlState) && !"40001".equals(sqlState)) {
                        tries = max + 1;
                    }
                    continue;
                }
                if (ex.getClass().getName().equals("com.mysql.jdbc.exceptions.jdbc4.CommunicationsException")) {
                    if (resetConn != null) {
                        conn = (Connection)resetConn.call();
                    }
                    continue;
                }
                throw ex;
            }
        } while (tries < max);
        return ret;
    }

    public static Connection getMysqlJdbcConn(String server, String database, String user, String password) throws Exception {
        return DbUtils.getMysqlJdbcConn(server, database, user, password, false);
    }

    public static Connection getMysqlJdbcConn(String server, String database, String user, String password, boolean profile) throws Exception {
        return DbUtils.getMysqlJdbcConn(server, database, user, password, false, false);
    }

    public static Connection getMysqlJdbcConn(String server, String database, String user, String password, boolean profile, boolean compression) throws Exception {
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        String url = "jdbc:mysql://" + server + "/" + database + "?jdbcCompliantTruncation=false&zeroDateTimeBehavior=round&emptyStringsConvertToZero=true&autoReconnect=true&allowMultiQueries=true";
        if (profile) {
            url = url + "&profileSql=true";
        }
        url = compression ? url + "&useCompression=true" : url + "&useCompression=false";
        url = url + "&connectTimeout=5000";
        url = url + "&socketTimeout=10000";
        url = url + "&useAffectedRows=true";
        Connection conn = DriverManager.getConnection(url, user, password);
        return conn;
    }

    public static Object getObject(Connection conn, String sql) throws Exception {
        return DbUtils.getObject(conn, sql, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObject(Connection conn, String sql, boolean throwsExc) throws Exception {
        if (DbUtils.checkCache(sql + "|obj")) {
            return DbUtils.fromCache(sql + "|obj");
        }
        ResultSet r = null;
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            if (r.next()) {
                Object o = r.getObject(1);
                DbUtils.inCache(sql + "|obj", o);
                Object object = o;
                return object;
            }
            if (throwsExc) {
                throw new Exception("record non trovato sql:" + sql);
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            if (r != null) {
                DbUtils.close(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getString(Connection conn, String sql) {
        String string;
        if (DbUtils.checkCache(sql + "|str")) {
            return (String)DbUtils.fromCache(sql + "|str");
        }
        ResultSet r = null;
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            if (!r.next()) return null;
            String o = r.getString(1);
            DbUtils.inCache(sql + "|str", o);
            string = o;
            if (r == null) return string;
        }
        catch (Exception exception) {
            // empty catch block
            return null;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        DbUtils.close(r);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getList(Connection conn, String sql) throws Exception {
        DbUtils.conteggio(sql);
        ResultSet r = null;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            while (r.next()) {
                list.add(r.getObject(1));
            }
            ArrayList<Object> arrayList = list;
            return arrayList;
        }
        finally {
            if (r != null) {
                DbUtils.close(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getListInt(Connection conn, String sql) throws Exception {
        DbUtils.conteggio(sql);
        ResultSet r = null;
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            while (r.next()) {
                list.add(r.getInt(1));
            }
            ArrayList<Integer> arrayList = list;
            return arrayList;
        }
        finally {
            if (r != null) {
                DbUtils.close(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Object[]> getListArray(Connection conn, String sql) throws Exception {
        DbUtils.conteggio(sql);
        ResultSet r = null;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            while (r.next()) {
                list.add(DbUtils.getRow(r));
            }
            ArrayList<Object[]> arrayList = list;
            return arrayList;
        }
        finally {
            if (r != null) {
                DbUtils.close(r);
            }
        }
    }

    public static ArrayList<Object[]> getListArray(ResultSet r) throws Exception {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        while (r.next()) {
            list.add(DbUtils.getRow(r));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Object[]> getListKV(Connection conn, String sql) throws Exception {
        DbUtils.conteggio(sql);
        ResultSet r = null;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            while (r.next()) {
                list.add(new Object[]{r.getObject(1), r.getObject(2)});
            }
            ArrayList<Object[]> arrayList = list;
            return arrayList;
        }
        finally {
            if (r != null) {
                DbUtils.close(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<KeyValuePair> getListKeyValuePair(Connection conn, String sql) throws Exception {
        DbUtils.conteggio(sql);
        ResultSet r = null;
        ArrayList<KeyValuePair> list = new ArrayList<KeyValuePair>();
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            while (r.next()) {
                list.add(new KeyValuePair(r.getObject(1), r.getObject(2)));
            }
            ArrayList<KeyValuePair> arrayList = list;
            return arrayList;
        }
        finally {
            if (r != null) {
                DbUtils.close(r);
            }
        }
    }

    public static Map getMap(Connection conn, String sql) throws Exception {
        return DbUtils.getListMap(conn, sql, false).get(0);
    }

    public static ArrayList<Map> getListMap(Connection conn, String sql) throws Exception {
        return DbUtils.getListMap(conn, sql, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Map> getListMap(Connection conn, String sql, boolean date_as_string) throws Exception {
        DbUtils.conteggio(sql);
        if (DbUtils.checkCache(sql + "|listmap")) {
            return (ArrayList)DbUtils.fromCache(sql + "|listmap");
        }
        ResultSet r = null;
        ArrayList<Map> list = new ArrayList<Map>();
        MicroBench mb = null;
        if (bench) {
            mb = new MicroBench(true);
        }
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            ResultSetMetaData m = r.getMetaData();
            while (r.next()) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                for (int i = 0; i < m.getColumnCount(); ++i) {
                    Object o = r.getObject(i + 1);
                    if (date_as_string && (o instanceof java.util.Date || o instanceof Timestamp || o instanceof Date)) {
                        o = FormatUtils.formatMysqlTimestamp((java.util.Date)o);
                    }
                    map.put(m.getColumnLabel(i + 1), o);
                }
                list.add(map);
            }
            if (bench) {
                mb.out("BENCH: getListMap");
            }
            DbUtils.inCache(sql + "|listmap", list);
            ArrayList<Map> arrayList = list;
            return arrayList;
        }
        finally {
            if (r != null) {
                DbUtils.close(r);
            }
        }
    }

    public static HashMap getListMapMap(Connection conn, String sql, String pk) throws Exception {
        return DbUtils.getListMapMap(conn, sql, pk, false);
    }

    public static HashMap getListMapMap(Connection conn, String sql, String pk, boolean forcePkToInteger) throws Exception {
        return DbUtils.getListMapMap(conn, sql, pk, forcePkToInteger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getListMapMap(Connection conn, String sql, String pk, boolean forcePkToInteger, boolean forcePkToString) throws Exception {
        DbUtils.conteggio(sql);
        ResultSet r = null;
        LinkedHashMap list = new LinkedHashMap();
        MicroBench mb = null;
        if (bench) {
            mb = new MicroBench(true);
        }
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            ResultSetMetaData m = r.getMetaData();
            while (r.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < m.getColumnCount(); ++i) {
                    map.put(m.getColumnLabel(i + 1), r.getObject(i + 1));
                }
                if (forcePkToInteger) {
                    list.put(cu.i(map.get(pk)), map);
                    continue;
                }
                if (forcePkToString) {
                    list.put(cu.s(map.get(pk)), map);
                    continue;
                }
                list.put(map.get(pk), map);
            }
            if (bench) {
                mb.out("BENCH: getListMapMap");
            }
            LinkedHashMap linkedHashMap = list;
            return linkedHashMap;
        }
        finally {
            if (r != null) {
                DbUtils.close(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Object, List<Map>> getMapListMap(Connection conn, String sql, String pk, boolean forcePkToInteger) throws Exception {
        DbUtils.conteggio(sql);
        ResultSet r = null;
        HashMap<Object, List<Map>> list = new HashMap<Object, List<Map>>();
        MicroBench mb = null;
        if (bench) {
            mb = new MicroBench(true);
        }
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            ResultSetMetaData m = r.getMetaData();
            while (r.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < m.getColumnCount(); ++i) {
                    map.put(m.getColumnLabel(i + 1), r.getObject(i + 1));
                }
                Integer k = null;
                k = forcePkToInteger ? CastUtils.toInteger(map.get(pk)) : (Integer)map.get(pk);
                List<Object> listn = null;
                listn = list.get(k) instanceof List ? list.get(k) : new ArrayList();
                listn.add(map);
                list.put(k, listn);
            }
            if (bench) {
                mb.out("BENCH: getMapListMap");
            }
            HashMap<Object, List<Map>> hashMap = list;
            return hashMap;
        }
        finally {
            if (r != null) {
                DbUtils.close(r);
            }
        }
    }

    public static List<Map> getListMapFromTableModel(TableModel model) throws Exception {
        return DbUtils.getListMapFromTableModel(model, null, null, null, null);
    }

    public static List<Map> getListMapFromTableModel(TableModel model, String[] includere, String[] escludere, Map tras, Map fixed) throws Exception {
        ArrayList<Map> list = new ArrayList<Map>();
        List<String> listinc = includere == null ? null : Arrays.asList(includere);
        List<String> listesc = escludere == null ? null : Arrays.asList(escludere);
        MicroBench mb = null;
        if (bench) {
            mb = new MicroBench(true);
        }
        for (int r = 0; r < model.getRowCount(); ++r) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < model.getColumnCount(); ++i) {
                String colname = model.getColumnName(i);
                boolean inc = true;
                if (listinc != null) {
                    inc = false;
                    if (listinc.contains(colname)) {
                        inc = true;
                    }
                }
                if (listesc != null && listesc.contains(colname)) {
                    inc = false;
                }
                if (!inc) continue;
                if (tras != null && tras.containsKey(colname)) {
                    colname = cu.s(tras.get(colname));
                }
                map.put(colname, model.getValueAt(r, i));
            }
            if (fixed != null) {
                Set fixedkeys = fixed.keySet();
                for (Object fkey : fixedkeys) {
                    map.put((String)fkey, fixed.get(fkey));
                }
            }
            list.add(map);
        }
        if (bench) {
            mb.out("BENCH: getListMapFromTableModel");
        }
        return list;
    }

    public static HashMap getListMapMapFromTableModel(TableModel model, String pk) throws Exception {
        return DbUtils.getListMapMapFromTableModel(model, pk, null, null, null, null);
    }

    public static HashMap getListMapMapFromTableModel(TableModel model, String pk, String[] includere, String[] escludere, Map tras, Map fixed) throws Exception {
        HashMap list = new HashMap();
        List<String> listinc = includere == null ? null : Arrays.asList(includere);
        List<String> listesc = escludere == null ? null : Arrays.asList(escludere);
        MicroBench mb = null;
        if (bench) {
            mb = new MicroBench(true);
        }
        for (int r = 0; r < model.getRowCount(); ++r) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < model.getColumnCount(); ++i) {
                String colname = model.getColumnName(i);
                boolean inc = true;
                if (listinc != null) {
                    inc = false;
                    if (listinc.contains(colname)) {
                        inc = true;
                    }
                }
                if (listesc != null && listesc.contains(colname)) {
                    inc = false;
                }
                if (!inc) continue;
                if (tras != null && tras.containsKey(colname)) {
                    colname = cu.s(tras.get(colname));
                }
                map.put(colname, model.getValueAt(r, i));
            }
            if (fixed != null) {
                Set fixedkeys = fixed.keySet();
                for (Object fkey : fixedkeys) {
                    map.put((String)fkey, fixed.get(fkey));
                }
            }
            if (map.get(pk) != null) {
                list.put(map.get(pk), map);
                continue;
            }
            list.put(new NullValue(), map);
        }
        if (bench) {
            mb.out("BENCH: getListMapFromTableModel");
        }
        return list;
    }

    public static Map getListMapMapFromList(List<Map> list, String pk) throws Exception {
        return DbUtils.getListMapMapFromList(list, pk, null, null, null, null);
    }

    public static Map getListMapMapFromList(List<Map> list, String pk, String[] includere, String[] escludere, Map tras, Map fixed) throws Exception {
        LinkedHashMap list_out = new LinkedHashMap();
        List<String> listinc = includere == null ? null : Arrays.asList(includere);
        List<String> listesc = escludere == null ? null : Arrays.asList(escludere);
        MicroBench mb = null;
        if (bench) {
            mb = new MicroBench(true);
        }
        for (int r = 0; r < list.size(); ++r) {
            HashMap map = new HashMap();
            for (Object key : list.get(r).keySet()) {
                String colname = cu.s(key);
                boolean inc = true;
                if (listinc != null) {
                    inc = false;
                    if (listinc.contains(colname)) {
                        inc = true;
                    }
                }
                if (listesc != null && listesc.contains(colname)) {
                    inc = false;
                }
                if (!inc) continue;
                if (tras != null && tras.containsKey(colname)) {
                    colname = cu.s(tras.get(colname));
                }
                map.put(colname, list.get(r).get(key));
            }
            if (fixed != null) {
                Set fixedkeys = fixed.keySet();
                for (Object fkey : fixedkeys) {
                    map.put((String)fkey, fixed.get(fkey));
                }
            }
            if (map.get(pk) != null) {
                list_out.put(map.get(pk), map);
                continue;
            }
            list_out.put(new NullValue(), map);
        }
        if (bench) {
            mb.out("BENCH: getListMapMapFromList");
        }
        return list_out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getListMapKV(Connection conn, String sql) throws Exception {
        DbUtils.conteggio(sql);
        ResultSet r = null;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            ResultSetMetaData m = r.getMetaData();
            while (r.next()) {
                map.put(r.getObject(1), r.getObject(2));
            }
            HashMap<Object, Object> hashMap = map;
            return hashMap;
        }
        finally {
            if (r != null) {
                DbUtils.close(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containRows(Connection conn, String sql) throws Exception {
        DbUtils.conteggio(sql);
        ResultSet r = null;
        try {
            r = DbUtils.tryOpenResultSet(conn, sql);
            if (r.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (r != null) {
                DbUtils.close(r);
            }
        }
    }

    public static boolean existTable(Connection conn, String table) throws SQLException {
        try {
            ArrayList tables = DbUtils.getList(conn, "show tables");
            if (tables.contains(table)) {
                return true;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(DbUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public static boolean existColumn(ResultSet r, String column) throws SQLException {
        ResultSetMetaData m = r.getMetaData();
        for (int i = 1; i <= m.getColumnCount(); ++i) {
            if (!m.getColumnLabel(i).equalsIgnoreCase(column)) continue;
            return true;
        }
        return false;
    }

    public static boolean existColumn(Connection conn, String table, String column) throws Exception {
        ArrayList fields = dbu.getList(conn, "describe " + table);
        return fields.contains(column);
    }

    public static String pc2(java.util.Date campo, int tipoCampo) {
        if (tipoCampo == 91) {
            SimpleDateFormat myFormat = new SimpleDateFormat("dd/MM/yy");
            SimpleDateFormat myFormatSql = new SimpleDateFormat("yyyy-MM-dd");
            myFormat.setLenient(false);
            try {
                return "'" + myFormatSql.format(campo) + "'";
            }
            catch (Exception err) {
                System.out.println("errore in campo: " + campo);
                err.printStackTrace();
                return "0";
            }
        }
        if (tipoCampo == 92) {
            SimpleDateFormat myFormatSql = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                return "'" + myFormatSql.format(campo) + "'";
            }
            catch (Exception err) {
                System.out.println("errore in campo: " + campo);
                err.printStackTrace();
                return "0";
            }
        }
        return "'" + DbUtils.aa(campo.toString()) + "'";
    }

    public static String aaOld(String stringa) {
        if (stringa != null && stringa.length() > 0) {
            stringa = StringUtils.replace((String)stringa, (String)"\\'", (String)"'");
            stringa = StringUtils.replace((String)stringa, (String)"'", (String)"\\'");
            return stringa;
        }
        return "";
    }

    public static String aa(String stringa) {
        if (stringa != null && stringa.length() > 0) {
            stringa = StringUtils.replace((String)stringa, (String)"\\'", (String)"'");
            stringa = StringUtils.replace((String)stringa, (String)"\\", (String)"\\\\");
            stringa = StringUtils.replace((String)stringa, (String)"'", (String)"\\'");
            stringa = StringUtils.replace((String)stringa, (String)"\u0000", (String)"\\0");
            stringa = StringUtils.replace((String)stringa, (String)"\b", (String)"\\b");
            stringa = StringUtils.replace((String)stringa, (String)"\n", (String)"\\n");
            stringa = StringUtils.replace((String)stringa, (String)"\r", (String)"\\r");
            stringa = StringUtils.replace((String)stringa, (String)"\t", (String)"\\t");
            stringa = StringUtils.replace((String)stringa, (String)"\u001a", (String)"\\Z");
            return stringa;
        }
        return "";
    }

    public static String aaAcc(String stringa) {
        if (stringa != null && stringa.length() > 0) {
            stringa = StringUtils.replace((String)stringa, (String)"\\'", (String)"'");
            stringa = StringUtils.replace((String)stringa, (String)"'", (String)"''");
            return stringa;
        }
        return "";
    }

    public static String aaJava(String str) {
        String temp = StringUtils.replace((String)str, (String)"\\'", (String)"'");
        temp = StringUtils.replace((String)str, (String)"'", (String)"\\\\'");
        temp = StringUtils.replace((String)str, (String)"\n", (String)"\\n\" +\n\"");
        return temp;
    }

    public static String dbCompare(String host1, String db1, String user1, String passwd1, String host2, String db2, String user2, String passwd2) {
        return DbUtils.dbCompare(host1, db1, user1, passwd1, host2, db2, user2, passwd2, null, null);
    }

    public static String dbCompare(String host1, String db1, String user1, String passwd1, String host2, String db2, String user2, String passwd2, String tab1, String tab2) {
        try {
            String s;
            Connection c1 = DbUtils.getMysqlJdbcConn(host1, db1, user1, passwd1);
            Connection c2 = DbUtils.getMysqlJdbcConn(host2, db2, user2, passwd2);
            ArrayList tables1a = null;
            ArrayList tables2a = null;
            String ret = "";
            if (tab1 == null) {
                ResultSet tables1 = c1.getMetaData().getTables("", "", "", null);
                ResultSet tables2 = c2.getMetaData().getTables("", "", "", null);
                tables1a = ArraysUtils.toArrayList(tables1, "TABLE_NAME");
                tables2a = ArraysUtils.toArrayList(tables2, "TABLE_NAME");
            } else {
                tables1a = new ArrayList();
                tables1a.add(tab1);
                tables2a = new ArrayList();
                tables2a.add(tab2);
            }
            ArrayList<String> tab_mancanti_in_2 = new ArrayList<String>();
            ArrayList<String> tab_mancanti_in_1 = new ArrayList<String>();
            TreeSet tab_comuni = new TreeSet();
            tab_comuni.addAll(tables1a);
            tab_comuni.addAll(tables2a);
            for (Object o : tables1a) {
                s = (String)o;
                if (ArraysUtils.containString(s, tables2a)) continue;
                tab_mancanti_in_2.add(s);
                tab_comuni.remove(s);
            }
            for (Object o : tables2a) {
                s = (String)o;
                if (ArraysUtils.containString(s, tables1a)) continue;
                tab_mancanti_in_1.add(s);
                tab_comuni.remove(s);
            }
            System.out.println("tabelle mancanti in 2");
            System.err.println(ArraysUtils.toString(tab_mancanti_in_2, "|"));
            System.out.println("tabelle mancanti in 1");
            System.err.println(ArraysUtils.toString(tab_mancanti_in_1, "|"));
            System.out.println("tabelle comuni");
            System.out.println(ArraysUtils.toString(tab_comuni, "|"));
            for (Object otab : tab_comuni) {
                String tab = (String)otab;
                System.out.println("tab:" + tab);
                String sql = "select * from " + tab + " limit 0";
                ResultSet r1 = DbUtils.tryOpenResultSet(c1, sql);
                ResultSet r2 = DbUtils.tryOpenResultSet(c2, sql);
                ResultSetMetaData m1 = r1.getMetaData();
                ResultSetMetaData m2 = r2.getMetaData();
                for (int c = 1; c <= m2.getColumnCount(); ++c) {
                    String colname1 = m2.getColumnName(c);
                    boolean found = false;
                    int ic2 = 0;
                    for (ic2 = 1; ic2 <= m1.getColumnCount(); ++ic2) {
                        if (!m1.getColumnName(ic2).equalsIgnoreCase(colname1)) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        String coltype2;
                        String coltype1 = m2.getColumnTypeName(c);
                        if (coltype1.equalsIgnoreCase(coltype2 = m1.getColumnTypeName(ic2))) {
                            int colprec2 = m2.getPrecision(c);
                            int colprec1 = m1.getPrecision(ic2);
                            if (colprec1 == colprec2) continue;
                            System.err.println(colname1 + " precisione diversa dal 2 -> " + colprec1 + " != " + colprec2);
                            ret = ret + "\nalter table " + tab1 + " modify column " + DbUtils.getColumnDef(c2, tab2, colname1) + ";";
                            continue;
                        }
                        System.err.println(colname1 + " tipo diverso dal 2 -> " + coltype1 + " != " + coltype2);
                        ret = ret + "\nalter table " + tab1 + " modify column " + DbUtils.getColumnDef(c2, tab2, colname1) + ";";
                        continue;
                    }
                    System.err.println(colname1 + " non trovata nel 2");
                    ret = ret + "\nalter table " + tab1 + " add column " + DbUtils.getColumnDef(c2, tab2, colname1) + ";";
                }
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object[] getRow(ResultSet r) throws Exception {
        int cols = r.getMetaData().getColumnCount();
        Object[] row = new Object[cols];
        for (int c = 1; c <= cols; ++c) {
            row[c - 1] = r.getObject(c);
        }
        return row;
    }

    public static Map getRowMap(ResultSet r) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ResultSetMetaData m = r.getMetaData();
        int cols = m.getColumnCount();
        boolean norow = r.isBeforeFirst();
        System.out.println(r.isAfterLast());
        System.out.println(r.isBeforeFirst());
        for (int c = 1; c <= cols; ++c) {
            Object val = null;
            if (!norow) {
                val = r.getObject(c);
            }
            map.put(m.getColumnLabel(c), val);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpResultSet(Connection conn, String sql) {
        ResultSet r = null;
        ResultSetMetaData m = null;
        try {
            int i;
            r = DbUtils.tryOpenResultSet(conn, sql);
            m = r.getMetaData();
            for (i = 1; i <= m.getColumnCount(); ++i) {
                System.out.print(FormatUtils.fill(m.getColumnLabel(i), Math.min(m.getColumnDisplaySize(i), 50)));
                System.out.print("|");
            }
            System.out.println("");
            while (r.next()) {
                for (i = 1; i <= m.getColumnCount(); ++i) {
                    System.out.print(FormatUtils.fill(r.getString(i), Math.min(m.getColumnDisplaySize(i), 50)));
                    System.out.print("|");
                }
                System.out.println("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DbUtils.close(r);
        }
    }

    public static String prepareSqlFromMap(Map mkeyvalue) {
        return DbUtils.prepareSqlFromMap(mkeyvalue, ", ");
    }

    public static String prepareSqlFromMap(Map mkeyvalue, String separator) {
        String sql = "";
        Set set = mkeyvalue.keySet();
        Iterator iter = set.iterator();
        int max = set.size();
        int conta = 0;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = mkeyvalue.get(key);
            sql = sql + " `" + key + "` = ";
            sql = sql + DbUtils.sql(value);
            if (++conta >= max) continue;
            sql = sql + separator;
        }
        return sql;
    }

    public static String sql(Object value) {
        String sql = "";
        if (value instanceof String) {
            sql = sql + "'" + DbUtils.aa((String)value) + "'";
        } else if (value instanceof Integer) {
            sql = sql + "(" + value + ")";
        } else if (value instanceof Float || value instanceof Double || value instanceof BigInteger || value instanceof Long || value instanceof BigDecimal) {
            sql = sql + "(" + value + ")";
        } else if (value instanceof Timestamp) {
            value = FormatUtils.formatMysqlTimestamp((Timestamp)value);
            sql = sql + "'" + value + "'";
        } else if (value instanceof Date) {
            value = FormatUtils.formatMysqlDate((Date)value);
            sql = sql + "'" + value + "'";
        } else if (value instanceof java.util.Date) {
            value = FormatUtils.formatMysqlDate((java.util.Date)value);
            sql = sql + "'" + value + "'";
        } else if (value instanceof Boolean) {
            sql = sql + "'" + value + "'";
        } else if (value instanceof NullValue) {
            sql = sql + "null";
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            if (bytes.length == 0) {
                return "null";
            }
            sql = sql + "0x" + DbUtils.bytesToHex(bytes);
        } else if (value == null) {
            sql = sql + "null";
        } else {
            System.err.println("sql(): " + value.getClass().toString() + " non riconosciuto");
            sql = sql + "'" + DbUtils.aa((String)value) + "'";
        }
        return sql;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String h = Integer.toHexString(bytes[i] & 0xFF);
            if (h.length() == 1) {
                h = "0" + h;
            }
            buffer.append(h);
        }
        return buffer.toString().toUpperCase();
    }

    public static String bytesToHex(byte[] bytes, int offset, int length) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            String h = Integer.toHexString(bytes[i + offset] & 0xFF);
            if (h.length() == 1) {
                h = "0" + h;
            }
            buffer.append(h);
        }
        return buffer.toString().toUpperCase();
    }

    public static byte[] hexToByte(String hex) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        for (int i = 2; i < hex.length(); ++i) {
            String hexp = hex.substring(i, i + 2);
            int b = Integer.decode("0x" + hexp);
            bout.write(b);
            ++i;
        }
        try {
            return bout.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String prepareSqlForCopy(Map mkeyvalueFrom, Map tras) {
        String sql = "";
        Set set = tras.keySet();
        Iterator iter = set.iterator();
        int max = set.size();
        int conta = 0;
        while (iter.hasNext()) {
            ++conta;
            String key = (String)iter.next();
            Object value = mkeyvalueFrom.get(key);
            sql = sql + " " + tras.get(key) + " = ";
            if (value instanceof String) {
                sql = sql + "'" + DbUtils.aa((String)value) + "'";
            } else if (value instanceof Integer) {
                sql = sql + "(" + value + ")";
            } else if (value instanceof Float || value instanceof Double || value instanceof BigInteger || value instanceof Long || value instanceof BigDecimal) {
                sql = sql + "(" + value + ")";
            } else if (value instanceof Timestamp) {
                value = FormatUtils.formatMysqlTimestamp((Timestamp)value);
                sql = sql + "'" + value + "'";
            } else if (value instanceof Date) {
                value = FormatUtils.formatMysqlDate((Date)value);
                sql = sql + "'" + value + "'";
            } else if (value instanceof java.util.Date) {
                value = FormatUtils.formatMysqlDate((java.util.Date)value);
                sql = sql + "'" + value + "'";
            } else if (value instanceof Boolean) {
                sql = sql + "'" + value + "'";
            } else if (value == null) {
                sql = sql + "null";
            } else {
                System.err.println("prepareSqlForCopy: " + value.getClass().toString() + " non riconosciuto");
                sql = sql + "'" + DbUtils.aa((String)value) + "'";
            }
            if (conta >= max) continue;
            sql = sql + ",";
        }
        return sql;
    }

    public static String prepareSqlFromMapJava(Map mkeyvalue) {
        String sql = "";
        Set set = mkeyvalue.keySet();
        Iterator iter = set.iterator();
        int max = set.size();
        int conta = 0;
        while (iter.hasNext()) {
            ++conta;
            String key = (String)iter.next();
            Object value = mkeyvalue.get(key);
            sql = sql + " " + key + " = ";
            if (value instanceof String) {
                sql = sql + "'" + DbUtils.aaJava((String)value) + "'";
            } else if (value instanceof Integer) {
                sql = sql + "(" + value + ")";
            } else if (value instanceof Float || value instanceof Double || value instanceof BigInteger || value instanceof Long || value instanceof BigDecimal) {
                sql = sql + "(" + value + ")";
            } else if (value instanceof Timestamp) {
                FormatUtils.formatMysqlTimestamp((Timestamp)value);
                sql = sql + "'" + value + "'";
            } else if (value == null) {
                sql = sql + "null";
            } else {
                System.err.println("prepareSqlFromMap: " + value.getClass().toString() + " non riconosciuto");
                sql = sql + "'" + DbUtils.aaJava((String)value) + "'";
            }
            if (conta >= max) continue;
            sql = sql + ",";
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCreateTable(String tableName, Connection dbConnection) {
        ResultSet show = null;
        Statement stat = null;
        String sqlCreate = "";
        int campiPK = 0;
        try {
            stat = dbConnection.createStatement();
            show = stat.executeQuery("show columns from " + tableName);
            sqlCreate = "create table " + tableName + " (\n";
            String sqlPrimary = "PRIMARY KEY (";
            while (show.next()) {
                if (show.getString("Key").equals("PRI")) {
                    sqlPrimary = sqlPrimary + show.getString("Field") + ",";
                    ++campiPK;
                }
                String sqlDefault = "";
                if (StringUtils.isNotEmpty((String)show.getString("Default"))) {
                    sqlDefault = show.getString("Default").indexOf("CURRENT") >= 0 ? "DEFAULT " + show.getString("Default") + "" : "DEFAULT '" + show.getString("Default") + "'";
                }
                String sqlNull = "NOT NULL";
                if (StringUtils.isNotEmpty((String)show.getString("Null"))) {
                    sqlNull = "NULL";
                }
                String sqlExtra = " " + show.getString("Extra");
                sqlCreate = sqlCreate + "   `" + show.getString("Field") + "` " + show.getString("Type") + " " + sqlNull + sqlExtra + " " + sqlDefault + ",\n";
            }
            sqlPrimary = sqlPrimary.substring(0, sqlPrimary.length() - 1) + ")";
            sqlCreate = campiPK > 0 ? sqlCreate + sqlPrimary + ")" : sqlCreate.substring(0, sqlCreate.length() - 2) + ")";
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        finally {
            try {
                if (show != null) {
                    show.close();
                }
            }
            catch (Exception e) {}
            try {
                if (stat != null) {
                    stat.close();
                }
            }
            catch (Exception e) {}
        }
        return sqlCreate;
    }

    public static void main(String[] args) {
    }

    private static String getColumnDef(Connection c1, String tab1, String colname1) throws Exception {
        ResultSet r = DbUtils.tryOpenResultSet(c1, "show columns from " + tab1 + " where Field = '" + DbUtils.aa(colname1) + "'");
        String sql = "";
        String sqlDefault = "";
        if (r.next()) {
            if (StringUtils.isNotEmpty((String)r.getString("Default"))) {
                sqlDefault = r.getString("Default").indexOf("CURRENT") >= 0 ? "DEFAULT " + r.getString("Default") + "" : "DEFAULT '" + r.getString("Default") + "'";
            }
            String sqlNull = "NOT NULL";
            if (StringUtils.isNotEmpty((String)r.getString("Null"))) {
                sqlNull = "NULL";
            }
            String sqlExtra = " " + r.getString("Extra");
            sql = sql + "`" + r.getString("Field") + "` " + r.getString("Type") + " " + sqlNull + sqlExtra + " " + sqlDefault;
            return sql;
        }
        return null;
    }

    public static void duplicateColumn(Connection conn, String tab, String source_column, String dest_column) {
        try {
            Object dest = DbUtils.getObject(conn, "show columns from " + tab + " like '" + dest_column + "'", false);
            if (dest == null) {
                String def_s = DbUtils.getColumnDef(conn, tab, source_column);
                System.out.println("def_s = " + def_s);
                String def_d = StringUtils.replace((String)def_s, (String)source_column, (String)dest_column) + " after " + source_column;
                System.out.println("def_d = " + def_d);
                String sql = "alter table " + tab + " add column " + def_d;
                System.out.println("sql = " + sql);
                DbUtils.tryExecQuery(conn, sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void close(ResultSet r) {
        try {
            r.getStatement().close();
        }
        catch (NullPointerException npe) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            r.close();
        }
        catch (NullPointerException npe) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toTable(Connection conn, String sql, JTable table) throws Exception {
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        model.setRowCount(0);
        ArrayList<Object[]> list = DbUtils.getListArray(conn, sql);
        for (Object[] row : list) {
            model.addRow(row);
        }
    }

    public static void tableChanged(Connection conn, TableModelEvent e, String table, String[] colonne, String pk, int pk_col_id, JTable jtable, int row, int col) throws Exception {
        if (e.getType() == 0) {
            Object pkv = jtable.getValueAt(row, pk_col_id);
            Object value = jtable.getValueAt(row, col);
            String sql = "update " + table + " set " + colonne[e.getColumn()] + " = " + DbUtils.sql(value) + " where " + pk + " = " + DbUtils.sql(pkv);
            System.out.println("sql = " + sql);
            DbUtils.tryExecQuery(conn, sql);
        }
    }

    public static Integer getColumnIndex(ResultSetMetaData m, String campo) {
        try {
            for (int i = 0; i < m.getColumnCount(); ++i) {
                String campon = m.getColumnName(i + 1);
                if (campo == null || !campo.equalsIgnoreCase(campon)) continue;
                return i + 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void conteggio(String sql) {
        if (conta) {
            if (mapconta.containsKey(sql)) {
                mapconta.put(sql, mapconta.get(sql) + 1);
            } else {
                mapconta.put(sql, 1);
            }
        }
    }

    public static Map getTopQuery() {
        final Map<String, Integer> map = mapconta;
        TreeMap<String, Integer> tm = new TreeMap<String, Integer>(new Comparator<String>(){

            @Override
            public int compare(String k1, String k2) {
                Integer i2;
                Integer i1 = (Integer)map.get(k1);
                return i1.compareTo(i2 = (Integer)map.get(k2)) == 0 ? 1 : i1.compareTo(i2);
            }
        });
        for (Map.Entry<String, Integer> e : map.entrySet()) {
            try {
                tm.put(e.getKey(), e.getValue());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return tm;
    }

    private static boolean checkCache(String sql) {
        return cache && mapcache.containsKey(sql);
    }

    private static Object fromCache(String sql) {
        System.err.println("DBUTILS FROM CACHE sql:" + sql);
        return mapcache.get(sql);
    }

    private static void inCache(String sql, Object o) {
        if (cache) {
            if (o instanceof ResultSet) {
                DbCacheResultSet cres = new DbCacheResultSet(null, sql, (ResultSet)o);
                o = cres;
            }
            mapcache.put(sql, o);
        }
    }

    public static boolean isAutoInc(Connection conn, String tab, String field) {
        String sql = "describe " + tab;
        try {
            ArrayList<Map> list = DbUtils.getListMap(conn, sql);
            if (list != null && list.size() > 0) {
                for (Map m : list) {
                    if (!cu.s(m.get("Field")).equalsIgnoreCase(field) || cu.s(m.get("Extra")).indexOf("auto_increment") < 0) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isInt(Connection conn, String tab, String field) {
        String sql = "describe " + tab;
        try {
            ArrayList<Map> list = DbUtils.getListMap(conn, sql);
            if (list != null && list.size() > 0) {
                for (Map m : list) {
                    if (!cu.s(m.get("Field")).equalsIgnoreCase(field) || !cu.s(m.get("Type")).toLowerCase().startsWith("int")) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void deleteOldTables(Connection conn, String tableName, int seconds) throws Exception {
        ArrayList<Map> list = DbUtils.getListMap(conn, "show table status where name like " + DbUtils.sql(tableName));
        for (Map m : list) {
            Date create = (Date)cu.toDate(m.get("Create_time"));
            long millis = System.currentTimeMillis() - create.getTime();
            if (millis / 60L <= (long)seconds) continue;
            String sql = "drop table " + m.get("Name");
            System.out.println("sql = " + sql);
        }
    }

    public static void viewToTable(Connection conn, String viewName, String tabDest, String ... fieldsToKey) throws Exception {
        String sql = "create table " + tabDest + " select * from " + viewName;
        DbUtils.tryExecQuery(conn, sql);
        for (String f : fieldsToKey) {
            sql = "ALTER TABLE " + tabDest + " ADD INDEX " + f + " (" + f + ")";
            DbUtils.tryExecQuery(conn, sql);
        }
    }

    public static Integer getLastInsertId(Connection conn) throws Exception {
        return cu.i(DbUtils.getObject(conn, "SELECT LAST_INSERT_ID();"));
    }
}

